Option Explicit 
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                                         :::
'::: DO NOT EDIT THIS SCRIPT IN WORD!                                        :::
':::                                                                         :::
'::: Editing using basic text editor such as Notepad.  A an editor for       :::
'::: VBS Script can download from https://www.vbsedit.com/                   :::
':::                                                                         :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

Const BlankColor = "LimeGreen"

Const Number_of_Image_Rows = 5

Const Number_of_Image_Columns = 5

Const Scale_of_grid_images = "15%"

Const Scale_of_overview_image  = "30%"


':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                                         :::
'::: Overview images are images with an altitude greater than or equal       :::
'::: to the following formula:                                               :::
':::                                                                         :::
'::: MaximumAltitude - (MaximumAltitude - MinimumAltitude)                   :::
':::  / Minimum_Altitude_of_Overview_images                                  :::
':::                                                                         :::
'::: :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

Const Minimum_Altitude_of_Overview_images = 4



':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                                         :::
':::  The file Exiftool.exe  is required and can be found out the            :::
':::  website https://exiftool.org/                                          :::
':::                                                                         :::
':::                                                                         :::
'::: This script is delivered in the zip file GPS_Image_Sorter.zip it        :::
'::: unzips to the folder GPS_Image_Sorter  This will contain the files      :::
'::: GPS_Image_Sorter.vbs, Exiftool.exe, and Instructions.pdf.  Copy this    :::
'::: entire folder to the folder with images to organize.  To keep things    :::
'::: neat this script and associated file are designed to run in their own   :::
'::: folder.                                                                 :::
':::                                                                         :::
'::: This script reads in latitude, longitude, and altitude data             :::
'::: from the comma separated value created by Exiftool.exe.                 :::
'::: If the user responds yes to "Look for Overview images                   :::
'::: (highest Altitude images) the minim and maximum values of altitude      :::
'::: is found.  This marks images taken at the highest altitude as           :::
'::: Overview images using the name convention OverView_OrignalFileName.     :::
':::                                                                         :::
'::: The minimum and maximum values of latitude, longitude are used to       :::
'::: definethe rectangle borders of where the images where taken.            :::
'::: This dividedinto cells defined by the variables                         :::
'::: Number_of_Image_Rows and Number_of_Image_Columns                        :::
'::: The images are sorted by three loops.  Look for the comment             :::
'::: This section sorts the images                                           :::
':::                                                                         :::
':::  Created by William Issac Harter last edit June 21st, 2020              :::
':::                                                                         :::
':::  Distance north to  south and east west is calculated using the         :::
':::  function distance from GeoDataSource.com from the site:                :::
':::  https://www.geodatasource.com                                          :::
':::                                                                         :::
'::: GeoDataSource provides free distance calculation using latitude and    :::
'::: longitude in different programming languages. You can get the free      :::
'::: sample codes by clicking this link                                      :::
'::: https://www.geodatasource.com/developers                                :::
':::                                                                         :::
':::                                                                         :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Const Mr_Meeseeks = "MrMks.bat" 
Const CopyFilesToHtml = "Copy_File.bat" 
Const CSV_File = "Exif_Image_Data.csv" 
Const ContentDirectory = "HtmlFiles\"
Const IndexFile = "Index.html"
Const KMLFile =  "Boundaries_of_Mission.kml"
Const OverViewFile = "OverView.html"
Const PicDir = "Pics\"
Const Boundaries ="Boundaries_of_Mission.txt"
Const Up2Dir = "../../"
Const UpADir ="../"

'Increase the size of cells to make up for cells not dividing evenly into the rectangular  area
Const IncreaseCellSize = 1.0001

'Header  Values 
' 1          2       3           4            5
'SourceFile, filename gpsaltitude gpslatitude gpslongitude
Const FileNameNumber = 2
Const GPSAltitude = 3 
Const LatitudeNumber = 4  
Const LongitudeNumber  = 5

Dim PictureFileName
Dim Count
Dim SampleImage
Dim PictureCount
Dim Overview
Dim AltitudeOverviewImages
Dim sData()' Used to read in Exif file
Dim sPictureFileName()'store picture file names
Dim sMatchPicture()
Dim sOutDone()' Mark images as "DONE"
Dim sLongitudeData()'Store longitude data 
Dim sLatitudeData()' store latitude data
Dim sAltitudeData() 'store altitude data
Dim Cell
Dim LineCount
Dim PrePicRow
Dim TopOfPage
Dim StartBatchFileBuffer
Dim RunOverView
Dim BatchFileBuffer
Dim CopyRenamePics
Dim x
Dim MinimumLatitude 
Dim MaximumLatitude 
Dim MinimumLongitude  
Dim MaximumLongitude  
Dim MaximumAltitude 
Dim MinimumAltitude
Dim NorthImage, SouthImage, EastImage, WestImage
Dim LongitudeCellSize
Dim LatitudeCellSize
Dim img
Dim PicCount 
Dim PicRow			
Dim PrePicCol 
Dim PicCol
Dim QT
Dim dash
Dim CurrentLongitude
Dim CurrentLatitude
Dim BoundariesBuffer
Dim KMLHeaderBuffer
Dim KMLFooterBuffer
Dim KMLBuffer 
Dim FileBuffer
Dim NorthSouth 
Dim EastWest
Dim CellNorthSouth 
Dim CellEastWest
Dim tempvalue,i,j,a,b
Dim objFSO, objFile, Temp
Dim  TempCountLines

QT = Chr(34) 'Quotation Mark Symbol "


'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                                          :::
'::: If neither Exiftool.exe or Exif_Image_Data.csv, a message is displayed   :::
'::: "Missing Exiftool.exe, please download from Exiftool.org."               :::
'::: Otherwise, the script will continue.                                     :::
':::                                                                          :::
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
If FileExists("exiftool.exe") Or FileExists(CSV_File ) Then
    
    
    
    '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    ':::                                                                          :::
    ':::  If Exif_Image_Data.csv file is not found create a batch file MrMks.bat, :::
    ':::  execute, and end this execute, and end this script. The batch file      :::
    ':::  MrMks.bat runs Exiftool.exe to create Exif_Image_Data.csv,              :::
    ':::  Exif_Image_Data.csv, then starts this scriptagain. When completed,      :::
    '::;  MrMks.bat deletes itself.                                               :::
    ':::                                                                          :::
    ':::  Otherwise, the script will continue.                                    :::
    ':::                                                                          :::
    '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    
    
    If Not(FileExists(CSV_File )) Then        
        
        'Build batch file to run Exiftool.exe then restart this script. 
        StartBatchFileBuffer = StartBatchFileBuffer & "exiftool -filename -gpsaltitude -gpslatitude -gpslongitude -createdate -T -n -csv -ext jpg ..\ > .\" & CSV_File   & vbCrLf 
        StartBatchFileBuffer  = StartBatchFileBuffer & "GPS_Image_Sorter.vbs" & vbCrLf
        StartBatchFileBuffer  = StartBatchFileBuffer & "Del " & Mr_Meeseeks         
        
        'Write and Run Batch File MrMks.bat.            
        WriteFile  Mr_Meeseeks, StartBatchFileBuffer, 2
        RunCommand( Mr_Meeseeks)
        
    Else
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                            :::
        ':::  Rest Script runs after the above esle statment                            :::
        ':::                                                                            :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                            :::
        ':::  Remove old Folders                                                        :::
        ':::                                                                            :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        RemoveFolder(PicDir)
        RemoveFolder(ContentDirectory)
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                            :::
        ':::  Get input from user                                                       :::
        ':::                                                                            :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        If MsgBox ("Look for Overview Images (highest altitude images)", 4, "Find Overview Images") = 6 Then 
            RunOverView = True
            BatchFileBuffer = "@echo off"  & vbCrLf
        Else
            RunOverView = False
        End If
        
        If MsgBox ("Copy pictures and rename images to new folder " & Replace(PicDir,"\",""), 4, "Copy and rename images") = 6 Then 
            CopyRenamePics = True
        Else
            CopyRenamePics = False
        End If
        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::  Create new flolders for Html Files and Images                             :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        Call CreateFolder(ContentDirectory,0)
        
        If  CopyRenamePics Then Call CreateFolder(PicDir,0)
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                          :::
        ':::  Read in file to a temporary variable to get the number of lines.        :::
        ':::                                                                          :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        LineCount = 0  
        '1) Create a File System Object
        Set objFSO = CreateObject("Scripting.FileSystemObject")
        Set objFile = objFSO.openTextFile(CSV_File, 1)
        TempCountLines = objFile.readLine & vbCrLf
        Do Until objFile.atEndOfStream
            LineCount = LineCount + 1
            TempCountLines = objFile.readLine & vbCrLf    
        Loop
        objFile.Close
        Set objFSO = Nothing
        LineCount = LineCount + 1    
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                          :::
        ':::  Correctly size arrays used based on the number of lines in the file.    :::
        ':::                                                                          :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        ReDim sData(LineCount)
        ReDim sPictureFileName(LineCount)
        ReDim sLongitudeData(LineCount)
        ReDim sLatitudeData(LineCount)
        ReDim sAltitudeData(LineCount)
        ReDim sMatchPicture(LineCount)
        ReDim sOutDone(LineCount)
        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                          :::
        ':::  Read in file to array sData.                                            :::
        ':::                                                                          :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        LineCount = 0   
        '1) Create a File System Object
        Set objFSO = CreateObject("Scripting.FileSystemObject")
        Set objFile = objFSO.openTextFile(CSV_File, 1)
        sData(LineCount) = objFile.readLine & vbCrLf
        Do Until objFile.atEndOfStream
            LineCount = LineCount + 1
            sData(LineCount) = objFile.readLine & vbCrLf            
        Loop
        objFile.Close
        Set objFSO = Nothing
        
        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                          :::
        ':::  Sorts the array first Longitude then by Latitude using bubble sort.     :::
        ':::                                                                          :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        'First bubble sort on longitude.
        For i = 1 To LineCount
            For j = 1 To LineCount - 1
                
                a = ReturnValue(sData(j),",", LongitudeNumber)
                b = ReturnValue(sData(j+1),",", LongitudeNumber)
                
                
                
                If a > b Then 
                    
                    
                    TempValue = sData(j + 1)
                    sData(j + 1) = sData(j)
                    sData(j) = TempValue
                    
                    
                End If
            Next
        Next
        
        'Second bubble sort on latitude.
        For i = 1 To LineCount
            For j = 1 To LineCount - 1
                
                If ReturnValue(sData(j),",", LongitudeNumber) = ReturnValue(sData(j+ 1),",", LongitudeNumber) Then
                    a = ReturnValue(sData(j),",", LatitudeNumber)
                    b = ReturnValue(sData(j+1),",", LatitudeNumber)
                    
                    
                    
                    If a > b Then                
                        
                        TempValue = sData(j + 1)
                        sData(j + 1) = sData(j)
                        sData(j) = TempValue
                        
                    End If
                    
                End If
            Next
        Next
        
        
        
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                                 :::
        ':::  Top of HTML pages "Header" is replace the with replace function example        :::
        ':::  Replace(TopOfPage,"Header","<h2>Click on an image to view it full size</h2>" ) :::
        ':::                                                                                 :::
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        TopOfPage = TopOfPage & "<html>" & vbCrLf
        TopOfPage = TopOfPage & "<head>" & vbCrLf
        TopOfPage = TopOfPage & "<style>" & vbCrLf
        TopOfPage = TopOfPage & "* {" & vbCrLf
        TopOfPage = TopOfPage & "box-sizing: border-box;" & vbCrLf
        TopOfPage = TopOfPage & "}" & vbCrLf
        TopOfPage = TopOfPage & ".column {" & vbCrLf
        TopOfPage = TopOfPage & "float: left;" & vbCrLf
        TopOfPage = TopOfPage & "width: 33.33%;" & vbCrLf
        TopOfPage = TopOfPage & " padding: 5px;" & vbCrLf
        TopOfPage = TopOfPage & "}" & vbCrLf
        TopOfPage = TopOfPage & "/* Clearfix (clear floats) */" & vbCrLf
        TopOfPage = TopOfPage & ".row::after {" & vbCrLf
        TopOfPage = TopOfPage & "content: " & QT & QT & ";" & vbCrLf
        TopOfPage = TopOfPage & "clear: both;" & vbCrLf
        TopOfPage = TopOfPage & "display: table;" & vbCrLf
        TopOfPage = TopOfPage & "</style>" & vbCrLf
        TopOfPage = TopOfPage & "</head>" &  vbCrLf & "<body>" & vbCrLf & "Header" & vbCrLf
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                            :::
        ':::  Assign initial values of latitude, longitude, and altitude for            :::
        ':::  the next section that finds the maximum and minimum values                :::
        ':::                                                                            :::
        ':::  If IsNumeric(x) Then ignores  values that are not numeric                 :::
        ':::  When all required values are found the For Loop exits.                    :::
        ':::                                                                            :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        For PictureCount = 1 To LineCount   
            
            
            Count = 0   
            
            'Assign initial value of latitude.
            x = ReturnValue(sData(PictureCount),",",LatitudeNumber)
            If IsNumeric(x) Then                
                Count = Count + 1
                MaximumLatitude =   CDbl (x)
                MinimumLatitude  =   CDbl (x)                              
            End If
            
            'Assign initial value of longitude.
            x = ReturnValue(sData(PictureCount),",",LongitudeNumber)
            If IsNumeric(x) Then  
                Count = Count + 1
                MaximumLongitude  =   CDbl (x)
                MinimumLongitude =   CDbl (x)
                
                
            End If
            
            'Assign initial value of altitude.
            x = ReturnValue(sData(PictureCount),",",GPSAltitude)
            If IsNumeric(x)  And RunOverView Then 
                Count = Count + 1
                MaximumAltitude =   CDbl (x)
                MinimumAltitude =   CDbl (x)
            End If
            
            
            If Count = 3 And RunOverView Then  Exit For
            If Count = 2 Then Exit For
        Next 
        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                            :::
        ':::  Find maximum and minimum values of latitude, longitude, and altitude.     :::
        ':::                                                                            :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        For PictureCount = 1 To LineCount
            
            'Find maximum and minimum values of latitude.
            x = ReturnValue(sData(PictureCount),",",LatitudeNumber)
            If IsNumeric(x)   Then 
                
                If   CDbl (x) >= MaximumLatitude Then 
                    MaximumLatitude =   CDbl (x)
                    NorthImage = PictureCount
                    
                End If 
                
                
                If   CDbl (x) <= MinimumLatitude  Then 
                    MinimumLatitude  =   CDbl (x)
                    SouthImage = PictureCount   
                    
                End If
                sLatitudeData(PictureCount)  =  CDbl (x)
            Else
                sOutDone(PictureCount) = "DONE"  'Do not process images without good Latitude data
                
            End If 
            
            
            
            'Find maximum and minimum values of longitude.
            x = ReturnValue(sData(PictureCount),",",LongitudeNumber) 
            If IsNumeric(x)   Then 
                If   CDbl (x) >= MaximumLongitude  Then                   
                    
                    MaximumLongitude  =   CDbl (x)
                    EastImage = PictureCount
                    
                End If
                
                If   CDbl (x) <= MinimumLongitude Then 
                    MinimumLongitude =   CDbl (x)
                    WestImage = PictureCount 
                End If
                
                sLongitudeData(PictureCount)  =  CDbl (x)
            Else
                sOutDone(PictureCount) = "DONE"  'Do not process images without good Longitude data
            End If
            
            
            
            'Find maximum and minimum values of altitude. 
            If RunOverView Then 
                x = ReturnValue(sData(PictureCount),",",GPSAltitude)
                If IsNumeric(x)   Then
                    If   CDbl (x) >= MaximumAltitude Then MaximumAltitude =   CDbl (x)
                    If   CDbl (x) <= MinimumAltitude Then MinimumAltitude =   CDbl (x)
                    sAltitudeData(PictureCount)  =   CDbl (x)
                    
                Else
                    sOutDone(PictureCount) = "DONE"  'Do not process images withot good Altitude data
                End If
                
            End If
            
            
            'Assign File Name.
            sPictureFileName(PictureCount) = ReturnValue(sData(PictureCount),",",FileNameNumber)
            
            
        Next
        
        
        If RunOverView Then AltitudeOverviewImages = MaximumAltitude - (MaximumAltitude - MinimumAltitude) / Minimum_Altitude_of_Overview_images
        
        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                            :::
        ':::   Find highest altitude overview to use as images.                         :::
        ':::                                                                            :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        
        If RunOverView Then
            
            dash = "_" 'The first overview image follows the format Overview_OriginalFileName.JPG images after that use the format Overview-OriginalFileName.JPG.
            
            
            WriteFile  ContentDirectory &  OverViewFile, Replace(TopOfPage,"Header","<h2>Click on an image to view it full size</h2>" ), 2
            
            'Find Overview 
            For PictureCount = 1 To LineCount                
                
                sOutDone(PictureCount) =  sPictureFileName(PictureCount)
                
                
                If  CDbl(sAltitudeData(PictureCount)) >= AltitudeOverviewImages Then
                    
                    WriteFile  ContentDirectory & OverViewFile, "<a href=" & QT &  Up2Dir &  sPictureFileName(PictureCount) & QT & ">" & "<img src=" & QT & Up2Dir &   sPictureFileName(PictureCount) & QT   &   "width=" & Scale_of_grid_images &" height=auto title="& QT & "Overview" & dash &   sPictureFileName(PictureCount) & QT   & "</a>" & vbCrLf,8
                    
                    
                    Overview =   sPictureFileName(PictureCount)
                    If CopyRenamePics Then BatchFileBuffer  =  BatchFileBuffer & "COPY ..\"  & Overview & " " & PiCDir & "OverView" & dash & OverView  & vbCrLf
                    
                    dash = "-" 'The first overview image follows the format Overview_OriginalFileName.JPG images after that use the format Overview-OriginalFileName.JPG.
                    sOutDone(PictureCount) = "DONE"
                Else
                    
                End If   
                
            Next       
            
            WriteFile  ContentDirectory & OverViewFile, "</div>" & vbCrLf & "</body>" & vbCrLf &  "</html>" & vbCrLf , 8
            
        End If
        
        
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                         :::
        '::: Create Blank bitmap image                                               :::
        ':::                                                                         :::
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        
        SampleImage = sPictureFileName(Int(LineCount/2))
        Set img = CreateObject("Vbsedit.ImageProcessor")
        img.Load  UpADir & sampleImage 
        
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                         :::
        ':::  Find the cell size. Cell size width and height is found by dividing    :::
        ':::  the with and height of the rectangular area defined by the maximum     :::
        ':::  and minimum latitude and longitude positions of the images. Diving by  :::
        ':::  Number_of_Image_Rows gives the height or latitude size of the cell.    :::
        ':::  Number_of_Image_Columns gives the width or longitude size of the cell. :::
        ':::                                                                         :::
        ':::  Multiplying  by IncreaseCellSize the size by make sure the cells are   :::
        ':::  large enough if they do not divided evenly in to rectangular area      :::
        ':::                                                                         :::
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        img.Create img.Width, img.Height,BlankColor  
        img.Save ContentDirectory & "Blank.bmp"
        
        
        LatitudeCellSize = IncreaseCellSize *   (CDbl(MaximumLatitude) - CDbl(MinimumLatitude )) /  CDbl(Number_of_Image_Rows)
        LongitudeCellSize = IncreaseCellSize * (CDbl(MaximumLongitude ) - CDbl(MinimumLongitude)) / CDbl(Number_of_Image_Columns)        
        
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                          :::
        ':::   This section sorts the images                                          :::
        ':::                                                                          :::
        ':::                                                                          :::
        ':::  This section steps through the cells of the boundaries defined by       :::
        ':::  latitude and longitude.   The html files in folder HtmlFiles\           :::
        ':::  are created here.                                                       :::
        ':::                                                                          :::
        ':::  Pictures are matched here by the index of the array of sMatchPicture    :::
        '::: for placement on Index.Html in the next section.                         :::
        ':::                                                                          :::
        ':::  If the users selects To copy the images To folder                       :::
        ':::  Pics the CopyPics.bat batch file is modified here.                      :::
        ':::                                                                          :::
        ':::  These done with three for loops.  The first loop steps through          :::
        ':::  longitude  and the second loop through latitude.  The third loop checks :::
        ':::  the latitude and longitude data of each image against latitude and      :::
        ':::  longitude represented by the first and second loop                      :::
        ':::                                                                          :::
        '::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        
        
        
        
        CurrentLongitude = CDbl(MinimumLongitude)
        'The loop steps through each cell the cell from west to east CurrentLatitude represent the Latitude position of the west border of the cell.  CurrentLatitude = incremented the bottom of the loop.
        For  PicCol = 1 To Number_of_Image_Columns
            
            
            CurrentLatitude = CDbl(MinimumLatitude ) 
            
            
            
            'The loop steps through each cell the cell from west to east CurrentLongitude represent the longitude position of the west border of the cell.  CurrentLongitude = incremented the bottom of the loop.
            For  PicRow  = 1 To Number_of_Image_Rows 
                
                
                For PictureCount = 1 To LineCount 'Loops though array of picture file names, array of picture latitude data, and picture longitude data.
                    
                    If  sOutDone(PictureCount) <> "DONE" Then 'Processes only once
                        
                        'test see if the picture longitude is in within the range of the current cell
                        If  CDbl(sLongitudeData(PictureCount))>= CDbl(CurrentLongitude) And CDbl(sLongitudeData(PictureCount)) =< CDbl(CurrentLongitude + LongitudeCellSize)  Then 
                            
                            
                            'test see if the picture latitude is in within the range of the current cell
                            If  CDbl(sLatitudeData(PictureCount))>= CDbl(CurrentLatitude) And  CDbl(sLatitudeData(PictureCount)) =< CDbl(CurrentLatitude + LatitudeCellSize)  Then
                                
                                If PrePicRow <> PicRow Or PrePicCol <> PicCol  Then 
                                    PicCount = 0 
                                    PrePicRow = PicRow			
                                    PrePicCol = PicCol
                                    dash = "_"' First image name follow the format X_Y_OriginalFileName.JPG images after use the format X_Y-OriginalFileName.JPG 
                                    
                                    WriteFile ContentDirectory & PicCol & "_" & PicRow & ".html", Replace(TopOfPage,"Header","<h2>Click an image to view it full size</h2>"),2
                                Else 
                                    dash = "-" 'The first overview image follows the format Overview_OriginalFileName.JPG images after that use the format Overview-OriginalFileName.JPG.
                                    
                                End If
                                
                                
                                
                                PicCount = PicCount + 1    
                                
                                
                                
                                'Matches pictures to place on Index.Html.
                                sMatchPicture(PictureCount) = PicCol & "_ " & PicRow  & "_" & PicCount
                                
                                
                                ''Writes Html file to folder HtmlFiles to display related images.	
                                WriteFile  ContentDirectory & PicCol & "_" & PicRow & ".html" , "<a href=" & QT & Up2Dir & sPictureFileName(PictureCount) & QT & ">" & "<img src=" & QT & Up2Dir& sPictureFileName(PictureCount)  & QT   &   "width=15% height=auto title=" & QT  & PicCol & "_" & PicRow &  dash & sPictureFileName(PictureCount) & QT & "</a>" & vbCrLf ,8
                                
                                
                                'Creates batch file to copy images to the Pics folder. 
                                If CopyRenamePics Then BatchFileBuffer =  BatchFileBuffer & "COPY ..\"  & sPictureFileName(PictureCount) & " " & PicDir & PicCol & "_" & PicRow &  dash & sPictureFileName(PictureCount)  & vbCrLf
                                
                                
                                'set flag so image will only be proceesed once 
                                sOutDone(PictureCount) = "DONE"                               
                                
                                
                                
                            End If 
                        End If
                        
                    End If
                Next
                CurrentLatitude =  CDbl(CurrentLatitude) + CDbl(LatitudeCellSize) 
            Next  
            
            CurrentLongitude =   CDbl(CurrentLongitude)  + CDbl(LongitudeCellSize)
            
        Next
        
        
        
        If CopyRenamePics Then BatchFileBuffer = BatchFileBuffer & "DEL " & CopyFilesToHtml      
        
        
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                         :::
        ':::  Write Index.html file                                                   :::
        ':::                                                                         :::
        ':::  Puts images matched in the previous section on Index.html               :::
        ':::                                                                         :::
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        FileBuffer = Replace(TopOfPage,"Header","<h2>Click image to see related images</h2>")
        
        FileBuffer = FileBuffer & "<div class=" & QT & "row" & QT & ">" & vbCrLf 
        For PicRow = Number_of_Image_Rows To  1 Step -1 
            FileBuffer = FileBuffer & "<div class=" & "column" & QT & ">" & vbCrLf
            
            For PicCol = 1 To Number_of_Image_Columns
                
                PictureFileName = PicCol & "_ " & PicRow  & "_" & "1"
                
                
                'Set image to blank as default if no picture is found as a match.  
                Cell = "<img src=" & QT & ContentDirectory & "Blank.bmp"  & QT   &   "width=" & Scale_of_grid_images &" height=auto "  & "title=" & QT & PicCol & "_" & PicRow & "-" & "Blank.bmp" & QT & ">" & vbCrLf
                For  PictureCount = 1 To LineCount
                    
                    'Matches' first picture to be placed on Index.html matched in the previous section. 
                    If sMatchPicture(PictureCount)  = PictureFileName Then 
                        Cell = "<a href=" & QT  & ContentDirectory & PicCol & "_" & PicRow  & ".html" & QT & ">" & "<img src=" & QT & UpADir &  sPictureFileName(PictureCount)  & QT   &   "width=" & Scale_of_grid_images &" height=auto "  & "title=" & QT & PicCol & "_" & PicRow & "_" & sPictureFileName(PictureCount) & QT & "/a>" & vbCrLf
                        
                        
                        Exit For
                    End If
                Next
                
                FileBuffer = FileBuffer & Cell
            Next    
            
            FileBuffer = FileBuffer & "</div>" & vbCrLf  & "</div>" & vbCrLf
            
            FileBuffer = FileBuffer & "<div class=" & QT & "row" & QT & ">" & vbCrLf 
        Next
        If RunOverView Then 
            FileBuffer = FileBuffer & "<div class=" & "column" & QT & ">" & vbCrLf
            FileBuffer = FileBuffer & "<a href=" & QT & ContentDirectory &  OverViewFile & QT & "><img src=" &  QT & UpADir &  Overview & QT  &   "width=" & Scale_of_overview_image  &" height=auto title=" & QT & "Overview_" & Overview & QT   &  "</a>" & vbCrLf
            FileBuffer = FileBuffer & "</div>" & vbCrLf  & "</div>" & vbCrLf
            
            
            
        End If
        FileBuffer = FileBuffer & "</body>" & vbCrLf & "</html>" & vbCrLf
        
        If CopyRenamePics Then WriteFile  CopyFilesToHtml, BatchFileBuffer, 2
        
        WriteFile  IndexFile, FileBuffer, 2
        
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                         :::
        ':::                                                                         :::
        ':::  Write file Boundaries_Of_Mission.txt                                   :::
        ':::                                                                         :::
        ':::  Distance north to  south and east west is calculated using the         :::
        ':::  function distance from GeoDataSource.com from the site:                :::
        ':::  https://www.geodatasource.com                                          :::
        ':::                                                                         :::
        ':::  GeoDataSource provides free distance calculation using latitude and   :::
        ':::  longitude in different programming languages. You can get the free     :::
        ':::  sample codes by clicking this link                                     :::
        ':::  https://www.geodatasource.com/developers                               :::
        ':::                                                                         :::
        ':::                                                                         :::
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        BoundariesBuffer = BoundariesBuffer & "Boundaries of Mission:" & vbCrLf  & vbCrLf 
        
        'Calculate distance in miles "M" Miles, "K"  Kilometers, "N",  Nautical Miles     
        
        NorthSouth = CDbl(distance(MinimumLatitude , MinimumLongitude, MaximumLatitude , MinimumLongitude, "M")) 
        EastWest =  CDbl(distance(MinimumLatitude , MinimumLongitude, MinimumLatitude , MaximumLongitude , "M"))  
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        BoundariesBuffer = BoundariesBuffer & "Images taken over area of:" & vbCrLf 
        
        If NorthSouth < 1 Then 
            'round to one decimal place  
            NorthSouth =   NorthSouth  * 5280  
            CellNorthSouth  = Round( IncreaseCellSize * NorthSouth / Number_of_Image_Rows,1) & " feet north to south"  & vbCrLf    
            BoundariesBuffer = BoundariesBuffer  & "   " & Round( NorthSouth,1) & " feet north to south"  & vbCrLf   
        Else
            CellNorthSouth  = Round( IncreaseCellSize * NorthSouth / Number_of_Image_Rows,1) & " miles north to south"  & vbCrLf   
            BoundariesBuffer = BoundariesBuffer  & "   " & Round( NorthSouth,1) & " miles north to south"  & vbCrLf   
        End If
        
        If  EastWest  < 1 Then 
            EastWest =  EastWest * 5280
            CellEastWest = Round( IncreaseCellSize * EastWest / Number_of_Image_Columns,1) & " feet east to west"  & vbCrLf   
            BoundariesBuffer = BoundariesBuffer  & "   " & Round( EastWest,1) & " feet east to west"  & vbCrLf & vbCrLf     
        Else 
            CellEastWest = Round( IncreaseCellSize * EastWest / Number_of_Image_Columns,1) & " miles east to west"  & vbCrLf   
            BoundariesBuffer = BoundariesBuffer  & "   " & Round( EastWest,1) & "  miles east to west"  & vbCrLf & vbCrLf     
        End If
        
        
        BoundariesBuffer = BoundariesBuffer & "Area is divided in to " & Number_of_Image_Rows * Number_of_Image_Columns & " cells:" & vbCrLf 
        
        
        BoundariesBuffer = BoundariesBuffer  & "   " & Number_of_Image_Rows & "  " & CellNorthSouth  
        BoundariesBuffer = BoundariesBuffer  & "   " & Number_of_Image_Columns & "  " & CellEastWest   
        
        
        BoundariesBuffer = BoundariesBuffer & "North West" & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Latitude " & MaximumLatitude & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Longitude " & MinimumLongitude & vbCrLf & vbCrLf
        
        
        BoundariesBuffer = BoundariesBuffer & "North East"& vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Latitude " & MaximumLatitude & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Longitude " & MaximumLongitude  & vbCrLf  & vbCrLf
        
        
        
        BoundariesBuffer = BoundariesBuffer & "South West" & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Latitude " & MinimumLatitude  & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Longitude " & MinimumLongitude & vbCrLf & vbCrLf
        
        BoundariesBuffer = BoundariesBuffer & "South East" & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Latitude " & MinimumLatitude   & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "   Longitude " & MaximumLongitude  & vbCrLf & vbCrLf & vbCrLf & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "Boundaries based on these images: " & vbCrLf
        
        
        BoundariesBuffer = BoundariesBuffer & "North most image " & sPictureFileName(NorthImage) & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "South most image " &  sPictureFileName(SouthImage) & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "East most image " &   sPictureFileName(EastImage) & vbCrLf
        BoundariesBuffer = BoundariesBuffer & "West most image " &   sPictureFileName(WestImage) & vbCrLf
        
        WriteFile  Boundaries, BoundariesBuffer , 2
        
        
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        ':::                                                                         :::
        '::: Write KML File for Google Earth                                         :::
        ':::                                                                         :::
        ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
        
        KMLHeaderBuffer = "<?xml version=" & QT & "1.0" & QT & " encoding=" & QT & "UTF-8" & QT & "?>" & vbCrLf
        KMLHeaderBuffer = KMLHeaderBuffer & "<kml>" & vbCrLf
        KMLHeaderBuffer = KMLHeaderBuffer & "<Document>" & vbCrLf
        
        KMLFooterBuffer =  KMLFooterBuffer & "</Document>" & vbCrLf
        KMLFooterBuffer =  KMLFooterBuffer & "</kml>" & vbCrLf
        
        KMLBuffer = KMLHeaderBuffer &  KMLPlaceMark("NW", MinimumLongitude,MaximumLatitude) &  KMLPlaceMark("NE", MaximumLongitude ,MaximumLatitude) &   KMLPlaceMark("SW", MinimumLongitude,MinimumLatitude ) &  KMLPlaceMark("SE", MaximumLongitude ,MinimumLatitude ) &  KMLFooterBuffer
        
        WriteFile  KMLFile,KMLBuffer, 2
        
        ' Run batch file to copy images if the user selected yes when prompted            
        If CopyRenamePics Then RunCommand(CopyFilesToHtml)
        
        
        ' Run file Index.htm                                                     
        RunCommand(IndexFile)
        
        
    End If
    
Else
    
    ' Tell user file is missing and end script   
    Call MsgBox("Missing Exiftool.exe please download from Exiftool.org",1)
    
    
    RunCommand("https://exiftool.org/")
End If 
'******End Of Script *************



Function FileExists(FilePath)
    Dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    If fso.FileExists(FilePath) Then
        FileExists=CBool(1)
    Else
        FileExists=CBool(0)
    End If
End Function

Function KMLPlaceMark(PointName,PointLong, PointLat)
    Dim KMLBuffer    
    KMLBuffer =  KMLBuffer & "<Placemark>" & vbCrLf
    
    
    KMLBuffer =  KMLBuffer &  "<name>" & PointName & "</name>" & vbCrLf
    
    
    KMLBuffer =  KMLBuffer & "<Point>" & vbCrLf
    
    
    KMLBuffer =  KMLBuffer &  "<coordinates>" & PointLong  & "," & PointLat & ",0</coordinates>" & vbCrLf
    
    KMLBuffer =  KMLBuffer &  "</Point>" & vbCrLf
    KMLBuffer =  KMLBuffer & "</Placemark>" & vbCrLf
    
    KMLPlaceMark = KMLBuffer
    
End Function




Function CreateFolder (FolderName,atrb)
    Dim filesys
    Set filesys=CreateObject("Scripting.FileSystemObject")
    If Not filesys.FolderExists(FolderName) Then
        filesys.CreateFolder (FolderName).Attributes = atrb
        ' Discard all variables.
        
    End If
    ' Discard all variables.
    Set filesys = Nothing
End Function



Function RemoveFolder(FolderName)
    Dim filesys
    FolderName = Replace(FolderName,"\","")
    Set filesys=CreateObject("Scripting.FileSystemObject")
    If filesys.FolderExists(FolderName) Then  Filesys.DeleteFolder(FolderName)
    
    Set filesys = Nothing
End Function



Function RunCommand(Command)
    Dim WShell 
    
    
    Set WShell = CreateObject("WScript.Shell") 
    WShell.Run QT & Command & QT, 1
    Set WShell = Nothing
    
End Function 


Function ReturnValue(StringValue,delimiter, SortByitem)
    Dim a,Ct,OutArray
    ct = 0
    OutArray = split(StringValue,delimiter)
    
    For Each a In OutArray
        ct = ct + 1
        If ct =  SortByitem Then Exit For
    Next
    If IsNumeric(a) Then 
        ReturnValue = CDbl(a)
    Else
        ReturnValue = a
    End If 
    
    
End Function

Sub WriteFile ( FileName, FileBuffer, Mode)
    Dim objFileToWrite, objFile, objFSO 
    Set objFileToWrite = CreateObject("Scripting.FileSystemObject").OpenTextFile(FileName,Mode,True)
    objFileToWrite.WriteLine FileBuffer
    objFileToWrite.Close
    Set objFile = Nothing
    Set objFSO = Nothing
End Sub



'Code copied from GeoDataSource.com *******************
'The following code was copied from https://www.geodatasource.com/ specifically from 
' https://www.geodatasource.com/developers/vb  


'To keep the original code in tact and allow it to work in my script the following lines
' are commented out:

'response.write "dist = " & dist & "<br>"
'response.write "dist = " & dist & "<br>"
'MsgBox(distance(32.9697, -96.80322, 29.46786, -98.53506, "M") & " Miles<br>")
'msgbox(distance(32.9697, -96.80322, 29.46786, -98.53506, "K") & " Kilometers<br>")
'msgbox(distance(32.9697, -96.80322, 29.46786, -98.53506, "N") & " Nautical Miles<br>")


':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::                                                                         :::
':::  This routine calculates the distance between two points (given the     :::
':::  latitude/longitude of those points). It is being used to calculate     :::
':::  the distance between two locations using  GeoDataSource(TM) products   :::
':::                                                                         :::
':::  Definitions:                                                           :::
':::    South latitudes are negative, east longitudes are positive           :::
':::                                                                         :::
':::  Passed to function:                                                    :::
':::    lat1, lon1 = Latitude and Longitude of point 1 (in decimal degrees)  :::
':::    lat2, lon2 = Latitude and Longitude of point 2 (in decimal degrees)  :::
':::    unit = the unit you desire for results                               :::
':::           where: 'M' is statute miles (default)                         :::
':::                  'K' is kilometers                                      :::
':::                  'N' is nautical miles                                  :::
':::                                                                         :::
':::  Worldwide cities and other features databases with latitude longitude  :::
':::  are available at https://www.geodatasource.com	                     :::
':::                                                                         :::
':::  For enquiries, please contact sales@geodatasource.com                  :::
':::                                                                         :::
':::  Official Web site: https://www.geodatasource.com                       :::
':::                                                                         :::
':::             GeoDataSource.com (C) All Rights Reserved 2018              :::
':::                                                                         :::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

Const pi = 3.14159265358979323846

Function distance(lat1, lon1, lat2, lon2, unit)
    Dim theta, dist
    If lat1 = lat2 And lon1 = lon2 Then
        distance = 0
    Else
        theta = lon1 - lon2
        dist = sin(deg2rad(lat1)) * sin(deg2rad(lat2)) + cos(deg2rad(lat1)) * cos(deg2rad(lat2)) * cos(deg2rad(theta))
        'response.write "dist = " & dist & "<br>"
        dist = acos(dist)
        dist = rad2deg(dist)
        'response.write "dist = " & dist & "<br>"
        distance = dist * 60 * 1.1515
        Select Case ucase(unit)
            Case "K"
            distance = distance * 1.609344
            Case "N"
            distance = distance * 0.8684
        End Select
    End If
End Function


'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::  This function get the arccos function using arctan function   :::
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Function acos(rad)
    If Abs(rad) <> 1 Then
        acos = pi/2 - Atn(rad / Sqr(1 - rad * rad))
    ElseIf rad = -1 Then
        acos = pi
    End If
End Function


'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::  This function converts decimal degrees to radians             :::
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Function deg2rad(Deg)
    deg2rad = cdbl(Deg * pi / 180)
End Function

'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
':::  This function converts radians to decimal degrees             :::
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Function rad2deg(Rad)
    rad2deg = cdbl(Rad * 180 / pi)
End Function

'MsgBox(distance(32.9697, -96.80322, 29.46786, -98.53506, "M") & " Miles<br>")
'msgbox(distance(32.9697, -96.80322, 29.46786, -98.53506, "K") & " Kilometers<br>")
'msgbox(distance(32.9697, -96.80322, 29.46786, -98.53506, "N") & " Nautical Miles<br>")


'end ofcode copied from GeoDataSource.com *******************