/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.iasm.world.biome;

import java.util.Random;
import java.util.Set;
import net.mcreator.iasm.IasmModElements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ObjectHolder;

@IasmModElements.ModElement.Tag
public class FairyPlanesBiome
extends IasmModElements.ModElement {
    @ObjectHolder(value="iasm:fairy_planes")
    public static final CustomBiome biome = null;

    public FairyPlanesBiome(IasmModElements instance) {
        super(instance, 8);
    }

    @Override
    public void initElements() {
        this.elements.biomes.add(() -> new CustomBiome());
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
    }

    static class CustomTreeFeature
    extends AbstractTreeFeature<BaseTreeFeatureConfig> {
        CustomTreeFeature() {
            super(BaseTreeFeatureConfig::func_227376_b_);
        }

        protected boolean func_225557_a_(IWorldGenerationReader worldgen, Random rand, BlockPos position, Set<BlockPos> changedBlocks, Set<BlockPos> changedBlocks2, MutableBoundingBox bbox, BaseTreeFeatureConfig conf) {
            if (!(worldgen instanceof IWorld)) {
                return false;
            }
            IWorld world = (IWorld)worldgen;
            int height = rand.nextInt(5) + 7;
            boolean spawnTree = true;
            if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= world.func_217301_I()) {
                for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                    int k = 1;
                    if (j == position.func_177956_o()) {
                        k = 0;
                    }
                    if (j >= position.func_177956_o() + height - 1) {
                        k = 2;
                    }
                    for (int px = position.func_177958_n() - k; px <= position.func_177958_n() + k && spawnTree; ++px) {
                        for (int pz = position.func_177952_p() - k; pz <= position.func_177952_p() + k && spawnTree; ++pz) {
                            if (j >= 0 && j < world.func_217301_I()) {
                                if (this.isReplaceable(world, new BlockPos(px, j, pz))) continue;
                                spawnTree = false;
                                continue;
                            }
                            spawnTree = false;
                        }
                    }
                }
                if (!spawnTree) {
                    return false;
                }
                Block ground = world.func_180495_p(position.func_177982_a(0, -1, 0)).func_177230_c();
                Block ground2 = world.func_180495_p(position.func_177982_a(0, -2, 0)).func_177230_c();
                if (ground != Blocks.field_196658_i.func_176223_P().func_177230_c() && ground != Blocks.field_150346_d.func_176223_P().func_177230_c() || ground2 != Blocks.field_196658_i.func_176223_P().func_177230_c() && ground2 != Blocks.field_150346_d.func_176223_P().func_177230_c()) {
                    return false;
                }
                BlockState state = world.func_180495_p(position.func_177977_b());
                if (position.func_177956_o() < world.func_217301_I() - height - 1) {
                    int genh;
                    this.setTreeBlockState(changedBlocks, (IWorldWriter)world, position.func_177977_b(), Blocks.field_150346_d.func_176223_P(), bbox);
                    for (genh = position.func_177956_o() - 3 + height; genh <= position.func_177956_o() + height; ++genh) {
                        int i4 = genh - (position.func_177956_o() + height);
                        int j1 = (int)(1.0 - (double)i4 * 0.5);
                        for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                            for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                                BlockPos blockpos;
                                int j2 = i2 - position.func_177952_p();
                                if (Math.abs(position.func_177958_n()) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(k1, genh, i2))).func_177230_c().isAir(state, (IBlockReader)world, blockpos) && !state.func_185904_a().func_76230_c() && !state.func_203425_a(BlockTags.field_206952_E) && state.func_177230_c() != Blocks.field_150350_a.func_176223_P().func_177230_c() && state.func_177230_c() != Blocks.field_196642_W.func_176223_P().func_177230_c()) continue;
                                this.setTreeBlockState(changedBlocks, (IWorldWriter)world, blockpos, Blocks.field_196642_W.func_176223_P(), bbox);
                            }
                        }
                    }
                    for (genh = 0; genh < height; ++genh) {
                        BlockPos genhPos = position.func_177981_b(genh);
                        state = world.func_180495_p(genhPos);
                        this.setTreeBlockState(changedBlocks, (IWorldWriter)world, genhPos, Blocks.field_196619_M.func_176223_P(), bbox);
                        if (!state.func_177230_c().isAir(state, (IBlockReader)world, genhPos) && !state.func_185904_a().func_76230_c() && !state.func_203425_a(BlockTags.field_206952_E) && state.func_177230_c() != Blocks.field_150350_a.func_176223_P().func_177230_c() && state.func_177230_c() != Blocks.field_196642_W.func_176223_P().func_177230_c()) continue;
                    }
                    if (rand.nextInt(4) == 0 && height > 5) {
                        for (int hlevel = 0; hlevel < 2; ++hlevel) {
                            for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - hlevel) != 0) continue;
                                Direction dir = Direction2.func_176734_d();
                                this.setTreeBlockState(changedBlocks, (IWorldWriter)world, position.func_177982_a(dir.func_82601_c(), height - 5 + hlevel, dir.func_82599_e()), Blocks.field_150350_a.func_176223_P(), bbox);
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private void addVines(IWorld world, BlockPos pos, Set<BlockPos> changedBlocks, MutableBoundingBox bbox) {
            this.setTreeBlockState(changedBlocks, (IWorldWriter)world, pos, Blocks.field_150350_a.func_176223_P(), bbox);
            BlockPos blockpos = pos.func_177977_b();
            for (int i = 5; world.func_175623_d(blockpos) && i > 0; --i) {
                this.setTreeBlockState(changedBlocks, (IWorldWriter)world, blockpos, Blocks.field_150350_a.func_176223_P(), bbox);
                blockpos = blockpos.func_177977_b();
            }
        }

        private boolean canGrowInto(Block blockType) {
            return blockType.func_176223_P().func_185904_a() == Material.field_151579_a || blockType == Blocks.field_196619_M.func_176223_P().func_177230_c() || blockType == Blocks.field_196642_W.func_176223_P().func_177230_c() || blockType == Blocks.field_196658_i.func_176223_P().func_177230_c() || blockType == Blocks.field_150346_d.func_176223_P().func_177230_c();
        }

        private boolean isReplaceable(IWorld world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockReader)world, pos) || this.canGrowInto(state.func_177230_c()) || !state.func_185904_a().func_76230_c();
        }

        private void setTreeBlockState(Set<BlockPos> changedBlocks, IWorldWriter world, BlockPos pos, BlockState state, MutableBoundingBox mbb) {
            super.func_227217_a_(world, pos, state, mbb);
            changedBlocks.add(pos.func_185334_h());
        }
    }

    static class CustomBiome
    extends Biome {
        public CustomBiome() {
            super(new Biome.Builder().func_205417_d(0.5f).func_205421_a(0.1f).func_205420_b(0.0f).func_205414_c(0.0f).func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.NONE).func_205412_a(-10092442).func_205413_b(329011).func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196658_i.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P())));
            this.setRegistryName("fairy_planes");
            DefaultBiomeFeatures.func_222300_a((Biome)this);
            DefaultBiomeFeatures.func_222335_f((Biome)this);
            DefaultBiomeFeatures.func_222295_c((Biome)this);
            DefaultBiomeFeatures.func_222288_h((Biome)this);
            this.func_226711_a_(Feature.field_214550_p.func_225566_b_((IFeatureConfig)new VillageConfig("village/snowy/town_centers", 6)));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226831_z_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226826_u_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(20, 0.3)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, new CustomTreeFeature().func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196619_M.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P())).func_225569_d_(7).setSapling((IPlantable)Blocks.field_196678_w).func_225568_b_()).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.1f, 1))));
            this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(Feature.field_202318_R.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226767_ab_), Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_))).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
            this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_220360_g, 20, 2, 6));
        }

        @OnlyIn(value=Dist.CLIENT)
        public int func_225528_a_(double posX, double posZ) {
            return -3407617;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int func_225527_a_() {
            return -10027162;
        }
    }
}

