# ========================================================================================================================================================
# Base de Datos Farmacia-1 (PA) v1, 2025-05-07 Test-l
# ========================================================================================================================================================

# Estructura de la tabla TblBloqueoFar1 ==================================================================================================================

CREATE TABLE TblBloqueoFar1 (
  BloSts TINYINT NOT NULL, 
  SelId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  LotId INTEGER NOT NULL, 
  BloCan INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblConfiguracionesFar1 ==========================================================================================================

CREATE TABLE TblConfiguracionesFar1 (
  ConId INTEGER NOT NULL AUTO_INCREMENT, 
  ConNom VARCHAR(100) NOT NULL, 
  ConSts VARCHAR(250) NOT NULL, 
  PRIMARY KEY (ConId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblDistribucionesFar1 ===========================================================================================================

CREATE TABLE TblDistribucionesFar1 (
  DisId INTEGER NOT NULL AUTO_INCREMENT, 
  DisNro VARCHAR(50) NOT NULL, 
  ModId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  DisCod VARCHAR(20) NOT NULL, 
  DisSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  DisAct TINYINT NOT NULL,  
  PRIMARY KEY (DisId)
) 
ENGINE=InnoDB;

INSERT INTO TblDistribucionesFar1 (DisId, DisNro, ModId, RepId, MvsId, ObsId, DisCod, DisSts, UsuId, DisAct) 
VALUES (0, '0', 1, 0, 0, 0, '0', 0, 0, 0);

UPDATE TblDistribucionesFar1 SET DisId = 0 WHERE DisId = 1;

ALTER TABLE TblDistribucionesFar1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblEntradasFar1 =================================================================================================================

CREATE TABLE TblEntradasFar1 (
  EntId INTEGER NOT NULL AUTO_INCREMENT, 
  EntDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  ModCod INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  EntAct TINYINT NOT NULL,
  PRIMARY KEY (EntId)
) 
ENGINE=InnoDB;

INSERT INTO TblEntradasFar1 (EntId, EntDoc, ProId, RepId, DisId, ModCod, MvsId, ObsId, UsuId, EntAct) 
VALUES (0, '0', 0, 0, 0, 0, 0, 0, 0, 0);

UPDATE TblEntradasFar1 SET EntId = 0 WHERE EntId = 1;

ALTER TABLE TblEntradasFar1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblEtiquetasFar1 ================================================================================================================

CREATE TABLE TblEtiquetasFar1 (
  SalId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  EtiDos DECIMAL(11,4) NOT NULL, 
  EtiMed VARCHAR(3) NOT NULL, 
  FreId INTEGER NOT NULL, 
  ViaId INTEGER NOT NULL, 
  EtiDia INTEGER NOT NULL, 
  IndId INTEGER NOT NULL, 
  NotId INTEGER NOT NULL, 
  EtiFch DATE NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblFraccionesFar1 ===============================================================================================================

CREATE TABLE TblFraccionesFar1 (
  FraId INTEGER NOT NULL AUTO_INCREMENT, 
  MvsId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  FueId INTEGER NOT NULL, 
  EntId INTEGER NOT NULL, 
  PosId INTEGER NOT NULL, 
  SalId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  NegId INTEGER NOT NULL, 
  FraEnt INTEGER NOT NULL, 
  FraPos INTEGER NOT NULL, 
  FraSal INTEGER NOT NULL, 
  FraDis INTEGER NOT NULL, 
  FraNeg INTEGER NOT NULL, 
  FraCos DECIMAL(11,4) NOT NULL, 
  LotId INTEGER NOT NULL, 
  FraRec INTEGER NOT NULL, 
  FraFch DATE NOT NULL, 
  UsuId INTEGER NOT NULL, 
  FraAct TINYINT NOT NULL, 
  INDEX (MvsId), 
  INDEX (SelId), 
  INDEX (EntId), 
  INDEX (PosId), 
  INDEX (SalId), 
  INDEX (DisId), 
  INDEX (NegId), 
  INDEX (FraFch),  
  PRIMARY KEY (FraId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblInternacionesFar1 ============================================================================================================

CREATE TABLE TblInternacionesFar1 (
  IntId INTEGER NOT NULL AUTO_INCREMENT, 
  FueId INTEGER NOT NULL, 
  SerId INTEGER NOT NULL, 
  CamId INTEGER NOT NULL, 
  IntFhi DATE NOT NULL, 
  IntFha DATE NOT NULL, 
  IntObs VARCHAR(250) NOT NULL, 
  IntSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  IntAct TINYINT NOT NULL, 
  PRIMARY KEY (IntId)
) 
ENGINE=InnoDB;

INSERT INTO TblInternacionesFar1 (IntId, FueId, SerId, CamId, IntFhi, IntFha, IntObs, IntSts, UsuId, IntAct) 
VALUES (0, 1, 0, 0, '2000-01-01', '2000-01-01', '0', 0, 0, 0);

UPDATE TblInternacionesFar1 SET IntId = 0 WHERE IntId = 1;

ALTER TABLE TblInternacionesFar1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblLotesFar1 ====================================================================================================================

CREATE TABLE TblLotesFar1 (
  LotId INTEGER NOT NULL AUTO_INCREMENT, 
  LotNro VARCHAR(20) NOT NULL, 
  LotVto DATE NOT NULL, 
  LotCos DECIMAL(11,5) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  LotAct TINYINT NOT NULL, 
  INDEX (LotNro), 
  PRIMARY KEY (LotId)
) 
ENGINE=InnoDB;

INSERT INTO TblLotesFar1 (LotId, LotNro, LotVto, LotCos, UsuId, LotAct) 
VALUES (0, '0', '2000-01-01', '0', 0, 0);

UPDATE TblLotesFar1 SET LotId = 0 WHERE LotId = 1;

ALTER TABLE TblLotesFar1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblMensualesFar1 ================================================================================================================

CREATE TABLE TblMensualesFar1 (
  MenId INTEGER NOT NULL AUTO_INCREMENT, 
  MenNro TINYINT NOT NULL, 
  MenMes VARCHAR(20) NOT NULL, 
  MenCon TINYINT NOT NULL, 
  MenMax DECIMAL(3,1) NOT NULL, 
  MenMin DECIMAL(3,1) NOT NULL, 
  MenFch DATE NOT NULL, 
  GesId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (MenMes), 
  PRIMARY KEY (MenId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMensualFar1 ==================================================================================================================

CREATE TABLE TblMensualFar1 (
  MenId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  MenSM INTEGER NOT NULL, 
  MenRM INTEGER NOT NULL, 
  MenCM INTEGER NOT NULL, 
  MenDM INTEGER NOT NULL, 
  MenAP INTEGER NOT NULL, 
  MenAN INTEGER NOT NULL, 
  MenCP INTEGER NOT NULL, 
  MenDI INTEGER NOT NULL, 
  MenME VARCHAR(10) NOT NULL, 
  MenMU VARCHAR(10) NOT NULL, 
  MenCS INTEGER NOT NULL, 
  MenCO DECIMAL(11,2) NOT NULL, 
  INDEX (MenId), 
  INDEX (SelId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMovimientoFar1 ===============================================================================================================

CREATE TABLE TblMovimientoFar1 (
  MovId INTEGER NOT NULL AUTO_INCREMENT, 
  MvsId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  FueId INTEGER NOT NULL, 
  EntId INTEGER NOT NULL, 
  PosId INTEGER NOT NULL, 
  SalId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  NegId INTEGER NOT NULL, 
  MovEnt INTEGER NOT NULL, 
  MovPos INTEGER NOT NULL, 
  MovSal INTEGER NOT NULL, 
  MovDis INTEGER NOT NULL, 
  MovNeg INTEGER NOT NULL, 
  MovSdo INTEGER NOT NULL, 
  MovCos DECIMAL(11,4) NOT NULL, 
  LotId INTEGER NOT NULL, 
  MovRec INTEGER NOT NULL, 
  MovFch DATE NOT NULL, 
  UsuId INTEGER NOT NULL, 
  MovAct TINYINT NOT NULL, 
  INDEX (MvsId), 
  INDEX (SelId), 
  INDEX (EntId), 
  INDEX (PosId), 
  INDEX (SalId), 
  INDEX (DisId), 
  INDEX (NegId), 
  INDEX (MovFch),  
  PRIMARY KEY (MovId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblNegativosFar1 ================================================================================================================

CREATE TABLE TblNegativosFar1 (
  NegId INTEGER NOT NULL AUTO_INCREMENT, 
  RecId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  NegAct TINYINT NOT NULL,
  PRIMARY KEY (NegId)
) 
ENGINE=InnoDB;

INSERT INTO TblNegativosFar1 (NegId, RecId, RepId, MvsId, ObsId, UsuId, NegAct) 
VALUES (0, 0, 0, 0, 0, 0, 0);

UPDATE TblNegativosFar1 SET NegId = 0 WHERE NegId = 1;

ALTER TABLE TblNegativosFar1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblPositivosFar1 ================================================================================================================

CREATE TABLE TblPositivosFar1 (
  PosId INTEGER NOT NULL AUTO_INCREMENT, 
  PosDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PosAct TINYINT NOT NULL, 
  INDEX (PosDoc), 
  PRIMARY KEY (PosId)
) 
ENGINE=InnoDB;

INSERT INTO TblPositivosFar1 (PosId, PosDoc, ProId, RepId, MvsId, ObsId, UsuId, PosAct) 
VALUES (0, '0', 0, 0, 0, 0, 0, 0);

UPDATE TblPositivosFar1 SET PosId = 0 WHERE PosId = 1;

ALTER TABLE TblPositivosFar1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblRelacionIntDiaFar1 ===========================================================================================================

CREATE TABLE TblRelacionIntDiaFar1 (
  IntId INTEGER NOT NULL, 
  DiaId INTEGER NOT NULL, 
  DiaCos DECIMAL(11,4) NOT NULL, 
  DiaNro TINYINT NOT NULL, 
  DiaFch DATE NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblRelacionSalDiaFar1 ===========================================================================================================

CREATE TABLE TblRelacionSalDiaFar1 (
  SalId INTEGER NOT NULL, 
  DiaId INTEGER NOT NULL, 
  DiaCos DECIMAL(11,4) NOT NULL, 
  DiaNro TINYINT NOT NULL, 
  DiaFch DATE NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblSalidasFar1 ==================================================================================================================

CREATE TABLE TblSalidasFar1 (
  SalId INTEGER NOT NULL AUTO_INCREMENT, 
  SalDoc VARCHAR(50) NOT NULL, 
  FueId INTEGER NOT NULL, 
  SerId INTEGER NOT NULL, 
  AmbId INTEGER NOT NULL, 
  PacId INTEGER NOT NULL, 
  DsrId INTEGER NOT NULL, 
  PsrId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  SalAno TINYINT NOT NULL, 
  SalMes TINYINT NOT NULL, 
  SalDia TINYINT NOT NULL, 
  SalTot DECIMAL(11,4) NOT NULL, 
  SalFch DATE NOT NULL, 
  SalAte DATE NOT NULL, 
  SalAse TINYINT NOT NULL, 
  SalTur VARCHAR(1) NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  IntId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SalAct TINYINT NOT NULL, 
  INDEX (SalDoc), 
  INDEX (SalAno), 
  INDEX (SalMes), 
  INDEX (SalDia), 
  INDEX (SalFch), 
  PRIMARY KEY (SalId)
) 
ENGINE=InnoDB;

INSERT INTO TblSalidasFar1 (SalId, SalDoc, FueId, SerId, AmbId, PacId, DsrId, PsrId, RepId, SalAno, SalMes, SalDia, SalTot, SalFch, SalAte, SalAse, SalTur, MvsId, ObsId, IntId, UsuId, SalAct) 
VALUES (0, '0', 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2000-01-01', '2000-01-01', 0, '0', 0, 0, 0, 0, 0);

UPDATE TblSalidasFar1 SET SalId = 0 WHERE SalId = 1;

ALTER TABLE TblSalidasFar1 AUTO_INCREMENT = 1;

# Relaciones de la tabla TblDistribucionesFar1 ===========================================================================================================

ALTER TABLE TblDistribucionesFar1 ADD CONSTRAINT TblDistribucionesFar1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblDistribucionesFar1 ADD CONSTRAINT TblDistribucionesFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblDistribucionesFar1 ADD CONSTRAINT TblDistribucionesFar1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblDistribucionesFar1 ADD CONSTRAINT TblDistribucionesFar1ModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblDistribucionesFar1 ADD CONSTRAINT TblDistribucionesFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblEntradasFar1 =================================================================================================================

ALTER TABLE TblEntradasFar1 ADD CONSTRAINT TblEntradasFar1ProId FOREIGN KEY (ProId) REFERENCES TblProveedores (ProId);
ALTER TABLE TblEntradasFar1 ADD CONSTRAINT TblEntradasFar1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblEntradasFar1 ADD CONSTRAINT TblEntradasFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblEntradasFar1 ADD CONSTRAINT TblEntradasFar1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblEntradasFar1 ADD CONSTRAINT TblEntradasFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblEtiquetasFar1 ================================================================================================================

ALTER TABLE TblEtiquetasFar1 ADD CONSTRAINT TblEtiquetasFar1SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar1 (SalId);
ALTER TABLE TblEtiquetasFar1 ADD CONSTRAINT TblEtiquetasFar1SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblEtiquetasFar1 ADD CONSTRAINT TblEtiquetasFar1FreId FOREIGN KEY (FreId) REFERENCES TblFrecuencias (FreId);
ALTER TABLE TblEtiquetasFar1 ADD CONSTRAINT TblEtiquetasFar1ViaId FOREIGN KEY (ViaId) REFERENCES TblVias (ViaId);
ALTER TABLE TblEtiquetasFar1 ADD CONSTRAINT TblEtiquetasFar1IndId FOREIGN KEY (IndId) REFERENCES TblIndicaciones (IndId);
ALTER TABLE TblEtiquetasFar1 ADD CONSTRAINT TblEtiquetasFar1NotId FOREIGN KEY (NotId) REFERENCES TblNotas (NotId);

# Relaciones de la tabla TblFraccionesFar1 ===============================================================================================================

ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1EntId FOREIGN KEY (EntId) REFERENCES TblEntradasFar1 (EntId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1PosId FOREIGN KEY (PosId) REFERENCES TblPositivosFar1 (PosId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar1 (SalId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1DisId FOREIGN KEY (DisId) REFERENCES TblDistribucionesFar1 (DisId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1NegId FOREIGN KEY (NegId) REFERENCES TblNegativosFar1 (NegId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1LotId FOREIGN KEY (LotId) REFERENCES TblLotesFar1 (LotId);
ALTER TABLE TblFraccionesFar1 ADD CONSTRAINT TblFraccionesFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblInternacionesFar1 ============================================================================================================

ALTER TABLE TblInternacionesFar1 ADD CONSTRAINT TblInternacionesFar1FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblInternacionesFar1 ADD CONSTRAINT TblInternacionesFar1SerId FOREIGN KEY (SerId) REFERENCES TblServicios (SerId);
ALTER TABLE TblInternacionesFar1 ADD CONSTRAINT TblInternacionesFar1CamId FOREIGN KEY (CamId) REFERENCES TblCamas (CamId);
ALTER TABLE TblInternacionesFar1 ADD CONSTRAINT TblInternacionesFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblLotesFar1 ====================================================================================================================

ALTER TABLE TblLotesFar1 ADD CONSTRAINT TblLotesFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMensualFar1 ==================================================================================================================

ALTER TABLE TblMensualFar1 ADD CONSTRAINT TblMensualFar1MenId FOREIGN KEY (MenId) REFERENCES TblMensualesFar1 (MenId);
ALTER TABLE TblMensualFar1 ADD CONSTRAINT TblMensualFar1SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblMensualesFar1 ================================================================================================================

ALTER TABLE TblMensualesFar1 ADD CONSTRAINT TblMensualesFar1GesId FOREIGN KEY (GesId) REFERENCES TblGestion (GesId);
ALTER TABLE TblMensualesFar1 ADD CONSTRAINT TblMensualesFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMovimientoFar1 ===============================================================================================================

ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1EntId FOREIGN KEY (EntId) REFERENCES TblEntradasFar1 (EntId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1PosId FOREIGN KEY (PosId) REFERENCES TblPositivosFar1 (PosId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar1 (SalId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1DisId FOREIGN KEY (DisId) REFERENCES TblDistribucionesFar1 (DisId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1NegId FOREIGN KEY (NegId) REFERENCES TblNegativosFar1 (NegId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1LotId FOREIGN KEY (LotId) REFERENCES TblLotesFar1 (LotId);
ALTER TABLE TblMovimientoFar1 ADD CONSTRAINT TblMovimientoFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblNegativosFar1 ================================================================================================================

ALTER TABLE TblNegativosFar1 ADD CONSTRAINT TblNegativosFar1RecId FOREIGN KEY (RecId) REFERENCES TblReceptores (RecId);
ALTER TABLE TblNegativosFar1 ADD CONSTRAINT TblNegativosFar1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblNegativosFar1 ADD CONSTRAINT TblNegativosFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblNegativosFar1 ADD CONSTRAINT TblNegativosFar1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblNegativosFar1 ADD CONSTRAINT TblNegativosFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblPositivosFar1 ================================================================================================================

ALTER TABLE TblPositivosFar1 ADD CONSTRAINT TblPositivosFar1ProId FOREIGN KEY (ProId) REFERENCES TblProveedores (ProId);
ALTER TABLE TblPositivosFar1 ADD CONSTRAINT TblPositivosFar1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblPositivosFar1 ADD CONSTRAINT TblPositivosFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblPositivosFar1 ADD CONSTRAINT TblPositivosFar1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblPositivosFar1 ADD CONSTRAINT TblPositivosFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblRelacionIntDiaFar1 ===========================================================================================================

ALTER TABLE TblRelacionIntDiaFar1 ADD CONSTRAINT TblRelacionIntDiaFar1IntId FOREIGN KEY (IntId) REFERENCES TblInternacionesFar1 (IntId);
ALTER TABLE TblRelacionIntDiaFar1 ADD CONSTRAINT TblRelacionIntDiaFar1DiaId FOREIGN KEY (DiaId) REFERENCES TblDiagnosticos (DiaId);

# Relaciones de la tabla TblRelacionSalDiaFar1 ===========================================================================================================

ALTER TABLE TblRelacionSalDiaFar1 ADD CONSTRAINT TblRelacionSalDiaFar1SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar1 (SalId);
ALTER TABLE TblRelacionSalDiaFar1 ADD CONSTRAINT TblRelacionSalDiaFar1DiaId FOREIGN KEY (DiaId) REFERENCES TblDiagnosticos (DiaId);

# Relaciones de la tabla TblSalidasFar1 ==================================================================================================================

ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1SerId FOREIGN KEY (SerId) REFERENCES TblServicios (SerId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1AmbId FOREIGN KEY (AmbId) REFERENCES TblAmbientes (AmbId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1PacId FOREIGN KEY (PacId) REFERENCES TblPacientes (PacId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1DsrId FOREIGN KEY (DsrId) REFERENCES TblDispensadores (DsrId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1PsrId FOREIGN KEY (PsrId) REFERENCES TblPrescriptores (PsrId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1IntId FOREIGN KEY (IntId) REFERENCES TblInternacionesFar1 (IntId);
ALTER TABLE TblSalidasFar1 ADD CONSTRAINT TblSalidasFar1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);