# ========================================================================================================================================================
# Base de Datos Establecimiento de Salud (PA) v1, 2025-05-07 Test-l
# ========================================================================================================================================================

# Cambiar el nombre de la base de datos segun la institucio ej: (bdsalmi_es_santotomas) ==================================================================
CREATE DATABASE bdsalmi_es DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci;
#CREATE DATABASE bdsalmi_es DEFAULT CHARACTER SET utf8mb4;

# Cambiar el nombre de la base de datos segun la institucio ej: (bdsalmi_es_santotomas) ==================================================================
USE bdsalmi_es;

# Estructura de la tabla TblActualizaciones ==============================================================================================================

CREATE TABLE TblActualizaciones (
  ActId INTEGER NOT NULL, 
  ActNom VARCHAR(100) NOT NULL, 
  ActFch DATE NOT NULL, 
  ActAct DATE NOT NULL,
  PRIMARY KEY (ActId)
) 
ENGINE=InnoDB;

INSERT INTO TblActualizaciones (ActId, ActNom, ActFch, ActAct) VALUES 
(1, 'Actualización de Parámetros', '2000-01-01', '2001-01-01'), 
(2, 'Actualización de Medicamentos', '2000-01-01', '2001-01-01'), 
(3, 'Actualización de Insumos', '2000-01-01', '2001-01-01'), 
(4, 'Actualización de Diagnósticos', '2000-01-01', '2001-01-01'), 
(5, 'Actualización de Red de Servicios', '2000-01-01', '2001-01-01'), 
(6, 'Actualización de Monitoreo Automático', '2000-01-01', '2001-01-01');

# Estructura de la tabla TblAdministrativos ==============================================================================================================

CREATE TABLE TblAdministrativos (
  AdmId INTEGER NOT NULL,
  AdmCod VARCHAR(20) NOT NULL, 
  RegCod VARCHAR(10) NOT NULL, 
  AdmMun VARCHAR(50) NOT NULL, 
  AdmCla VARCHAR(10) NOT NULL, 
  AdmEst VARCHAR(50) NOT NULL, 
  AdmDir VARCHAR(100) NOT NULL, 
  AdmTel VARCHAR(20) NOT NULL,  
  AdmNiv VARCHAR(20) NOT NULL, 
  AdmVer INTEGER NOT NULL, 
  AdmRst INTEGER NOT NULL, 
  AdmTok VARCHAR(50) NOT NULL, 
  AdmSin DATETIME NOT null, 
  ResId INTEGER NOT NULL, 
  AdmDri VARCHAR(50) NOT NULL, 
  AdmSer VARCHAR(90) NOT NULL, 
  AdmPue VARCHAR(10) NOT NULL, 
  AdmBas VARCHAR(20) NOT NULL, 
  AdmUsu VARCHAR(50) NOT NULL, 
  AdmCon VARCHAR(50) NOT NULL, 
  AdmSsl VARCHAR(10) NOT NULL, 
  PRIMARY KEY (AdmId)
) 
ENGINE=InnoDB;

INSERT INTO TblAdministrativos (AdmId, AdmCod, RegCod, AdmMun, AdmCla, AdmEst, AdmDir, AdmTel, AdmNiv, AdmVer, AdmRst, AdmTok, AdmSin, ResId, AdmDri, AdmSer, AdmPue, AdmBas, AdmUsu, AdmCon, AdmSsl) 
VALUES (1, '0', '0', '0', '0', '0', '0', '0', '0', 1, 0, '0', '2000-01-01 01:01:01', 1, '0', '0', '0', '0', '0', '0', '0');

# Estructura de la tabla TblAmbientes ====================================================================================================================

CREATE TABLE TblAmbientes (
  AmbId INTEGER NOT NULL AUTO_INCREMENT, 
  AmbTip VARCHAR(20) NOT NULL, 
  AmbNom VARCHAR(50) NOT NULL, 
  AmbDes VARCHAR(250) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  AmbAct TINYINT NOT NULL,
  PRIMARY KEY (AmbId)
) 
ENGINE=InnoDB;

INSERT INTO TblAmbientes (AmbId, AmbTip, AmbNom, AmbDes, UsuId, AmbAct) VALUES 
(0, 'Ninguno', 'Ninguna', 'Ninguna', 0, 0);

UPDATE TblAmbientes SET AmbId = 0 WHERE AmbId = 1;

ALTER TABLE TblAmbientes AUTO_INCREMENT = 1;

# Estructura de la tabla TblBarras =======================================================================================================================

CREATE TABLE TblBarras (
  SelId INTEGER NOT NULL, 
  BarCod VARCHAR(50) NOT NULL, 
  UsuId INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblCamas ========================================================================================================================

CREATE TABLE TblCamas (
  CamId INTEGER NOT NULL AUTO_INCREMENT, 
  AmbId INTEGER NOT NULL, 
  CamNom VARCHAR(50) NOT NULL, 
  CamDes VARCHAR(250) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  CamAct TINYINT NOT NULL,
  PRIMARY KEY (CamId)
) 
ENGINE=InnoDB;

INSERT INTO TblCamas (CamId, AmbId, CamNom, CamDes, UsuId, CamAct) 
VALUES (0, 0, 'Ninguna', 'Ninguna', 0, 0);

UPDATE TblCamas SET CamId = 0 WHERE CamId = 1;

ALTER TABLE TblCamas AUTO_INCREMENT = 1;

# Estructura de la tabla TblCargos =======================================================================================================================

CREATE TABLE TblCargos (
  CarId INTEGER NOT NULL, 
  CarNom VARCHAR(50) NOT NULL, 
  INDEX (CarNom), 
  PRIMARY KEY (CarId)
) 
ENGINE=InnoDB;

INSERT INTO TblCargos (CarId, CarNom) 
VALUES (0, 'Otro');

# Estructura de la tabla TblCausas =======================================================================================================================

CREATE TABLE TblCausas (
  CauId INTEGER NOT NULL, 
  CauNom VARCHAR(50) NOT NULL, 
  CauTip VARCHAR(10) NOT NULL, 
  INDEX (CauNom), 
  PRIMARY KEY (CauId)
) 
ENGINE=InnoDB;

INSERT INTO TblCausas (CauId, CauNom, CauTip) 
VALUES (0, 'Otra', 'Otra');

# Estructura de la tabla TblClasificaciones ==============================================================================================================

CREATE TABLE TblClasificaciones (
  ClaId INTEGER NOT NULL AUTO_INCREMENT, 
  ClaTip INTEGER NOT NULL, 
  ClaNom VARCHAR(100) NOT NULL, 
  ClaSgs VARCHAR(50) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PRIMARY KEY (ClaId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblClasificacion ================================================================================================================

CREATE TABLE TblClasificacion (
  ClaId INTEGER NOT NULL, 
  ClaIde INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblConfiguraciones ==============================================================================================================

CREATE TABLE TblConfiguraciones (
  ConId INTEGER NOT NULL AUTO_INCREMENT, 
  ConNom VARCHAR(100) NOT NULL, 
  ConSts VARCHAR(250) NOT NULL, 
  PRIMARY KEY (ConId)
) 
ENGINE=InnoDB;

# Crear tabla TblDepartamentos ===========================================================================================================================

CREATE TABLE TblDepartamentos (
  DepCod VARCHAR(10) NOT NULL, 
  DepNom VARCHAR(20) NOT NULL, 
  DepSgs VARCHAR(10) NOT NULL, 
  INDEX (DepNom), 
  PRIMARY KEY (DepCod)
)
ENGINE=InnoDB;

# Estructura de la tabla TblDiagnostico ==================================================================================================================

CREATE TABLE TblDiagnostico (
  DiaCod VARCHAR(20) NOT NULL, 
  DiaNom VARCHAR(250) NOT NULL, 
  INDEX (DiaCod), 
  INDEX (DiaNom)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblDiagnosticos =================================================================================================================

CREATE TABLE TblDiagnosticos (
  DiaId INTEGER NOT NULL AUTO_INCREMENT, 
  DiaCod VARCHAR(20) NOT NULL, 
  DiaNom VARCHAR(250) NOT NULL, 
  DiaCos DECIMAL(11,4) NOT NULL, 
  FueId INTEGER NOT NULL, 
  DiaTip TINYINT NOT NULL, 
  DiaCla TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  DiaAct TINYINT NOT NULL, 
  INDEX (DiaCod), 
  INDEX (DiaNom), 
  PRIMARY KEY (DiaId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblDispensadores ================================================================================================================

CREATE TABLE TblDispensadores (
  DsrId INTEGER NOT NULL AUTO_INCREMENT, 
  DsrNom VARCHAR(50) NOT NULL, 
  DsrApe VARCHAR(50) NOT NULL, 
  DsrApm VARCHAR(50) NOT NULL, 
  DsrIde VARCHAR(20) NOT NULL, 
  PrfId INTEGER NOT NULL, 
  CarId INTEGER NOT NULL, 
  DsrCel VARCHAR(20) NOT NULL, 
  DsrCor VARCHAR(50) NOT NULL, 
  DsrSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  DsrAct TINYINT NOT NULL, 
  INDEX (DsrNom), 
  INDEX (DsrApe), 
  INDEX (DsrIde), 
  PRIMARY KEY (DsrId)
) 
ENGINE=InnoDB;

INSERT INTO TblDispensadores (DsrId, DsrNom, DsrApe, DsrApm, DsrIde, PrfId, CarId, DsrCel, DsrCor, DsrSts, UsuId, DsrAct) 
VALUES (0, 'Sin', 'Dispensador', 'Definido', '0', 0, 0, '0', '0', 0, 0, 1);

UPDATE TblDispensadores SET DsrId = 0 WHERE DsrId = 1;

ALTER TABLE TblDispensadores AUTO_INCREMENT = 1;

# Estructura de la tabla TblEntradasTem ==================================================================================================================

CREATE TABLE TblEntradasTem (
  EntId INTEGER NOT NULL AUTO_INCREMENT, 
  EntDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  ModId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  EntLot VARCHAR(20) NOT NULL, 
  EntVto DATE NOT NULL, 
  EntCan INTEGER NOT NULL, 
  EntCos DECIMAL(11,4) NOT NULL, 
  EntFra INTEGER NOT NULL, 
  EntFca INTEGER NOT NULL, 
  EntFco DECIMAL(11,4) NOT NULL, 
  PRIMARY KEY (EntId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblEspecialidades ===============================================================================================================

CREATE TABLE TblEspecialidades (
  EspId INTEGER NOT NULL, 
  EspNom VARCHAR(50) NOT NULL, 
  INDEX (EspNom), 
  PRIMARY KEY (EspId)
) 
ENGINE=InnoDB;

INSERT INTO TblEspecialidades (EspId, EspNom) 
VALUES (0, 'Otra');

# Estructura de la tabla TblEstablecimientos =============================================================================================================

CREATE TABLE TblEstablecimientos (
  EstCod VARCHAR(20) NOT NULL, 
  RegCod VARCHAR(10) NOT NULL, 
  EstNom VARCHAR(100) NOT NULL, 
  EstTip VARCHAR(10) NOT NULL, 
  NivId INTEGER NOT NULL, 
  EstLat VARCHAR(20) NOT NULL, 
  EstLon VARCHAR(20) NOT NULL, 
  INDEX (EstCod), 
  INDEX (EstNom)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblFrecuencias ==================================================================================================================

CREATE TABLE TblFrecuencias (
  FreId INTEGER NOT NULL, 
  FreCod VARCHAR(10) NOT NULL, 
  FreNom VARCHAR(100) NOT NULL, 
  FreNro VARCHAR(20) NOT NULL, 
  INDEX (FreCod),
  INDEX (FreNom), 
  PRIMARY KEY (FreId) 
) 
ENGINE=InnoDB;

# Estructura de la tabla TblFuentes ======================================================================================================================

CREATE TABLE TblFuentes (
  FueId INTEGER NOT NULL, 
  FueNom VARCHAR(100) NOT NULL, 
  FueSgs VARCHAR(20) NOT NULL, 
  FueMax DECIMAL(3,1) NOT NULL, 
  FueMin DECIMAL(3,1) NOT NULL, 
  FueAct TINYINT NOT NULL, 
  INDEX (FueNom), 
  PRIMARY KEY (FueId)
) 
ENGINE=InnoDB;

INSERT INTO TblFuentes (FueId, FueNom, FueSgs, FueMax, FueMin, FueAct) 
VALUES (1, 'Ninguno', 'N', '4.5', '1.5', 1);

# Estructura de la tabla TblGestion ======================================================================================================================

CREATE TABLE TblGestion (
  GesId INTEGER NOT NULL AUTO_INCREMENT, 
  GesNro INTEGER NOT NULL, 
  GesFch DATE NOT NULL, 
  GesMee INTEGER NOT NULL, 
  GesMen INTEGER NOT NULL, 
  GesIne INTEGER NOT NULL, 
  GesInn INTEGER NOT NULL, 
  GesDia INTEGER NOT NULL, 
  GesRec INTEGER NOT NULL, 
  GesSol INTEGER NOT NULL, 
  GesEnt INTEGER NOT NULL, 
  GesPos INTEGER NOT NULL, 
  GesNeg INTEGER NOT NULL, 
  GesDis INTEGER NOT NULL, 
  GesPac INTEGER NOT NULL, 
  GesAte INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  GesAct TINYINT NOT NULL, 
  PRIMARY KEY (GesId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblIndicaciones =================================================================================================================

CREATE TABLE TblIndicaciones (
  IndId INTEGER NOT NULL AUTO_INCREMENT, 
  IndTxt VARCHAR(255) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (IndTxt), 
  PRIMARY KEY (IndId)
) 
ENGINE=InnoDB;

INSERT INTO TblIndicaciones (IndId, IndTxt, UsuId) 
VALUES (0, '0', 0);

UPDATE TblIndicaciones SET IndId = 0 WHERE IndId = 1;

ALTER TABLE TblIndicaciones AUTO_INCREMENT = 1;

# Estructura de la tabla TblInsumos ======================================================================================================================

CREATE TABLE TblInsumos (
  InsCod VARCHAR(20) NOT NULL, 
  InsNom VARCHAR(200) NOT NULL, 
  InsFof VARCHAR(50) NOT NULL, 
  InsCon VARCHAR(50) NOT NULL, 
  InsCos DECIMAL(11,4) NOT NULL, 
  NivId INTEGER NOT NULL, 
  INDEX (InsNom), 
  INDEX (InsFof), 
  INDEX (InsCon)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblInsumosFue ===================================================================================================================

CREATE TABLE TblInsumosFue (
  InsCod VARCHAR(20) NOT NULL, 
  InsNom VARCHAR(200) NOT NULL, 
  InsFof VARCHAR(50) NOT NULL, 
  InsCon VARCHAR(50) NOT NULL, 
  InsCos DECIMAL(11,4) NOT NULL, 
  NivId INTEGER NOT NULL, 
  INDEX (InsNom), 
  INDEX (InsFof), 
  INDEX (InsCon)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblJornadas =====================================================================================================================

CREATE TABLE TblJornadas (
  PsrId INTEGER NOT NULL, 
  JorTip TINYINT NOT NULL, 
  JorDia VARCHAR(10) NOT NULL, 
  JorDno INTEGER NOT NULL, 
  JorHin TIME NOT NULL, 
  JorHfi TIME NOT NULL, 
  JorCit INTEGER NOT NULL, 
  JorDur TIME NOT NULL, 
  JorFin DATE NOT NULL, 
  JorFfi DATE NOT NULL, 
  JorTod TINYINT NOT NULL, 
  JorRep TINYINT NOT NULL, 
  JorMot VARCHAR(100) NOT NULL, 
  UsuId INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMedicamentos =================================================================================================================

CREATE TABLE TblMedicamentos (
  MedCod VARCHAR(20) NOT NULL, 
  MedNom VARCHAR(200) NOT NULL, 
  MedFof VARCHAR(50) NOT NULL, 
  MedCon VARCHAR(50) NOT NULL, 
  MedCos DECIMAL(11,4) NOT NULL, 
  NivId INTEGER NOT NULL, 
  INDEX (MedNom), 
  INDEX (MedFof), 
  INDEX (MedCon)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMedicamentosFue ==============================================================================================================

CREATE TABLE TblMedicamentosFue (
  MedCod VARCHAR(20) NOT NULL, 
  MedNom VARCHAR(200) NOT NULL, 
  MedFof VARCHAR(50) NOT NULL, 
  MedCon VARCHAR(50) NOT NULL, 
  MedCos DECIMAL(11,4) NOT NULL, 
  NivId INTEGER NOT NULL, 
  INDEX (MedNom), 
  INDEX (MedFof), 
  INDEX (MedCon)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMensualesCon =================================================================================================================

CREATE TABLE TblMensualesCon (
  MenId INTEGER NOT NULL AUTO_INCREMENT, 
  MenNro TINYINT NOT NULL, 
  MenMes VARCHAR(20) NOT NULL, 
  MenCon TINYINT NOT NULL, 
  MenMax DECIMAL(3,1) NOT NULL, 
  MenMin DECIMAL(3,1) NOT NULL, 
  MenReg TINYINT NOT NULL, 
  MenRep TINYINT NOT NULL, 
  MenCds TINYINT NOT NULL, 
  MenFch DATE NOT NULL, 
  GesId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (MenMes), 
  PRIMARY KEY (MenId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMensualCon ===================================================================================================================

CREATE TABLE TblMensualCon (
  MenId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  MenSM INTEGER NOT NULL, 
  MenRM INTEGER NOT NULL, 
  MenCM INTEGER NOT NULL, 
  MenAP INTEGER NOT NULL, 
  MenAN INTEGER NOT NULL, 
  MenCP INTEGER NOT NULL, 
  MenDI INTEGER NOT NULL, 
  MenME VARCHAR(10) NOT NULL, 
  MenMU VARCHAR(10) NOT NULL, 
  MenCS INTEGER NOT NULL, 
  MenCO DECIMAL(11,2) NOT NULL, 
  INDEX (MenId), 
  INDEX (SelId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblModulos ======================================================================================================================

CREATE TABLE TblModulos (
  MosId INTEGER NOT NULL, 
  MosNom VARCHAR(50) NOT NULL, 
  PRIMARY KEY (MosId)
) 
ENGINE=InnoDB;

INSERT INTO TblModulos (MosId, MosNom) VALUES 
(1, 'Administrador'), 
(2, 'Almacén'), 
(3, 'Farmacia'), 
(4, 'Sub Farmacia'),
(5, 'Admisión'), 
(6, 'Consultorio');

# Estructura de la tabla TblModulo =======================================================================================================================

CREATE TABLE TblModulo (
  ModId INTEGER NOT NULL AUTO_INCREMENT, 
  ModNom VARCHAR(50) NOT NULL, 
  ModCod INTEGER NOT NULL, 
  MosId INTEGER NOT NULL, 
  ModFch DATE NOT NULL, 
  ModCon INTEGER NOT NULL, 
  ModMax DECIMAL(3,1) NOT NULL, 
  ModMin DECIMAL(3,1) NOT NULL, 
  ModVer VARCHAR(10) NOT NULL, 
  ModUlt DATETIME NOT NULL, 
  ModAct TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PRIMARY KEY (ModId)
) 
ENGINE=InnoDB;

INSERT INTO TblModulo (ModId, ModNom, ModCod, MosId, ModFch, ModCon, ModMax, ModMin, ModVer, ModUlt, ModAct, UsuId) VALUES 
(1, 'Administrador', 1, 1, '2000-01-01', 12, '3', '2', '0', '2000-01-01 00:00:00', 1, 0), 
(2, 'Admisión', 1, 5, '2000-01-01', 0, '0', '0', '0', '2000-01-01 00:00:00', 1, 0), 
(3, 'Consultorio', 1, 6, '2000-01-01', 0, '0', '0', '0', '2000-01-01 00:00:00', 1, 0);

# Estructura de la tabla TblModificaciones ===============================================================================================================

CREATE TABLE TblModificaciones (
  MdfId INTEGER NOT NULL AUTO_INCREMENT, 
  MdfNom VARCHAR(50) NOT NULL, 
  MdfTip VARCHAR(50) NOT NULL, 
  MdfNro INTEGER NOT NULL, 
  MdfFch DATETIME NOT NULL, 
  ModId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (MdfNom), 
  PRIMARY KEY (MdfId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMonitoreos ===================================================================================================================

CREATE TABLE TblMonitoreos (
  MonId INTEGER NOT NULL, 
  MonTip INTEGER NOT NULL, 
  MonNom VARCHAR(50) NOT NULL, 
  INDEX (MonNom), 
  PRIMARY KEY (MonId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMonitoreo ====================================================================================================================

CREATE TABLE TblMonitoreo (
  MonId INTEGER NOT NULL, 
  MonCod VARCHAR(20) NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMovimientos ==================================================================================================================

CREATE TABLE TblMovimientos (
  MvsId INTEGER NOT NULL, 
  MvsTip VARCHAR(50) NOT NULL, 
  MvsSgs VARCHAR(10) NOT NULL, 
  ClaNro INTEGER NOT NULL, 
  MvsCla VARCHAR(50) NOT NULL, 
  NomNro INTEGER NOT NULL, 
  MvsNom VARCHAR(50) NOT NULL, 
  PRIMARY KEY (MvsId)
) 
ENGINE=InnoDB;

INSERT INTO TblMovimientos (MvsId, MvsTip, MvsSgs, ClaNro, MvsCla, NomNro, MvsNom) 
VALUES (0, 'Sin Movimiento', 'SM', 0, 'Ninguno', 0, 'Ninguno');

# Estructura de la tabla TblMunicipios ===================================================================================================================

CREATE TABLE TblMunicipios (
  MunCod VARCHAR(10) NOT NULL, 
  DepCod VARCHAR(10) NOT NULL, 
  MunNom VARCHAR(100) NOT NULL, 
  INDEX (MunNom), 
  PRIMARY KEY (MunCod)
)
ENGINE=InnoDB;

# Estructura de la tabla TblNiveles ======================================================================================================================

CREATE TABLE TblNiveles (
  NivId INTEGER NOT NULL, 
  NivNom VARCHAR(50) NOT NULL, 
  NivSgs VARCHAR(20) NOT NULL, 
  INDEX (NivNom), 
  INDEX (NivSgs), 
  PRIMARY KEY (NivId)
) 
ENGINE=InnoDB;

INSERT INTO TblNiveles (NivId, NivNom, NivSgs) 
VALUES (0, 'Sin Nivel', 'SN');

# Estructura de la tabla TblNotas ========================================================================================================================

CREATE TABLE TblNotas (
  NotId INTEGER NOT NULL AUTO_INCREMENT, 
  NotTxt VARCHAR(255) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (NotTxt), 
  PRIMARY KEY (NotId)
) 
ENGINE=InnoDB;

INSERT INTO TblNotas (NotId, NotTxt, UsuId) 
VALUES (0, '0', 0);

UPDATE TblNotas SET NotId = 0 WHERE NotId = 1;

ALTER TABLE TblNotas AUTO_INCREMENT = 1;

# Estructura de la tabla TblObservaciones ================================================================================================================

CREATE TABLE TblObservaciones (
  ObsId INTEGER NOT NULL AUTO_INCREMENT, 
  ObsTxt VARCHAR(255) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (ObsTxt), 
  PRIMARY KEY (ObsId)
) 
ENGINE=InnoDB;

INSERT INTO TblObservaciones (ObsId, ObsTxt, UsuId) 
VALUES (0, '0', 0);

UPDATE TblObservaciones SET ObsId = 0 WHERE ObsId = 1;

ALTER TABLE TblObservaciones AUTO_INCREMENT = 1;

# Estructura de la tabla TblPacientes ====================================================================================================================

CREATE TABLE TblPacientes (
  PacId INTEGER NOT NULL AUTO_INCREMENT, 
  PacNom VARCHAR(50) NOT NULL, 
  PacApe VARCHAR(50) NOT NULL, 
  PacApm VARCHAR(50) NOT NULL, 
  PacSex VARCHAR(10) NOT NULL, 
  PacIde VARCHAR(20) NOT NULL, 
  PacCiv VARCHAR(15) NOT NULL, 
  PacExp VARCHAR(20) NOT NULL, 
  PacFch DATE NOT NULL, 
  PacDom VARCHAR(100) NOT NULL, 
  PacTe1 VARCHAR(15) NOT NULL, 
  PacTe2 VARCHAR(15) NOT NULL, 
  PacReg DATE NOT NULL, 
  PacPai VARCHAR(5) NOT NULL, 
  PacMad VARCHAR(50) NOT NULL, 
  PacPad VARCHAR(50) NOT NULL, 
  PacSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PacAct TINYINT NOT NULL, 
  PacCla TINYINT NOT NULL, 
  INDEX (PacNom), 
  INDEX (PacApe), 
  INDEX (PacIde), 
  PRIMARY KEY (PacId)
) 
ENGINE=InnoDB;

INSERT INTO TblPacientes (PacId, PacNom, PacApe, PacApm, PacSex, PacIde, PacCiv, PacExp, PacFch, PacDom, PacTe1, PacTe2, PacReg, PacPai, PacMad, PacPad, PacSts, UsuId, PacAct, PacCla) 
VALUES (0, 'Sin', 'Paciente', 'Definido', '0', '0', '0', 'OTRO', '2007-11-10', '0', '0', '0', '2000-01-01', '0', '0', '0', 0, 0, 1, 0);

UPDATE TblPacientes SET PacId = 0 WHERE PacId = 1;

ALTER TABLE TblPacientes AUTO_INCREMENT = 1;

# Estructura de la tabla TblPaises =======================================================================================================================

CREATE TABLE TblPaises (
  PaiId INTEGER NOT NULL, 
  PaiNom VARCHAR(50) NOT NULL, 
  PaiIso VARCHAR(5) NOT NULL, 
  INDEX (PaiNom), 
  PRIMARY KEY (PaiId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblPerfiles =====================================================================================================================

CREATE TABLE TblPerfiles (
  PerId INTEGER NOT NULL, 
  PerNom VARCHAR(50) NOT NULL, 
  PerTip TINYINT NOT NULL, 
  MosId INTEGER NOT NULL, 
  PRIMARY KEY (PerId)
) 
ENGINE=InnoDB;

INSERT INTO TblPerfiles (PerId, PerNom, PerTip, MosId) VALUES 
(1, 'Administrador', 1, 1);

# Estructura de la tabla TblPerfil =======================================================================================================================

CREATE TABLE TblPerfil (
  PerId INTEGER NOT NULL, 
  PerVen VARCHAR(20) NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblPreguntas ====================================================================================================================

CREATE TABLE TblPreguntas (
  PtaCod VARCHAR(20) NOT NULL, 
  PtaTip INTEGER NOT NULL, 
  PtaOrd INTEGER NOT NULL, 
  PtaNom VARCHAR(255) NOT NULL, 
  InsId INTEGER NOT NULL, 
  RtaTip INTEGER NOT NULL, 
  PtaPer INTEGER NOT NULL, 
  INDEX (PtaNom), 
  PRIMARY KEY (PtaCod)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblPrescriptores ================================================================================================================

CREATE TABLE TblPrescriptores (
  PsrId INTEGER NOT NULL AUTO_INCREMENT, 
  PsrNom VARCHAR(50) NOT NULL, 
  PsrApe VARCHAR(50) NOT NULL, 
  PsrApm VARCHAR(50) NOT NULL, 
  PsrIde VARCHAR(20) NOT NULL, 
  PsrPai VARCHAR(5) NOT NULL, 
  EspId INTEGER NOT NULL, 
  PrfId INTEGER NOT NULL, 
  CarId INTEGER NOT NULL, 
  PsrCol VARCHAR(30) NOT NULL, 
  PsrCel VARCHAR(20) NOT NULL, 
  PsrCor VARCHAR(50) NOT NULL, 
  PsrSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PsrAct TINYINT NOT NULL, 
  INDEX (PsrId), 
  PRIMARY KEY (PsrId)
) 
ENGINE=InnoDB;

INSERT INTO TblPrescriptores (PsrId, PsrNom, PsrApe, PsrApm, PsrIde, PsrPai, EspId, PrfId, CarId, PsrCol, PsrCel, PsrCor, PsrSts, UsuId, PsrAct) 
VALUES (0, 'Sin', 'Prescriptor', 'Definido', '0', '0', 0, 0, 0, '0', '0', '0', 0, 0, 1);

UPDATE TblPrescriptores SET PsrId = 0 WHERE PsrId = 1;

ALTER TABLE TblPrescriptores AUTO_INCREMENT = 1;

# Estructura de la tabla TblPresentaciones ===============================================================================================================

CREATE TABLE TblPresentaciones (
  PreId INTEGER NOT NULL, 
  PreTip TINYINT NOT NULL, 
  PreNom VARCHAR(30) NOT NULL, 
  PreIco VARCHAR(10) NOT NULL, 
  PreDes VARCHAR(80) NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblProfesiones ==================================================================================================================

CREATE TABLE TblProfesiones (
  PrfId INTEGER NOT NULL, 
  PrfNom VARCHAR(50) NOT NULL, 
  INDEX (PrfNom), 
  PRIMARY KEY (PrfId)
) 
ENGINE=InnoDB;

INSERT INTO TblProfesiones (PrfId, PrfNom) 
VALUES (0, 'Sin Profesión');

# Estructura de la tabla TblProgramaciones ===============================================================================================================

CREATE TABLE TblProgramaciones (
  PrgId INTEGER NOT NULL AUTO_INCREMENT, 
  PrgGes INTEGER NOT NULL, 
  PrgFch DATE NOT NULL, 
  UsuId INTEGER NOT NULL,  
  PRIMARY KEY (PrgId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblProgramacion =================================================================================================================

CREATE TABLE TblProgramacion (
  PrgId INTEGER NOT NULL, 
  SelCod VARCHAR(20) NOT NULL, 
  PrgCan INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblProveedores ==================================================================================================================

CREATE TABLE TblProveedores (
  ProId INTEGER NOT NULL AUTO_INCREMENT, 
  ProNom VARCHAR(50) NOT NULL, 
  ProDir VARCHAR(100) NOT NULL, 
  ProTel VARCHAR(50) NOT NULL, 
  ProCor VARCHAR(50) NOT NULL, 
  ModId INTEGER NOT NULL, 
  ProSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  ProAct TINYINT NOT NULL, 
  INDEX (ProNom), 
  PRIMARY KEY (ProId)
) 
ENGINE=InnoDB;

INSERT INTO TblProveedores (ProId, ProNom, ProDir, ProTel, ProCor, ModId, ProSts, UsuId, ProAct) 
VALUES (0, 'Sin Proveedor', '0', '0', '0', 1, 0, 0, 1);

UPDATE TblProveedores SET ProId = 0 WHERE ProId = 1;

ALTER TABLE TblProveedores AUTO_INCREMENT = 1;

# Estructura de la tabla TblReceptores ===================================================================================================================

CREATE TABLE TblReceptores (
  RecId INTEGER NOT NULL AUTO_INCREMENT, 
  RecNom VARCHAR(50) NOT NULL, 
  RecDir VARCHAR(100) NOT NULL, 
  RecTel VARCHAR(10) NOT NULL, 
  RecCor VARCHAR(50) NOT NULL, 
  ModId INTEGER NOT NULL, 
  RecSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  RecAct TINYINT NOT NULL, 
  INDEX (RecNom), 
  PRIMARY KEY (RecId)
) 
ENGINE=InnoDB;

INSERT INTO TblReceptores (RecId, RecNom, RecDir, RecTel, RecCor, ModId, RecSts, UsuId, RecAct) 
VALUES (0, 'Sin Receptor', '0', '0', '0', 1, 0, 0, 1);

UPDATE TblReceptores SET RecId = 0 WHERE RecId = 1;

ALTER TABLE TblReceptores AUTO_INCREMENT = 1;

# Estructura de la tabla TblRegiones =====================================================================================================================

CREATE TABLE TblRegiones (
  RegCod VARCHAR(10) NOT NULL, 
  RegNom VARCHAR(50) NOT NULL,
  RegSgs VARCHAR(20) NOT NULL, 
  INDEX (RegNom),
  INDEX (RegSgs),
  PRIMARY KEY (RegCod)
) 
ENGINE=InnoDB;

INSERT INTO TblRegiones (RegCod, RegNom, RegSgs) 
VALUES ('0', 'OTRO', 'OTR');

# Estructura de la tabla TblRepresentantes ===============================================================================================================

CREATE TABLE TblRepresentantes (
  RepId INTEGER NOT NULL AUTO_INCREMENT, 
  RepNom VARCHAR(50) NOT NULL, 
  RepApe VARCHAR(50) NOT NULL, 
  RepApm VARCHAR(50) NOT NULL, 
  RepIde VARCHAR(20) NOT NULL, 
  PrfId INTEGER NOT NULL, 
  CarId INTEGER NOT NULL, 
  RepCel VARCHAR(20) NOT NULL, 
  RepCor VARCHAR(50) NOT NULL, 
  RepSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  RepAct TINYINT NOT NULL, 
  INDEX (RepNom), 
  INDEX (RepApe), 
  INDEX (RepIde),
  PRIMARY KEY (RepId)
) 
ENGINE=InnoDB;

INSERT INTO TblRepresentantes (RepId, RepNom, RepApe, RepApm, RepIde, PrfId, CarId, RepCel, RepCor, RepSts, UsuId, RepAct) 
VALUES (0, 'Sin', 'Representante', 'Definido', '0', 0, 0, '0', '0', 0, 0, 1);

UPDATE TblRepresentantes SET RepId = 0 WHERE RepId = 1;

ALTER TABLE TblRepresentantes AUTO_INCREMENT = 1;

# Estructura de la tabla TblRequisiciones ================================================================================================================

CREATE TABLE TblRequisiciones (
  ReqId INTEGER NOT NULL AUTO_INCREMENT, 
  ReqNro VARCHAR(50) NOT NULL, 
  SolId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  ReqFch DATE NOT NULL, 
  ObsId INTEGER NOT NULL, 
  ModId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  ReqSts TINYINT NOT NULL, 
  ReqAct TINYINT NOT NULL,  
  PRIMARY KEY (ReqId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblRequisicion =======================================================================================================================

CREATE TABLE TblRequisicion (
  ReqId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  ReqReq INTEGER NOT NULL, 
  ReqApr INTEGER NOT NULL, 
  ReqObs VARCHAR(255) NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblResponsables =================================================================================================================

CREATE TABLE TblResponsables (
  ResId INTEGER NOT NULL AUTO_INCREMENT, 
  ResNom VARCHAR(50) NOT NULL, 
  ResApe VARCHAR(50) NOT NULL, 
  ResApm VARCHAR(50) NOT NULL, 
  ResIde VARCHAR(20) NOT NULL, 
  PrfId INTEGER NOT NULL, 
  CarId INTEGER NOT NULL, 
  ResCel VARCHAR(20) NOT NULL, 
  ResCor VARCHAR(50) NOT NULL, 
  INDEX (ResNom), 
  INDEX (ResApe), 
  INDEX (ResIde),
  PRIMARY KEY (ResId)
) 
ENGINE=InnoDB;

INSERT INTO TblResponsables (ResId, ResNom, ResApe, ResApm, ResIde, PrfId, CarId, ResCel, ResCor) 
VALUES (1, '0', '0', '0', '0', 0, 0, '0', '0');

# Estructura de la tabla TblRespuestas ===================================================================================================================

CREATE TABLE TblRespuestas (
  RtaId INTEGER NOT NULL, 
  RtaTip INTEGER NOT NULL, 
  RtaOpc VARCHAR(50) NOT NULL, 
  PRIMARY KEY (RtaId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblSaldos =======================================================================================================================

CREATE TABLE TblSaldos (
  SalId INTEGER NOT NULL AUTO_INCREMENT, 
  SalTip TINYINT NOT NULL, 
  SalNom VARCHAR(80) NOT NULL, 
  DsrId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  SalFch DATE NOT NULL, 
  SalObs VARCHAR(255) NOT NULL, 
  ModId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SalAct TINYINT NOT NULL, 
  PRIMARY KEY (SalId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblSaldo ========================================================================================================================

CREATE TABLE TblSaldo (
  SalId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  SalSis INTEGER NOT NULL, 
  SalFis INTEGER NOT NULL, 
  SalCos DECIMAL(11,4) NOT NULL, 
  SalLot INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblSeleccion ====================================================================================================================

CREATE TABLE TblSeleccion (
  SelId INTEGER NOT NULL AUTO_INCREMENT, 
  SelTip INTEGER NOT NULL, 
  SelCod VARCHAR(20) NOT NULL, 
  SelNom VARCHAR(200) NOT NULL, 
  SelFof VARCHAR(50) NOT NULL, 
  SelCon VARCHAR(50) NOT NULL, 
  SelCos DECIMAL(11,2) NOT NULL, 
  SelSma INTEGER NOT NULL, 
  SelSmf INTEGER NOT NULL, 
  SelSms INTEGER NOT NULL, 
  SelMin INTEGER NOT NULL, 
  SelMax INTEGER NOT NULL, 
  SelUni INTEGER NOT NULL, 
  SelFra VARCHAR(5) NOT NULL, 
  SelSin TINYINT NOT NULL, 
  SelCla TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SelAct TINYINT NOT NULL, 
  INDEX (SelCod), 
  INDEX (SelNom), 
  INDEX (SelFof), 
  INDEX (SelCon), 
  UNIQUE (SelCod), 
  PRIMARY KEY (SelId)
) 
ENGINE=InnoDB;

INSERT INTO TblSeleccion (SelId, SelTip, SelCod, SelNom, SelFof, SelCon, SelCos, SelSma, SelSmf, SelSms, SelMin, SelMax, SelUni, SelFra, SelSin, SelCla, UsuId, SelAct) 
VALUES (0, 0, '00000000000', 'Sin', 'Suministro', 'Definido', '0', 0, 0, 0, 0, 0, 1, '0', 0, 0, 0, 0);

UPDATE TblSeleccion SET SelId = 0 WHERE SelId = 1;

ALTER TABLE TblSeleccion AUTO_INCREMENT = 1;

# Estructura de la tabla TblServicios ====================================================================================================================

CREATE TABLE TblServicios (
  SerId INTEGER NOT NULL, 
  SerNom VARCHAR(50) NOT NULL, 
  SerSgs VARCHAR(20) NOT NULL, 
  SerAct INTEGER NOT NULL, 
  PRIMARY KEY (SerId)
) 
ENGINE=InnoDB;

INSERT INTO TblServicios (SerId, SerNom, SerSgs, SerAct) 
VALUES (0, 'Otro', 'OTR', 0);

# Estructura de la tabla TblSolicitudes ==================================================================================================================

CREATE TABLE TblSolicitudes (
  SolId INTEGER NOT NULL AUTO_INCREMENT, 
  SolNro VARCHAR(50) NOT NULL, 
  SolTip VARCHAR(50) NOT NULL, 
  SolReg VARCHAR(10) NOT NULL, 
  FueId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  SolMax DECIMAL(3,1) NOT NULL, 
  SolMin DECIMAL(3,1) NOT NULL, 
  SolObs VARCHAR(255) NOT NULL, 
  SolFch DATE NOT NULL, 
  ModId INTEGER NOT NULL, 
  ModIde INTEGER NOT NULL, 
  ModCod INTEGER NOT NULL, 
  ModNom VARCHAR(50) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SolSts TINYINT NOT NULL, 
  SolEnv TINYINT NOT NULL, 
  SolAct TINYINT NOT NULL, 
  PRIMARY KEY (SolId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblSolicitud ====================================================================================================================

CREATE TABLE TblSolicitud (
  SolId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  SolPrg INTEGER NOT NULL, 
  SolSug INTEGER NOT NULL, 
  SolSol INTEGER NOT NULL, 
  SolCos DECIMAL (11,4) NOT NULL, 
  SolObs VARCHAR(255) NOT NULL, 
  SolC01 INTEGER NOT NULL, 
  SolC02 INTEGER NOT NULL, 
  SolC03 INTEGER NOT NULL, 
  SolC04 INTEGER NOT NULL, 
  SolC05 INTEGER NOT NULL, 
  SolC06 INTEGER NOT NULL, 
  SolC07 INTEGER NOT NULL, 
  SolC08 INTEGER NOT NULL, 
  SolC09 INTEGER NOT NULL, 
  SolC10 INTEGER NOT NULL, 
  SolC11 INTEGER NOT NULL, 
  SolC12 INTEGER NOT NULL, 
  SolCon INTEGER NOT NULL, 
  SolMed VARCHAR(10) NOT NULL, 
  SolMud VARCHAR(10) NOT NULL, 
  SolSal INTEGER NOT NULL, 
  SolSts TINYINT NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblUsuarios =====================================================================================================================

CREATE TABLE TblUsuarios (
  UsuId INTEGER NOT NULL AUTO_INCREMENT, 
  UsuNom VARCHAR(20) NOT NULL, 
  UsuPsw VARCHAR(20) NOT NULL, 
  UsuFch DATE NOT NULL, 
  DsrId INTEGER NOT NULL, 
  UsuVe1 VARCHAR(20) NOT NULL, 
  UsuVe2 VARCHAR(20) NOT NULL, 
  UsuVe3 VARCHAR(20) NOT NULL, 
  UsuVe4 VARCHAR(20) NOT NULL, 
  UsuVe5 VARCHAR(20) NOT NULL, 
  UsuCnx VARCHAR(2) NOT NULL, 
  UsuTur VARCHAR(1) NOT NULL, 
  MosId INTEGER NOT NULL, 
  ModCod INTEGER NOT NULL, 
  ConId INTEGER NOT NULL, 
  PsrId INTEGER NOT NULL, 
  ModVer VARCHAR(10) NOT NULL, 
  ModPub VARCHAR(50) NOT NULL, 
  PerId INTEGER NOT NULL, 
  UsuSts TINYINT NOT NULL, 
  UsuSes INTEGER NOT NULL, 
  UsuAcc DATETIME NOT NULL, 
  UsuAct TINYINT NOT NULL, 
  INDEX (UsuNom), 
  PRIMARY KEY (UsuId)
) 
ENGINE=InnoDB;

INSERT INTO TblUsuarios (UsuId, UsuNom, UsuPsw, UsuFch, DsrId, UsuVe1, UsuVe2, UsuVe3, UsuVe4, UsuVe5, UsuCnx, UsuTur, MosId, ModCod, ConId, PsrId, ModVer, ModPub, PerId, UsuSts, UsuSes, UsuAcc, UsuAct) 
VALUES (0, 'SALMI', 'SALMI', '2000-01-01', 0, '0', '0', '0', '0', '0', 'Si', 'A', 1, 0, 0, 0, '0', '0', 1, 0, 0, '2000-01-01 00:00:00', 1);

UPDATE TblUsuarios SET UsuId = 0 WHERE UsuId = 1;

ALTER TABLE TblUsuarios AUTO_INCREMENT = 1;

# Estructura de la tabla TblVias =========================================================================================================================

CREATE TABLE TblVias (
  ViaId INTEGER NOT NULL, 
  ViaNom VARCHAR(20) NOT NULL, 
  ViaSgs VARCHAR(5) NOT NULL, 
  PRIMARY KEY (ViaId)
) 
ENGINE=InnoDB;

INSERT INTO TblVias (ViaId, ViaNom, ViaSgs) 
VALUES (0, 'Sin Vía', '-');

# Relaciones de la tabla TblAdministrativos ==============================================================================================================

ALTER TABLE TblAdministrativos ADD CONSTRAINT TblAdministrativosResId FOREIGN KEY (ResId) REFERENCES TblResponsables (ResId);

# Relaciones de la tabla TblBarras =======================================================================================================================

ALTER TABLE TblBarras ADD CONSTRAINT TblBarrasSelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblBarras ADD CONSTRAINT TblBarrasUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblCamas ========================================================================================================================

ALTER TABLE TblCamas ADD CONSTRAINT TblCamasAmbId FOREIGN KEY (AmbId) REFERENCES TblAmbientes (AmbId);
ALTER TABLE TblCamas ADD CONSTRAINT TblCamasUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblClasificaciones ==============================================================================================================

ALTER TABLE TblClasificaciones ADD CONSTRAINT TblClasificacionesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblClasificacion ================================================================================================================

ALTER TABLE TblClasificacion ADD CONSTRAINT TblClasificacionClaId FOREIGN KEY (ClaId) REFERENCES TblClasificaciones (ClaId);

# Relaciones de la tabla TblDiagnosticos =================================================================================================================

ALTER TABLE TblDiagnosticos ADD CONSTRAINT TblDiagnosticosFueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblDiagnosticos ADD CONSTRAINT TblDiagnosticosUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblDispensadores ================================================================================================================

ALTER TABLE TblDispensadores ADD CONSTRAINT TblDispensadoresPrfId FOREIGN KEY (PrfId) REFERENCES TblProfesiones (PrfId);
ALTER TABLE TblDispensadores ADD CONSTRAINT TblDispensadoresCarId FOREIGN KEY (CarId) REFERENCES TblCargos (CarId);
ALTER TABLE TblDispensadores ADD CONSTRAINT TblDispensadoresUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblEstablecimientos =============================================================================================================

ALTER TABLE TblEstablecimientos ADD CONSTRAINT TblEstablecimientosRegCod FOREIGN KEY (RegCod) REFERENCES TblRegiones (RegCod);
ALTER TABLE TblEstablecimientos ADD CONSTRAINT TblEstablecimientosNivId FOREIGN KEY (NivId) REFERENCES TblNiveles (NivId);

# Relaciones de la tabla TblGestion ======================================================================================================================

ALTER TABLE TblGestion ADD CONSTRAINT TblGestionUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblInsumos ======================================================================================================================

ALTER TABLE TblInsumos ADD CONSTRAINT TblInsumosNivId FOREIGN KEY (NivId) REFERENCES TblNiveles (NivId);

# Relaciones de la tabla TblInsumosFue ===================================================================================================================

ALTER TABLE TblInsumosFue ADD CONSTRAINT TblInsumosFueNivId FOREIGN KEY (NivId) REFERENCES TblNiveles (NivId);

# Relaciones de la tabla TblJornadas =====================================================================================================================

ALTER TABLE TblJornadas ADD CONSTRAINT TblJornadasPsrId FOREIGN KEY (PsrId) REFERENCES TblPrescriptores (PsrId);
ALTER TABLE TblJornadas ADD CONSTRAINT TblJornadasUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMedicamentos =================================================================================================================

ALTER TABLE TblMedicamentos ADD CONSTRAINT TblMedicamentosNivId FOREIGN KEY (NivId) REFERENCES TblNiveles (NivId);

# Relaciones de la tabla TblMedicamentosFue ==============================================================================================================

ALTER TABLE TblMedicamentosFue ADD CONSTRAINT TblMedicamentosFueNivId FOREIGN KEY (NivId) REFERENCES TblNiveles (NivId);

# Relaciones de la tabla TblMensualesCon =================================================================================================================

ALTER TABLE TblMensualesCon ADD CONSTRAINT TblMensualesConGesId FOREIGN KEY (GesId) REFERENCES TblGestion (GesId);
ALTER TABLE TblMensualesCon ADD CONSTRAINT TblMensualesConUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMensualCon ===================================================================================================================

ALTER TABLE TblMensualCon ADD CONSTRAINT TblMensualConMenId FOREIGN KEY (MenId) REFERENCES TblMensualesCon (MenId);
ALTER TABLE TblMensualCon ADD CONSTRAINT TblMensualConSelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblModulo =======================================================================================================================

ALTER TABLE TblModulo ADD CONSTRAINT TblModuloMosId FOREIGN KEY (MosId) REFERENCES TblModulos (MosId);
ALTER TABLE TblModulo ADD CONSTRAINT TblModuloUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblModificaciones ===============================================================================================================

ALTER TABLE TblModificaciones ADD CONSTRAINT TblModificacionesModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblModificaciones ADD CONSTRAINT TblModificacionesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMonitoreo ====================================================================================================================

ALTER TABLE TblMonitoreo ADD CONSTRAINT TblMonitoreoMonId FOREIGN KEY (MonId) REFERENCES TblMonitoreos (MonId);

# Relaciones de la tabla TblObservaciones ================================================================================================================

ALTER TABLE TblObservaciones ADD CONSTRAINT TblObservacionesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblPacientes ====================================================================================================================

ALTER TABLE TblPacientes ADD CONSTRAINT TblPacientesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblPerfiles =====================================================================================================================

ALTER TABLE TblPerfiles ADD CONSTRAINT TblPerfilesMosId FOREIGN KEY (MosId) REFERENCES TblModulos (MosId);

# Relaciones de la tabla TblPerfil =======================================================================================================================

ALTER TABLE TblPerfil ADD CONSTRAINT TblPerfilPerId FOREIGN KEY (PerId) REFERENCES TblPerfiles (PerId);

# Relaciones de la tabla TblPrescriptores ================================================================================================================

ALTER TABLE TblPrescriptores ADD CONSTRAINT TblPrescriptoresPrfId FOREIGN KEY (PrfId) REFERENCES TblProfesiones (PrfId);
ALTER TABLE TblPrescriptores ADD CONSTRAINT TblPrescriptoresEspId FOREIGN KEY (EspId) REFERENCES TblEspecialidades (EspId);
ALTER TABLE TblPrescriptores ADD CONSTRAINT TblPrescriptoresCarId FOREIGN KEY (CarId) REFERENCES TblCargos (CarId);
ALTER TABLE TblPrescriptores ADD CONSTRAINT TblPrescriptoresUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblProgramacion =================================================================================================================

ALTER TABLE TblProgramacion ADD CONSTRAINT TblProgramacionPrgId FOREIGN KEY (PrgId) REFERENCES TblProgramaciones (PrgId);

# Relaciones de la tabla TblProveedores ==================================================================================================================

ALTER TABLE TblProveedores ADD CONSTRAINT TblProveedoresModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblProveedores ADD CONSTRAINT TblProveedoresUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblReceptores ===================================================================================================================

ALTER TABLE TblReceptores ADD CONSTRAINT TblReceptoresModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblReceptores ADD CONSTRAINT TblReceptoresUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblRepresentantes ===============================================================================================================

ALTER TABLE TblRepresentantes ADD CONSTRAINT TblRepresentantesPrfId FOREIGN KEY (PrfId) REFERENCES TblProfesiones (PrfId);
ALTER TABLE TblRepresentantes ADD CONSTRAINT TblRepresentantesCarId FOREIGN KEY (CarId) REFERENCES TblCargos (CarId);
ALTER TABLE TblRepresentantes ADD CONSTRAINT TblRepresentantesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblRequisiciones ================================================================================================================

ALTER TABLE TblRequisiciones ADD CONSTRAINT TblRequisicionesSolId FOREIGN KEY (SolId) REFERENCES TblSolicitudes (SolId);
ALTER TABLE TblRequisiciones ADD CONSTRAINT TblRequisicionesRepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblRequisiciones ADD CONSTRAINT TblRequisicionesObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblRequisiciones ADD CONSTRAINT TblRequisicionesModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblRequisiciones ADD CONSTRAINT TblRequisicionesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblRequisicion ==================================================================================================================

ALTER TABLE TblRequisicion ADD CONSTRAINT TblRequisicionReqId FOREIGN KEY (ReqId) REFERENCES TblRequisiciones (ReqId);
ALTER TABLE TblRequisicion ADD CONSTRAINT TblRequisicionSelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblResponsables =================================================================================================================

ALTER TABLE TblResponsables ADD CONSTRAINT TblResponsablesPrfId FOREIGN KEY (PrfId) REFERENCES TblProfesiones (PrfId);
ALTER TABLE TblResponsables ADD CONSTRAINT TblResponsablesCarId FOREIGN KEY (CarId) REFERENCES TblCargos (CarId);

# Relaciones de la tabla TblSaldos =======================================================================================================================

ALTER TABLE TblSaldos ADD CONSTRAINT TblSaldosDsrId FOREIGN KEY (DsrId) REFERENCES TblDispensadores (DsrId);
ALTER TABLE TblSaldos ADD CONSTRAINT TblSaldosRepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblSaldos ADD CONSTRAINT TblSaldosModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblSaldos ADD CONSTRAINT TblSaldosUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblSaldo ========================================================================================================================

ALTER TABLE TblSaldo ADD CONSTRAINT TblSaldoSalId FOREIGN KEY (SalId) REFERENCES TblSaldos (SalId);
ALTER TABLE TblSaldo ADD CONSTRAINT TblSaldoSelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblSolicitudes ==================================================================================================================

ALTER TABLE TblSolicitudes ADD CONSTRAINT TblSolicitudesRepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblSolicitudes ADD CONSTRAINT TblSolicitudesModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblSolicitudes ADD CONSTRAINT TblSolicitudesUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblSolicitud ====================================================================================================================

ALTER TABLE TblSolicitud ADD CONSTRAINT TblSolicitudSolId FOREIGN KEY (SolId) REFERENCES TblSolicitudes (SolId);
ALTER TABLE TblSolicitud ADD CONSTRAINT TblSolicitudSelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblSeleccion ====================================================================================================================

ALTER TABLE TblSeleccion ADD CONSTRAINT TblSeleccionUsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblUsuarios =====================================================================================================================

ALTER TABLE TblUsuarios ADD CONSTRAINT TblUsuariosDsrId FOREIGN KEY (DsrId) REFERENCES TblDispensadores (DsrId);
ALTER TABLE TblUsuarios ADD CONSTRAINT TblUsuariosMosId FOREIGN KEY (MosId) REFERENCES TblModulos (MosId);
ALTER TABLE TblUsuarios ADD CONSTRAINT TblUsuariosPerId FOREIGN KEY (PerId) REFERENCES TblPerfiles (PerId);