# ========================================================================================================================================================
# Base de Datos Almacén-1 (PA) v1, 2025-05-07 Test-l
# ========================================================================================================================================================

# Estructura de la tabla TblBloqueoAlm1 ==================================================================================================================

CREATE TABLE TblBloqueoAlm1 (
  BloSts TINYINT NOT NULL, 
  SelId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL,
  LotId INTEGER NOT NULL,
  BloCan INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblConfiguracionesAlm1 ==========================================================================================================

CREATE TABLE TblConfiguracionesAlm1 (
  ConId INTEGER NOT NULL AUTO_INCREMENT, 
  ConNom VARCHAR(100) NOT NULL, 
  ConSts VARCHAR(250) NOT NULL, 
  PRIMARY KEY (ConId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblDistribucionesAlm1 ===========================================================================================================

CREATE TABLE TblDistribucionesAlm1 (
  DisId INTEGER NOT NULL AUTO_INCREMENT, 
  DisNro VARCHAR(50) NOT NULL, 
  ModId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  DisCod VARCHAR(20) NOT NULL, 
  DisSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  DisAct TINYINT NOT NULL,  
  PRIMARY KEY (DisId)
) 
ENGINE=InnoDB;

INSERT INTO TblDistribucionesAlm1 (DisId, DisNro, ModId, RepId, MvsId, ObsId, DisCod, DisSts, UsuId, DisAct) 
VALUES (0, '0', 1, 0, 0, 0, '0', 0, 0, 0);

UPDATE TblDistribucionesAlm1 SET DisId = 0 WHERE DisId = 1;

ALTER TABLE TblDistribucionesAlm1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblEntradasAlm1 =================================================================================================================

CREATE TABLE TblEntradasAlm1 (
  EntId INTEGER NOT NULL AUTO_INCREMENT, 
  EntDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  EntAct TINYINT NOT NULL,
  PRIMARY KEY (EntId)
) 
ENGINE=InnoDB;

INSERT INTO TblEntradasAlm1 (EntId, EntDoc, ProId, RepId, MvsId, ObsId, UsuId, EntAct) 
VALUES (0, '0', 0, 0, 0, 0, 0, 0);

UPDATE TblEntradasAlm1 SET EntId = 0 WHERE EntId = 1;

ALTER TABLE TblEntradasAlm1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblLotesAlm1 ====================================================================================================================

CREATE TABLE TblLotesAlm1 (
  LotId INTEGER NOT NULL AUTO_INCREMENT, 
  LotNro VARCHAR(20) NOT NULL, 
  LotVto DATE NOT NULL, 
  LotCos DECIMAL(11,5) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  LotAct TINYINT NOT NULL, 
  INDEX (LotNro), 
  PRIMARY KEY (LotId)
) 
ENGINE=InnoDB;

INSERT INTO TblLotesAlm1 (LotId, LotNro, LotVto, LotCos, UsuId, LotAct) 
VALUES (0, '0', '2000-01-01', '0', 0, 0);

UPDATE TblLotesAlm1 SET LotId = 0 WHERE LotId = 1;

ALTER TABLE TblLotesAlm1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblMensualesAlm1 ================================================================================================================

CREATE TABLE TblMensualesAlm1 (
  MenId INTEGER NOT NULL AUTO_INCREMENT, 
  MenNro TINYINT NOT NULL, 
  MenMes VARCHAR(20) NOT NULL, 
  MenCon TINYINT NOT NULL, 
  MenMax DECIMAL(3,1) NOT NULL, 
  MenMin DECIMAL(3,1) NOT NULL, 
  MenFch DATE NOT NULL, 
  GesId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (MenMes), 
  PRIMARY KEY (MenId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMensualAlm1 ==================================================================================================================

CREATE TABLE TblMensualAlm1 (
  MenId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  MenSM INTEGER NOT NULL, 
  MenRM INTEGER NOT NULL, 
  MenCM INTEGER NOT NULL, 
  MenDM INTEGER NOT NULL, 
  MenAP INTEGER NOT NULL, 
  MenAN INTEGER NOT NULL, 
  MenCP INTEGER NOT NULL, 
  MenDI INTEGER NOT NULL, 
  MenME VARCHAR(10) NOT NULL, 
  MenMU VARCHAR(10) NOT NULL, 
  MenCS INTEGER NOT NULL, 
  MenCO DECIMAL(11,2) NOT NULL, 
  INDEX (MenId), 
  INDEX (SelId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMovimientoAlm1 ===============================================================================================================

CREATE TABLE TblMovimientoAlm1 (
  MovId INTEGER NOT NULL AUTO_INCREMENT, 
  MvsId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  FueId INTEGER NOT NULL, 
  EntId INTEGER NOT NULL, 
  PosId INTEGER NOT NULL, 
  SalId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  NegId INTEGER NOT NULL, 
  MovEnt INTEGER NOT NULL, 
  MovPos INTEGER NOT NULL, 
  MovSal INTEGER NOT NULL, 
  MovDis INTEGER NOT NULL, 
  MovNeg INTEGER NOT NULL, 
  MovSdo INTEGER NOT NULL, 
  MovCos DECIMAL(11,4) NOT NULL, 
  LotId INTEGER NOT NULL, 
  MovRec INTEGER NOT NULL, 
  MovFch DATE NOT NULL, 
  UsuId INTEGER NOT NULL, 
  MovAct TINYINT NOT NULL, 
  INDEX (MvsId), 
  INDEX (SelId), 
  INDEX (EntId), 
  INDEX (PosId), 
  INDEX (SalId), 
  INDEX (DisId), 
  INDEX (NegId), 
  INDEX (MovFch),  
  PRIMARY KEY (MovId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblNegativosAlm1 ================================================================================================================

CREATE TABLE TblNegativosAlm1 (
  NegId INTEGER NOT NULL AUTO_INCREMENT, 
  RecId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  NegAct TINYINT NOT NULL,
  PRIMARY KEY (NegId)
) 
ENGINE=InnoDB;

INSERT INTO TblNegativosAlm1 (NegId, RecId, RepId, MvsId, ObsId, UsuId, NegAct) 
VALUES (0, 0, 0, 0, 0, 0, 0);

UPDATE TblNegativosAlm1 SET NegId = 0 WHERE NegId = 1;

ALTER TABLE TblNegativosAlm1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblPositivosAlm1 ================================================================================================================

CREATE TABLE TblPositivosAlm1 (
  PosId INTEGER NOT NULL AUTO_INCREMENT, 
  PosDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PosAct TINYINT NOT NULL, 
  INDEX (PosDoc),
  PRIMARY KEY (PosId)
) 
ENGINE=InnoDB;

INSERT INTO TblPositivosAlm1 (PosId, PosDoc, ProId, RepId, MvsId, ObsId, UsuId, PosAct) 
VALUES (0, '0', 0, 0, 0, 0, 0, 0);

UPDATE TblPositivosAlm1 SET PosId = 0 WHERE PosId = 1;

ALTER TABLE TblPositivosAlm1 AUTO_INCREMENT = 1;

# Estructura de la tabla TblSalidasAlm1 ==================================================================================================================

CREATE TABLE TblSalidasAlm1 (
  SalId INTEGER NOT NULL AUTO_INCREMENT, 
  SalDoc VARCHAR(50) NOT NULL, 
  FueId INTEGER NOT NULL, 
  SerId INTEGER NOT NULL, 
  AmbId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  SalFch DATE NOT NULL, 
  SalAte DATE NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SalAct TINYINT NOT NULL,  
  PRIMARY KEY (SalId)
) 
ENGINE=InnoDB;

INSERT INTO TblSalidasAlm1 (SalId, SalDoc, FueId, SerId, AmbId, RepId, SalFch, SalAte, MvsId, ObsId, UsuId, SalAct) 
VALUES (0, '0', 1, 0, 0, 0, '2000-01-01', '2000-01-01', 0, 0, 0, 0);

UPDATE TblSalidasAlm1 SET SalId = 0 WHERE SalId = 1;

ALTER TABLE TblSalidasAlm1 AUTO_INCREMENT = 1;

# Relaciones de la tabla TblDistribucionesAlm1 ===========================================================================================================

ALTER TABLE TblDistribucionesAlm1 ADD CONSTRAINT TblDistribucionesAlm1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblDistribucionesAlm1 ADD CONSTRAINT TblDistribucionesAlm1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblDistribucionesAlm1 ADD CONSTRAINT TblDistribucionesAlm1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblDistribucionesAlm1 ADD CONSTRAINT TblDistribucionesAlm1ModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblDistribucionesAlm1 ADD CONSTRAINT TblDistribucionesAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblEntradasAlm1 =================================================================================================================

ALTER TABLE TblEntradasAlm1 ADD CONSTRAINT TblEntradasAlm1ProId FOREIGN KEY (ProId) REFERENCES TblProveedores (ProId);
ALTER TABLE TblEntradasAlm1 ADD CONSTRAINT TblEntradasAlm1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblEntradasAlm1 ADD CONSTRAINT TblEntradasAlm1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblEntradasAlm1 ADD CONSTRAINT TblEntradasAlm1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblEntradasAlm1 ADD CONSTRAINT TblEntradasAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblLotesAlm1 ====================================================================================================================

ALTER TABLE TblLotesAlm1 ADD CONSTRAINT TblLotesAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMensualesAlm1 ================================================================================================================

ALTER TABLE TblMensualesAlm1 ADD CONSTRAINT TblMensualesAlm1GesId FOREIGN KEY (GesId) REFERENCES TblGestion (GesId);
ALTER TABLE TblMensualesAlm1 ADD CONSTRAINT TblMensualesAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMensualAlm1 ==================================================================================================================

ALTER TABLE TblMensualAlm1 ADD CONSTRAINT TblMensualAlm1MenId FOREIGN KEY (MenId) REFERENCES TblMensualesAlm1 (MenId);
ALTER TABLE TblMensualAlm1 ADD CONSTRAINT TblMensualAlm1SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblMovimientoAlm1 ===============================================================================================================

ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1EntId FOREIGN KEY (EntId) REFERENCES TblEntradasAlm1 (EntId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1PosId FOREIGN KEY (PosId) REFERENCES TblPositivosAlm1 (PosId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1SalId FOREIGN KEY (SalId) REFERENCES TblSalidasAlm1 (SalId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1DisId FOREIGN KEY (DisId) REFERENCES TblDistribucionesAlm1 (DisId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1NegId FOREIGN KEY (NegId) REFERENCES TblNegativosAlm1 (NegId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1LotId FOREIGN KEY (LotId) REFERENCES TblLotesAlm1 (LotId);
ALTER TABLE TblMovimientoAlm1 ADD CONSTRAINT TblMovimientoAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblNegativosAlm1 ================================================================================================================

ALTER TABLE TblNegativosAlm1 ADD CONSTRAINT TblNegativosAlm1RecId FOREIGN KEY (RecId) REFERENCES TblReceptores (RecId);
ALTER TABLE TblNegativosAlm1 ADD CONSTRAINT TblNegativosAlm1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblNegativosAlm1 ADD CONSTRAINT TblNegativosAlm1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblNegativosAlm1 ADD CONSTRAINT TblNegativosAlm1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblNegativosAlm1 ADD CONSTRAINT TblNegativosAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblPositivosAlm1 ================================================================================================================

ALTER TABLE TblPositivosAlm1 ADD CONSTRAINT TblPositivosAlm1ProId FOREIGN KEY (ProId) REFERENCES TblProveedores (ProId);
ALTER TABLE TblPositivosAlm1 ADD CONSTRAINT TblPositivosAlm1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblPositivosAlm1 ADD CONSTRAINT TblPositivosAlm1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblPositivosAlm1 ADD CONSTRAINT TblPositivosAlm1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblPositivosAlm1 ADD CONSTRAINT TblPositivosAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblSalidasAlm1 ==================================================================================================================

ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1SerId FOREIGN KEY (SerId) REFERENCES TblServicios (SerId);
ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1AmbId FOREIGN KEY (AmbId) REFERENCES TblAmbientes (AmbId);
ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblSalidasAlm1 ADD CONSTRAINT TblSalidasAlm1UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);