# ========================================================================================================================================================
# Base de Datos Farmacia-2 (PA) v1, 2025-05-07 Test-l
# ========================================================================================================================================================

# Estructura de la tabla TblBloqueoFar2 ==================================================================================================================

CREATE TABLE TblBloqueoFar2 (
  BloSts TINYINT NOT NULL, 
  SelId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  LotId INTEGER NOT NULL, 
  BloCan INTEGER NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblConfiguracionesFar2 ==========================================================================================================

CREATE TABLE TblConfiguracionesFar2 (
  ConId INTEGER NOT NULL AUTO_INCREMENT, 
  ConNom VARCHAR(100) NOT NULL, 
  ConSts VARCHAR(250) NOT NULL, 
  PRIMARY KEY (ConId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblDistribucionesFar2 ===========================================================================================================

CREATE TABLE TblDistribucionesFar2 (
  DisId INTEGER NOT NULL AUTO_INCREMENT, 
  DisNro VARCHAR(50) NOT NULL, 
  ModId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  DisCod VARCHAR(20) NOT NULL, 
  DisSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  DisAct TINYINT NOT NULL,  
  PRIMARY KEY (DisId)
) 
ENGINE=InnoDB;

INSERT INTO TblDistribucionesFar2 (DisId, DisNro, ModId, RepId, MvsId, ObsId, DisCod, DisSts, UsuId, DisAct) 
VALUES (0, '0', 1, 0, 0, 0, '0', 0, 0, 0);

UPDATE TblDistribucionesFar2 SET DisId = 0 WHERE DisId = 1;

ALTER TABLE TblDistribucionesFar2 AUTO_INCREMENT = 1;

# Estructura de la tabla TblEntradasFar2 =================================================================================================================

CREATE TABLE TblEntradasFar2 (
  EntId INTEGER NOT NULL AUTO_INCREMENT, 
  EntDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  ModCod INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  EntAct TINYINT NOT NULL,
  PRIMARY KEY (EntId)
) 
ENGINE=InnoDB;

INSERT INTO TblEntradasFar2 (EntId, EntDoc, ProId, RepId, DisId, ModCod, MvsId, ObsId, UsuId, EntAct) 
VALUES (0, '0', 0, 0, 0, 0, 0, 0, 0, 0);

UPDATE TblEntradasFar2 SET EntId = 0 WHERE EntId = 1;

ALTER TABLE TblEntradasFar2 AUTO_INCREMENT = 1;

# Estructura de la tabla TblEtiquetasFar2 ================================================================================================================

CREATE TABLE TblEtiquetasFar2 (
  SalId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  EtiDos DECIMAL(11,4) NOT NULL, 
  EtiMed VARCHAR(3) NOT NULL, 
  FreId INTEGER NOT NULL, 
  ViaId INTEGER NOT NULL, 
  EtiDia INTEGER NOT NULL, 
  IndId INTEGER NOT NULL, 
  NotId INTEGER NOT NULL, 
  EtiFch DATE NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblFraccionesFar2 ===============================================================================================================

CREATE TABLE TblFraccionesFar2 (
  FraId INTEGER NOT NULL AUTO_INCREMENT, 
  MvsId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  FueId INTEGER NOT NULL, 
  EntId INTEGER NOT NULL, 
  PosId INTEGER NOT NULL, 
  SalId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  NegId INTEGER NOT NULL, 
  FraEnt INTEGER NOT NULL, 
  FraPos INTEGER NOT NULL, 
  FraSal INTEGER NOT NULL, 
  FraDis INTEGER NOT NULL, 
  FraNeg INTEGER NOT NULL, 
  FraCos DECIMAL(11,4) NOT NULL, 
  LotId INTEGER NOT NULL, 
  FraRec INTEGER NOT NULL, 
  FraFch DATE NOT NULL, 
  UsuId INTEGER NOT NULL, 
  FraAct TINYINT NOT NULL, 
  INDEX (MvsId), 
  INDEX (SelId), 
  INDEX (EntId), 
  INDEX (PosId), 
  INDEX (SalId), 
  INDEX (DisId), 
  INDEX (NegId), 
  INDEX (FraFch),  
  PRIMARY KEY (FraId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblInternacionesFar2 ============================================================================================================

CREATE TABLE TblInternacionesFar2 (
  IntId INTEGER NOT NULL AUTO_INCREMENT, 
  FueId INTEGER NOT NULL, 
  SerId INTEGER NOT NULL, 
  CamId INTEGER NOT NULL, 
  IntFhi DATE NOT NULL, 
  IntFha DATE NOT NULL, 
  IntObs VARCHAR(250) NOT NULL, 
  IntSts TINYINT NOT NULL, 
  UsuId INTEGER NOT NULL, 
  IntAct TINYINT NOT NULL, 
  PRIMARY KEY (IntId)
) 
ENGINE=InnoDB;

INSERT INTO TblInternacionesFar2 (IntId, FueId, SerId, CamId, IntFhi, IntFha, IntObs, IntSts, UsuId, IntAct) 
VALUES (0, 1, 0, 0, '2000-01-01', '2000-01-01', '0', 0, 0, 0);

UPDATE TblInternacionesFar2 SET IntId = 0 WHERE IntId = 1;

ALTER TABLE TblInternacionesFar2 AUTO_INCREMENT = 1;

# Estructura de la tabla TblLotesFar2 ====================================================================================================================

CREATE TABLE TblLotesFar2 (
  LotId INTEGER NOT NULL AUTO_INCREMENT, 
  LotNro VARCHAR(20) NOT NULL, 
  LotVto DATE NOT NULL, 
  LotCos DECIMAL(11,5) NOT NULL, 
  UsuId INTEGER NOT NULL, 
  LotAct TINYINT NOT NULL, 
  INDEX (LotNro), 
  PRIMARY KEY (LotId)
) 
ENGINE=InnoDB;

INSERT INTO TblLotesFar2 (LotId, LotNro, LotVto, LotCos, UsuId, LotAct) 
VALUES (0, '0', '2000-01-01', '0', 0, 0);

UPDATE TblLotesFar2 SET LotId = 0 WHERE LotId = 1;

ALTER TABLE TblLotesFar2 AUTO_INCREMENT = 1;

# Estructura de la tabla TblMensualesFar2 ================================================================================================================

CREATE TABLE TblMensualesFar2 (
  MenId INTEGER NOT NULL AUTO_INCREMENT, 
  MenNro TINYINT NOT NULL, 
  MenMes VARCHAR(20) NOT NULL, 
  MenCon TINYINT NOT NULL, 
  MenMax DECIMAL(3,1) NOT NULL, 
  MenMin DECIMAL(3,1) NOT NULL, 
  MenFch DATE NOT NULL, 
  GesId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  INDEX (MenMes), 
  PRIMARY KEY (MenId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMensualFar2 ==================================================================================================================

CREATE TABLE TblMensualFar2 (
  MenId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  MenSM INTEGER NOT NULL, 
  MenRM INTEGER NOT NULL, 
  MenCM INTEGER NOT NULL, 
  MenDM INTEGER NOT NULL, 
  MenAP INTEGER NOT NULL, 
  MenAN INTEGER NOT NULL, 
  MenCP INTEGER NOT NULL, 
  MenDI INTEGER NOT NULL, 
  MenME VARCHAR(10) NOT NULL, 
  MenMU VARCHAR(10) NOT NULL, 
  MenCS INTEGER NOT NULL, 
  MenCO DECIMAL(11,2) NOT NULL, 
  INDEX (MenId), 
  INDEX (SelId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblMovimientoFar2 ===============================================================================================================

CREATE TABLE TblMovimientoFar2 (
  MovId INTEGER NOT NULL AUTO_INCREMENT, 
  MvsId INTEGER NOT NULL, 
  SelId INTEGER NOT NULL, 
  FueId INTEGER NOT NULL, 
  EntId INTEGER NOT NULL, 
  PosId INTEGER NOT NULL, 
  SalId INTEGER NOT NULL, 
  DisId INTEGER NOT NULL, 
  NegId INTEGER NOT NULL, 
  MovEnt INTEGER NOT NULL, 
  MovPos INTEGER NOT NULL, 
  MovSal INTEGER NOT NULL, 
  MovDis INTEGER NOT NULL, 
  MovNeg INTEGER NOT NULL, 
  MovSdo INTEGER NOT NULL, 
  MovCos DECIMAL(11,4) NOT NULL, 
  LotId INTEGER NOT NULL, 
  MovRec INTEGER NOT NULL, 
  MovFch DATE NOT NULL, 
  UsuId INTEGER NOT NULL, 
  MovAct TINYINT NOT NULL, 
  INDEX (MvsId), 
  INDEX (SelId), 
  INDEX (EntId), 
  INDEX (PosId), 
  INDEX (SalId), 
  INDEX (DisId), 
  INDEX (NegId), 
  INDEX (MovFch),  
  PRIMARY KEY (MovId)
) 
ENGINE=InnoDB;

# Estructura de la tabla TblNegativosFar2 ================================================================================================================

CREATE TABLE TblNegativosFar2 (
  NegId INTEGER NOT NULL AUTO_INCREMENT, 
  RecId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  NegAct TINYINT NOT NULL,
  PRIMARY KEY (NegId)
) 
ENGINE=InnoDB;

INSERT INTO TblNegativosFar2 (NegId, RecId, RepId, MvsId, ObsId, UsuId, NegAct) 
VALUES (0, 0, 0, 0, 0, 0, 0);

UPDATE TblNegativosFar2 SET NegId = 0 WHERE NegId = 1;

ALTER TABLE TblNegativosFar2 AUTO_INCREMENT = 1;

# Estructura de la tabla TblPositivosFar2 ================================================================================================================

CREATE TABLE TblPositivosFar2 (
  PosId INTEGER NOT NULL AUTO_INCREMENT, 
  PosDoc VARCHAR(50) NOT NULL, 
  ProId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  PosAct TINYINT NOT NULL, 
  INDEX (PosDoc), 
  PRIMARY KEY (PosId)
) 
ENGINE=InnoDB;

INSERT INTO TblPositivosFar2 (PosId, PosDoc, ProId, RepId, MvsId, ObsId, UsuId, PosAct) 
VALUES (0, '0', 0, 0, 0, 0, 0, 0);

UPDATE TblPositivosFar2 SET PosId = 0 WHERE PosId = 1;

ALTER TABLE TblPositivosFar2 AUTO_INCREMENT = 1;

# Estructura de la tabla TblRelacionIntDiaFar2 ===========================================================================================================

CREATE TABLE TblRelacionIntDiaFar2 (
  IntId INTEGER NOT NULL, 
  DiaId INTEGER NOT NULL, 
  DiaCos DECIMAL(11,4) NOT NULL, 
  DiaNro TINYINT NOT NULL, 
  DiaFch DATE NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblRelacionSalDiaFar2 ===========================================================================================================

CREATE TABLE TblRelacionSalDiaFar2 (
  SalId INTEGER NOT NULL, 
  DiaId INTEGER NOT NULL, 
  DiaCos DECIMAL(11,4) NOT NULL, 
  DiaNro TINYINT NOT NULL, 
  DiaFch DATE NOT NULL
) 
ENGINE=InnoDB;

# Estructura de la tabla TblSalidasFar2 ==================================================================================================================

CREATE TABLE TblSalidasFar2 (
  SalId INTEGER NOT NULL AUTO_INCREMENT, 
  SalDoc VARCHAR(50) NOT NULL, 
  FueId INTEGER NOT NULL, 
  SerId INTEGER NOT NULL, 
  AmbId INTEGER NOT NULL, 
  PacId INTEGER NOT NULL, 
  DsrId INTEGER NOT NULL, 
  PsrId INTEGER NOT NULL, 
  RepId INTEGER NOT NULL, 
  SalAno TINYINT NOT NULL, 
  SalMes TINYINT NOT NULL, 
  SalDia TINYINT NOT NULL, 
  SalTot DECIMAL(11,4) NOT NULL, 
  SalFch DATE NOT NULL, 
  SalAte DATE NOT NULL, 
  SalAse TINYINT NOT NULL, 
  SalTur VARCHAR(1) NOT NULL, 
  MvsId INTEGER NOT NULL, 
  ObsId INTEGER NOT NULL, 
  IntId INTEGER NOT NULL, 
  UsuId INTEGER NOT NULL, 
  SalAct TINYINT NOT NULL, 
  INDEX (SalDoc), 
  INDEX (SalAno), 
  INDEX (SalMes), 
  INDEX (SalDia), 
  INDEX (SalFch), 
  PRIMARY KEY (SalId)
) 
ENGINE=InnoDB;

INSERT INTO TblSalidasFar2 (SalId, SalDoc, FueId, SerId, AmbId, PacId, DsrId, PsrId, RepId, SalAno, SalMes, SalDia, SalTot, SalFch, SalAte, SalAse, SalTur, MvsId, ObsId, IntId, UsuId, SalAct) 
VALUES (0, '0', 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2000-01-01', '2000-01-01', 0, '0', 0, 0, 0, 0, 0);

UPDATE TblSalidasFar2 SET SalId = 0 WHERE SalId = 1;

ALTER TABLE TblSalidasFar2 AUTO_INCREMENT = 1;

# Relaciones de la tabla TblDistribucionesFar2 ===========================================================================================================

ALTER TABLE TblDistribucionesFar2 ADD CONSTRAINT TblDistribucionesFar2RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblDistribucionesFar2 ADD CONSTRAINT TblDistribucionesFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblDistribucionesFar2 ADD CONSTRAINT TblDistribucionesFar2ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblDistribucionesFar2 ADD CONSTRAINT TblDistribucionesFar2ModId FOREIGN KEY (ModId) REFERENCES TblModulo (ModId);
ALTER TABLE TblDistribucionesFar2 ADD CONSTRAINT TblDistribucionesFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblEntradasFar2 =================================================================================================================

ALTER TABLE TblEntradasFar2 ADD CONSTRAINT TblEntradasFar2ProId FOREIGN KEY (ProId) REFERENCES TblProveedores (ProId);
ALTER TABLE TblEntradasFar2 ADD CONSTRAINT TblEntradasFar2RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblEntradasFar2 ADD CONSTRAINT TblEntradasFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblEntradasFar2 ADD CONSTRAINT TblEntradasFar2ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblEntradasFar2 ADD CONSTRAINT TblEntradasFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblEtiquetasFar2 ================================================================================================================

ALTER TABLE TblEtiquetasFar2 ADD CONSTRAINT TblEtiquetasFar2SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar2 (SalId);
ALTER TABLE TblEtiquetasFar2 ADD CONSTRAINT TblEtiquetasFar2SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblEtiquetasFar2 ADD CONSTRAINT TblEtiquetasFar2FreId FOREIGN KEY (FreId) REFERENCES TblFrecuencias (FreId);
ALTER TABLE TblEtiquetasFar2 ADD CONSTRAINT TblEtiquetasFar2ViaId FOREIGN KEY (ViaId) REFERENCES TblVias (ViaId);
ALTER TABLE TblEtiquetasFar2 ADD CONSTRAINT TblEtiquetasFar2IndId FOREIGN KEY (IndId) REFERENCES TblIndicaciones (IndId);
ALTER TABLE TblEtiquetasFar2 ADD CONSTRAINT TblEtiquetasFar2NotId FOREIGN KEY (NotId) REFERENCES TblNotas (NotId);

# Relaciones de la tabla TblFraccionesFar2 ===============================================================================================================

ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2EntId FOREIGN KEY (EntId) REFERENCES TblEntradasFar2 (EntId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2PosId FOREIGN KEY (PosId) REFERENCES TblPositivosFar2 (PosId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar2 (SalId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2DisId FOREIGN KEY (DisId) REFERENCES TblDistribucionesFar2 (DisId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2NegId FOREIGN KEY (NegId) REFERENCES TblNegativosFar2 (NegId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2LotId FOREIGN KEY (LotId) REFERENCES TblLotesFar2 (LotId);
ALTER TABLE TblFraccionesFar2 ADD CONSTRAINT TblFraccionesFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblInternacionesFar2 ============================================================================================================

ALTER TABLE TblInternacionesFar2 ADD CONSTRAINT TblInternacionesFar2FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblInternacionesFar2 ADD CONSTRAINT TblInternacionesFar2SerId FOREIGN KEY (SerId) REFERENCES TblServicios (SerId);
ALTER TABLE TblInternacionesFar2 ADD CONSTRAINT TblInternacionesFar2CamId FOREIGN KEY (CamId) REFERENCES TblCamas (CamId);
ALTER TABLE TblInternacionesFar2 ADD CONSTRAINT TblInternacionesFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblLotesFar2 ====================================================================================================================

ALTER TABLE TblLotesFar2 ADD CONSTRAINT TblLotesFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMensualFar2 ==================================================================================================================

ALTER TABLE TblMensualFar2 ADD CONSTRAINT TblMensualFar2MenId FOREIGN KEY (MenId) REFERENCES TblMensualesFar2 (MenId);
ALTER TABLE TblMensualFar2 ADD CONSTRAINT TblMensualFar2SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);

# Relaciones de la tabla TblMensualesFar2 ================================================================================================================

ALTER TABLE TblMensualesFar2 ADD CONSTRAINT TblMensualesFar2GesId FOREIGN KEY (GesId) REFERENCES TblGestion (GesId);
ALTER TABLE TblMensualesFar2 ADD CONSTRAINT TblMensualesFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblMovimientoFar2 ===============================================================================================================

ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2SelId FOREIGN KEY (SelId) REFERENCES TblSeleccion (SelId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2EntId FOREIGN KEY (EntId) REFERENCES TblEntradasFar2 (EntId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2PosId FOREIGN KEY (PosId) REFERENCES TblPositivosFar2 (PosId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar2 (SalId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2DisId FOREIGN KEY (DisId) REFERENCES TblDistribucionesFar2 (DisId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2NegId FOREIGN KEY (NegId) REFERENCES TblNegativosFar2 (NegId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2LotId FOREIGN KEY (LotId) REFERENCES TblLotesFar2 (LotId);
ALTER TABLE TblMovimientoFar2 ADD CONSTRAINT TblMovimientoFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblNegativosFar2 ================================================================================================================

ALTER TABLE TblNegativosFar2 ADD CONSTRAINT TblNegativosFar2RecId FOREIGN KEY (RecId) REFERENCES TblReceptores (RecId);
ALTER TABLE TblNegativosFar2 ADD CONSTRAINT TblNegativosFar2RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblNegativosFar2 ADD CONSTRAINT TblNegativosFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblNegativosFar2 ADD CONSTRAINT TblNegativosFar2ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblNegativosFar2 ADD CONSTRAINT TblNegativosFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblPositivosFar2 ================================================================================================================

ALTER TABLE TblPositivosFar2 ADD CONSTRAINT TblPositivosFar2ProId FOREIGN KEY (ProId) REFERENCES TblProveedores (ProId);
ALTER TABLE TblPositivosFar2 ADD CONSTRAINT TblPositivosFar2RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblPositivosFar2 ADD CONSTRAINT TblPositivosFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblPositivosFar2 ADD CONSTRAINT TblPositivosFar2ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblPositivosFar2 ADD CONSTRAINT TblPositivosFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);

# Relaciones de la tabla TblRelacionIntDiaFar2 ===========================================================================================================

ALTER TABLE TblRelacionIntDiaFar2 ADD CONSTRAINT TblRelacionIntDiaFar2IntId FOREIGN KEY (IntId) REFERENCES TblInternacionesFar2 (IntId);
ALTER TABLE TblRelacionIntDiaFar2 ADD CONSTRAINT TblRelacionIntDiaFar2DiaId FOREIGN KEY (DiaId) REFERENCES TblDiagnosticos (DiaId);

# Relaciones de la tabla TblRelacionSalDiaFar2 ===========================================================================================================

ALTER TABLE TblRelacionSalDiaFar2 ADD CONSTRAINT TblRelacionSalDiaFar2SalId FOREIGN KEY (SalId) REFERENCES TblSalidasFar2 (SalId);
ALTER TABLE TblRelacionSalDiaFar2 ADD CONSTRAINT TblRelacionSalDiaFar2DiaId FOREIGN KEY (DiaId) REFERENCES TblDiagnosticos (DiaId);

# Relaciones de la tabla TblSalidasFar2 ==================================================================================================================

ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2FueId FOREIGN KEY (FueId) REFERENCES TblFuentes (FueId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2SerId FOREIGN KEY (SerId) REFERENCES TblServicios (SerId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2AmbId FOREIGN KEY (AmbId) REFERENCES TblAmbientes (AmbId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2PacId FOREIGN KEY (PacId) REFERENCES TblPacientes (PacId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2DsrId FOREIGN KEY (DsrId) REFERENCES TblDispensadores (DsrId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2PsrId FOREIGN KEY (PsrId) REFERENCES TblPrescriptores (PsrId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2RepId FOREIGN KEY (RepId) REFERENCES TblRepresentantes (RepId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2MvsId FOREIGN KEY (MvsId) REFERENCES TblMovimientos (MvsId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2ObsId FOREIGN KEY (ObsId) REFERENCES TblObservaciones (ObsId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2IntId FOREIGN KEY (IntId) REFERENCES TblInternacionesFar2 (IntId);
ALTER TABLE TblSalidasFar2 ADD CONSTRAINT TblSalidasFar2UsuId FOREIGN KEY (UsuId) REFERENCES TblUsuarios (UsuId);