// game/engine.js
export const BOARD_LENGTH = 40;
export const PEGS_PER_PLAYER = 4;

export function newDeck() {
  const nums = [1,2,3,4,5,6];
  const deck = [];
  for (let r=0;r<8;r++) nums.forEach(n=>deck.push(String(n)));
  deck.push('J'); deck.push('J');
  for (let i=deck.length-1;i>0;i--) {
    const j = Math.floor(Math.random()*(i+1));
    [deck[i], deck[j]] = [deck[j], deck[i]];
  }
  return deck;
}

export function dealHands(deck, nPlayers, handSize=5){
  const hands = Array.from({length:nPlayers}, ()=>[]);
  for (let i=0;i<handSize;i++){
    for (let p=0;p<nPlayers;p++) hands[p].push(deck.pop());
  }
  return hands;
}

export function legalMovesForCard(player, card) {
  const moves = [];
  if (card === 'J') {
    player.pegs.forEach((pos, idx)=>{
      if (pos === -1) moves.push({pegIdx: idx, newPos: 0});
      else if (pos >= 0 && pos < BOARD_LENGTH) moves.push({pegIdx: idx, newPos: BOARD_LENGTH});
    });
  } else {
    const n = Number(card);
    player.pegs.forEach((pos, idx)=>{
      if (pos === -1) {
        if (n === 1) moves.push({pegIdx: idx, newPos: 0});
      } else if (pos >= 0 && pos < BOARD_LENGTH) {
        let candidate = pos + n;
        if (candidate > BOARD_LENGTH) candidate = BOARD_LENGTH;
        moves.push({pegIdx: idx, newPos: candidate});
      }
    });
  }
  return moves;
}

export function applyMoveToState(state, playerIndex, cardIndex, pegIdx) {
  const s = JSON.parse(JSON.stringify(state));
  const player = s.players[playerIndex];
  const card = player.hand[cardIndex];
  const moves = legalMovesForCard(player, card);
  const chosen = moves.find(m=>m.pegIdx === pegIdx);
  if (!chosen) throw new Error('Illegal move');
  player.pegs[pegIdx] = chosen.newPos;
  if (chosen.newPos === BOARD_LENGTH) player.finished = (player.finished||0) + 1;
  player.hand.splice(cardIndex,1);
  if (s.deck.length>0) player.hand.push(s.deck.pop());
  s.turn = (s.turn + 1) % s.players.length;
  s.history = s.history || [];
  s.history.push({playerIndex, card, pegIdx, timestamp: Date.now()});
  return s;
}
