from machine import Pin, time_pulse_us
import time

# Set up pins
trig = Pin(14, Pin.OUT)
echo = Pin(15, Pin.IN)
RLED = Pin(16, Pin.OUT)
GLED = Pin(17, Pin.OUT)
BLED = Pin(18, Pin.OUT)

def get_distance():
    # Ensure trigger is low
    trig.low()
    time.sleep_us(2)
    
    # Send a 10us pulse to trigger
    trig.high()
    time.sleep_us(10)
    trig.low()

    # Measure the echo pulse duration (in microseconds)
    duration = time_pulse_us(echo, 1, 30000)  # Wait up to 30ms for response

    if duration < 0:
        return None  # Timeout or no echo

    # Calculate distance (duration is round-trip time)
    distance_cm = (duration / 2) / 29.1
    return round(distance_cm, 2)

# Main loop
while True:
    dist = get_distance()
    if dist is not None:
        print("Distance:", dist, "cm")
        if dist < 10:
            if dist < 5:
                RLED.value(0)
                GLED.value(1)
                BLED.value(1)
            else:    
                RLED.value(0)
                GLED.value(0)
                BLED.value(1)
        else:
            RLED.value(1)
            GLED.value(1)
            BLED.value(1)
    else:
        print("Out of range or no object detected")
    time.sleep_ms(50)   
 