#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators
{
	public class CandleQuarters : Indicator
	{
		private double c 	= 0; 	// center of candle
		private double p	= 0; 	// pivot of candle
		private double hq	= 0; 	// High Quarter of candle
		private double lq	= 0; 	// Low Quarter of Candle
		private double pm	= 0; 	// Probable Max

		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description							= @"Paints a Cross on the Bar Center and a Dot at the Bar Pivot and the 25% 75% points";
				Name								= "CandleQuarters";
				Calculate							= Calculate.OnBarClose;
				IsOverlay							= true;
				DisplayInDataBox					= true;
				DrawOnPricePanel					= true;
				DrawHorizontalGridLines				= true;
				DrawVerticalGridLines				= true;
				PaintPriceMarkers					= true;
				ScaleJustification					= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive			= true;
				AddPlot(new Stroke(Brushes.Indigo, 2), PlotStyle.Cross, "BarCenter");
				AddPlot(new Stroke(Brushes.Gold, 2), PlotStyle.Dot, "BarPivot");
				AddPlot(new Stroke(Brushes.Orange, 2), PlotStyle.Dot, "HighQuarter");
				AddPlot(new Stroke(Brushes.Orange, 2), PlotStyle.Dot, "LowQuarter");
			}
			else if (State == State.Active)
			{
				SetZOrder(1);		// keep on top of candles
			}
		}

		protected override void OnBarUpdate()
		{
						
			if(CurrentBar < 20) return;
			
			c = (High[0] - Low[0]) / 2 + Low[0];
			
			p = (High[0] + Low[0] + Close[0]) / 3;
			
			hq = (High[0] - c) / 2 + c;
			
			lq = c - (High[0] - c) / 2;
			
			BarCenter[0] 	= 	c;
			BarPivot[0]		=	p;
			HighQuarter[0]	=	hq;
			LowQuarter[0]	=	lq;
			
		}

		#region Properties

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> BarCenter
		{
			get { return Values[0]; }
		}

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> BarPivot
		{
			get { return Values[1]; }
		}

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> HighQuarter
		{
			get { return Values[2]; }
		}

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> LowQuarter
		{
			get { return Values[3]; }
		}
		#endregion

	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private CandleQuarters[] cacheCandleQuarters;
		public CandleQuarters CandleQuarters()
		{
			return CandleQuarters(Input);
		}

		public CandleQuarters CandleQuarters(ISeries<double> input)
		{
			if (cacheCandleQuarters != null)
				for (int idx = 0; idx < cacheCandleQuarters.Length; idx++)
					if (cacheCandleQuarters[idx] != null &&  cacheCandleQuarters[idx].EqualsInput(input))
						return cacheCandleQuarters[idx];
			return CacheIndicator<CandleQuarters>(new CandleQuarters(), input, ref cacheCandleQuarters);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.CandleQuarters CandleQuarters()
		{
			return indicator.CandleQuarters(Input);
		}

		public Indicators.CandleQuarters CandleQuarters(ISeries<double> input )
		{
			return indicator.CandleQuarters(input);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.CandleQuarters CandleQuarters()
		{
			return indicator.CandleQuarters(Input);
		}

		public Indicators.CandleQuarters CandleQuarters(ISeries<double> input )
		{
			return indicator.CandleQuarters(input);
		}
	}
}

#endregion
