#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 

    /// Copyright j2algoTrader.com 2025.
	/// DO NOT REDISTRIBUTE. DO NOT REMOVE j2algoTrader.com COPYRIGHT NOTICE. 

 
namespace NinjaTrader.NinjaScript.Indicators.j2
{
	public class j2Wiseman : Indicator
	{
		private WisemanAlligator WisemanAlligator1;
		private CandleQuarters CandleQuarters1;
		private WisemanFractal WisemanFractal1;
		private EMA EMA1;
		private ATR ATR1;
		private j2Ergodic j2Ergodic1;
		private Momentum Mom1;
		
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Modified / enhanced Wiseman price action pivots relevant to impending price reversal. Arrow indication combined with the Dot indicates stronger pressure is in play";
				Name										= "j2Wiseman";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				Liplen					= 5;
				Teethlen				= 8;
				Jawlen					= 13;
				Lipdis					= 3;
				Teethdisp				= 5;
				Jawdis					= 8;
				ATRS					= 7;
				TickDistance			= 8;
				ArrowBrush				= Brushes.White;
				
				
				AddPlot(Brushes.Transparent, "WiseAlert");
			}
			else if (State == State.Configure)
			{
				
			}
			else if (State == State.DataLoaded)
			{				
				WisemanAlligator1			= WisemanAlligator(Close, Convert.ToInt32(Jawlen), Convert.ToInt32(Teethlen), Convert.ToInt32(Liplen), Convert.ToInt32(Jawdis), Convert.ToInt32(Teethdisp), Convert.ToInt32(Lipdis));
				CandleQuarters1				= CandleQuarters(Close);	
				WisemanFractal1				= WisemanFractal(Close, 2, 8);
				EMA1 						= EMA(Close, 50);
				ATR1						= ATR(Close, ATRS);
				j2Ergodic1			    	= j2Ergodic(Close, 7, 21, 4, false, true, true, true, true);
				Mom1			         	= Momentum(j2Ergodic1.Main, 50);
			}			
			
		}

		protected override void OnBarUpdate()
		{
			
			if (CurrentBars[0] < BarsRequiredToPlot)
				return;
		
	

			 // Set 1 Long
			if (    Low[0] <= Low[1] 
                 && Low[1] <= Low[2]  
				 && High[0] <   Instrument.MasterInstrument.RoundToTickSize(WisemanAlligator1.Lips[0])  
				 && High[0] <   Instrument.MasterInstrument.RoundToTickSize(WisemanAlligator1.Teeth[0]) 
				 && High[0] <   Instrument.MasterInstrument.RoundToTickSize(WisemanAlligator1.Jaw[0]) 
				 && Close[0] >= CandleQuarters1.HighQuarter[0]
				 && ATR1[0] > 1 
				 && Close[0] != Open[0]
				 && Mom1[0] > Mom1[1]
				 && (EMA1[0] > High[0] || EMA1[0] < Low[0]))
	
			{
				Draw.Dot(this, @"DivergenceBar Diamond_1" + CurrentBar, false, 0, Low[0] - (TickDistance * TickSize), ArrowBrush);
				Draw.ArrowUp(this, @"Wiseman" + CurrentBar, false, 0, Low[0] - ((TickDistance + 2) * TickSize), ArrowBrush);
                WiseAlert[0] = 1; 
	
			}
			
			 // Set 2 Short
			if (   High[0] >= High[1] 
				 && High[1] >= High[2] 
				 && Low[0] >= Instrument.MasterInstrument.RoundToTickSize(WisemanAlligator1.Lips[0])
				 && Low[0] > Instrument.MasterInstrument.RoundToTickSize(WisemanAlligator1.Teeth[0])
				 && Low[0] > Instrument.MasterInstrument.RoundToTickSize(WisemanAlligator1.Jaw[0]) 
				 && Close[0] <= CandleQuarters1.LowQuarter[0]
				 && ATR1[0] > 1
				 && Close[0] != Open[0]
				 && Mom1[0] < Mom1[1]
				 && (EMA1[0] > High[0] || EMA1[0] < Low[0]) )
			{
				Draw.Dot(this, @"DivergenceBar Diamond_2" + CurrentBar, false, 0, High[0] + (TickDistance * TickSize), ArrowBrush);
				Draw.ArrowDown(this, @"Wiseman" + CurrentBar, false, 0, High[0] + ((TickDistance + 2) * TickSize), ArrowBrush);
				WiseAlert[0] = -1;
			}
		}

#region Properties
		
        [XmlIgnore]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Dot | Arrow Color", GroupName = "Alert", Order = 1)]
		public Brush ArrowBrush { get; set; }
		
		[Browsable(false)]
		public string ArrowBrushSerialize
		{
			get { return Serialize.BrushToString(ArrowBrush); }
		   	set { ArrowBrush = Serialize.StringToBrush(value); }
		}
			
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Alert Tick Distance", Description="Alert Tick Distance from High or Low of Candle", Order = 2, GroupName="Alert")]
		public int TickDistance
		{ get; set; }
			
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Lip length", Description="Lip length", Order = 1, GroupName="Wiseman Settings")]
		public int Liplen
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Teeth length", Description="Teeth Length", Order = 2, GroupName="Wiseman Settings")]
		public int Teethlen
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Jaw length", Description="Jaw Length", Order = 3, GroupName="Wiseman Settings")]
		public int Jawlen
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Lip displacement", Description="Lip Displacement", Order = 4, GroupName="Wiseman Settings")]
		public int Lipdis
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Teeth displacement", Description="Teeth  Displacement", Order = 5, GroupName="Wiseman Settings")]
		public int Teethdisp
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Jaw displacement", Description="Jaw  Displacement", Order = 6, GroupName="Wiseman Settings")]
		public int Jawdis
		{ get; set; }
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="ATR Period", Description="Average True Range Lookback period", Order = 1, GroupName="Support ATR")]
		public int ATRS
		{ get; set; }
		
		
		
		
				
		  [XmlIgnore]
		[Browsable(false)]
		public Series<double> WiseAlert	
			{
			get { return Values[0];}
			}
		
		#endregion

	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private j2.j2Wiseman[] cachej2Wiseman;
		public j2.j2Wiseman j2Wiseman(int tickDistance, int liplen, int teethlen, int jawlen, int lipdis, int teethdisp, int jawdis, int aTRS)
		{
			return j2Wiseman(Input, tickDistance, liplen, teethlen, jawlen, lipdis, teethdisp, jawdis, aTRS);
		}

		public j2.j2Wiseman j2Wiseman(ISeries<double> input, int tickDistance, int liplen, int teethlen, int jawlen, int lipdis, int teethdisp, int jawdis, int aTRS)
		{
			if (cachej2Wiseman != null)
				for (int idx = 0; idx < cachej2Wiseman.Length; idx++)
					if (cachej2Wiseman[idx] != null && cachej2Wiseman[idx].TickDistance == tickDistance && cachej2Wiseman[idx].Liplen == liplen && cachej2Wiseman[idx].Teethlen == teethlen && cachej2Wiseman[idx].Jawlen == jawlen && cachej2Wiseman[idx].Lipdis == lipdis && cachej2Wiseman[idx].Teethdisp == teethdisp && cachej2Wiseman[idx].Jawdis == jawdis && cachej2Wiseman[idx].ATRS == aTRS && cachej2Wiseman[idx].EqualsInput(input))
						return cachej2Wiseman[idx];
			return CacheIndicator<j2.j2Wiseman>(new j2.j2Wiseman(){ TickDistance = tickDistance, Liplen = liplen, Teethlen = teethlen, Jawlen = jawlen, Lipdis = lipdis, Teethdisp = teethdisp, Jawdis = jawdis, ATRS = aTRS }, input, ref cachej2Wiseman);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.j2.j2Wiseman j2Wiseman(int tickDistance, int liplen, int teethlen, int jawlen, int lipdis, int teethdisp, int jawdis, int aTRS)
		{
			return indicator.j2Wiseman(Input, tickDistance, liplen, teethlen, jawlen, lipdis, teethdisp, jawdis, aTRS);
		}

		public Indicators.j2.j2Wiseman j2Wiseman(ISeries<double> input , int tickDistance, int liplen, int teethlen, int jawlen, int lipdis, int teethdisp, int jawdis, int aTRS)
		{
			return indicator.j2Wiseman(input, tickDistance, liplen, teethlen, jawlen, lipdis, teethdisp, jawdis, aTRS);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.j2.j2Wiseman j2Wiseman(int tickDistance, int liplen, int teethlen, int jawlen, int lipdis, int teethdisp, int jawdis, int aTRS)
		{
			return indicator.j2Wiseman(Input, tickDistance, liplen, teethlen, jawlen, lipdis, teethdisp, jawdis, aTRS);
		}

		public Indicators.j2.j2Wiseman j2Wiseman(ISeries<double> input , int tickDistance, int liplen, int teethlen, int jawlen, int lipdis, int teethdisp, int jawdis, int aTRS)
		{
			return indicator.j2Wiseman(input, tickDistance, liplen, teethlen, jawlen, lipdis, teethdisp, jawdis, aTRS);
		}
	}
}

#endregion
