#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript.Indicators;

#endregion


// This namespace holds indicators in this folder and is required. Do not change it.
namespace NinjaTrader.NinjaScript.Indicators.j2
{
	/// <summary>
	/// Plots the open, high, and low values from the session starting on the current day.
	/// </summary>
	public class j2CurrentDayOHLM: Indicator
	{
		private DateTime			currentDate			=	Core.Globals.MinDate;
		private double				currentOpen			=	double.MinValue;
		private double				currentHigh			=	double.MinValue;
		private double				currentLow			=	double.MaxValue;
		private double				currentMidPoint	    =   double.MinValue;
		private double				currentONH		    =   double.MinValue;
		private double				currentONL		    =   double.MinValue;
		private double				currentONM		    =   double.MinValue;
		
		private DateTime			lastDate			= 	Core.Globals.MinDate;
		private SessionIterator		sessionIterator;

		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description					= @"ScriptReady Current Day Open, High, Low, and MidPoint of High & Low, plus the overnight high & low plots through the day session.";
				Name						= "j2CurrentDayOHLM";
				IsAutoScale					= false;
				DrawOnPricePanel			= false;
				IsOverlay					= true;
				IsSuspendedWhileInactive	= true;
				RTHStart					= DateTime.Parse("08:30", System.Globalization.CultureInfo.InvariantCulture);
				ShowLow						= true;
				ShowHigh					= true;
				ShowOpen					= true;
				ShowMidPoint				= true;
				ShowONH						= true;
				ShowONL						= true;
				ShowONM						= true;
				BarsRequiredToPlot			= 0;

				AddPlot(new Stroke(Brushes.Goldenrod,	DashStyleHelper.Dash, 2), PlotStyle.Square, Custom.Resource.CurrentDayOHLOpen); // 0
				AddPlot(new Stroke(Brushes.SeaGreen,	DashStyleHelper.Dash, 2), PlotStyle.Square, Custom.Resource.CurrentDayOHLHigh); // 1
				AddPlot(new Stroke(Brushes.Red,			DashStyleHelper.Dash, 2), PlotStyle.Square, Custom.Resource.CurrentDayOHLLow);  // 2
				AddPlot(new Stroke(Brushes.Magenta,		DashStyleHelper.Dash, 2), PlotStyle.Square, "CurrentMidPoint");					// 3
				AddPlot(new Stroke(Brushes.SeaGreen,	DashStyleHelper.Dash, 1), PlotStyle.Square, "CurrentONH");						// 4
			    AddPlot(new Stroke(Brushes.Red,			DashStyleHelper.Dash, 1), PlotStyle.Square, "CurrentONL");						// 5
			    AddPlot(new Stroke(Brushes.Magenta,		DashStyleHelper.Dash, 1), PlotStyle.Square, "CurrentONM");						// 6
			}
			
			else if (State == State.Configure)
			{
				currentDate			= Core.Globals.MinDate;
				currentOpen			= double.MinValue;
				currentHigh			= double.MinValue;
				currentLow			= double.MaxValue;
				currentMidPoint		= double.MinValue;
				lastDate			= Core.Globals.MinDate;
			}
	
			else if (State == State.DataLoaded)
			{
				sessionIterator = new SessionIterator(Bars);
			}
			else if (State == State.Historical)
			{
				if (!Bars.BarsType.IsIntraday)
				{
					Draw.TextFixed(this, "NinjaScriptInfo", Custom.Resource.CurrentDayOHLError, TextPosition.BottomRight);
					Log(Custom.Resource.CurrentDayOHLError, LogLevel.Error);
				}
			}
		}

		protected override void OnBarUpdate()
		{
			if (!Bars.BarsType.IsIntraday) return;

			lastDate 		= currentDate;
			currentDate 	= sessionIterator.GetTradingDay(Time[0]);
			
			if (lastDate != currentDate || currentOpen == double.MinValue)
			{
				currentOpen		= Open[0];
				currentHigh		= High[0];
				currentLow		= Low[0];
				currentMidPoint = (currentHigh - ((currentHigh - currentLow)/2));
				currentONH		= High[0];
				currentONL		= Low[0];
				currentONM		= (currentHigh - ((currentHigh - currentLow)/2));
			}

			currentHigh			= Math.Max(currentHigh, High[0]);
			currentLow			= Math.Min(currentLow, Low[0]);
			currentMidPoint     = Math.Max(currentHigh,High[0]) - ((Math.Max(currentHigh,High[0]) - Math.Min(currentLow, Low[0]))/2);
			
			if (Times[0][0].TimeOfDay <= RTHStart.TimeOfDay) 
			 
			  { currentONH = currentHigh;
				currentONL = currentLow;
				currentONM = currentMidPoint;
			  }
			  
			 else if (Times[0][0].TimeOfDay > RTHStart.TimeOfDay)
				 
			 { currentONH = currentONH;
			   currentONL = currentONL;
			   currentONM = currentONM;
			 }
				 
			if (ShowOpen)
				CurrentOpen[0] = currentOpen;

			if (ShowHigh)
				CurrentHigh[0] = currentHigh;

			if (ShowLow)
				CurrentLow[0] = currentLow;
					  					
			if (ShowMidPoint)
				CurrentMidPoint[0] = currentMidPoint;
			
			if (ShowONH)
				CurrentONH[0] = currentONH;
			
			if (ShowONL)
				CurrentONL[0] = currentONL;
			
			if (ShowONM)
				CurrentONM[0] = currentONM;
			
			
			
			
		}

		#region Properties
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentOpen
		{
			get { return Values[0]; }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentHigh
		{
			get { return Values[1]; }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentLow
		{
			get { return Values[2]; }
		}

		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentMidPoint
		{
			get { return Values[3]; }
		}
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentONH
		{
			get { return Values[4]; }
		}
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentONL
		{
			get { return Values[5]; }
		}
		
		[Browsable(false)]	// this line prevents the data series from being displayed in the indicator properties dialog, do not remove
		[XmlIgnore()]		// this line ensures that the indicator can be saved/recovered as part of a chart template, do not remove
		public Series<double> CurrentONM
		{
			get { return Values[6]; }
		}
		
		[NinjaScriptProperty]
		[PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
		[Display(Name="RTH Start", GroupName="Parameters", Order = 0)]
		public DateTime RTHStart
		{ get; set; }
		
		[Display(ResourceType = typeof(Custom.Resource), Name = "Show High", GroupName = "Parameters", Order = 1)]
		public bool ShowHigh
		{ get; set; }

		[Display(ResourceType = typeof(Custom.Resource), Name = "Show Low", GroupName = "Parameters", Order = 2)]
		public bool ShowLow
		{ get; set; }

		[Display(ResourceType = typeof(Custom.Resource), Name = "Show Open", GroupName = "Parameters", Order = 3)]
		public bool ShowOpen
		{ get; set; }
		
		[Display(ResourceType = typeof(Custom.Resource), Name = "Show MidPoint", GroupName = "Parameters", Order = 4)]
		public bool ShowMidPoint
		{ get; set; }
		
		[Display(ResourceType = typeof(Custom.Resource), Name = "Show Overnight High", GroupName = "Parameters", Order = 5)]
		public bool ShowONH
		{ get; set; }
		
		[Display(ResourceType = typeof(Custom.Resource), Name = "Show Overnight Low", GroupName = "Parameters", Order = 6)]
		public bool ShowONL
		{ get; set; }
		
		[Display(ResourceType = typeof(Custom.Resource), Name = "Show Overnight MidPoint", GroupName = "Parameters", Order = 7)]
		public bool ShowONM
		{ get; set; }
		
		#endregion
		
		
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private j2.j2CurrentDayOHLM[] cachej2CurrentDayOHLM;
		public j2.j2CurrentDayOHLM j2CurrentDayOHLM(DateTime rTHStart)
		{
			return j2CurrentDayOHLM(Input, rTHStart);
		}

		public j2.j2CurrentDayOHLM j2CurrentDayOHLM(ISeries<double> input, DateTime rTHStart)
		{
			if (cachej2CurrentDayOHLM != null)
				for (int idx = 0; idx < cachej2CurrentDayOHLM.Length; idx++)
					if (cachej2CurrentDayOHLM[idx] != null && cachej2CurrentDayOHLM[idx].RTHStart == rTHStart && cachej2CurrentDayOHLM[idx].EqualsInput(input))
						return cachej2CurrentDayOHLM[idx];
			return CacheIndicator<j2.j2CurrentDayOHLM>(new j2.j2CurrentDayOHLM(){ RTHStart = rTHStart }, input, ref cachej2CurrentDayOHLM);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.j2.j2CurrentDayOHLM j2CurrentDayOHLM(DateTime rTHStart)
		{
			return indicator.j2CurrentDayOHLM(Input, rTHStart);
		}

		public Indicators.j2.j2CurrentDayOHLM j2CurrentDayOHLM(ISeries<double> input , DateTime rTHStart)
		{
			return indicator.j2CurrentDayOHLM(input, rTHStart);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.j2.j2CurrentDayOHLM j2CurrentDayOHLM(DateTime rTHStart)
		{
			return indicator.j2CurrentDayOHLM(Input, rTHStart);
		}

		public Indicators.j2.j2CurrentDayOHLM j2CurrentDayOHLM(ISeries<double> input , DateTime rTHStart)
		{
			return indicator.j2CurrentDayOHLM(input, rTHStart);
		}
	}
}

#endregion
