#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.NinjaScript.Indicators.j2
{
    public class j2Wicks : Indicator
    {
        private int tickSizeInTicks;

        protected override void OnStateChange()
        {
            if (State == State.SetDefaults)
            {
                Description     = "Displays wick distance in ticks above and below candles";
                Name            = "j2Wicks";
                Calculate		= Calculate.OnBarClose;
                IsOverlay       = true;
                Pixels			= 50;
				
				AddPlot(Brushes.Transparent, "UpperWick");
				AddPlot(Brushes.Transparent, "LowerWick");				
            }
            else if (State == State.Configure)
            {
                tickSizeInTicks = (int)Math.Round(1.0 / TickSize);
            }
        }

        protected override void OnBarUpdate()
        {
             NinjaTrader.Gui.Tools.SimpleFont myFont = new NinjaTrader.Gui.Tools.SimpleFont("Courier New", 14) { Size = 14, Bold = false };
			
			if (CurrentBar < 1)
                return;

            double topWick = 0;
            double bottomWick = 0;

            // Determine open and close
            double bodyTop = Math.Max(Open[0], Close[0]);
            double bodyBottom = Math.Min(Open[0], Close[0]);

            // Calculate wick distances
            topWick = ((High[0] - bodyTop) * 4);
            bottomWick = ((bodyBottom - Low[0]) * 4);

            // Convert to ticks
            int topWickTicks = (int)Math.Round(topWick / TickSize);
            int bottomWickTicks = (int)Math.Round(bottomWick / TickSize);
           
            Draw.Text(this, "TopWick"+CurrentBar, true, topWick.ToString(), 0, High[0], Pixels, Brushes.Gray, myFont, TextAlignment.Center, null, null, 1); 
			Draw.Text(this, "bottomWick"+CurrentBar, true, bottomWick.ToString(), 0, Low[0], -(Pixels), Brushes.Gray, myFont, TextAlignment.Center, null, null, 1); 
			
			UpperWick[0] = topWick;
			LowerWick[0] = bottomWick;
			
        }
		
				
     #region Properties
				
		
  
		
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Pixels", Description = "Pixel Distance ", GroupName = "Visual", Order = 4)]
		public int Pixels
		{ get; set; }
		
	   [XmlIgnore]
		[Browsable(false)]
		public Series<double> UpperWick	
			{
			get { return Values[0];}
			}	
			
		[XmlIgnore]
		[Browsable(false)]
		public Series<double> LowerWick	
			{
			get { return Values[1];}
			}	
		
				
#endregion		
    }
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private j2.j2Wicks[] cachej2Wicks;
		public j2.j2Wicks j2Wicks(int pixels)
		{
			return j2Wicks(Input, pixels);
		}

		public j2.j2Wicks j2Wicks(ISeries<double> input, int pixels)
		{
			if (cachej2Wicks != null)
				for (int idx = 0; idx < cachej2Wicks.Length; idx++)
					if (cachej2Wicks[idx] != null && cachej2Wicks[idx].Pixels == pixels && cachej2Wicks[idx].EqualsInput(input))
						return cachej2Wicks[idx];
			return CacheIndicator<j2.j2Wicks>(new j2.j2Wicks(){ Pixels = pixels }, input, ref cachej2Wicks);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.j2.j2Wicks j2Wicks(int pixels)
		{
			return indicator.j2Wicks(Input, pixels);
		}

		public Indicators.j2.j2Wicks j2Wicks(ISeries<double> input , int pixels)
		{
			return indicator.j2Wicks(input, pixels);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.j2.j2Wicks j2Wicks(int pixels)
		{
			return indicator.j2Wicks(Input, pixels);
		}

		public Indicators.j2.j2Wicks j2Wicks(ISeries<double> input , int pixels)
		{
			return indicator.j2Wicks(input, pixels);
		}
	}
}

#endregion
