#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.j2
{
	public class j2BodySize : Indicator
	{
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Compares the body size relative to the Hi/Lo Range of the Candle and fires a ninjascript ready signal when it meets or exceeds user defined percentage of body vs. total range and also paints the bar. ";
				Name										= "j2BodySize";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
	
			
				
			Range						= 80;
			soundAlert                  = false;
			UpBrush					    = Brushes.DarkGreen;
			DownBrush					= Brushes.Maroon;

			AddPlot(Brushes.Transparent, "percent");
	
			
				
				
			}
			else if (State == State.Configure)
			{
			}
		}

		protected override void OnBarUpdate()
		{
		//Add your custom indicator logic here.
			
			
	 	var range = High[0] - Low[0];
        var bodySize = Math.Abs(Open[0] - Close[0]);
 

        if(range > 0)
		{
                 var percent = bodySize / range * 100;
                 Value[0] = percent;
        }
			
			
			
  	//	set 1 Price Rising	
			
			if (Close[0] > Open[0] && Value[0] >= Range)
	 
			  { BarBrush = UpBrush;
		 
		 	     if (soundAlert)  
				
				 {  PlaySound(@"C:\Program Files\NinjaTrader 8\sounds\j2pctAlert.wav");}
				 
			  } 
				 
	// set Price Falling
				 
				 	
			if (Close[0] < Open[0] && Value[0] >= Range)
	 
			  { BarBrush = DownBrush;
		 
		 	     if (soundAlert)  
				
				 {  PlaySound(@"C:\Program Files\NinjaTrader 8\sounds\j2pctAlert.wav");}
				 
		}
		
	}
		
		
#region Properties
		
		[NinjaScriptProperty]
		[Range(0, int.MaxValue)]
		[Display(Name="Range Min", Description="Minimum percentage range of body vs. Range to trigger Alert", Order=1, GroupName="Parameters")]
		public int Range
		{ get; set; }
		

		[Display(Name = "Sound Alert", Description = "Sound alerts activated", Order = 2, GroupName = "Parameters")]
        public bool soundAlert
		{ get; set; }

		
		[NinjaScriptProperty]
		[XmlIgnore]
		[Display(Name="UpBrush", Description="UpBrush Color", Order=3, GroupName="Parameters")]
		public Brush UpBrush
		{ get; set; }

		[Browsable(false)]
		public string UpBrushSerializable
		{
			get { return Serialize.BrushToString(UpBrush); }
			set { UpBrush = Serialize.StringToBrush(value); }
		}			

		[NinjaScriptProperty]
		[XmlIgnore]
		[Display(Name="DownBrush", Description="DownBrush Color", Order=4, GroupName="Parameters")]
		public Brush DownBrush
		{ get; set; }

		[Browsable(false)]
		public string DownBrushSerializable
		{
			get { return Serialize.BrushToString(DownBrush); }
			set { DownBrush = Serialize.StringToBrush(value); }
		}		

		
        [Browsable(false)]
		[XmlIgnore]
		public Series<double> percent
		{
			get { return Values[0]; }
		}	
		
		
		
		
		
#endregion
		
		
		
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private j2.j2BodySize[] cachej2BodySize;
		public j2.j2BodySize j2BodySize(int range, Brush upBrush, Brush downBrush)
		{
			return j2BodySize(Input, range, upBrush, downBrush);
		}

		public j2.j2BodySize j2BodySize(ISeries<double> input, int range, Brush upBrush, Brush downBrush)
		{
			if (cachej2BodySize != null)
				for (int idx = 0; idx < cachej2BodySize.Length; idx++)
					if (cachej2BodySize[idx] != null && cachej2BodySize[idx].Range == range && cachej2BodySize[idx].UpBrush == upBrush && cachej2BodySize[idx].DownBrush == downBrush && cachej2BodySize[idx].EqualsInput(input))
						return cachej2BodySize[idx];
			return CacheIndicator<j2.j2BodySize>(new j2.j2BodySize(){ Range = range, UpBrush = upBrush, DownBrush = downBrush }, input, ref cachej2BodySize);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.j2.j2BodySize j2BodySize(int range, Brush upBrush, Brush downBrush)
		{
			return indicator.j2BodySize(Input, range, upBrush, downBrush);
		}

		public Indicators.j2.j2BodySize j2BodySize(ISeries<double> input , int range, Brush upBrush, Brush downBrush)
		{
			return indicator.j2BodySize(input, range, upBrush, downBrush);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.j2.j2BodySize j2BodySize(int range, Brush upBrush, Brush downBrush)
		{
			return indicator.j2BodySize(Input, range, upBrush, downBrush);
		}

		public Indicators.j2.j2BodySize j2BodySize(ISeries<double> input , int range, Brush upBrush, Brush downBrush)
		{
			return indicator.j2BodySize(input, range, upBrush, downBrush);
		}
	}
}

#endregion
