/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixin.ClientPlayerEntityAccessor;
import meteordevelopment.meteorclient.mixin.PlayerMoveC2SPacketAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2696;
import net.minecraft.class_2828;
import net.minecraft.class_4970;

public class Flight
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgAntiKick;
    private final Setting<Mode> mode;
    private final Setting<Double> speed;
    private final Setting<Boolean> verticalSpeedMatch;
    private final Setting<Boolean> noSneak;
    private final Setting<AntiKickMode> antiKickMode;
    private final Setting<Integer> delay;
    private final Setting<Integer> offTime;
    private int delayLeft;
    private int offLeft;
    private boolean flip;
    private float lastYaw;
    private double lastPacketY;

    public Flight() {
        super(Categories.Movement, "flight", "FLYYYY! No Fall is recommended with this module.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgAntiKick = this.settings.createGroup("Anti Kick");
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("The mode for Flight.")).defaultValue(Mode.Abilities)).onChanged(mode -> {
            if (!this.isActive() || !Utils.canUpdate()) {
                return;
            }
            this.abilitiesOff();
        })).build());
        this.speed = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("speed")).description("Your speed when flying.")).defaultValue(0.1).min(0.0).build());
        this.verticalSpeedMatch = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("vertical-speed-match")).description("Matches your vertical speed to your horizontal speed, otherwise uses vanilla ratio.")).defaultValue(false)).build());
        this.noSneak = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("no-sneak")).description("Prevents you from sneaking while flying.")).defaultValue(false)).visible(() -> this.mode.get() == Mode.Velocity)).build());
        this.antiKickMode = this.sgAntiKick.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("The mode for anti kick.")).defaultValue(AntiKickMode.Packet)).build());
        this.delay = this.sgAntiKick.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("The amount of delay, in ticks, between flying down a bit and return to original position")).defaultValue(20)).min(1).sliderMax(200).build());
        this.offTime = this.sgAntiKick.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("off-time")).description("The amount of delay, in milliseconds, to fly down a bit to reset floating ticks.")).defaultValue(1)).min(1).sliderRange(1, 20).build());
        this.delayLeft = this.delay.get();
        this.offLeft = this.offTime.get();
        this.lastPacketY = Double.MAX_VALUE;
    }

    @Override
    public void onActivate() {
        if (this.mode.get() == Mode.Abilities && !this.mc.field_1724.method_7325()) {
            this.mc.field_1724.method_31549().field_7479 = true;
            if (this.mc.field_1724.method_31549().field_7477) {
                return;
            }
            this.mc.field_1724.method_31549().field_7478 = true;
        }
    }

    @Override
    public void onDeactivate() {
        if (this.mode.get() == Mode.Abilities && !this.mc.field_1724.method_7325()) {
            this.abilitiesOff();
        }
    }

    @EventHandler
    private void onPreTick(TickEvent.Pre event) {
        float currentYaw = this.mc.field_1724.method_36454();
        if (this.mc.field_1724.field_6017 >= 3.0f && currentYaw == this.lastYaw && this.mc.field_1724.method_18798().method_1033() < 0.003) {
            this.mc.field_1724.method_36456(currentYaw + (float)(this.flip ? 1 : -1));
            this.flip = !this.flip;
        }
        this.lastYaw = currentYaw;
    }

    @EventHandler
    private void onPostTick(TickEvent.Post event) {
        if (this.delayLeft > 0) {
            --this.delayLeft;
        }
        if (this.offLeft <= 0 && this.delayLeft <= 0) {
            this.delayLeft = this.delay.get();
            this.offLeft = this.offTime.get();
            if (this.antiKickMode.get() == AntiKickMode.Packet) {
                ((ClientPlayerEntityAccessor)this.mc.field_1724).setTicksSinceLastPositionPacketSent(20);
            }
        } else if (this.delayLeft <= 0) {
            boolean shouldReturn = false;
            if (this.antiKickMode.get() == AntiKickMode.Normal) {
                if (this.mode.get() == Mode.Abilities) {
                    this.abilitiesOff();
                    shouldReturn = true;
                }
            } else if (this.antiKickMode.get() == AntiKickMode.Packet && this.offLeft == this.offTime.get()) {
                ((ClientPlayerEntityAccessor)this.mc.field_1724).setTicksSinceLastPositionPacketSent(20);
            }
            --this.offLeft;
            if (shouldReturn) {
                return;
            }
        }
        if (this.mc.field_1724.method_36454() != this.lastYaw) {
            this.mc.field_1724.method_36456(this.lastYaw);
        }
        switch (this.mode.get().ordinal()) {
            case 1: {
                this.mc.field_1724.method_31549().field_7479 = false;
                this.mc.field_1724.method_18800(0.0, 0.0, 0.0);
                class_243 playerVelocity = this.mc.field_1724.method_18798();
                if (this.mc.field_1690.field_1903.method_1434()) {
                    playerVelocity = playerVelocity.method_1031(0.0, this.speed.get() * (double)(this.verticalSpeedMatch.get() != false ? 10.0f : 5.0f), 0.0);
                }
                if (this.mc.field_1690.field_1832.method_1434()) {
                    playerVelocity = playerVelocity.method_1023(0.0, this.speed.get() * (double)(this.verticalSpeedMatch.get() != false ? 10.0f : 5.0f), 0.0);
                }
                this.mc.field_1724.method_18799(playerVelocity);
                if (!this.noSneak.get().booleanValue()) break;
                this.mc.field_1724.method_24830(false);
                break;
            }
            case 0: {
                if (this.mc.field_1724.method_7325()) {
                    return;
                }
                this.mc.field_1724.method_31549().method_7248(this.speed.get().floatValue());
                this.mc.field_1724.method_31549().field_7479 = true;
                if (this.mc.field_1724.method_31549().field_7477) {
                    return;
                }
                this.mc.field_1724.method_31549().field_7478 = true;
            }
        }
    }

    private void antiKickPacket(class_2828 packet, double currentY) {
        if (this.delayLeft <= 0 && this.lastPacketY != Double.MAX_VALUE && this.shouldFlyDown(currentY, this.lastPacketY) && this.isEntityOnAir((class_1297)this.mc.field_1724)) {
            ((PlayerMoveC2SPacketAccessor)packet).setY(this.lastPacketY - 0.0313);
        } else {
            this.lastPacketY = currentY;
        }
    }

    @EventHandler
    private void onSendPacket(PacketEvent.Send event) {
        class_2828 packet;
        block6: {
            block5: {
                class_2596<?> class_25962 = event.packet;
                if (!(class_25962 instanceof class_2828)) break block5;
                packet = (class_2828)class_25962;
                if (this.antiKickMode.get() == AntiKickMode.Packet) break block6;
            }
            return;
        }
        double currentY = packet.method_12268(Double.MAX_VALUE);
        if (currentY != Double.MAX_VALUE) {
            this.antiKickPacket(packet, currentY);
        } else {
            Object fullPacket = packet.method_36172() ? new class_2828.class_2830(this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321(), packet.method_12271(0.0f), packet.method_12270(0.0f), packet.method_12273(), this.mc.field_1724.field_5976) : new class_2828.class_2829(this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321(), packet.method_12273(), this.mc.field_1724.field_5976);
            event.cancel();
            this.antiKickPacket((class_2828)fullPacket, this.mc.field_1724.method_23318());
            this.mc.method_1562().method_52787((class_2596)fullPacket);
        }
    }

    @EventHandler
    private void onReceivePacket(PacketEvent.Receive event) {
        class_2696 packet;
        block3: {
            block2: {
                class_2596<?> class_25962 = event.packet;
                if (!(class_25962 instanceof class_2696)) break block2;
                packet = (class_2696)class_25962;
                if (this.mode.get() == Mode.Abilities) break block3;
            }
            return;
        }
        event.cancel();
        this.mc.field_1724.method_31549().field_7480 = packet.method_11695();
        this.mc.field_1724.method_31549().field_7477 = packet.method_11696();
        this.mc.field_1724.method_31549().method_7250(packet.method_11691());
    }

    private boolean shouldFlyDown(double currentY, double lastY) {
        if (currentY >= lastY) {
            return true;
        }
        return lastY - currentY < 0.0313;
    }

    private void abilitiesOff() {
        this.mc.field_1724.method_31549().field_7479 = false;
        this.mc.field_1724.method_31549().method_7248(0.05f);
        if (this.mc.field_1724.method_31549().field_7477) {
            return;
        }
        this.mc.field_1724.method_31549().field_7478 = false;
    }

    private boolean isEntityOnAir(class_1297 entity) {
        return entity.method_37908().method_29546(entity.method_5829().method_1014(0.0625).method_1012(0.0, -0.55, 0.0)).allMatch(class_4970.class_4971::method_26215);
    }

    public float getOffGroundSpeed() {
        if (!this.isActive() || this.mode.get() != Mode.Velocity) {
            return -1.0f;
        }
        return this.speed.get().floatValue() * (this.mc.field_1724.method_5624() ? 15.0f : 10.0f);
    }

    public boolean noSneak() {
        return this.isActive() && this.mode.get() == Mode.Velocity && this.noSneak.get() != false;
    }

    public static enum Mode {
        Abilities,
        Velocity;

    }

    public static enum AntiKickMode {
        Normal,
        Packet,
        None;

    }
}

