/*
 * Decompiled with CFR 0.152.
 */
package org.vined.ikea.modules.misc;

import java.awt.Color;
import java.io.IOException;
import meteordevelopment.meteorclient.events.entity.EntityAddedEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_418;
import org.vined.ikea.IKEA;
import org.vined.ikea.utils.ChunkUtils;
import org.vined.ikea.utils.DiscordWebhook;
import org.vined.ikea.utils.LogUtils;

public class DiscordNotifier
extends Module {
    private final String name = "IKEA Addon";
    private final String avatar = "https://cdn.discordapp.com/attachments/1062488528862314607/1143279084940566648/ikea.png";
    private DiscordWebhook hook;
    public SettingGroup sgGeneral = this.settings.getDefaultGroup();
    public SettingGroup sgNotifs = this.settings.createGroup("Notifications");
    private final Setting<String> link = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-URL")).description("Discord Webhook URL to send messages to")).defaultValue((Object)"")).build());
    private final Setting<PingModes> pingMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("ping-mode")).description("How the notifier should ping")).defaultValue((Object)PingModes.NoPing)).build());
    private final Setting<String> userId = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-ID")).description("ID of the user to ping")).defaultValue((Object)"")).visible(() -> this.pingMode.get() == PingModes.User)).build());
    private final Setting<Boolean> stashNotifier = this.sgNotifs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("stash-notifier")).defaultValue((Object)true)).build());
    private final Setting<Integer> chestLimit = this.sgNotifs.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("chest-limit")).description("How many chests until you get notified")).sliderRange(0, 100).defaultValue((Object)50)).visible(() -> this.stashNotifier.get())).build());
    private final Setting<Integer> shulkerLimit = this.sgNotifs.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("shulker-limit")).description("How many shulkers until you get notified")).sliderRange(0, 100).defaultValue((Object)50)).visible(() -> this.stashNotifier.get())).build());
    private final Setting<Boolean> deathNotifier = this.sgNotifs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("death-notifier")).description("Get notified on death")).defaultValue((Object)true)).build());
    private final Setting<Boolean> visualRange = this.sgNotifs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Visual Range")).description("Notifies of a player entering visual range")).defaultValue((Object)true)).build());

    public DiscordNotifier() {
        super(IKEA.MISC, "discord-notifier", "Sends notifications to a Discord webhook on certain events.");
    }

    public void onActivate() {
        String url = (String)this.link.get();
        if (!url.isEmpty()) {
            this.hook = new DiscordWebhook(url);
        } else {
            LogUtils.info("Invalid webhook URL in DiscordNotifier");
            this.toggle();
        }
    }

    @EventHandler
    private void onChunkData(ChunkDataEvent event) throws IOException {
        assert (this.mc.field_1724 != null);
        if (this.hook == null) {
            return;
        }
        if (((Boolean)this.stashNotifier.get()).booleanValue()) {
            class_2338 pos = event.chunk().method_12004().method_8323();
            String posStr = "X: " + pos.method_10263() + " Z: " + pos.method_10260();
            int chestCount = ChunkUtils.getChestCount(event.chunk());
            int shulkerCount = ChunkUtils.getShulkerCount((class_2791)event.chunk());
            if (chestCount > (Integer)this.chestLimit.get() || shulkerCount > (Integer)this.shulkerLimit.get()) {
                this.readyHook(this.hook);
                this.hook.addEmbed(new DiscordWebhook.EmbedObject().setTitle("Unusual chest or shulker amount! (" + String.valueOf(this.mc.field_1724.method_5477()) + ")").setColor(Color.YELLOW).addField("Coordinates:", posStr, false).addField("Chest Amount:", String.valueOf(chestCount), false).addField("Shulker Amount:", String.valueOf(shulkerCount), false).setThumbnail("https://cdn.discordapp.com/attachments/1062488528862314607/1143279084940566648/ikea.png"));
                this.hook.execute();
                this.hook.clearEmbeds();
            }
        }
    }

    @EventHandler
    private void onEntityAdded(EntityAddedEvent event) throws IOException {
        assert (this.mc.field_1724 != null);
        if (this.hook == null) {
            return;
        }
        if (event.entity instanceof class_1657 && ((Boolean)this.visualRange.get()).booleanValue()) {
            int PlayerX = (int)event.entity.method_23317();
            int PlayerZ = (int)event.entity.method_23321();
            this.readyHook(this.hook);
            this.hook.addEmbed(new DiscordWebhook.EmbedObject().setTitle("Player has entered visual range!").setColor(Color.RED).addField("Player:", event.entity.method_5477().getString(), false).setThumbnail("https://cdn.discordapp.com/attachments/1062488528862314607/1143279084940566648/ikea.png"));
            this.hook.execute();
            this.hook.clearEmbeds();
        }
    }

    @EventHandler(priority=200)
    private void onOpenScreen(OpenScreenEvent event) throws IOException {
        assert (this.mc.field_1724 != null);
        if (this.hook == null) {
            return;
        }
        if (event.screen instanceof class_418 && ((Boolean)this.deathNotifier.get()).booleanValue()) {
            class_2338 pos = this.mc.field_1724.method_24515();
            String posStr = "X: " + pos.method_10263() + " Y: " + pos.method_10264() + " Z: " + pos.method_10260();
            this.readyHook(this.hook);
            this.hook.addEmbed(new DiscordWebhook.EmbedObject().setTitle("You have died! (" + String.valueOf(this.mc.field_1724.method_5477()) + ")").setColor(Color.YELLOW).addField("Coordinates:", posStr, false).addField("Dimension:", PlayerUtils.getDimension().toString(), false).setThumbnail("https://cdn.discordapp.com/attachments/1062488528862314607/1143279084940566648/ikea.png"));
            this.hook.execute();
            this.hook.clearEmbeds();
        }
    }

    private void readyHook(DiscordWebhook hook) {
        assert (this.mc.field_1724 != null);
        if (hook == null) {
            return;
        }
        Object mention = "";
        switch (((PingModes)((Object)this.pingMode.get())).ordinal()) {
            case 1: {
                mention = "@everyone";
                break;
            }
            case 0: {
                mention = "<@" + (String)this.userId.get() + ">";
                break;
            }
            case 2: {
                mention = "";
            }
        }
        hook.setContent((String)mention);
        hook.setAvatarUrl("https://cdn.discordapp.com/attachments/1062488528862314607/1143279084940566648/ikea.png");
        hook.setUsername("IKEA Addon");
    }

    public static enum PingModes {
        User,
        Everyone,
        NoPing;

    }
}

