/*
 * Decompiled with CFR 0.152.
 */
package org.vined.ikea.modules.utility;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.render.RenderBlockEntityEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import org.vined.ikea.IKEA;
import org.vined.ikea.utils.ChunkUtils;
import org.vined.ikea.utils.LogUtils;
import org.vined.ikea.utils.TimerUtils;

public class DubCounter
extends Module {
    public List<class_2338> coords = new ArrayList<class_2338>();
    public TimerUtils timer = new TimerUtils();
    public SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final Setting<CountMode> countMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("count-mode")).description("The way the chests are counted.")).defaultValue((Object)CountMode.Loaded)).build());
    private final Setting<Integer> loadTime = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("loading-time")).description("How much time it's going to take to load all the dubs.")).defaultValue((Object)1)).min(1).sliderMax(60).visible(() -> this.countMode.get() == CountMode.Rendered)).build());

    public DubCounter() {
        super(IKEA.UTILITY, "dub-counter", "Counts how many double chests are in render distance.");
    }

    public void onActivate() {
        this.timer.reset();
        if (this.countMode.get() == CountMode.Rendered) {
            LogUtils.info(String.valueOf(class_124.field_1080) + "Please wait " + String.valueOf(class_124.field_1068) + String.valueOf(this.loadTime.get()) + String.valueOf(class_124.field_1080) + " second(s)...");
        } else {
            int length = ChunkUtils.getChestCount();
            int dubs = length % 2 == 0 ? length / 2 : (length - 1) / 2;
            LogUtils.info(String.valueOf(class_124.field_1080) + "There are roughly " + String.valueOf(class_124.field_1068) + dubs + String.valueOf(class_124.field_1080) + " (" + length + " normal chests)" + String.valueOf(class_124.field_1080) + " loaded double chests.");
            this.toggle();
        }
    }

    public void onDeactivate() {
        this.coords.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.countMode.get() == CountMode.Rendered && this.timer.hasReached((long)((Integer)this.loadTime.get()).intValue() * 1000L)) {
            int length = this.coords.size();
            int dubs = length % 2 == 0 ? length / 2 : (length - 1) / 2;
            LogUtils.info(String.valueOf(class_124.field_1080) + "There are roughly " + String.valueOf(class_124.field_1068) + dubs + String.valueOf(class_124.field_1080) + " (" + length + " normal chests)" + String.valueOf(class_124.field_1080) + " rendered double chests.");
            this.toggle();
            this.timer.reset();
        }
    }

    @EventHandler
    private void onRenderBlockEntity(RenderBlockEntityEvent event) {
        class_2586 block;
        if (this.countMode.get() == CountMode.Rendered && (block = event.blockEntity) instanceof class_2595) {
            class_2595 chest = (class_2595)block;
            if (this.coords.contains(chest.method_11016())) {
                return;
            }
            this.coords.add(chest.method_11016());
        }
    }

    public static enum CountMode {
        Rendered,
        Loaded;

    }
}

