/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.commands.Command;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3965;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class TextCommand
extends Command {
    private static final double LINE_SPACING = 0.3;
    private static final double INITIAL_HEIGHT_OFFSET = 1.0;
    private static final String PRESETS_DIRECTORY = "TrouserStreak/TextPresets";

    public TextCommand() {
        super("text", "Spawns a text hologram with custom text in front of you. Use | for new lines and #color for text color.", new String[0]);
        this.createDefaultPresets();
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(TextCommand.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            this.spawnTextLines((String)context.getArgument("message", String.class));
            return 1;
        }))).then(TextCommand.literal((String)"save").then(TextCommand.argument((String)"presetName", (ArgumentType)StringArgumentType.word()).then(TextCommand.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String presetName = (String)context.getArgument("presetName", String.class);
            String text = (String)context.getArgument("text", String.class);
            this.savePreset(presetName, text);
            this.info("Saved preset: " + presetName, new Object[0]);
            return 1;
        }))))).then(TextCommand.literal((String)"load").then(TextCommand.argument((String)"presetName", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> this.suggestPresets(suggestionsBuilder)).executes(context -> {
            String presetName = (String)context.getArgument("presetName", String.class);
            String text = this.loadPreset(presetName);
            if (text != null) {
                this.spawnTextLines(text);
                this.info("Loaded preset: " + presetName, new Object[0]);
            } else {
                this.error("Preset not found: " + presetName, new Object[0]);
            }
            return 1;
        })))).then(TextCommand.literal((String)"regeneratedefaults").executes(context -> {
            this.regenDefaultPresets();
            this.info("Default presets regenerated.", new Object[0]);
            return 1;
        }))).then(TextCommand.literal((String)"delete").then(TextCommand.argument((String)"presetName", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> this.suggestPresets(suggestionsBuilder)).executes(context -> {
            String presetName = (String)context.getArgument("presetName", String.class);
            this.deletePreset(presetName);
            return 1;
        })));
    }

    private CompletableFuture<Suggestions> suggestPresets(SuggestionsBuilder builder) {
        block8: {
            try {
                Path presetsDir = Paths.get(PRESETS_DIRECTORY, new String[0]);
                if (!Files.exists(presetsDir, new LinkOption[0])) break block8;
                try (Stream<Path> files = Files.list(presetsDir);){
                    files.filter(path -> path.toString().endsWith(".txt")).map(path -> path.getFileName().toString().replace(".txt", "")).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder.buildFuture();
    }

    private void spawnTextLines(String text) {
        String[] lines = text.split("\\|");
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i].trim();
            String formattedText = this.formatTextWithColors(line);
            double heightOffset = (double)(lines.length - 1 - i) * 0.3 + 1.0;
            this.spawnText(formattedText, heightOffset, true);
        }
    }

    private String formatTextWithColors(String line) {
        String[] words;
        StringBuilder formattedText = new StringBuilder();
        String currentColor = "white";
        boolean isObfuscated = false;
        for (String word : words = line.split(" ")) {
            if (word.startsWith("#")) {
                if (word.equalsIgnoreCase("#obfuscated")) {
                    isObfuscated = true;
                    continue;
                }
                try {
                    currentColor = word.substring(1).toLowerCase();
                }
                catch (IllegalArgumentException ignored) {
                    formattedText.append(word).append(" ");
                }
                continue;
            }
            formattedText.append("{\"text\":\"").append(word).append(" \",\"color\":\"").append(currentColor).append("\"");
            if (isObfuscated) {
                formattedText.append(",\"obfuscated\":true");
            }
            formattedText.append("},");
            isObfuscated = false;
        }
        return "[" + formattedText.substring(0, formattedText.length() - 1) + "]";
    }

    private void savePreset(String presetName, String text) {
        try {
            Path dirPath = Paths.get(PRESETS_DIRECTORY, new String[0]);
            Files.createDirectories(dirPath, new FileAttribute[0]);
            Path filePath = dirPath.resolve(presetName + ".txt");
            Files.write(filePath, text.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            this.error("Failed to save preset: " + e.getMessage(), new Object[0]);
        }
    }

    private String loadPreset(String presetName) {
        try {
            Path filePath = Paths.get(PRESETS_DIRECTORY, presetName + ".txt");
            if (Files.exists(filePath, new LinkOption[0])) {
                return Files.readString(filePath);
            }
        }
        catch (IOException e) {
            this.error("Failed to load preset: " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    private void deletePreset(String presetName) {
        Path filePath = Paths.get(PRESETS_DIRECTORY, presetName + ".txt");
        try {
            if (Files.exists(filePath, new LinkOption[0])) {
                Files.delete(filePath);
                this.info("Deleted preset: " + presetName, new Object[0]);
            } else {
                this.error("Preset not found: " + presetName, new Object[0]);
            }
        }
        catch (IOException e) {
            this.error("Failed to delete preset: " + e.getMessage(), new Object[0]);
        }
    }

    private void createDefaultPresets() {
        String[] defaultPresets;
        for (String preset : defaultPresets = new String[]{"trolled=#green [ #dark_red Trolled! #green ]|#gold Mountains of Lava Inc.|#red Youtube: #blue www.youtube.com/@mountainsoflavainc.6913|#green [ #dark_red Trolled! #green ]", "mountains=#red Mountains Of Lava Inc.|#gold youtube.com/@mountainsoflavainc.6913", "genesis=#gold THE BOOK OF GENESIS|#gold Chapter 1|#green [1:1] In the beginning when God created the heavens and the earth,|#green [1:2] the earth was a formless void and darkness covered the face of the deep, while a wind from God swept over the face of the waters.|#green [1:3] Then God said, 'Let there be light'; and there was light.|#green [1:4] And God saw that the light was good; and God separated the light from the darkness.|#green [1:5] God called the light Day, and the darkness he called Night. And there was evening and there was morning, the first day.|#green [1:6] And God said, 'Let there be a dome in the midst of the waters, and let it separate the waters from the waters.'|#green [1:7] So God made the dome and separated the waters that were under the dome from the waters that were above the dome. And it was so.|#green [1:8] God called the dome Sky. And there was evening and there was morning, the second day.|#green [1:9] And God said, 'Let the waters under the sky be gathered together into one place, and let the dry land appear.' And it was so.|#green [1:10] God called the dry land Earth, and the waters that were gathered together he called Seas. And God saw that it was good.|#gold Chapter 2|#green [2:1] Thus the heavens and the earth were finished, and all their multitude.|#green [2:2] And on the seventh day God finished the work that he had done, and he rested on the seventh day from all the work that he had done."}) {
            String[] parts = preset.split("=", 2);
            if (Files.exists(Paths.get(PRESETS_DIRECTORY, parts[0] + ".txt"), new LinkOption[0])) continue;
            this.savePreset(parts[0], parts[1]);
        }
    }

    private void regenDefaultPresets() {
        String[] defaultPresetNames = new String[]{"trolled", "mountains", "genesis"};
        try {
            String[] defaultPresets;
            Path dirPath = Paths.get(PRESETS_DIRECTORY, new String[0]);
            if (Files.exists(dirPath, new LinkOption[0])) {
                try (Stream<Path> files = Files.list(dirPath);){
                    files.filter(path -> {
                        String fileName = path.getFileName().toString();
                        return Arrays.stream(defaultPresetNames).anyMatch(name -> fileName.equals(name + ".txt"));
                    }).forEach(path -> {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException e) {
                            this.error("Failed to delete preset: " + String.valueOf(path) + " - " + e.getMessage(), new Object[0]);
                        }
                    });
                }
                catch (IOException e) {
                    this.error("Failed to list directory: " + e.getMessage(), new Object[0]);
                }
            }
            Files.createDirectories(dirPath, new FileAttribute[0]);
            for (String preset : defaultPresets = new String[]{"trolled=#green [ #dark_red Trolled! #green ]|#gold Mountains of Lava Inc.|#red Youtube: #blue www.youtube.com/@mountainsoflavainc.6913|#green [ #dark_red Trolled! #green ]", "mountains=#red Mountains Of Lava Inc.|#gold youtube.com/@mountainsoflavainc.6913", "genesis=#gold THE BOOK OF GENESIS|#gold Chapter 1|#green [1:1] In the beginning when God created the heavens and the earth,|#green [1:2] the earth was a formless void and darkness covered the face of the deep, while a wind from God swept over the face of the waters.|#green [1:3] Then God said, 'Let there be light'; and there was light.|#green [1:4] And God saw that the light was good; and God separated the light from the darkness.|#green [1:5] God called the light Day, and the darkness he called Night. And there was evening and there was morning, the first day.|#green [1:6] And God said, 'Let there be a dome in the midst of the waters, and let it separate the waters from the waters.'|#green [1:7] So God made the dome and separated the waters that were under the dome from the waters that were above the dome. And it was so.|#green [1:8] God called the dome Sky. And there was evening and there was morning, the second day.|#green [1:9] And God said, 'Let the waters under the sky be gathered together into one place, and let the dry land appear.' And it was so.|#green [1:10] God called the dry land Earth, and the waters that were gathered together he called Seas. And God saw that it was good.|#gold Chapter 2|#green [2:1] Thus the heavens and the earth were finished, and all their multitude.|#green [2:2] And on the seventh day God finished the work that he had done, and he rested on the seventh day from all the work that he had done."}) {
                String[] parts = preset.split("=", 2);
                this.savePreset(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            this.error("Failed to regenerate presets: " + e.getMessage(), new Object[0]);
        }
    }

    private void spawnText(String message, double yOffset, boolean isJson) {
        if (!TextCommand.mc.field_1724.method_31549().field_7477) {
            this.error("Creative mode required!", new Object[0]);
            return;
        }
        class_1799 armorStand = new class_1799((class_1935)class_1802.field_8694);
        class_1799 current = TextCommand.mc.field_1724.method_6047();
        class_243 pos = TextCommand.mc.field_1724.method_19538().method_1019(TextCommand.mc.field_1724.method_5720().method_1021(2.0)).method_1031(0.0, yOffset, 0.0);
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_49609, (Object)this.createEntityData(pos, message, isJson)).method_57852();
        armorStand.method_59692(changes);
        class_3965 bhr = new class_3965(pos, class_2350.field_11036, class_2338.method_49638((class_2374)pos), false);
        TextCommand.mc.field_1761.method_2909(armorStand, 36 + TextCommand.mc.field_1724.method_31548().field_7545);
        TextCommand.mc.field_1761.method_2896(TextCommand.mc.field_1724, class_1268.field_5808, bhr);
        TextCommand.mc.field_1761.method_2909(current, 36 + TextCommand.mc.field_1724.method_31548().field_7545);
    }

    private class_9279 createEntityData(class_243 pos, String text, boolean isJson) {
        class_2487 entityTag = new class_2487();
        class_2499 position = new class_2499();
        position.add((Object)class_2489.method_23241((double)pos.field_1352));
        position.add((Object)class_2489.method_23241((double)pos.field_1351));
        position.add((Object)class_2489.method_23241((double)pos.field_1350));
        entityTag.method_10582("id", "minecraft:armor_stand");
        entityTag.method_10566("Pos", (class_2520)position);
        entityTag.method_10556("Invisible", true);
        entityTag.method_10556("Marker", true);
        entityTag.method_10556("NoGravity", true);
        entityTag.method_10556("CustomNameVisible", true);
        entityTag.method_10582("CustomName", (String)(isJson ? text : "{\"text\":\"" + text + "\"}"));
        return class_9279.method_57456((class_2487)entityTag);
    }
}

