/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.hud;

import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_9334;

public class ElytraCount
extends HudElement {
    public static final HudElementInfo<ElytraCount> INFO = new HudElementInfo(Hud.GROUP, "elytra-count", "Displays a count of elytra's in inventory with configurable minimum durability.", ElytraCount::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgBackground;
    public final Setting<Integer> minDurability;
    private final Setting<Mode> mode;
    private final Setting<Double> scale;
    private final Setting<Integer> border;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;

    public ElytraCount() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgBackground = this.settings.createGroup("Background");
        this.minDurability = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-durability")).description("Durability threshold to count elytras.")).defaultValue((Object)300)).range(1, (Integer)class_1802.field_8833.method_57347().method_57829(class_9334.field_50072) - 1).sliderRange(1, (Integer)class_1802.field_8833.method_57347().method_57829(class_9334.field_50072) - 1).build());
        this.mode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("none-mode")).description("How to render the item when you don't have the specified item in your inventory.")).defaultValue((Object)Mode.HideCount)).build());
        this.scale = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Scale of the item.")).defaultValue(2.0).onChanged(aDouble -> this.calculateSize())).min(1.0).sliderRange(1.0, 4.0).build());
        this.border = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("border")).description("How much space to add around the element.")).defaultValue((Object)0)).onChanged(integer -> this.calculateSize())).build());
        this.background = this.sgBackground.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue((Object)false)).build());
        this.backgroundColor = this.sgBackground.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(() -> this.background.get())).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.calculateSize();
    }

    public void setSize(double width, double height) {
        super.setSize(width + (double)((Integer)this.border.get() * 2), height + (double)((Integer)this.border.get() * 2));
    }

    private void calculateSize() {
        this.setSize(17.0 * (Double)this.scale.get(), 17.0 * (Double)this.scale.get());
    }

    public void render(HudRenderer renderer) {
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8833, InvUtils.find(stack -> stack.method_7909() == class_1802.field_8833 && stack.method_7936() - stack.method_7919() > (Integer)this.minDurability.get()).count());
        if (this.mode.get() == Mode.HideItem && itemStack.method_7960()) {
            if (this.isInEditor()) {
                renderer.line((double)this.x, (double)this.y, (double)(this.x + this.getWidth()), (double)(this.y + this.getHeight()), Color.GRAY);
                renderer.line((double)this.x, (double)(this.y + this.getHeight()), (double)(this.x + this.getWidth()), (double)this.y, Color.GRAY);
            }
        } else {
            renderer.post(() -> {
                double x = this.x + (Integer)this.border.get();
                double y = this.y + (Integer)this.border.get();
                this.render(renderer, itemStack, (int)x, (int)y);
            });
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            renderer.quad((double)this.x, (double)this.y, (double)this.getWidth(), (double)this.getHeight(), (Color)this.backgroundColor.get());
        }
    }

    private void render(HudRenderer renderer, class_1799 itemStack, int x, int y) {
        if (this.mode.get() == Mode.HideItem) {
            renderer.item(itemStack, x, y, ((Double)this.scale.get()).floatValue(), true);
            return;
        }
        String countOverride = null;
        boolean resetToZero = false;
        if (itemStack.method_7960()) {
            if (this.mode.get() == Mode.ShowCount) {
                countOverride = "0";
            }
            itemStack.method_7939(1);
            resetToZero = true;
        }
        renderer.item(itemStack, x, y, ((Double)this.scale.get()).floatValue(), true, countOverride);
        if (resetToZero) {
            itemStack.method_7939(0);
        }
    }

    public static enum Mode {
        HideItem,
        HideCount,
        ShowCount;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Hide Item";
                case 1 -> "Hide Count";
                case 2 -> "Show Count";
            };
        }
    }
}

