/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnchantmentListSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1820;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_9362;
import pwn.noobs.trouserstreak.Trouser;

public class AdvancedItemESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgColors;
    private final List<class_1792> defaultPlayerItems;
    public final Setting<ShapeMode> shapeMode;
    public final Setting<Double> fillOpacity;
    private final Setting<Double> fadeDistance;
    private final Setting<List<class_1792>> items;
    public final Setting<Boolean> enchants;
    public final Setting<Boolean> certainenchants;
    private final Setting<Set<class_5321<class_1887>>> toolenchants;
    private final Setting<Set<class_5321<class_1887>>> swordenchants;
    private final Setting<Set<class_5321<class_1887>>> armorenchants;
    private final Setting<Set<class_5321<class_1887>>> maceenchants;
    private final Setting<Set<class_5321<class_1887>>> tridentenchants;
    private final Setting<Boolean> chatFeedback;
    private final Setting<Boolean> coordsInChat;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> monstersColor;
    public final Setting<Boolean> distance;
    private final Setting<SettingColor> distantColor;
    public final Setting<Integer> distanceInt;
    private final Color lineColor;
    private final Color sideColor;
    private final Color baseColor;
    private int count;
    private final Set<class_1297> scannedEntities;

    public AdvancedItemESP() {
        super(Trouser.baseHunting, "AdvancedItemESP", "ESP Module that highlights only certain items.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgColors = this.settings.createGroup("Colors");
        this.defaultPlayerItems = new ArrayList<class_1792>(List.of(class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030, class_1802.field_8833, class_1802.field_49814, class_1802.field_8547, class_1802.field_8802, class_1802.field_8556, class_1802.field_8377, class_1802.field_8250, class_1802.field_8527, class_1802.field_22022, class_1802.field_22025, class_1802.field_22024, class_1802.field_22023, class_1802.field_22026, class_1802.field_8367, class_1802.field_8301, class_1802.field_8466, class_1802.field_8288, class_1802.field_8287, class_1802.field_8545, class_1802.field_8676, class_1802.field_8380, class_1802.field_8271, class_1802.field_8548, class_1802.field_8461, class_1802.field_8213, class_1802.field_8829, class_1802.field_8350, class_1802.field_8816, class_1802.field_8050, class_1802.field_8520, class_1802.field_8722, class_1802.field_8451, class_1802.field_8627, class_1802.field_8584, class_1802.field_8268));
        this.shapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.fillOpacity = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("fill-opacity")).description("The opacity of the shape fill.")).defaultValue(0.3).range(0.0, 1.0).sliderMax(1.0).build());
        this.fadeDistance = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("fade-distance")).description("The distance from an entity where the color begins to fade.")).defaultValue(3.0).min(0.0).sliderMax(12.0).build());
        this.items = this.sgGeneral.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("item-checker")).description("Items to check for.")).defaultValue(this.defaultPlayerItems)).build());
        this.enchants = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enforce-item-enchants")).description("Requires that armor and tools must be enchanted for module to detect.")).defaultValue((Object)true)).build());
        this.certainenchants = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("find-certain-item-enchants")).description("Requires that armor and tools must be enchanted with these enchants.")).defaultValue((Object)false)).visible(() -> (Boolean)this.enchants.get())).build());
        this.toolenchants = this.sgGeneral.add((Setting)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)new EnchantmentListSetting.Builder().name("Mining Tool Enchants")).description("List of enchantments required.")).visible(() -> (Boolean)this.enchants.get() != false && (Boolean)this.certainenchants.get() != false)).defaultValue(new class_5321[]{class_1893.field_9131, class_1893.field_9119, class_1893.field_9101}).build());
        this.swordenchants = this.sgGeneral.add((Setting)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)new EnchantmentListSetting.Builder().name("Sword Enchants")).description("List of enchantments required.")).visible(() -> (Boolean)this.enchants.get() != false && (Boolean)this.certainenchants.get() != false)).defaultValue(new class_5321[]{class_1893.field_9119, class_1893.field_9101}).build());
        this.armorenchants = this.sgGeneral.add((Setting)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)new EnchantmentListSetting.Builder().name("Armor Enchants")).description("List of enchantments required.")).visible(() -> (Boolean)this.enchants.get() != false && (Boolean)this.certainenchants.get() != false)).defaultValue(new class_5321[]{class_1893.field_9119, class_1893.field_9101}).build());
        this.maceenchants = this.sgGeneral.add((Setting)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)new EnchantmentListSetting.Builder().name("Mace Enchants")).description("List of enchantments required.")).visible(() -> (Boolean)this.enchants.get() != false && (Boolean)this.certainenchants.get() != false)).defaultValue(new class_5321[]{class_1893.field_9119, class_1893.field_9101}).build());
        this.tridentenchants = this.sgGeneral.add((Setting)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)((EnchantmentListSetting.Builder)new EnchantmentListSetting.Builder().name("Trident Enchants")).description("List of enchantments required.")).visible(() -> (Boolean)this.enchants.get() != false && (Boolean)this.certainenchants.get() != false)).defaultValue(new class_5321[]{class_1893.field_9119, class_1893.field_9101}).build());
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chat feedback")).description("Display info about items in chat")).defaultValue((Object)true)).build());
        this.coordsInChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Display coords in chat")).description("Display coords of a detected item")).visible(() -> this.chatFeedback.get())).defaultValue((Object)true)).build());
        this.tracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracers")).description("Add tracers to item detected")).defaultValue((Object)true)).build());
        this.monstersColor = this.sgColors.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("items-color")).description("The item's bounding box and tracer color.")).defaultValue(new SettingColor(255, 25, 255, 255)).build());
        this.distance = this.sgColors.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("distance-colors")).description("Changes the color of tracers depending on distance.")).defaultValue((Object)true)).build());
        this.distantColor = this.sgColors.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("distant-color")).description("The item's bounding box and tracer color when you are far away.")).defaultValue(new SettingColor(25, 255, 255, 255)).visible(() -> this.distance.get())).build());
        this.distanceInt = this.sgColors.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("distance-colors-threshold")).description("The max distance for colors to change.")).defaultValue((Object)128)).min(1).sliderRange(1, 1024).visible(() -> this.distance.get())).build());
        this.lineColor = new Color();
        this.sideColor = new Color();
        this.baseColor = new Color();
        this.scannedEntities = Collections.synchronizedSet(new HashSet());
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        this.count = 0;
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            class_1542 itemEntity;
            if (!(entity instanceof class_1542) || this.shouldSkip(itemEntity = (class_1542)entity)) continue;
            if (!this.scannedEntities.contains(entity)) {
                StringBuilder message = new StringBuilder(itemEntity.method_6983().method_7909().method_63680().getString() + " found ");
                if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                    if (((Boolean)this.coordsInChat.get()).booleanValue()) {
                        message.append(" at ").append(entity.method_31477()).append(", ").append(entity.method_31478()).append(", ").append(entity.method_31479());
                    }
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)message.toString()));
                }
            }
            this.scannedEntities.add(entity);
            this.drawBoundingBox(event, entity);
            if (((Boolean)this.tracers.get()).booleanValue()) {
                this.drawTracer(event, entity);
            }
            ++this.count;
        }
    }

    public void onActivate() {
        this.scannedEntities.clear();
    }

    public void onDeactivate() {
        this.scannedEntities.clear();
    }

    private void drawBoundingBox(Render3DEvent event, class_1297 entity) {
        Color color = this.getColor(entity);
        if (color != null) {
            this.lineColor.set(color);
            this.sideColor.set(color).a((int)((double)this.sideColor.a * (Double)this.fillOpacity.get()));
        }
        double x = class_3532.method_16436((double)event.tickDelta, (double)entity.field_6038, (double)entity.method_23317()) - entity.method_23317();
        double y = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5971, (double)entity.method_23318()) - entity.method_23318();
        double z = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5989, (double)entity.method_23321()) - entity.method_23321();
        class_238 box = entity.method_5829();
        event.renderer.box(x + box.field_1323, y + box.field_1322, z + box.field_1321, x + box.field_1320, y + box.field_1325, z + box.field_1324, this.sideColor, this.lineColor, (ShapeMode)this.shapeMode.get(), 0);
    }

    private void drawTracer(Render3DEvent event, class_1297 entity) {
        if (this.mc.field_1690.field_1842) {
            return;
        }
        Color baseColor = (Color)this.monstersColor.get();
        if (((Boolean)this.distance.get()).booleanValue()) {
            baseColor = this.getOpposingColor(baseColor, entity);
        }
        double x = entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)event.tickDelta;
        double y = entity.field_6036 + (entity.method_23318() - entity.field_6036) * (double)event.tickDelta;
        double z = entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)event.tickDelta;
        double height = entity.method_5829().field_1325 - entity.method_5829().field_1322;
        event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, x, y += height / 2.0, z, baseColor);
    }

    private Color getOpposingColor(Color c, class_1297 e) {
        Color oppositeColor = (Color)this.distantColor.get();
        double distance = Math.sqrt(this.mc.field_1724.method_5858(e));
        double maxDistance = ((Integer)this.distanceInt.get()).intValue();
        double percent = class_3532.method_15350((double)(distance / maxDistance), (double)0.0, (double)1.0);
        int r = (int)((double)c.r + (double)(oppositeColor.r - c.r) * percent);
        int g = (int)((double)c.g + (double)(oppositeColor.g - c.g) * percent);
        int b = (int)((double)c.b + (double)(oppositeColor.b - c.b) * percent);
        int a = c.a;
        Color interpolatedColor = new Color(r, g, b, a);
        return interpolatedColor;
    }

    public static boolean isTool(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_42612) || itemStack.method_31573(class_3489.field_42613) || itemStack.method_31573(class_3489.field_42614) || itemStack.method_31573(class_3489.field_42615) || itemStack.method_7909() instanceof class_1820 || itemStack.method_7909() instanceof class_1786;
    }

    public static boolean isArmor(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_48297) || itemStack.method_31573(class_3489.field_48296) || itemStack.method_31573(class_3489.field_48295) || itemStack.method_31573(class_3489.field_48294);
    }

    public boolean shouldSkip(class_1542 entity) {
        boolean skip = false;
        if (((Boolean)this.enchants.get()).booleanValue()) {
            if (!((Boolean)this.certainenchants.get()).booleanValue() && (AdvancedItemESP.isTool(entity.method_6983()) || AdvancedItemESP.isArmor(entity.method_6983()) || entity.method_6983().method_31573(class_3489.field_42611) || entity.method_6983().method_7909() instanceof class_1787 || entity.method_6983().method_7909() instanceof class_1786 || entity.method_6983().method_7909() instanceof class_9362 || entity.method_6983().method_7909() instanceof class_1820 || entity.method_6983().method_7909() instanceof class_1819 || entity.method_6983().method_7909() instanceof class_1835) && entity.method_6983().method_7923() && entity.method_6983().method_58657().method_57543()) {
                skip = true;
            } else if (((Boolean)this.certainenchants.get()).booleanValue()) {
                if (AdvancedItemESP.isTool(entity.method_6983())) {
                    skip = this.compareEnchants(entity, this.toolenchants);
                } else if (entity.method_6983().method_31573(class_3489.field_42611)) {
                    skip = this.compareEnchants(entity, this.swordenchants);
                } else if (AdvancedItemESP.isArmor(entity.method_6983())) {
                    skip = this.compareEnchants(entity, this.armorenchants);
                } else if (entity.method_6983().method_7909() instanceof class_9362) {
                    skip = this.compareEnchants(entity, this.maceenchants);
                } else if (entity.method_6983().method_7909() instanceof class_1835) {
                    skip = this.compareEnchants(entity, this.tridentenchants);
                }
            }
        }
        if (!((List)this.items.get()).contains(entity.method_6983().method_7909())) {
            skip = true;
        }
        return skip;
    }

    private boolean compareEnchants(class_1542 entity, Setting<Set<class_5321<class_1887>>> enchantsetting) {
        boolean skip = false;
        HashSet itemenchants = new HashSet();
        entity.method_6983().method_58657().method_57534().forEach(enchantment -> itemenchants.add((class_5321)enchantment.method_40230().get()));
        for (class_5321 enchantKey : (Set)enchantsetting.get()) {
            if (itemenchants.contains(enchantKey)) continue;
            skip = true;
            break;
        }
        return skip;
    }

    public Color getColor(class_1297 entity) {
        double alpha = this.getFadeAlpha(entity);
        if (alpha == 0.0) {
            return null;
        }
        Color color = (Color)this.monstersColor.get();
        if (((Boolean)this.distance.get()).booleanValue()) {
            color = this.getOpposingColor(color, entity);
        }
        return this.baseColor.set(color.r, color.g, color.b, (int)((double)color.a * alpha));
    }

    private double getFadeAlpha(class_1297 entity) {
        double dist = PlayerUtils.squaredDistanceToCamera((double)(entity.method_23317() + (double)(entity.method_17681() / 2.0f)), (double)(entity.method_23318() + (double)entity.method_18381(entity.method_18376())), (double)(entity.method_23321() + (double)(entity.method_17681() / 2.0f)));
        double fadeDist = Math.pow((Double)this.fadeDistance.get(), 2.0);
        double alpha = 1.0;
        if (dist <= fadeDist * fadeDist) {
            alpha = (float)(Math.sqrt(dist) / fadeDist);
        }
        if (alpha <= 0.075) {
            alpha = 0.0;
        }
        return alpha;
    }

    public String getInfoString() {
        return Integer.toString(this.count);
    }

    @EventHandler
    private void onPreTick(TickEvent.Pre event) {
        if (this.mc.field_1687 != null) {
            Iterable entities = this.mc.field_1687.method_18112();
            this.scannedEntities.removeIf(entity -> {
                HashSet entitySet = new HashSet();
                entities.forEach(entity1 -> entitySet.add(entity1));
                return !entitySet.contains(entity);
            });
        }
    }
}

