/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.modules;

import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.world.PlaySoundEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_419;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import pwn.noobs.trouserstreak.Trouser;

public class AutoTexts
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgText;
    private final SettingGroup sgSpawning;
    private final SettingGroup sgMisc;
    private final Setting<Boolean> disconnectdisable;
    private final Setting<List<String>> texts;
    private final Setting<Boolean> rainbow;
    private final Setting<ColorModes> textColor;
    private final Setting<Integer> radius;
    private final Setting<Integer> height;
    private final Setting<Boolean> heightVariation;
    private final Setting<Integer> spawnDelay;
    private final Setting<Integer> spawnCount;
    private final Setting<Boolean> muteSounds;
    private final Random random;
    private int ticks;
    private class_243 origin;
    private String namecolour;

    public AutoTexts() {
        super(Trouser.operator, "auto-texts", "Spawns invisible armor stands with custom text. Requires creative mode.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgText = this.settings.createGroup("Text Options");
        this.sgSpawning = this.settings.createGroup("Spawn Settings");
        this.sgMisc = this.settings.createGroup("Miscellaneous");
        this.disconnectdisable = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Disable on Disconnect")).description("Disables module on disconnecting")).defaultValue((Object)false)).build());
        this.texts = this.sgText.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("Texts")).description("Text lines to display")).defaultValue(List.of("Trolled by Mountains of Lava Inc", "www.youtube.com/@mountainsoflavainc.6913"))).build());
        this.rainbow = this.sgText.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Rainbow")).description("Randomly cycles through all available colors")).defaultValue((Object)false)).build());
        this.textColor = this.sgText.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Text Color")).description("Color of the text")).defaultValue((Object)ColorModes.red)).visible(() -> (Boolean)this.rainbow.get() == false)).build());
        this.radius = this.sgSpawning.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Radius")).description("Spawn radius")).defaultValue((Object)8)).min(1).sliderMax(8).build());
        this.height = this.sgSpawning.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Height")).description("Base spawn height relative to player")).defaultValue((Object)0)).sliderRange(-8, 8).build());
        this.heightVariation = this.sgSpawning.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Height Variation")).description("Enable random height variation")).defaultValue((Object)false)).build());
        this.spawnDelay = this.sgSpawning.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Spawn Delay")).description("Delay between spawns in ticks")).defaultValue((Object)2)).min(0).sliderMax(20).build());
        this.spawnCount = this.sgSpawning.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Spawn Count")).description("How many to spawn per tick")).defaultValue((Object)1)).min(1).sliderMax(100).build());
        this.muteSounds = this.sgMisc.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Mute Sounds")).description("Prevents playing armor stand placement sounds")).defaultValue((Object)true)).build());
        this.random = new Random();
    }

    public void onActivate() {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!this.mc.field_1724.method_31549().field_7477) {
            this.error("Creative mode required!", new Object[0]);
            this.toggle();
            return;
        }
        this.ticks = 0;
        this.origin = null;
        this.namecolour = "";
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (((Boolean)this.disconnectdisable.get()).booleanValue() && event.screen instanceof class_419) {
            this.toggle();
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        if (((Boolean)this.disconnectdisable.get()).booleanValue()) {
            this.toggle();
        }
    }

    @EventHandler
    private void onPlaySound(PlaySoundEvent event) {
        if (((Boolean)this.muteSounds.get()).booleanValue() && event.sound.method_4775().method_12832().contains("entity.armor_stand.place")) {
            event.cancel();
        }
    }

    @EventHandler
    public void onTick(TickEvent.Pre event) {
        this.origin = this.mc.field_1724.method_19538();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.ticks >= (Integer)this.spawnDelay.get()) {
            this.updateNameColor();
            for (int i = 0; i < (Integer)this.spawnCount.get(); ++i) {
                this.spawnArmorStand();
            }
            this.ticks = 0;
        }
        ++this.ticks;
    }

    private void updateNameColor() {
        if (((Boolean)this.rainbow.get()).booleanValue()) {
            ColorModes[] colors = ColorModes.values();
            this.namecolour = colors[this.random.nextInt(colors.length)].toString();
        } else {
            this.namecolour = ((ColorModes)((Object)this.textColor.get())).toString();
        }
    }

    private class_243 pickRandomPos() {
        double x = this.random.nextDouble((Integer)this.radius.get() * 2) - (double)((Integer)this.radius.get()).intValue() + this.origin.field_1352;
        double y = this.mc.field_1724.method_23318() + (double)((Integer)this.height.get()).intValue() + ((Boolean)this.heightVariation.get() != false ? this.random.nextDouble(8.0) - 4.0 : 0.0);
        double z = this.random.nextDouble((Integer)this.radius.get() * 2) - (double)((Integer)this.radius.get()).intValue() + this.origin.field_1350;
        return new class_243(x, y, z);
    }

    private void spawnArmorStand() {
        class_1799 armorStand = new class_1799((class_1935)class_1802.field_8694);
        class_1799 current = this.mc.field_1724.method_6047();
        class_243 pos = this.pickRandomPos();
        String selectedText = (String)((List)this.texts.get()).get(this.random.nextInt(((List)this.texts.get()).size()));
        class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_49631, (Object)class_2561.method_43470((String)selectedText).method_27692(class_124.valueOf((String)this.namecolour.toUpperCase()))).method_57854(class_9334.field_49609, (Object)this.createEntityData(pos)).method_57852();
        armorStand.method_59692(changes);
        class_3965 bhr = new class_3965(pos, class_2350.field_11036, class_2338.method_49638((class_2374)pos), false);
        this.mc.field_1761.method_2909(armorStand, 36 + this.mc.field_1724.method_31548().field_7545);
        this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, bhr);
        this.mc.field_1761.method_2909(current, 36 + this.mc.field_1724.method_31548().field_7545);
    }

    private class_9279 createEntityData(class_243 pos) {
        class_2487 entityTag = new class_2487();
        class_2499 position = new class_2499();
        String selectedText = (String)((List)this.texts.get()).get(this.random.nextInt(((List)this.texts.get()).size()));
        position.add((Object)class_2489.method_23241((double)pos.field_1352));
        position.add((Object)class_2489.method_23241((double)pos.field_1351));
        position.add((Object)class_2489.method_23241((double)pos.field_1350));
        entityTag.method_10582("id", "minecraft:armor_stand");
        entityTag.method_10566("Pos", (class_2520)position);
        entityTag.method_10556("Invisible", true);
        entityTag.method_10556("Marker", true);
        entityTag.method_10556("NoGravity", true);
        entityTag.method_10556("CustomNameVisible", true);
        class_2487 CustomNameNBT = new class_2487();
        CustomNameNBT.method_10582("text", selectedText);
        CustomNameNBT.method_10582("color", this.namecolour);
        String serverVersion = this.mc.method_1496() ? this.mc.method_1576().method_3827() : this.mc.method_1558().field_3760.method_54160();
        if (serverVersion == null) {
            entityTag.method_10566("CustomName", (class_2520)CustomNameNBT);
        } else if (this.isVersionLessThan(serverVersion, 1, 21, 5)) {
            entityTag.method_10582("CustomName", "{\"text\":\"" + selectedText + "\",\"color\":\"" + this.namecolour + "\"}");
        } else {
            entityTag.method_10566("CustomName", (class_2520)CustomNameNBT);
        }
        return class_9279.method_57456((class_2487)entityTag);
    }

    private boolean isVersionLessThan(String serverVersion, int major, int minor, int patch) {
        if (serverVersion == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
        Matcher matcher = pattern.matcher(serverVersion);
        if (matcher.find()) {
            try {
                int serverMajor = Integer.parseInt(matcher.group(1));
                int serverMinor = Integer.parseInt(matcher.group(2));
                int serverPatch = Integer.parseInt(matcher.group(3));
                if (serverMajor < major) {
                    return true;
                }
                if (serverMajor > major) {
                    return false;
                }
                if (serverMinor < minor) {
                    return true;
                }
                if (serverMinor > minor) {
                    return false;
                }
                return serverPatch < patch;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static enum ColorModes {
        aqua,
        black,
        blue,
        dark_aqua,
        dark_blue,
        dark_gray,
        dark_green,
        dark_purple,
        dark_red,
        gold,
        gray,
        green,
        italic,
        light_purple,
        red,
        white,
        yellow;

    }
}

