/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_419;
import net.minecraft.class_434;
import pwn.noobs.trouserstreak.Trouser;

public class CaveDisturbanceDetector
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Boolean> chatFeedback;
    private final Setting<Boolean> displaycoords;
    public final Setting<Integer> FPdistance;
    private final Setting<Boolean> removerenderdist;
    public final Setting<Integer> renderDistance;
    private final Setting<Boolean> trcr;
    private final Setting<Boolean> nearesttrcr;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final Set<class_1923> scannedChunks;
    private Set<class_2338> scannedAir;
    private final Set<class_2338> disturbanceLocations;
    private int closestX;
    private int closestY;
    private int closestZ;
    private double distance;

    public CaveDisturbanceDetector() {
        super(Trouser.baseHunting, "CaveDisturbanceDetector", "Scans for single air blocks within the cave air blocks found in caves and underground structures in 1.13+ chunks. There are several false positives.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chat feedback")).description("Displays info for you.")).defaultValue((Object)false)).build());
        this.displaycoords = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("DisplayCoords")).description("Displays coords of air disturbances in chat.")).defaultValue((Object)true)).build());
        this.FPdistance = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("False Positive Distance")).description("If extra normal air within this range of the cave air disturbance then ignore the disturbance")).defaultValue((Object)1)).min(1).sliderRange(1, 10).build());
        this.removerenderdist = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("RemoveOutsideRenderDistance")).description("Removes the cached disturbances when they leave render distance.")).defaultValue((Object)true)).build());
        this.renderDistance = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Render-Distance(Chunks)")).description("How many chunks from the character to render the detected disturbances.")).defaultValue((Object)32)).min(6).sliderRange(6, 1024).build());
        this.trcr = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracers")).description("Show tracers to the air disturbances.")).defaultValue((Object)true)).build());
        this.nearesttrcr = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracer to nearest Disturbance Only")).description("Show only one tracer to the nearest air disturbance.")).defaultValue((Object)false)).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.sideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("air-disturbance-side-color")).description("Color of possible air disturbances.")).defaultValue(new SettingColor(255, 0, 130, 55)).visible(() -> this.shapeMode.get() == ShapeMode.Sides || this.shapeMode.get() == ShapeMode.Both)).build());
        this.lineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("air-disturbance-line-color")).description("Color of possible air disturbances.")).defaultValue(new SettingColor(255, 0, 130, 200)).visible(() -> this.shapeMode.get() == ShapeMode.Lines || this.shapeMode.get() == ShapeMode.Both || (Boolean)this.trcr.get() != false)).build());
        this.scannedChunks = Collections.synchronizedSet(new HashSet());
        this.scannedAir = Collections.synchronizedSet(new HashSet());
        this.disturbanceLocations = Collections.synchronizedSet(new HashSet());
        this.closestX = 2000000000;
        this.closestY = 2000000000;
        this.closestZ = 2000000000;
        this.distance = 2.0E9;
    }

    public void onActivate() {
        this.clearChunkData();
    }

    private void scanTheAir() {
        if (this.mc.field_1687 == null) {
            return;
        }
        ArrayList<class_1923> chunksToProcess = new ArrayList<class_1923>();
        AtomicReferenceArray chunks = this.mc.field_1687.method_2935().field_16246.field_16251;
        for (int i = 0; i < chunks.length(); ++i) {
            class_2818 chunk = (class_2818)chunks.get(i);
            if (chunk == null || chunk.method_12223()) continue;
            chunksToProcess.add(chunk.method_12004());
        }
        chunksToProcess.parallelStream().forEach(chunkPos -> {
            class_2818 chunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            if (chunk != null && !chunk.method_12223() && !this.scannedChunks.contains(chunk.method_12004())) {
                this.processChunk(chunk);
                this.scannedChunks.add(chunk.method_12004());
            }
        });
    }

    public void onDeactivate() {
        this.clearChunkData();
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (event.screen instanceof class_419 || event.screen instanceof class_434) {
            this.clearChunkData();
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.clearChunkData();
    }

    private void clearChunkData() {
        this.scannedChunks.clear();
        this.scannedAir.clear();
        this.disturbanceLocations.clear();
        this.closestX = 2000000000;
        this.closestY = 2000000000;
        this.closestZ = 2000000000;
        this.distance = 2.0E9;
    }

    @EventHandler
    private void onPreTick(TickEvent.Pre event) {
        this.scanTheAir();
        if (((Boolean)this.nearesttrcr.get()).booleanValue()) {
            try {
                if (this.disturbanceLocations.stream().toList().size() > 0) {
                    for (int b = 0; b < this.disturbanceLocations.stream().toList().size(); ++b) {
                        if (!(this.distance > Math.sqrt(Math.pow(((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10263() - this.mc.field_1724.method_31477(), 2.0) + Math.pow(((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10260() - this.mc.field_1724.method_31479(), 2.0)))) continue;
                        this.closestX = ((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10263();
                        this.closestY = ((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10264();
                        this.closestZ = ((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10260();
                        this.distance = Math.sqrt(Math.pow(((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10263() - this.mc.field_1724.method_31477(), 2.0) + Math.pow(((class_2338)this.disturbanceLocations.stream().toList().get(b)).method_10260() - this.mc.field_1724.method_31479(), 2.0));
                    }
                    this.distance = 2.0E9;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (((Boolean)this.removerenderdist.get()).booleanValue()) {
            this.removeChunksOutsideRenderDistance();
        }
    }

    private void processChunk(class_2818 chunk) {
        int minY = this.mc.field_1687.method_31607();
        int maxY = 180;
        if (this.mc.field_1687.method_27983() == class_1937.field_25180) {
            maxY = 126;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    class_2338 blockPos = new class_2338(chunk.method_12004().method_8326() + x, y, chunk.method_12004().method_8328() + z);
                    class_2680 blockState = chunk.method_8320(blockPos);
                    if (blockState.method_26204() != class_2246.field_10543) continue;
                    this.isSurroundingBlockRegAir(blockPos);
                }
            }
        }
    }

    private void isSurroundingBlockRegAir(class_2338 bPos) {
        this.scannedAir = Collections.synchronizedSet(new HashSet());
        block8: for (int dir = 1; dir < 6; ++dir) {
            switch (dir) {
                case 1: {
                    class_2338 BlockPastTheAir;
                    class_2338 Air = bPos.method_10095();
                    if (!this.scannedAir.contains(Air)) {
                        BlockPastTheAir = Air.method_10069(0, 0, -1);
                        if (this.mc.field_1687.method_8320(Air).method_26204() == class_2246.field_10124 && this.mc.field_1687.method_8320(BlockPastTheAir).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(-1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 1, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, -1, 0)).method_26204() != class_2246.field_10124 && !this.FPcheck(Air)) {
                            this.disturbanceFound(Air);
                        }
                    }
                    this.scannedAir.add(Air);
                    continue block8;
                }
                case 2: {
                    class_2338 BlockPastTheAir;
                    class_2338 Air = bPos.method_10072();
                    if (!this.scannedAir.contains(Air)) {
                        BlockPastTheAir = Air.method_10069(0, 0, 1);
                        if (this.mc.field_1687.method_8320(Air).method_26204() == class_2246.field_10124 && this.mc.field_1687.method_8320(BlockPastTheAir).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(-1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 1, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, -1, 0)).method_26204() != class_2246.field_10124 && !this.FPcheck(Air)) {
                            this.disturbanceFound(Air);
                        }
                    }
                    this.scannedAir.add(Air);
                    continue block8;
                }
                case 3: {
                    class_2338 BlockPastTheAir;
                    class_2338 Air = bPos.method_10067();
                    if (!this.scannedAir.contains(Air)) {
                        BlockPastTheAir = Air.method_10069(-1, 0, 0);
                        if (this.mc.field_1687.method_8320(Air).method_26204() == class_2246.field_10124 && this.mc.field_1687.method_8320(BlockPastTheAir).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 1, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, -1, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, 1)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, -1)).method_26204() != class_2246.field_10124 && !this.FPcheck(Air)) {
                            this.disturbanceFound(Air);
                        }
                    }
                    this.scannedAir.add(Air);
                    continue block8;
                }
                case 4: {
                    class_2338 BlockPastTheAir;
                    class_2338 Air = bPos.method_10078();
                    if (!this.scannedAir.contains(Air)) {
                        BlockPastTheAir = Air.method_10069(1, 0, 0);
                        if (this.mc.field_1687.method_8320(Air).method_26204() == class_2246.field_10124 && this.mc.field_1687.method_8320(BlockPastTheAir).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 1, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, -1, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, 1)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, -1)).method_26204() != class_2246.field_10124 && !this.FPcheck(Air)) {
                            this.disturbanceFound(Air);
                        }
                    }
                    this.scannedAir.add(Air);
                    continue block8;
                }
                case 5: {
                    class_2338 BlockPastTheAir;
                    class_2338 Air = bPos.method_10084();
                    if (!this.scannedAir.contains(Air)) {
                        BlockPastTheAir = Air.method_10069(0, 1, 0);
                        if (this.mc.field_1687.method_8320(Air).method_26204() == class_2246.field_10124 && this.mc.field_1687.method_8320(BlockPastTheAir).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(-1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, 1)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, -1)).method_26204() != class_2246.field_10124 && !this.FPcheck(Air)) {
                            this.disturbanceFound(Air);
                        }
                    }
                    this.scannedAir.add(Air);
                    continue block8;
                }
                case 6: {
                    class_2338 BlockPastTheAir;
                    class_2338 Air = bPos.method_10074();
                    if (!this.scannedAir.contains(Air)) {
                        BlockPastTheAir = Air.method_10069(0, -1, 0);
                        if (this.mc.field_1687.method_8320(Air).method_26204() == class_2246.field_10124 && this.mc.field_1687.method_8320(BlockPastTheAir).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(-1, 0, 0)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, 1)).method_26204() != class_2246.field_10124 && this.mc.field_1687.method_8320(Air.method_10069(0, 0, -1)).method_26204() != class_2246.field_10124 && !this.FPcheck(Air)) {
                            this.disturbanceFound(Air);
                        }
                    }
                    this.scannedAir.add(Air);
                }
            }
        }
    }

    private boolean FPcheck(class_2338 disturbance) {
        boolean extraAirFound = false;
        for (int x = -((Integer)this.FPdistance.get()).intValue(); x < (Integer)this.FPdistance.get() + 1; ++x) {
            block1: for (int y = -((Integer)this.FPdistance.get()).intValue(); y < (Integer)this.FPdistance.get() + 1; ++y) {
                for (int z = -((Integer)this.FPdistance.get()).intValue(); z < (Integer)this.FPdistance.get() + 1; ++z) {
                    class_2338 bpos = new class_2338((class_2382)disturbance.method_10069(x, y, z));
                    if (bpos.equals((Object)disturbance) || this.mc.field_1687.method_8320(bpos).method_26204() != class_2246.field_10124) continue;
                    extraAirFound = true;
                    continue block1;
                }
            }
        }
        return extraAirFound;
    }

    private void disturbanceFound(class_2338 disturbance) {
        if (!this.disturbanceLocations.contains(disturbance)) {
            this.disturbanceLocations.add(disturbance);
            if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                if (((Boolean)this.displaycoords.get()).booleanValue()) {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("Disturbance in the Cave Air found: " + String.valueOf(disturbance))));
                } else if (!((Boolean)this.displaycoords.get()).booleanValue()) {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)"Disturbance in the Cave Air found!"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onRender(Render3DEvent event) {
        if ((((SettingColor)this.sideColor.get()).a > 5 || ((SettingColor)this.lineColor.get()).a > 5) && this.mc.field_1724 != null) {
            Set<class_2338> set = this.disturbanceLocations;
            synchronized (set) {
                if (!((Boolean)this.nearesttrcr.get()).booleanValue()) {
                    for (class_2338 pos : this.disturbanceLocations) {
                        class_2338 playerPos = new class_2338(this.mc.field_1724.method_31477(), pos.method_10264(), this.mc.field_1724.method_31479());
                        if (pos == null || !playerPos.method_19771((class_2382)pos, (double)((Integer)this.renderDistance.get() * 16))) continue;
                        int startX = pos.method_10263();
                        int startY = pos.method_10264();
                        int startZ = pos.method_10260();
                        int endX = pos.method_10263();
                        int endY = pos.method_10264();
                        int endZ = pos.method_10260();
                        this.render(new class_238(new class_243((double)(startX + 1), (double)(startY + 1), (double)(startZ + 1)), new class_243((double)endX, (double)endY, (double)endZ)), (Color)this.sideColor.get(), (Color)this.lineColor.get(), (ShapeMode)this.shapeMode.get(), event);
                    }
                } else if (((Boolean)this.nearesttrcr.get()).booleanValue()) {
                    for (class_2338 pos : this.disturbanceLocations) {
                        class_2338 playerPos = new class_2338(this.mc.field_1724.method_31477(), pos.method_10264(), this.mc.field_1724.method_31479());
                        if (pos == null || !playerPos.method_19771((class_2382)pos, (double)((Integer)this.renderDistance.get() * 16))) continue;
                        int startX = pos.method_10263();
                        int startY = pos.method_10264();
                        int startZ = pos.method_10260();
                        int endX = pos.method_10263();
                        int endY = pos.method_10264();
                        int endZ = pos.method_10260();
                        this.render(new class_238(new class_243((double)(startX + 1), (double)(startY + 1), (double)(startZ + 1)), new class_243((double)endX, (double)endY, (double)endZ)), (Color)this.sideColor.get(), (Color)this.lineColor.get(), (ShapeMode)this.shapeMode.get(), event);
                    }
                    this.render2(new class_238(new class_243((double)(this.closestX + 1), (double)(this.closestY + 1), (double)(this.closestZ + 1)), new class_243((double)this.closestX, (double)this.closestY, (double)this.closestZ)), (Color)this.sideColor.get(), (Color)this.lineColor.get(), ShapeMode.Sides, event);
                }
            }
        }
    }

    private void render(class_238 box, Color sides, Color lines, ShapeMode shapeMode, Render3DEvent event) {
        if (((Boolean)this.trcr.get()).booleanValue() && Math.abs(box.field_1323 - RenderUtils.center.field_1352) <= (double)((Integer)this.renderDistance.get() * 16) && Math.abs(box.field_1321 - RenderUtils.center.field_1350) <= (double)((Integer)this.renderDistance.get() * 16) && !((Boolean)this.nearesttrcr.get()).booleanValue()) {
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, box.field_1323 + 0.5, box.field_1322 + (box.field_1325 - box.field_1322) / 2.0, box.field_1321 + 0.5, lines);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, sides, new Color(0, 0, 0, 0), shapeMode, 0);
    }

    private void render2(class_238 box, Color sides, Color lines, ShapeMode shapeMode, Render3DEvent event) {
        if (((Boolean)this.trcr.get()).booleanValue() && Math.abs(box.field_1323 - RenderUtils.center.field_1352) <= (double)((Integer)this.renderDistance.get() * 16) && Math.abs(box.field_1321 - RenderUtils.center.field_1350) <= (double)((Integer)this.renderDistance.get() * 16)) {
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, box.field_1323 + 0.5, box.field_1322 + (box.field_1325 - box.field_1322) / 2.0, box.field_1321 + 0.5, lines);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, sides, new Color(0, 0, 0, 0), shapeMode, 0);
    }

    private void removeChunksOutsideRenderDistance() {
        AtomicReferenceArray chunks = this.mc.field_1687.method_2935().field_16246.field_16251;
        HashSet<class_2818> chunkSet = new HashSet<class_2818>();
        for (int i = 0; i < chunks.length(); ++i) {
            class_2818 chunk = (class_2818)chunks.get(i);
            if (chunk == null) continue;
            chunkSet.add(chunk);
        }
        this.removechunksOutsideRenderDistance(this.scannedChunks, chunkSet);
        this.removeChunksOutsideRenderDistance(this.disturbanceLocations, chunkSet);
    }

    private void removeChunksOutsideRenderDistance(Set<class_2338> boxSet, Set<class_2818> worldChunks) {
        boxSet.removeIf(box -> {
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_22350(box));
        });
    }

    private void removechunksOutsideRenderDistance(Set<class_1923> chunkSet, Set<class_2818> worldChunks) {
        chunkSet.removeIf(c -> {
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_8497(c.field_9181, c.field_9180));
        });
    }
}

