/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.modules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.game.ReceiveMessageEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_419;
import pwn.noobs.trouserstreak.Trouser;

public class MultiverseAnnihilator
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> delay;
    private int timer;
    private int currentPage;
    private int totalPages;
    private final List<String> worldsToDelete;
    private final Set<String> deletedWorlds;
    private int deleteIndex;

    public MultiverseAnnihilator() {
        super(Trouser.operator, "MultiverseAnnihilator", "Effortlessly deletes all Multiverse worlds! Made by https://youtube.com/@ogmur");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("The delay between commands in ticks.")).defaultValue((Object)10)).min(1).sliderMax(200).build());
        this.currentPage = 1;
        this.totalPages = 1;
        this.worldsToDelete = new ArrayList<String>();
        this.deletedWorlds = new HashSet<String>();
        this.deleteIndex = 0;
    }

    public void onActivate() {
        this.resetState();
        if (this.mc.field_1724 != null && !this.mc.field_1724.method_64475(2)) {
            this.toggle();
            this.error("Operator status required!", new Object[0]);
            return;
        }
        ChatUtils.info((String)"Starting MVDeleter...", (Object[])new Object[0]);
        this.sendCommand("mv list 1");
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (event.screen instanceof class_419) {
            this.toggle();
            ChatUtils.warning((String)"Disconnected. Module disabled.", (Object[])new Object[0]);
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.toggle();
        ChatUtils.warning((String)"Left game. Module disabled.", (Object[])new Object[0]);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.worldsToDelete.isEmpty() && this.timer <= 0) {
            if (this.deleteIndex < this.worldsToDelete.size()) {
                String worldName = this.worldsToDelete.get(this.deleteIndex);
                if (!this.deletedWorlds.contains(worldName)) {
                    this.sendCommand("mv delete " + worldName);
                    ChatUtils.info((String)("Deleting: " + worldName), (Object[])new Object[0]);
                    this.deletedWorlds.add(worldName);
                }
                ++this.deleteIndex;
                this.timer = (Integer)this.delay.get();
                this.sendCommand("mv confirm");
                ChatUtils.info((String)"Confirming deletion.", (Object[])new Object[0]);
                this.timer = (Integer)this.delay.get() * 2;
            } else {
                this.toggle();
                ChatUtils.info((String)"\u00a7cAll worlds deleted.", (Object[])new Object[0]);
            }
        }
        if (this.timer > 0) {
            --this.timer;
        }
    }

    @EventHandler
    public void onMessageReceive(ReceiveMessageEvent event) {
        if (event.getMessage() != null && this.mc.field_1724 != null) {
            String worldName;
            String message = event.getMessage().getString();
            if (message.contains("Unknown")) {
                ChatUtils.error((String)"\u00a7cMultiverse not detected. Module disabled.", (Object[])new Object[0]);
                this.toggle();
                return;
            }
            if (message.contains("====[ Multiverse World List ]====")) {
                ChatUtils.info((String)"World list found, extracting worlds...", (Object[])new Object[0]);
            }
            if (message.contains(" - ") && !(worldName = message.split(" - ")[0].trim()).isEmpty() && !this.deletedWorlds.contains(worldName)) {
                this.worldsToDelete.add(worldName);
                ChatUtils.info((String)("Found world: " + worldName), (Object[])new Object[0]);
            }
            if (message.contains("[ Page ")) {
                this.parsePageInformation(message);
            }
            if (message.contains("World successfully deleted")) {
                String lastDeleted = this.worldsToDelete.get(this.deleteIndex - 1);
                ChatUtils.info((String)("Successfully deleted: " + lastDeleted), (Object[])new Object[0]);
            }
        }
    }

    private void parsePageInformation(String message) {
        try {
            String[] parts = message.split("Page ");
            if (parts.length > 1) {
                String[] pageDetails = parts[1].split(" of ");
                int current = Integer.parseInt(pageDetails[0].trim());
                int total = Integer.parseInt(pageDetails[1].replace("]", "").trim());
                this.currentPage = current;
                this.totalPages = total;
                ChatUtils.info((String)("Currently on page " + this.currentPage + " of " + this.totalPages + "."), (Object[])new Object[0]);
                if (this.currentPage < this.totalPages) {
                    ++this.currentPage;
                    this.sendCommand("mv list " + this.currentPage);
                    this.timer = (Integer)this.delay.get();
                    ChatUtils.info((String)("Fetching page " + this.currentPage + " of " + this.totalPages + "..."), (Object[])new Object[0]);
                }
            }
        }
        catch (NumberFormatException e) {
            ChatUtils.error((String)("Failed to parse page information: " + e.getMessage()), (Object[])new Object[0]);
        }
    }

    private void sendCommand(String command) {
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.field_3944.method_45730(command);
        }
    }

    private void resetState() {
        this.timer = (Integer)this.delay.get();
        this.currentPage = 1;
        this.totalPages = 1;
        this.worldsToDelete.clear();
        this.deletedWorlds.clear();
        this.deleteIndex = 0;
    }
}

