/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.modules;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.pathing.PathManagers;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_419;
import net.minecraft.class_434;
import pwn.noobs.trouserstreak.Trouser;

public class NoSpawnerDetector
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgLocations;
    private final SettingGroup sgRender;
    private final SettingGroup locationLogs;
    private final Setting<Boolean> chatFeedback;
    private final Setting<Boolean> displaycoords;
    private final Setting<Boolean> enableDungeon;
    private final Setting<Boolean> spawnerDetect;
    private final Setting<Boolean> chestDetect;
    private final Setting<Boolean> enableMineshaft;
    private final Setting<Boolean> spawnerDetectmineshaft;
    public final Setting<Integer> renderDistance;
    private final Setting<Boolean> removerenderdist;
    private final Setting<Boolean> trcr;
    private final Setting<Boolean> nearesttrcr;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> spawnerSideColor;
    private final Setting<SettingColor> spawnerLineColor;
    private final Setting<Boolean> locLogging;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<LoggedStructure> loggedStructures;
    private final Set<class_1923> scannedChunks;
    private final Set<class_2338> scannedBlocks;
    private final Set<class_2338> checkedBlocks;
    private final Set<class_2338> StructurePositions;
    private int closestStructureX;
    private int closestStructureY;
    private int closestStructureZ;
    private double StructureDistance;

    public NoSpawnerDetector() {
        super(Trouser.baseHunting, "NoSpawnerDetector", "Detects Structures and also their lack of mob spawner.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgLocations = this.settings.createGroup("Location Toggles");
        this.sgRender = this.settings.createGroup("Render");
        this.locationLogs = this.settings.createGroup("Location Logs");
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chat feedback")).description("Display info about Structure in chat.")).defaultValue((Object)true)).build());
        this.displaycoords = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("DisplayCoords")).description("Displays coords of Structure in chat.")).defaultValue((Object)true)).build());
        this.enableDungeon = this.sgLocations.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Dungeon")).description("Enable detection for dungeons.")).defaultValue((Object)true)).build());
        this.spawnerDetect = this.sgLocations.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("No Spawner Detection (Dungeon)")).description("Only display dungeons if NO spawner.")).defaultValue((Object)true)).visible(() -> (Boolean)this.enableDungeon.get())).build());
        this.chestDetect = this.sgLocations.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chest Detection")).description("Only detect dungeons with chests.")).defaultValue((Object)true)).visible(() -> (Boolean)this.enableDungeon.get())).build());
        this.enableMineshaft = this.sgLocations.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Mineshaft")).description("Enable detection for Mineshaft spawners.")).defaultValue((Object)true)).build());
        this.spawnerDetectmineshaft = this.sgLocations.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("No Spawner Detection (Mineshaft)")).description("Only display Mineshaft spawner locations if NO spawner.")).defaultValue((Object)true)).visible(() -> (Boolean)this.enableMineshaft.get())).build());
        this.renderDistance = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Render-Distance(Chunks)")).description("How many chunks from the character to render the detected Structure.")).defaultValue((Object)32)).min(6).sliderRange(6, 1024).build());
        this.removerenderdist = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("RemoveOutsideRenderDistance")).description("Removes the cached block positions when they leave the defined render distance.")).defaultValue((Object)true)).build());
        this.trcr = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracers")).description("Show tracers to the Structure.")).defaultValue((Object)true)).build());
        this.nearesttrcr = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracer to nearest Structure Only")).description("Show only one tracer to the nearest Structure.")).defaultValue((Object)false)).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.spawnerSideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("structure-side-color")).description("Color of the structure indicator.")).defaultValue(new SettingColor(251, 5, 5, 70)).visible(() -> this.shapeMode.get() == ShapeMode.Sides || this.shapeMode.get() == ShapeMode.Both)).build());
        this.spawnerLineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("structure-line-color")).description("Color of the structure indicator.")).defaultValue(new SettingColor(251, 5, 5, 235)).visible(() -> this.shapeMode.get() == ShapeMode.Lines || this.shapeMode.get() == ShapeMode.Both || (Boolean)this.trcr.get() != false)).build());
        this.locLogging = this.locationLogs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Location Logging")).description("Logs the locations of detected structures to a csv file as well as a table in this options menu.")).defaultValue((Object)false)).build());
        this.loggedStructures = new ArrayList<LoggedStructure>();
        this.scannedChunks = Collections.synchronizedSet(new HashSet());
        this.scannedBlocks = Collections.synchronizedSet(new HashSet());
        this.checkedBlocks = Collections.synchronizedSet(new HashSet());
        this.StructurePositions = Collections.synchronizedSet(new HashSet());
        this.closestStructureX = 2000000000;
        this.closestStructureY = 2000000000;
        this.closestStructureZ = 2000000000;
        this.StructureDistance = 2.0E9;
    }

    public void onActivate() {
        this.clearChunkData();
        this.loadLogs();
    }

    public void onDeactivate() {
        this.clearChunkData();
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (event.screen instanceof class_419 || event.screen instanceof class_434) {
            this.clearChunkData();
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.clearChunkData();
    }

    private void clearChunkData() {
        this.loggedStructures.clear();
        this.scannedBlocks.clear();
        this.scannedChunks.clear();
        this.checkedBlocks.clear();
        this.StructurePositions.clear();
        this.closestStructureX = 2000000000;
        this.closestStructureY = 2000000000;
        this.closestStructureZ = 2000000000;
        this.StructureDistance = 2.0E9;
    }

    private boolean chunkContainsBlock(class_2818 chunk, class_2248 target, int sectionsToCheck) {
        class_2826[] sections = chunk.method_12006();
        for (int i = 0; i < sectionsToCheck; ++i) {
            class_2826 section = sections[i];
            if (section.method_38292()) continue;
            class_2841 blockStatesContainer = section.method_12265();
            class_2837 blockStatePalette = blockStatesContainer.field_34560.comp_119();
            int blockPaletteLength = blockStatePalette.method_12197();
            for (int i2 = 0; i2 < blockPaletteLength; ++i2) {
                class_2680 blockPaletteEntry = (class_2680)blockStatePalette.method_12288(i2);
                if (blockPaletteEntry.method_26204() != target) continue;
                return true;
            }
        }
        return false;
    }

    @EventHandler
    private void onPreTick(TickEvent.Pre event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        AtomicReferenceArray chunks = this.mc.field_1687.method_2935().field_16246.field_16251;
        HashSet<class_2818> chunkSet = new HashSet<class_2818>();
        for (int i = 0; i < chunks.length(); ++i) {
            class_2818 chunk2 = (class_2818)chunks.get(i);
            if (chunk2 == null) continue;
            chunkSet.add(chunk2);
        }
        chunkSet.forEach(chunk -> {
            if (!chunk.method_12223() && !this.scannedChunks.contains(chunk.method_12004())) {
                if (((Boolean)this.enableDungeon.get()).booleanValue() && this.mc.field_1687.method_27983() == class_1937.field_25179 && this.chunkContainsBlock((class_2818)chunk, class_2246.field_9989, Math.min(chunk.method_12006().length, 20)) || ((Boolean)this.enableMineshaft.get()).booleanValue() && this.mc.field_1687.method_27983() == class_1937.field_25179 && this.chunkContainsBlock((class_2818)chunk, class_2246.field_10343, Math.min(chunk.method_12006().length, 20))) {
                    for (int x = 0; x < 16; ++x) {
                        for (int y = this.mc.field_1687.method_31607(); y < this.mc.field_1687.method_31600(); ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2338 blockPos = new class_2338(x + chunk.method_12004().field_9181 * 16, y, z + chunk.method_12004().field_9180 * 16);
                                if (((Boolean)this.enableDungeon.get()).booleanValue() && this.mc.field_1687.method_8320(blockPos).method_26204() == class_2246.field_9989) {
                                    if (!this.scannedBlocks.contains(blockPos) && !this.checkedBlocks.contains(blockPos)) {
                                        this.scanForDungeonFloor(blockPos);
                                    }
                                    this.checkedBlocks.add(blockPos);
                                }
                                if (!((Boolean)this.enableMineshaft.get()).booleanValue() || this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_10343) continue;
                                if (!this.scannedBlocks.contains(blockPos) && !this.checkedBlocks.contains(blockPos)) {
                                    this.scanForMineshaftSpawner(blockPos);
                                }
                                this.checkedBlocks.add(blockPos);
                            }
                        }
                    }
                }
                this.scannedChunks.add(chunk.method_12004());
            }
        });
        if (((Boolean)this.nearesttrcr.get()).booleanValue()) {
            try {
                if (this.StructurePositions.stream().toList().size() > 0) {
                    for (int b = 0; b < this.StructurePositions.stream().toList().size(); ++b) {
                        if (!(this.StructureDistance > Math.sqrt(Math.pow(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10263() - this.mc.field_1724.method_31477(), 2.0) + Math.pow(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10260() - this.mc.field_1724.method_31479(), 2.0)))) continue;
                        this.closestStructureX = Math.round(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10263());
                        this.closestStructureY = Math.round(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10264());
                        this.closestStructureZ = Math.round(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10260());
                        this.StructureDistance = Math.sqrt(Math.pow(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10263() - this.mc.field_1724.method_31477(), 2.0) + Math.pow(((class_2338)this.StructurePositions.stream().toList().get(b)).method_10260() - this.mc.field_1724.method_31479(), 2.0));
                    }
                    this.StructureDistance = 2.0E9;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (((Boolean)this.removerenderdist.get()).booleanValue()) {
            this.removeChunksOutsideRenderDistance(chunkSet);
        }
    }

    private void scanForDungeonFloor(class_2338 blockPos) {
        int radius = 4;
        int y = blockPos.method_10264();
        int minX = blockPos.method_10263() - radius;
        int maxX = blockPos.method_10263() + radius;
        int minZ = blockPos.method_10260() - radius;
        int maxZ = blockPos.method_10260() + radius;
        int mossyCobbleCount = 0;
        int cobbleCount = 0;
        int totalBlocks = (maxX - minX + 1) * (maxZ - minZ + 1);
        Set<class_2338> potentialBlocks = Collections.synchronizedSet(new HashSet());
        boolean foundChests = false;
        boolean foundSpawner = false;
        boolean foundCaveAir = false;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                class_2338 scanPos = new class_2338(x, y, z);
                if (this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_9989) {
                    ++mossyCobbleCount;
                } else if (this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_10445) {
                    ++cobbleCount;
                }
                class_2338 extraScanPos = new class_2338(x, y + 1, z);
                if (!foundCaveAir && this.mc.field_1687.method_8320(extraScanPos).method_26204() == class_2246.field_10543) {
                    foundCaveAir = true;
                }
                if (((Boolean)this.chestDetect.get()).booleanValue() && !foundChests && this.mc.field_1687.method_8320(extraScanPos).method_26204() == class_2246.field_10034) {
                    foundChests = true;
                }
                if (((Boolean)this.spawnerDetect.get()).booleanValue() && !foundSpawner && this.mc.field_1687.method_8320(extraScanPos).method_26204() == class_2246.field_10260) {
                    foundSpawner = true;
                }
                potentialBlocks.add(scanPos);
            }
        }
        int requiredBlocks = (int)((double)totalBlocks * 0.55);
        if (mossyCobbleCount + cobbleCount > requiredBlocks && (((Boolean)this.chestDetect.get()).booleanValue() && foundChests || !((Boolean)this.chestDetect.get()).booleanValue()) && (((Boolean)this.spawnerDetect.get()).booleanValue() && !foundSpawner || !((Boolean)this.spawnerDetect.get()).booleanValue()) && foundCaveAir) {
            this.scannedBlocks.addAll(potentialBlocks);
            this.displayMessage("dungeon", blockPos);
        }
    }

    private void scanForMineshaftSpawner(class_2338 blockPos) {
        int radius = 1;
        int minY = blockPos.method_10264();
        int maxY = blockPos.method_10264() + radius;
        int minX = blockPos.method_10263() - radius;
        int maxX = blockPos.method_10263() + radius;
        int minZ = blockPos.method_10260() - radius;
        int maxZ = blockPos.method_10260() + radius;
        int cobwebCount = 0;
        int totalBlocks = (maxX - minX + 1) * (maxZ - minZ + 1) * (maxY - minY + 1);
        Set<class_2338> potentialBlocks = Collections.synchronizedSet(new HashSet());
        boolean foundAir = false;
        boolean foundCaveAir = false;
        boolean foundSpawner = false;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    class_2338 scanPos = new class_2338(x, y, z);
                    if (this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_10343) {
                        ++cobwebCount;
                    }
                    if (!foundCaveAir && this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_10543) {
                        foundCaveAir = true;
                    }
                    if (!foundAir && this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_10124) {
                        foundAir = true;
                    }
                    if (!foundSpawner && this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_10260) {
                        foundSpawner = true;
                    }
                    potentialBlocks.add(scanPos);
                }
            }
        }
        int requiredBlocks = (int)((double)totalBlocks * 0.45);
        boolean doublechecknospawner = false;
        if (((Boolean)this.spawnerDetectmineshaft.get()).booleanValue() && !foundSpawner && foundAir && cobwebCount > requiredBlocks) {
            int radius2 = 18;
            int y = blockPos.method_10264();
            int minX2 = blockPos.method_10263() - radius2;
            int maxX2 = blockPos.method_10263() + radius2;
            int minZ2 = blockPos.method_10260() - radius2;
            int maxZ2 = blockPos.method_10260() + radius2;
            for (int x = minX2; x <= maxX2; ++x) {
                for (int z = minZ2; z <= maxZ2; ++z) {
                    class_2338 scanPos = new class_2338(x, y, z);
                    if (!doublechecknospawner && this.mc.field_1687.method_8320(scanPos).method_26204() == class_2246.field_10260) {
                        doublechecknospawner = true;
                    }
                    if (doublechecknospawner || this.mc.field_1687.method_8320(scanPos).method_26204() != class_2246.field_10243) continue;
                    doublechecknospawner = true;
                }
            }
        }
        if (cobwebCount > requiredBlocks && (((Boolean)this.spawnerDetectmineshaft.get()).booleanValue() && !doublechecknospawner && !foundSpawner && foundAir || !((Boolean)this.spawnerDetectmineshaft.get()).booleanValue()) && foundCaveAir) {
            this.scannedBlocks.addAll(potentialBlocks);
            this.displayMessage("mineshaft", blockPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onRender(Render3DEvent event) {
        if (((SettingColor)this.spawnerSideColor.get()).a > 5 || ((SettingColor)this.spawnerLineColor.get()).a > 5) {
            Set<class_2338> set = this.StructurePositions;
            synchronized (set) {
                for (class_2338 pos : this.StructurePositions) {
                    class_2338 playerPos = new class_2338(this.mc.field_1724.method_31477(), pos.method_10264(), this.mc.field_1724.method_31479());
                    if (pos == null || !playerPos.method_19771((class_2382)pos, (double)((Integer)this.renderDistance.get() * 16))) continue;
                    int startX = pos.method_10263();
                    int startY = pos.method_10264();
                    int startZ = pos.method_10260();
                    int endX = pos.method_10263();
                    int endY = pos.method_10264();
                    int endZ = pos.method_10260();
                    if (!((Boolean)this.nearesttrcr.get()).booleanValue()) {
                        this.render(new class_238(new class_243((double)(startX + 1), (double)(startY + 1), (double)(startZ + 1)), new class_243((double)endX, (double)endY, (double)endZ)), (Color)this.spawnerSideColor.get(), (Color)this.spawnerLineColor.get(), (ShapeMode)this.shapeMode.get(), event);
                        continue;
                    }
                    if (!((Boolean)this.nearesttrcr.get()).booleanValue()) continue;
                    this.render(new class_238(new class_243((double)(startX + 1), (double)(startY + 1), (double)(startZ + 1)), new class_243((double)endX, (double)endY, (double)endZ)), (Color)this.spawnerSideColor.get(), (Color)this.spawnerLineColor.get(), (ShapeMode)this.shapeMode.get(), event);
                    this.render2(new class_238(new class_243((double)this.closestStructureX, (double)this.closestStructureY, (double)this.closestStructureZ), new class_243((double)this.closestStructureX, (double)this.closestStructureY, (double)this.closestStructureZ)), (Color)this.spawnerSideColor.get(), (Color)this.spawnerLineColor.get(), ShapeMode.Sides, event);
                }
            }
        }
    }

    private void displayMessage(String key, class_2338 pos) {
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            if (key == "dungeon") {
                if (((Boolean)this.displaycoords.get()).booleanValue()) {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("\u00a79NSD\u00a7r | Detected \u00a79DUNGEON\u00a7r! Block Position: " + String.valueOf(pos))));
                } else {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)"\u00a79NSD\u00a7r | Detected \u00a79DUNGEON\u00a7r!"));
                }
                this.logStructure(pos);
            }
            if (key == "mineshaft") {
                if (((Boolean)this.displaycoords.get()).booleanValue()) {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("\u00a79NSD\u00a7r | Detected \u00a79MINESHAFT\u00a7r! Block Position: " + String.valueOf(pos))));
                } else {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)"\u00a79NSD\u00a7r | Detected \u00a79MINESHAFT\u00a7r!"));
                }
                this.logStructure(pos);
            }
        }
    }

    private void render(class_238 box, Color sides, Color lines, ShapeMode shapeMode, Render3DEvent event) {
        if (((Boolean)this.trcr.get()).booleanValue() && Math.abs(box.field_1323 - RenderUtils.center.field_1352) <= (double)((Integer)this.renderDistance.get() * 16) && Math.abs(box.field_1321 - RenderUtils.center.field_1350) <= (double)((Integer)this.renderDistance.get() * 16) && !((Boolean)this.nearesttrcr.get()).booleanValue()) {
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, box.field_1323 + 0.5, box.field_1322 + (box.field_1325 - box.field_1322) / 2.0, box.field_1321 + 0.5, lines);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, sides, new Color(0, 0, 0, 0), shapeMode, 0);
    }

    private void render2(class_238 box, Color sides, Color lines, ShapeMode shapeMode, Render3DEvent event) {
        if (((Boolean)this.trcr.get()).booleanValue() && Math.abs(box.field_1323 - RenderUtils.center.field_1352) <= (double)((Integer)this.renderDistance.get() * 16) && Math.abs(box.field_1321 - RenderUtils.center.field_1350) <= (double)((Integer)this.renderDistance.get() * 16)) {
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, box.field_1323 + 0.5, box.field_1322 + (box.field_1325 - box.field_1322) / 2.0, box.field_1321 + 0.5, lines);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, sides, new Color(0, 0, 0, 0), shapeMode, 0);
    }

    private void removeChunksOutsideRenderDistance(Set<class_2818> chunks) {
        this.removechunksOutsideRenderDistance(this.scannedChunks, chunks);
        this.removeBlockPosOutsideRenderDistance(this.StructurePositions, chunks);
        this.removeBlockPosOutsideRenderDistance(this.scannedBlocks, chunks);
        this.removeBlockPosOutsideRenderDistance(this.checkedBlocks, chunks);
    }

    private void removeBlockPosOutsideRenderDistance(Set<class_2338> blockSet, Set<class_2818> worldChunks) {
        blockSet.removeIf(blockpos -> {
            class_2338 boxPos = new class_2338((int)Math.floor(blockpos.method_10263()), (int)Math.floor(blockpos.method_10264()), (int)Math.floor(blockpos.method_10260()));
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_22350(boxPos));
        });
    }

    private void removechunksOutsideRenderDistance(Set<class_1923> chunkSet, Set<class_2818> worldChunks) {
        chunkSet.removeIf(c -> {
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_8497(c.field_9181, c.field_9180));
        });
    }

    private void logStructure(class_2338 pos) {
        if (!this.StructurePositions.contains(pos)) {
            this.StructurePositions.add(pos);
            if (((Boolean)this.locLogging.get()).booleanValue()) {
                this.loggedStructures.add(new LoggedStructure(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                this.saveJson();
                this.saveCsv();
            }
        }
    }

    private void saveCsv() {
        try {
            File file = this.getCsvFile();
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            writer.write("X,Y,Z\n");
            for (LoggedStructure ls : this.loggedStructures) {
                ls.write(writer);
            }
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveJson() {
        try {
            File file = this.getJsonFile();
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            GSON.toJson(this.loggedStructures, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getJsonFile() {
        return new File(new File(new File("TrouserStreak", "NoSpawnerDetector"), Utils.getFileWorldName()), "NoSpawnerDetector.json");
    }

    private File getCsvFile() {
        return new File(new File(new File("TrouserStreak", "NoSpawnerDetector"), Utils.getFileWorldName()), "NoSpawnerDetector.csv");
    }

    private void loadLogs() {
        Reader reader2;
        File file = this.getJsonFile();
        boolean loaded = false;
        if (file.exists()) {
            try {
                reader2 = new FileReader(file);
                List data = (List)GSON.fromJson(reader2, new TypeToken<List<LoggedStructure>>(){}.getType());
                ((InputStreamReader)reader2).close();
                if (data != null) {
                    this.loggedStructures.addAll(data);
                    for (LoggedStructure ls : data) {
                        this.StructurePositions.add(new class_2338(ls.x, ls.y, ls.z));
                    }
                    loaded = true;
                }
            }
            catch (Exception reader2) {
                // empty catch block
            }
        }
        if (!loaded && (file = this.getCsvFile()).exists()) {
            try {
                String line;
                reader2 = new BufferedReader(new FileReader(file));
                ((BufferedReader)reader2).readLine();
                while ((line = ((BufferedReader)reader2).readLine()) != null) {
                    LoggedStructure ls;
                    String[] values = line.split(",");
                    ls = new LoggedStructure(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
                    this.loggedStructures.add(ls);
                    this.StructurePositions.add(new class_2338(ls.x, ls.y, ls.z));
                }
                ((BufferedReader)reader2).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public WWidget getWidget(GuiTheme theme) {
        this.loggedStructures.sort(Comparator.comparingInt(s -> s.y));
        WVerticalList list = theme.verticalList();
        WButton clear = (WButton)list.add((WWidget)theme.button("Clear Logged Positions")).widget();
        WTable table = new WTable();
        if (!this.loggedStructures.isEmpty()) {
            list.add((WWidget)table);
        }
        clear.action = () -> {
            this.loggedStructures.clear();
            this.StructurePositions.clear();
            table.clear();
            this.saveJson();
            this.saveCsv();
        };
        this.fillTable(theme, table);
        return list;
    }

    private void fillTable(GuiTheme theme, WTable table) {
        ArrayList<LoggedStructure> spawnerCoords = new ArrayList<LoggedStructure>();
        for (LoggedStructure ls : this.loggedStructures) {
            if (spawnerCoords.contains(ls)) continue;
            spawnerCoords.add(ls);
            table.add((WWidget)theme.label("Pos: " + ls.x + ", " + ls.y + ", " + ls.z));
            WButton gotoBtn = (WButton)table.add((WWidget)theme.button("Goto")).widget();
            gotoBtn.action = () -> PathManagers.get().moveTo(new class_2338(ls.x, ls.y, ls.z), true);
            WMinus delete = (WMinus)table.add((WWidget)theme.minus()).widget();
            delete.action = () -> {
                this.loggedStructures.remove(ls);
                this.StructurePositions.remove(new class_2338(ls.x, ls.y, ls.z));
                table.clear();
                this.fillTable(theme, table);
                this.saveJson();
                this.saveCsv();
            };
            table.row();
        }
    }

    private static class LoggedStructure {
        public int x;
        public int y;
        public int z;

        public LoggedStructure(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void write(Writer writer) throws IOException {
            writer.write(this.x + "," + this.y + "," + this.z + "\n");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoggedStructure)) {
                return false;
            }
            LoggedStructure that = (LoggedStructure)o;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }
}

