/*
 * Decompiled with CFR 0.152.
 */
package pwn.noobs.trouserstreak.modules;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WMinus;
import meteordevelopment.meteorclient.pathing.PathManagers;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_419;
import net.minecraft.class_434;
import pwn.noobs.trouserstreak.Trouser;

public class PortalPatternFinder
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final SettingGroup locationLogs;
    private final Setting<Boolean> displaycoords;
    private final Setting<Boolean> ignorecorners;
    private final Setting<Boolean> falsepositives1;
    public final Setting<Integer> nonAirPercent;
    public final Setting<Integer> percent;
    public final Setting<Integer> pWidth;
    public final Setting<Integer> pHeight;
    private final Setting<Boolean> removerenderdist;
    public final Setting<Integer> renderDistance;
    private final Setting<Boolean> trcr;
    private final Setting<Boolean> nearesttrcr;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> portalSideColor;
    private final Setting<SettingColor> portalLineColor;
    private final Setting<Boolean> locLogging;
    private final Set<class_1923> scannedChunks;
    private final Set<class_238> possiblePortalLocations;
    private final Set<class_2338> loggedPortalPositions;
    private int closestPortalX;
    private int closestPortalY;
    private int closestPortalZ;
    private double PortalDistance;
    private final List<PortalPattern> portalPatterns;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public PortalPatternFinder() {
        super(Trouser.baseHunting, "PortalPatternFinder", "Scans for the shapes of broken/removed Nether Portals within the cave air blocks found in caves and underground structures in 1.13+ chunks. **May be useful for finding portal skips in the Nether**");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.locationLogs = this.settings.createGroup("Location Logs");
        this.displaycoords = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("DisplayCoords")).description("Displays coords of portal patterns in chat.")).defaultValue((Object)true)).build());
        this.ignorecorners = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-corner-blocks")).description("Also matches portal patterns that are missing the corner blocks.")).defaultValue((Object)true)).build());
        this.falsepositives1 = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("False Positive Removal")).description("Removes false positives in relation to the air above and below the portal pattern.")).defaultValue((Object)true)).build());
        this.nonAirPercent = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Non-Air Percent")).description("What percentage of the blocks in the portal shape can be non-air.")).defaultValue((Object)20)).min(0).sliderRange(0, 100).build());
        this.percent = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Adjacent Air Percent")).description("What percentage of the blocks in the portal shape that is allowed to have air blocks adjacent to it.")).defaultValue((Object)15)).min(0).sliderRange(0, 100).build());
        this.pWidth = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Portal Width")).description("finds portals that are up to this large")).defaultValue((Object)5)).min(4).sliderRange(4, 8).build());
        this.pHeight = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Portal Height")).description("finds portals that are up to this large")).defaultValue((Object)5)).min(5).sliderRange(5, 8).build());
        this.removerenderdist = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("RemoveOutsideRenderDistance")).description("Removes the cached portal patterns when they leave render distance.")).defaultValue((Object)true)).build());
        this.renderDistance = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Render-Distance(Chunks)")).description("How many chunks from the character to render the portal patterns.")).defaultValue((Object)32)).min(6).sliderRange(6, 1024).build());
        this.trcr = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracers")).description("Show tracers to the portal patterns.")).defaultValue((Object)true)).build());
        this.nearesttrcr = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Tracer to nearest Portal Only")).description("Show only one tracer to the nearest portal pattern.")).defaultValue((Object)false)).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.portalSideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("possible-portal-side-color")).description("Color of possible portal locations.")).defaultValue(new SettingColor(170, 0, 255, 55)).visible(() -> this.shapeMode.get() == ShapeMode.Sides || this.shapeMode.get() == ShapeMode.Both)).build());
        this.portalLineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("possible-portal-line-color")).description("Color of possible portal locations.")).defaultValue(new SettingColor(170, 0, 255, 200)).visible(() -> this.shapeMode.get() == ShapeMode.Lines || this.shapeMode.get() == ShapeMode.Both || (Boolean)this.trcr.get() != false)).build());
        this.locLogging = this.locationLogs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Location Logging")).description("Logs the locations of detected spawners to a csv file as well as a table in this options menu.")).defaultValue((Object)false)).build());
        this.scannedChunks = new CopyOnWriteArraySet<class_1923>();
        this.possiblePortalLocations = new CopyOnWriteArraySet<class_238>();
        this.loggedPortalPositions = new CopyOnWriteArraySet<class_2338>();
        this.closestPortalX = 2000000000;
        this.closestPortalY = 2000000000;
        this.closestPortalZ = 2000000000;
        this.PortalDistance = 2.0E9;
        this.portalPatterns = new ArrayList<PortalPattern>();
    }

    public void onActivate() {
        this.clearChunkData();
        this.loadPortalPatterns();
    }

    private void scanTheAir(AtomicReferenceArray<class_2818> chunks) {
        ArrayList<class_1923> chunksToProcess = new ArrayList<class_1923>();
        for (int i = 0; i < chunks.length(); ++i) {
            class_2818 chunk = chunks.get(i);
            if (chunk == null || chunk.method_12223()) continue;
            chunksToProcess.add(chunk.method_12004());
        }
        chunksToProcess.stream().forEach(chunkPos -> {
            class_2818 chunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            if (chunk != null && !chunk.method_12223() && !this.scannedChunks.contains(chunk.method_12004())) {
                this.processChunk(chunk);
                this.scannedChunks.add(chunk.method_12004());
            }
        });
    }

    public void onDeactivate() {
        this.clearChunkData();
        this.portalPatterns.clear();
        this.loggedPortalPositions.clear();
    }

    @EventHandler
    private void onScreenOpen(OpenScreenEvent event) {
        if (event.screen instanceof class_419 || event.screen instanceof class_434) {
            this.clearChunkData();
        }
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.clearChunkData();
    }

    private void clearChunkData() {
        this.scannedChunks.clear();
        this.possiblePortalLocations.clear();
        this.closestPortalX = 2000000000;
        this.closestPortalY = 2000000000;
        this.closestPortalZ = 2000000000;
        this.PortalDistance = 2.0E9;
    }

    @EventHandler
    private void onPreTick(TickEvent.Pre event) {
        if (this.mc.field_1687 == null) {
            return;
        }
        AtomicReferenceArray chunks = this.mc.field_1687.method_2935().field_16246.field_16251;
        HashSet<class_2818> chunkSet = new HashSet<class_2818>();
        for (int i = 0; i < chunks.length(); ++i) {
            class_2818 chunk = (class_2818)chunks.get(i);
            if (chunk == null) continue;
            chunkSet.add(chunk);
        }
        this.scanTheAir(chunks);
        if (((Boolean)this.nearesttrcr.get()).booleanValue()) {
            try {
                if (this.possiblePortalLocations.stream().toList().size() > 0) {
                    for (int b = 0; b < this.possiblePortalLocations.stream().toList().size(); ++b) {
                        if (!(this.PortalDistance > Math.sqrt(Math.pow(((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1352 - 1.0 - (double)this.mc.field_1724.method_31477(), 2.0) + Math.pow(((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1350 - 1.0 - (double)this.mc.field_1724.method_31479(), 2.0)))) continue;
                        this.closestPortalX = Math.round((float)((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1352 - 1.0f);
                        this.closestPortalY = Math.round((float)((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1351 - 1.0f);
                        this.closestPortalZ = Math.round((float)((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1350 - 1.0f);
                        this.PortalDistance = Math.sqrt(Math.pow(((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1352 - 1.0 - (double)this.mc.field_1724.method_31477(), 2.0) + Math.pow(((class_238)this.possiblePortalLocations.stream().toList().get((int)b)).method_1005().field_1350 - 1.0 - (double)this.mc.field_1724.method_31479(), 2.0));
                    }
                    this.PortalDistance = 2.0E9;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (((Boolean)this.removerenderdist.get()).booleanValue()) {
            this.removeChunksOutsideRenderDistance(chunkSet);
        }
    }

    private void processChunk(class_2818 chunk) {
        int minY = this.mc.field_1687.method_31607();
        int maxY = 180;
        if (this.mc.field_1687.method_27983() == class_1937.field_25180) {
            maxY = 126;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    class_2338 blockPos = new class_2338(chunk.method_12004().method_8326() + x, y, chunk.method_12004().method_8328() + z);
                    class_2680 blockState = chunk.method_8320(blockPos);
                    if (blockState.method_26204() != class_2246.field_10543) continue;
                    this.isSurroundingBlockRegAir(blockPos);
                }
            }
        }
    }

    private void isSurroundingBlockRegAir(class_2338 bPos) {
        class_2338 airPos = bPos.method_10095();
        class_2338 blockPastTheAir = bPos.method_10095().method_10069(0, 0, -1);
        for (int dir = 1; dir <= 4; ++dir) {
            switch (dir) {
                case 1: {
                    airPos = bPos.method_10095();
                    blockPastTheAir = bPos.method_10095().method_10069(0, 0, -1);
                    break;
                }
                case 2: {
                    airPos = bPos.method_10072();
                    blockPastTheAir = bPos.method_10072().method_10069(0, 0, 1);
                    break;
                }
                case 3: {
                    airPos = bPos.method_10067();
                    blockPastTheAir = bPos.method_10067().method_10069(-1, 0, 0);
                    break;
                }
                case 4: {
                    airPos = bPos.method_10078();
                    blockPastTheAir = bPos.method_10078().method_10069(1, 0, 0);
                }
            }
            if (this.mc.field_1687.method_8320(airPos).method_26204() != class_2246.field_10124 || this.mc.field_1687.method_8320(blockPastTheAir).method_26204() == class_2246.field_10124) continue;
            this.findAirShape(airPos);
        }
    }

    private void findAirShape(class_2338 pos) {
        boolean airfoundaboveorbelow;
        class_2338 boxEnd;
        class_2338 boxStart;
        int currentHeight;
        class_2338[] surroundingPositions;
        int nonairblockonsides;
        class_2338 bPos;
        int y;
        int squareWidth = (Integer)this.pWidth.get();
        int squareHeight = (Integer)this.pHeight.get();
        int areaWidth = squareWidth / 2 + 1;
        int areaHeight = squareHeight / 2 + 1;
        ArrayList<class_2338> AirBlockPatternWEast = new ArrayList<class_2338>();
        ArrayList<class_2338> AirBlockPatternNouth = new ArrayList<class_2338>();
        int AirBlockPatternWEastREJECT = 0;
        int AirBlockPatternNouthREJECT = 0;
        int AirBlockPatternWEastREJECT2 = 0;
        int AirBlockPatternNouthREJECT2 = 0;
        for (int x = -areaWidth; x <= areaWidth; ++x) {
            for (y = -areaHeight; y <= areaHeight; ++y) {
                bPos = new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260());
                if (this.mc.field_1687.method_8320(bPos).method_26204() == class_2246.field_10124) {
                    nonairblockonsides = 0;
                    for (class_2338 posi : surroundingPositions = new class_2338[]{bPos.method_10095(), bPos.method_10072()}) {
                        if (this.mc.field_1687.method_8320(posi).method_26204() == class_2246.field_10124) continue;
                        ++nonairblockonsides;
                    }
                    if (nonairblockonsides >= 2) {
                        AirBlockPatternWEast.add(bPos);
                        continue;
                    }
                    ++AirBlockPatternWEastREJECT;
                    AirBlockPatternWEast.add(bPos);
                    continue;
                }
                if (this.mc.field_1687.method_8320(bPos).method_26204() == class_2246.field_10124 || this.mc.field_1687.method_8320(bPos).method_26204() == class_2246.field_10543) continue;
                ++AirBlockPatternWEastREJECT2;
                AirBlockPatternWEast.add(bPos);
            }
        }
        for (int z = -areaWidth; z <= areaWidth; ++z) {
            for (y = -areaHeight; y <= areaHeight; ++y) {
                bPos = new class_2338(pos.method_10263(), pos.method_10264() + y, pos.method_10260() + z);
                if (this.mc.field_1687.method_8320(bPos).method_26204() == class_2246.field_10124) {
                    nonairblockonsides = 0;
                    for (class_2338 posi : surroundingPositions = new class_2338[]{bPos.method_10067(), bPos.method_10078()}) {
                        if (this.mc.field_1687.method_8320(posi).method_26204() == class_2246.field_10124) continue;
                        ++nonairblockonsides;
                    }
                    if (nonairblockonsides >= 2) {
                        AirBlockPatternNouth.add(bPos);
                        continue;
                    }
                    ++AirBlockPatternNouthREJECT;
                    AirBlockPatternNouth.add(bPos);
                    continue;
                }
                if (this.mc.field_1687.method_8320(bPos).method_26204() == class_2246.field_10124 || this.mc.field_1687.method_8320(bPos).method_26204() == class_2246.field_10543) continue;
                ++AirBlockPatternNouthREJECT2;
                AirBlockPatternNouth.add(bPos);
            }
        }
        if ((double)AirBlockPatternWEastREJECT2 / (double)(AirBlockPatternWEast.size() - AirBlockPatternWEastREJECT) * 100.0 <= (double)((Integer)this.nonAirPercent.get()).intValue() && (double)AirBlockPatternWEastREJECT / (double)AirBlockPatternWEast.size() * 100.0 <= (double)((Integer)this.percent.get()).intValue()) {
            for (class_2338 block : AirBlockPatternWEast) {
                block7: for (int currentWidth = 4; currentWidth <= squareWidth; ++currentWidth) {
                    for (currentHeight = 5; currentHeight <= squareHeight; ++currentHeight) {
                        if (!this.isValidWEastPortalShape(AirBlockPatternWEast, block, currentWidth, currentHeight)) continue;
                        boxStart = block;
                        boxEnd = new class_2338(boxStart.method_10263() + currentWidth - 1, boxStart.method_10264() + currentHeight - 1, boxStart.method_10260());
                        airfoundaboveorbelow = false;
                        if (((Boolean)this.falsepositives1.get()).booleanValue()) {
                            int x;
                            for (x = 0; x < currentWidth; ++x) {
                                class_2338 blockPos = boxStart.method_10069(x, -1, 0);
                                if (this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_10124) continue;
                                airfoundaboveorbelow = true;
                            }
                            for (x = 0; x < currentWidth; ++x) {
                                class_2338 blockPos = boxStart.method_10069(x, currentHeight + 1, 0);
                                if (this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_10124) continue;
                                airfoundaboveorbelow = true;
                            }
                            if (airfoundaboveorbelow) continue;
                        }
                        class_238 portalBox = new class_238(new class_243((double)boxStart.method_10263(), (double)boxStart.method_10264(), (double)boxStart.method_10260()), new class_243((double)(boxEnd.method_10263() + 1), (double)(boxEnd.method_10264() + 1), (double)(boxEnd.method_10260() + 1)));
                        boolean intersects = false;
                        for (class_238 existingBox : this.possiblePortalLocations) {
                            if (!portalBox.method_994(existingBox)) continue;
                            intersects = true;
                            break;
                        }
                        if (intersects) continue;
                        this.portalFound(portalBox);
                        continue block7;
                    }
                }
            }
        }
        if ((double)AirBlockPatternNouthREJECT2 / (double)(AirBlockPatternNouth.size() - AirBlockPatternNouthREJECT) * 100.0 <= (double)((Integer)this.nonAirPercent.get()).intValue() && (double)AirBlockPatternNouthREJECT / (double)AirBlockPatternNouth.size() * 100.0 <= (double)((Integer)this.percent.get()).intValue()) {
            for (class_2338 block : AirBlockPatternNouth) {
                for (int currentWidth = 4; currentWidth <= squareWidth; ++currentWidth) {
                    for (currentHeight = 5; currentHeight <= squareHeight; ++currentHeight) {
                        if (!this.isValidNouthPortalShape(AirBlockPatternNouth, block, currentWidth, currentHeight)) continue;
                        boxStart = block;
                        boxEnd = new class_2338(boxStart.method_10263(), boxStart.method_10264() + currentHeight - 1, boxStart.method_10260() + currentWidth - 1);
                        airfoundaboveorbelow = false;
                        if (((Boolean)this.falsepositives1.get()).booleanValue()) {
                            int z;
                            for (z = 0; z < currentWidth; ++z) {
                                class_2338 blockPos = boxStart.method_10069(0, -1, z);
                                if (this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_10124) continue;
                                airfoundaboveorbelow = true;
                            }
                            for (z = 0; z < currentWidth; ++z) {
                                class_2338 blockPos = boxStart.method_10069(0, currentHeight + 1, z);
                                if (this.mc.field_1687.method_8320(blockPos).method_26204() != class_2246.field_10124) continue;
                                airfoundaboveorbelow = true;
                            }
                            if (airfoundaboveorbelow) continue;
                        }
                        class_238 portalBox = new class_238(new class_243((double)boxStart.method_10263(), (double)boxStart.method_10264(), (double)boxStart.method_10260()), new class_243((double)(boxEnd.method_10263() + 1), (double)(boxEnd.method_10264() + 1), (double)(boxEnd.method_10260() + 1)));
                        boolean intersects = false;
                        for (class_238 existingBox : this.possiblePortalLocations) {
                            if (!portalBox.method_994(existingBox)) continue;
                            intersects = true;
                            break;
                        }
                        if (intersects) continue;
                        this.portalFound(portalBox);
                    }
                }
            }
        }
    }

    private void portalFound(class_238 portalBox) {
        if (!this.possiblePortalLocations.contains(portalBox)) {
            this.possiblePortalLocations.add(portalBox);
            this.mc.execute(() -> {
                if (((Boolean)this.displaycoords.get()).booleanValue()) {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("Possible portal found: " + String.valueOf(portalBox.method_1005()))));
                } else if (!((Boolean)this.displaycoords.get()).booleanValue()) {
                    ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)"Possible portal found!"));
                }
            });
            class_2338 cp = new class_2338(Math.round((float)portalBox.method_1005().field_1352), Math.round((float)portalBox.method_1005().field_1351), Math.round((float)portalBox.method_1005().field_1350));
            if (!this.loggedPortalPositions.contains(cp) && ((Boolean)this.locLogging.get()).booleanValue()) {
                this.loggedPortalPositions.add(cp);
                this.portalPatterns.add(new PortalPattern(cp.method_10263(), cp.method_10264(), cp.method_10260()));
                this.saveJson();
                this.saveCsv();
            }
        }
    }

    private boolean isValidWEastPortalShape(List<class_2338> portalBlocks, class_2338 startBlock, Integer squareWidth, Integer squareHeight) {
        for (int currentWidth = 4; currentWidth <= squareWidth; ++currentWidth) {
            for (int currentHeight = 5; currentHeight <= squareHeight; ++currentHeight) {
                boolean validShape = true;
                for (int dx = 0; dx < currentWidth; ++dx) {
                    for (int dy = 0; dy < currentHeight; ++dy) {
                        class_2338 checkPos = startBlock.method_10069(dx, dy, 0);
                        if (((Boolean)this.ignorecorners.get()).booleanValue() && (dx == 0 && dy == 0 || dx == currentWidth - 1 && dy == 0 || dx == 0 && dy == currentHeight - 1 || dx == currentWidth - 1 && dy == currentHeight - 1) || portalBlocks.contains(checkPos)) continue;
                        validShape = false;
                        break;
                    }
                    if (!validShape) break;
                }
                if (!validShape) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidNouthPortalShape(List<class_2338> portalBlocks, class_2338 startBlock, Integer squareWidth, Integer squareHeight) {
        for (int currentWidth = 4; currentWidth <= squareWidth; ++currentWidth) {
            for (int currentHeight = 5; currentHeight <= squareHeight; ++currentHeight) {
                boolean validShape = true;
                for (int dz = 0; dz < currentWidth; ++dz) {
                    for (int dy = 0; dy < currentHeight; ++dy) {
                        class_2338 checkPos = startBlock.method_10069(0, dy, dz);
                        if (((Boolean)this.ignorecorners.get()).booleanValue() && (dz == 0 && dy == 0 || dz == currentWidth - 1 && dy == 0 || dz == 0 && dy == currentHeight - 1 || dz == currentWidth - 1 && dy == currentHeight - 1) || portalBlocks.contains(checkPos)) continue;
                        validShape = false;
                        break;
                    }
                    if (!validShape) break;
                }
                if (!validShape) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onRender(Render3DEvent event) {
        if (((SettingColor)this.portalSideColor.get()).a > 5 || ((SettingColor)this.portalLineColor.get()).a > 5) {
            Set<class_238> set = this.possiblePortalLocations;
            synchronized (set) {
                if (!((Boolean)this.nearesttrcr.get()).booleanValue()) {
                    for (class_238 box : this.possiblePortalLocations) {
                        class_2338 playerPos = new class_2338(this.mc.field_1724.method_31477(), Math.round((float)box.method_1005().method_10214()), this.mc.field_1724.method_31479());
                        if (box == null || !playerPos.method_19769((class_2374)box.method_1005(), (double)((Integer)this.renderDistance.get() * 16))) continue;
                        this.render(box, (Color)this.portalSideColor.get(), (Color)this.portalLineColor.get(), (ShapeMode)this.shapeMode.get(), event);
                    }
                } else if (((Boolean)this.nearesttrcr.get()).booleanValue()) {
                    for (class_238 box : this.possiblePortalLocations) {
                        class_2338 playerPos = new class_2338(this.mc.field_1724.method_31477(), Math.round((float)box.method_1005().method_10214()), this.mc.field_1724.method_31479());
                        if (box == null || !playerPos.method_19769((class_2374)box.method_1005(), (double)((Integer)this.renderDistance.get() * 16))) continue;
                        this.render(box, (Color)this.portalSideColor.get(), (Color)this.portalLineColor.get(), (ShapeMode)this.shapeMode.get(), event);
                    }
                    this.render2(new class_238(new class_243((double)this.closestPortalX, (double)this.closestPortalY, (double)this.closestPortalZ), new class_243((double)this.closestPortalX, (double)this.closestPortalY, (double)this.closestPortalZ)), (Color)this.portalSideColor.get(), (Color)this.portalLineColor.get(), ShapeMode.Sides, event);
                }
            }
        }
    }

    private void render(class_238 box, Color sides, Color lines, ShapeMode shapeMode, Render3DEvent event) {
        if (((Boolean)this.trcr.get()).booleanValue() && Math.abs(box.field_1323 - RenderUtils.center.field_1352) <= (double)((Integer)this.renderDistance.get() * 16) && Math.abs(box.field_1321 - RenderUtils.center.field_1350) <= (double)((Integer)this.renderDistance.get() * 16) && !((Boolean)this.nearesttrcr.get()).booleanValue()) {
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, box.field_1323 + 0.5, box.field_1322 + (box.field_1325 - box.field_1322) / 2.0, box.field_1321 + 0.5, lines);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, sides, new Color(0, 0, 0, 0), shapeMode, 0);
    }

    private void render2(class_238 box, Color sides, Color lines, ShapeMode shapeMode, Render3DEvent event) {
        if (((Boolean)this.trcr.get()).booleanValue() && Math.abs(box.field_1323 - RenderUtils.center.field_1352) <= (double)((Integer)this.renderDistance.get() * 16) && Math.abs(box.field_1321 - RenderUtils.center.field_1350) <= (double)((Integer)this.renderDistance.get() * 16)) {
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, box.field_1323 + 0.5, box.field_1322 + (box.field_1325 - box.field_1322) / 2.0, box.field_1321 + 0.5, lines);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, sides, new Color(0, 0, 0, 0), shapeMode, 0);
    }

    private void removeChunksOutsideRenderDistance(Set<class_2818> worldChunks) {
        this.removechunksOutsideRenderDistance(this.scannedChunks, worldChunks);
        this.removeChunksOutsideRenderDistance(this.possiblePortalLocations, worldChunks);
    }

    private void removeChunksOutsideRenderDistance(Set<class_238> boxSet, Set<class_2818> worldChunks) {
        boxSet.removeIf(box -> {
            class_2338 boxPos = new class_2338((int)Math.floor(box.method_1005().method_10216()), (int)Math.floor(box.method_1005().method_10214()), (int)Math.floor(box.method_1005().method_10215()));
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_22350(boxPos));
        });
    }

    private void removechunksOutsideRenderDistance(Set<class_1923> chunkSet, Set<class_2818> worldChunks) {
        chunkSet.removeIf(c -> {
            assert (this.mc.field_1687 != null);
            return !worldChunks.contains(this.mc.field_1687.method_8497(c.field_9181, c.field_9180));
        });
    }

    public WWidget getWidget(GuiTheme theme) {
        this.portalPatterns.sort(Comparator.comparingInt(a -> a.y));
        WVerticalList list = theme.verticalList();
        WButton clear = (WButton)list.add((WWidget)theme.button("Clear Logged Positions")).widget();
        WTable table = new WTable();
        if (!this.portalPatterns.isEmpty()) {
            list.add((WWidget)table);
        }
        clear.action = () -> {
            this.portalPatterns.clear();
            this.loggedPortalPositions.clear();
            this.possiblePortalLocations.clear();
            table.clear();
            this.saveJson();
            this.saveCsv();
        };
        this.fillTable(theme, table);
        return list;
    }

    private void fillTable(GuiTheme theme, WTable table) {
        ArrayList<PortalPattern> portalCoords = new ArrayList<PortalPattern>();
        for (PortalPattern p : this.portalPatterns) {
            if (portalCoords.contains(p)) continue;
            portalCoords.add(p);
            table.add((WWidget)theme.label("Pos: " + p.x + ", " + p.y + ", " + p.z));
            WButton gotoBtn = (WButton)table.add((WWidget)theme.button("Goto")).widget();
            gotoBtn.action = () -> PathManagers.get().moveTo(new class_2338(p.x, p.y, p.z), true);
            WMinus delete = (WMinus)table.add((WWidget)theme.minus()).widget();
            delete.action = () -> {
                this.portalPatterns.remove(p);
                this.loggedPortalPositions.remove(new class_2338(p.x, p.y, p.z));
                this.possiblePortalLocations.removeIf(box -> {
                    class_2338 cp = new class_2338(Math.round((float)box.method_1005().field_1352), Math.round((float)box.method_1005().field_1351), Math.round((float)box.method_1005().field_1350));
                    return cp.equals((Object)new class_2338(p.x, p.y, p.z));
                });
                table.clear();
                this.fillTable(theme, table);
                this.saveJson();
                this.saveCsv();
            };
            table.row();
        }
    }

    private void loadPortalPatterns() {
        Reader reader2;
        File file = this.getJsonFile();
        boolean loaded = false;
        if (file.exists()) {
            try {
                reader2 = new FileReader(file);
                List data = (List)GSON.fromJson(reader2, new TypeToken<List<PortalPattern>>(){}.getType());
                ((InputStreamReader)reader2).close();
                if (data != null) {
                    this.portalPatterns.addAll(data);
                    for (PortalPattern p : data) {
                        this.loggedPortalPositions.add(new class_2338(p.x, p.y, p.z));
                    }
                    loaded = true;
                }
            }
            catch (Exception reader2) {
                // empty catch block
            }
        }
        if (!loaded && (file = this.getCsvFile()).exists()) {
            try {
                String line;
                reader2 = new BufferedReader(new FileReader(file));
                ((BufferedReader)reader2).readLine();
                while ((line = ((BufferedReader)reader2).readLine()) != null) {
                    PortalPattern p;
                    String[] values = line.split(",");
                    p = new PortalPattern(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
                    this.portalPatterns.add(p);
                    this.loggedPortalPositions.add(new class_2338(p.x, p.y, p.z));
                }
                ((BufferedReader)reader2).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveCsv() {
        try {
            File file = this.getCsvFile();
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            writer.write("X,Y,Z\n");
            for (PortalPattern p : this.portalPatterns) {
                p.write(writer);
            }
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveJson() {
        try {
            File file = this.getJsonFile();
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            GSON.toJson(this.portalPatterns, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getJsonFile() {
        return new File(new File(new File("TrouserStreak", "PortalPatterns"), Utils.getFileWorldName()), "portalpatterns.json");
    }

    private File getCsvFile() {
        return new File(new File(new File("TrouserStreak", "PortalPatterns"), Utils.getFileWorldName()), "portalpatterns.csv");
    }

    private static class PortalPattern {
        private static final StringBuilder sb = new StringBuilder();
        public int x;
        public int y;
        public int z;

        public PortalPattern(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void write(Writer writer) throws IOException {
            sb.setLength(0);
            sb.append(this.x).append(',').append(this.y).append(',').append(this.z).append('\n');
            writer.write(sb.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PortalPattern pattern = (PortalPattern)o;
            return this.x == pattern.x && this.y == pattern.y && this.z == pattern.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }
}

