/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.enums.Role;

public class SocketChannelIOHelper {
    private SocketChannelIOHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean read(ByteBuffer buf, WebSocketImpl ws2, ByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.read(buf);
        buf.flip();
        if (read == -1) {
            ws2.eot();
            return false;
        }
        return read != 0;
    }

    public static boolean readMore(ByteBuffer buf, WebSocketImpl ws2, WrappedByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.readMore(buf);
        buf.flip();
        if (read == -1) {
            ws2.eot();
            return false;
        }
        return channel.isNeedRead();
    }

    public static boolean batch(WebSocketImpl ws2, ByteChannel sockchannel) throws IOException {
        if (ws2 == null) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)ws2.outQueue.peek();
        WrappedByteChannel c = null;
        if (buffer == null) {
            if (sockchannel instanceof WrappedByteChannel && (c = (WrappedByteChannel)sockchannel).isNeedWrite()) {
                c.writeMore();
            }
        } else {
            do {
                sockchannel.write(buffer);
                if (buffer.remaining() > 0) {
                    return false;
                }
                ws2.outQueue.poll();
            } while ((buffer = (ByteBuffer)ws2.outQueue.peek()) != null);
        }
        if (ws2.outQueue.isEmpty() && ws2.isFlushAndClose() && ws2.getDraft() != null && ws2.getDraft().getRole() != null && ws2.getDraft().getRole() == Role.SERVER) {
            ws2.closeConnection();
        }
        return c == null || !((WrappedByteChannel)sockchannel).isNeedWrite();
    }
}

