/*
 * Decompiled with CFR 0.152.
 */
package spigey.asteroide.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import meteordevelopment.meteorclient.events.game.ReceiveMessageEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import spigey.asteroide.AsteroideAddon;
import spigey.asteroide.util;

public class AutoChatGame
extends Module {
    private final SettingGroup sgTriggers;
    private final SettingGroup sgFilters;
    private final SettingGroup sgDelay;
    private final SettingGroup sgChat;
    private final Setting<List<String>> messages;
    private final Setting<List<String>> reversers;
    private final Setting<List<String>> mether;
    private final Setting<List<String>> filltriggers;
    private final Setting<List<String>> scramble;
    private final Setting<List<String>> quotes;
    private final Setting<List<String>> contain;
    private final Setting<List<String>> dont;
    private final Setting<Mode> mode;
    private final Setting<Integer> delay;
    private final Setting<Integer> minoffset;
    private final Setting<Integer> maxoffset;
    private final Setting<Boolean> hidetr;
    private final Setting<Boolean> shmsg;
    private final Setting<Boolean> showsul;
    private final Setting<Boolean> triviaEnabled;
    private final Setting<String> variableSolveFor;
    private int tick;
    private String solution;
    private final Random rand;
    private final Map<String, String> trivia;
    private final Setting<List<String>> unscramble;
    private final Setting<List<String>> fillout;
    private List<String> buffer;
    private boolean isVariable;

    public AutoChatGame() {
        super(AsteroideAddon.CATEGORY, "Auto-Chatgame", "Automatically answers most chat games when triggered");
        this.sgTriggers = this.settings.createGroup("Triggers", true);
        this.sgFilters = this.settings.createGroup("Filters", true);
        this.sgDelay = this.settings.createGroup("Delay", true);
        this.sgChat = this.settings.createGroup("Chat", true);
        this.messages = this.sgTriggers.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("say")).description("Strings that will say the solution")).defaultValue(new String[]{"say", "type", "write"}).build());
        this.reversers = this.sgTriggers.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("reverse")).description("Strings that will reverse the solution")).defaultValue(new String[]{"reverse"}).build());
        this.mether = this.sgTriggers.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("math")).description("Strings that will solve an equation as solution")).defaultValue(new String[]{"solve", "equation", "calculate"}).build());
        this.filltriggers = this.sgTriggers.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("fillout")).description("Strings that will fill in a word as solution")).defaultValue(new String[]{"fill in", "fillout"}).build());
        this.scramble = this.sgTriggers.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("unscramble")).description("Strings that will unscramble a word as solution")).defaultValue(new String[]{"unscramble"}).build());
        this.quotes = this.sgFilters.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("quotes")).description("Quotes")).defaultValue(new String[]{"\"", "'", "`"}).build());
        this.contain = this.sgFilters.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("must contain all")).description("Requires the message to contain all of these Strings")).defaultValue(new String[0]).build());
        this.dont = this.sgFilters.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("must not contain")).description("Do not solve the chatgame if it contains one of these Strings")).defaultValue(new String[]{"correctly unscrambled", "was the fastest to"}).build());
        this.mode = this.sgDelay.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("delay type")).description("Whether it waits for a random or precise amount of time")).defaultValue((Object)Mode.Random)).build());
        this.delay = this.sgDelay.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("The delay before sending the solution in ticks")).defaultValue((Object)30)).min(0).sliderMax(200).build());
        this.minoffset = this.sgDelay.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay min offset")).description("Minimum offset from the delay in ticks")).defaultValue((Object)0)).min(0).sliderMax(40).visible(() -> this.mode.get() == Mode.Random)).build());
        this.maxoffset = this.sgDelay.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay max offset")).description("Maximum offset from the delay in ticks")).defaultValue((Object)10)).min(0).sliderMax(40).visible(() -> this.mode.get() == Mode.Random)).build());
        this.hidetr = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Hide Triggers")).description("Hides messages that trigger the chatgame module")).defaultValue((Object)false)).build());
        this.shmsg = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Shorter message instead")).description("Shows a shorter chatgame message instead")).defaultValue((Object)false)).visible(() -> this.hidetr.get())).build());
        this.showsul = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Show solution")).description("Shows you the chatgame solution instead of sending it automatically")).defaultValue((Object)false)).build());
        this.triviaEnabled = this.sgChat.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Solve Trivia")).description("Solves Trivia Games")).defaultValue((Object)true)).build());
        this.variableSolveFor = this.sgFilters.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Variable game X")).description("Solves for the specified string")).defaultValue((Object)"\u2717")).build());
        this.solution = "";
        this.rand = new Random();
        this.trivia = Map.of("in what planet do we live in?", "Earth", "how many sides does a dice have? (number)", "6");
        this.unscramble = this.sgChat.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("unscramble words")).description("Words to unscramble")).defaultValue(new String[]{"Day", "Night", "Morning", "Afternoon"}).build());
        this.fillout = this.sgChat.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("fillout words")).description("Words to unscramble")).defaultValue(new String[]{"Minecraft", "Iron", "Diamond", "Lava"}).build());
        this.buffer = new ArrayList<String>();
        this.isVariable = false;
    }

    public void onActivate() {
        this.tick = -1;
    }

    @EventHandler
    private void onMessageReceive(ReceiveMessageEvent event) {
        try {
            if (!this.isActive()) {
                return;
            }
            GameMode gameMode = GameMode.NONE;
            String content = event.getMessage().getString();
            String Quote = null;
            String game = null;
            for (String msg : (List)this.messages.get()) {
                if (!content.toLowerCase().contains(msg.toLowerCase())) continue;
                gameMode = GameMode.STRING;
                break;
            }
            for (String msg : (List)this.reversers.get()) {
                if (!content.toLowerCase().contains(msg.toLowerCase())) continue;
                gameMode = GameMode.REVERSE;
                break;
            }
            for (String msg : (List)this.mether.get()) {
                if (!content.toLowerCase().contains(msg.toLowerCase())) continue;
                gameMode = GameMode.SOLVE;
                break;
            }
            for (String msg : (List)this.filltriggers.get()) {
                if (!content.toLowerCase().contains(msg.toLowerCase())) continue;
                gameMode = GameMode.FILLOUT;
                break;
            }
            for (String msg : (List)this.scramble.get()) {
                if (!content.toLowerCase().contains(msg.toLowerCase())) continue;
                gameMode = GameMode.UNSCRAMBLE;
                break;
            }
            if (((Boolean)this.triviaEnabled.get()).booleanValue()) {
                for (String msg : this.trivia.keySet()) {
                    if (!content.trim().toLowerCase().startsWith(String.format("`%s`", msg.toLowerCase()))) continue;
                    gameMode = GameMode.TRIVIA;
                    break;
                }
            }
            if (content.toLowerCase().contains(String.format("solve for: `%s`", ((String)this.variableSolveFor.get()).toLowerCase()))) {
                this.isVariable = true;
                return;
            }
            if (this.isVariable && ((Boolean)this.hidetr.get()).booleanValue()) {
                event.cancel();
            }
            if (!this.isVariable) {
                for (String msg : (List)this.contain.get()) {
                    if (content.toLowerCase().contains(msg.toLowerCase())) continue;
                    return;
                }
                for (String msg : (List)this.dont.get()) {
                    if (!content.toLowerCase().contains(msg.toLowerCase())) continue;
                    return;
                }
                for (String quote : (List)this.quotes.get()) {
                    if (!content.contains(quote)) continue;
                    Quote = quote;
                }
                if (gameMode == GameMode.NONE || Quote == null) {
                    return;
                }
                game = content.split(Quote)[1];
            } else {
                if (!content.contains("=")) {
                    return;
                }
                this.buffer.add(content.trim());
                if (!content.contains(String.format(" + %s = ", this.variableSolveFor.get()))) {
                    return;
                }
                gameMode = GameMode.VARIABLE;
            }
            if (((Boolean)this.hidetr.get()).booleanValue()) {
                if (((Boolean)this.shmsg.get()).booleanValue()) {
                    event.setMessage(class_2561.method_30163((String)String.format("\u00a77[\u00a79ChatGame\u00a77]\u00a7f %s `%s`!", new Object[]{gameMode, game})));
                } else {
                    event.cancel();
                }
            }
            try {
                this.solution = switch (gameMode.ordinal()) {
                    case 2 -> String.valueOf((int)util.meth(game));
                    case 1 -> new StringBuilder(game).reverse().toString();
                    case 3 -> game;
                    case 4 -> this.fillout(game);
                    case 5 -> this.unscramble(game);
                    case 6 -> this.trivia.getOrDefault(game.trim().toLowerCase(), "");
                    case 7 -> String.valueOf(this.variableSolution(2) - this.variableSolution(0) / 3 - this.variableSolution(1) / 3);
                    default -> "";
                };
            }
            catch (Exception e) {
                this.info("\u00a78\u00a7l[\u00a74\u00a7lX\u00a78\u00a7l] \u00a7c" + e.getMessage(), new Object[0]);
                return;
            }
            if (this.mode.get() == Mode.Precise) {
                this.tick = (Integer)this.delay.get();
            } else {
                int rdm = this.rand.nextInt((Integer)this.maxoffset.get() - (Integer)this.minoffset.get() + 1) + (Integer)this.minoffset.get();
                if (Math.random() > 0.5) {
                    rdm = -rdm;
                }
                this.tick = (Integer)this.delay.get() + rdm;
            }
            if (this.tick == 0) {
                this.run();
            } else {
                --this.tick;
            }
            this.isVariable = false;
            this.buffer.clear();
        }
        catch (Exception L) {
            this.info("\u00a78\u00a7l[\u00a74\u00a7lX\u00a78\u00a7l] \u00a7c" + L.getMessage(), new Object[0]);
        }
    }

    private int variableSolution(int index) {
        try {
            return Integer.parseInt(this.buffer.get(index).split("= ")[1].trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String fillout(String game) {
        for (String sample : (List)this.fillout.get()) {
            if (sample.length() != game.length()) continue;
            char[] chr = sample.toCharArray();
            for (int i = 0; i < chr.length; ++i) {
                if (game.charAt(i) != '_') continue;
                chr[i] = 95;
            }
            if (!new String(chr).equals(game)) continue;
            return sample;
        }
        this.error("Could not find word to fill out " + game, new Object[0]);
        return "";
    }

    private String unscramble(String game) {
        for (String sample : (List)this.unscramble.get()) {
            if (sample.length() != game.length()) continue;
            char[] chr = sample.toCharArray();
            char[] gameChr = game.toCharArray();
            Arrays.sort(chr);
            Arrays.sort(gameChr);
            if (!Arrays.equals(chr, gameChr)) continue;
            return sample;
        }
        this.error("Could not find word to unscramble " + game, new Object[0]);
        return "";
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.isActive() || this.tick == -1) {
            return;
        }
        if (this.tick > 0) {
            --this.tick;
            return;
        }
        this.run();
    }

    private void run() {
        if (((Boolean)this.showsul.get()).booleanValue()) {
            ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("\u00a78[\u00a79\ud83d\udec8\u00a78] \u00a77The solution is \u00a7e" + this.solution + "\u00a77.")));
        } else {
            util.msg(this.solution);
        }
        this.tick = -1;
    }

    public static enum Mode {
        Random,
        Precise;

    }

    private static enum GameMode {
        NONE,
        REVERSE,
        SOLVE,
        STRING,
        FILLOUT,
        UNSCRAMBLE,
        TRIVIA,
        VARIABLE;

    }
}

