/*
 * Decompiled with CFR 0.152.
 */
package spigey.asteroide.modules;

import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.utils.StarscriptTextBoxRenderer;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.settings.Vector3dSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.misc.MeteorStarscript;
import meteordevelopment.orbit.EventHandler;
import meteordevelopment.starscript.Script;
import meteordevelopment.starscript.compiler.Compiler;
import meteordevelopment.starscript.compiler.Parser;
import meteordevelopment.starscript.utils.Error;
import meteordevelopment.starscript.utils.StarscriptError;
import net.minecraft.class_243;
import org.joml.Vector3d;
import spigey.asteroide.AsteroideAddon;
import spigey.asteroide.util;

public class AutoCommandModule
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Vector3d> start;
    private final Setting<Vector3d> end;
    private final Setting<String> command;
    private final Setting<Integer> delay;
    private int tick;

    public AutoCommandModule() {
        super(AsteroideAddon.CATEGORY, "Auto-Command", "Automatically runs a command when you are in a specific area.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.start = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("Start Position  ")).description("Start position of the area.")).defaultValue(new Vector3d(-20.0, -60.0, -20.0)).noSlider().build());
        this.end = this.sgGeneral.add((Setting)((Vector3dSetting.Builder)((Vector3dSetting.Builder)new Vector3dSetting.Builder().name("End Position  ")).description("End position of the area.")).defaultValue(new Vector3d(20.0, 100.0, 20.0)).noSlider().build());
        this.command = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Command")).description("The command to run.")).renderer(StarscriptTextBoxRenderer.class).defaultValue((Object)"/home")).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Delay")).description("Delay between command executions in ticks.")).defaultValue((Object)20)).min(1).sliderMin(1).sliderMax(100).build());
        this.tick = (Integer)this.delay.get();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.tick > 0) {
            --this.tick;
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_243 pos = this.mc.field_1724.method_19538();
        if ((double)((int)Math.floor(pos.field_1352)) < Math.min(((Vector3d)this.start.get()).x, ((Vector3d)this.end.get()).x) || (double)((int)Math.floor(pos.field_1352)) > Math.max(((Vector3d)this.start.get()).x, ((Vector3d)this.end.get()).x) || (double)((int)Math.floor(pos.field_1351)) < Math.min(((Vector3d)this.start.get()).y, ((Vector3d)this.end.get()).y) || (double)((int)Math.floor(pos.field_1351)) > Math.max(((Vector3d)this.start.get()).y, ((Vector3d)this.end.get()).y) || (double)((int)Math.floor(pos.field_1350)) < Math.min(((Vector3d)this.start.get()).z, ((Vector3d)this.end.get()).z) || (double)((int)Math.floor(pos.field_1350)) > Math.max(((Vector3d)this.start.get()).z, ((Vector3d)this.end.get()).z)) {
            return;
        }
        String output = AutoCommandModule.compile((String)this.command.get());
        if (output != null) {
            util.msg(output);
        }
        this.tick = (Integer)this.delay.get();
    }

    private static String compile(String script) {
        if (script == null) {
            return null;
        }
        Parser.Result result = Parser.parse((String)script);
        if (result.hasErrors()) {
            MeteorStarscript.printChatError((Error)((Error)result.errors.get(0)));
            return null;
        }
        Script compiled = Compiler.compile((Parser.Result)result);
        if (compiled == null) {
            return null;
        }
        try {
            return MeteorStarscript.ss.run((Script)compiled).text;
        }
        catch (StarscriptError e) {
            MeteorStarscript.printChatError((StarscriptError)e);
            return null;
        }
    }
}

