/*
 * Decompiled with CFR 0.152.
 */
package spigey.asteroide.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.ParticleEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EntityTypeListSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ParticleTypeListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1671;
import net.minecraft.class_1937;
import net.minecraft.class_2396;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2663;
import net.minecraft.class_2675;
import spigey.asteroide.AsteroideAddon;

public class BetterAntiCrashModule
extends Module {
    final SettingGroup sgEntities;
    private final Setting<Set<class_1299<?>>> entities;
    private final Setting<Boolean> EntityLimit;
    private final Setting<Integer> EntityThreshold;
    private final Setting<Set<class_1299<?>>> excludeFromThreshold;
    final SettingGroup sgParticles;
    private final Setting<List<class_2396<?>>> particles;
    private final Setting<Boolean> DeleteParticles;
    private final Setting<Integer> Threshold;
    final SettingGroup sgOther;
    private final Setting<Boolean> CancelFireworks;
    private final Setting<Boolean> translationCrash;
    public final Setting<List<String>> translations;
    private Map<class_1299<?>, Integer> entityCounts;

    public BetterAntiCrashModule() {
        super(AsteroideAddon.CATEGORY, "Better-Anti-Crash", "Fixes crashes from too many entities/particles/fireworks & invalid translations.");
        this.sgEntities = this.settings.createGroup("Entities", true);
        this.entities = this.sgEntities.add((Setting)((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)new EntityTypeListSetting.Builder().name("entities")).description("Disables spawning of selected entities.")).build());
        this.EntityLimit = this.sgEntities.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Entity Limit Enabled")).description("Cancels entity spawning at a specific threshold.")).defaultValue((Object)true)).build());
        this.EntityThreshold = this.sgEntities.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Entity Limit")).description("Cancels entities X from spawning when there are more than X entities in the world.")).defaultValue((Object)2000)).min(-1).sliderMin(0).sliderMax(10000).max(Integer.MAX_VALUE).visible(() -> this.EntityLimit.get())).build());
        this.excludeFromThreshold = this.sgEntities.add((Setting)((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)new EntityTypeListSetting.Builder().name("Entity Limit Exclusions")).description("Excludes entities from the entity limit threshold.")).defaultValue(Set.of(class_1299.field_6097, class_1299.field_6052))).build());
        this.sgParticles = this.settings.createGroup("Particles", true);
        this.particles = this.sgParticles.add((Setting)((ParticleTypeListSetting.Builder)((ParticleTypeListSetting.Builder)new ParticleTypeListSetting.Builder().name("particles")).description("Particles to not block.")).build());
        this.DeleteParticles = this.sgParticles.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Cancel Particles")).description("Cancels particle spawning at a specific threshold.")).defaultValue((Object)true)).build());
        this.Threshold = this.sgParticles.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Particle Threshold")).description("Minimum threshold to start cancelling particles.")).defaultValue((Object)2000)).min(-1).sliderMin(0).sliderMax(10000).max(Integer.MAX_VALUE).visible(() -> this.DeleteParticles.get())).build());
        this.sgOther = this.settings.createGroup("Other", true);
        this.CancelFireworks = this.sgOther.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Cancel Fireworks")).description("Cancels Fireworks from spawning particles.")).defaultValue((Object)false)).build());
        this.translationCrash = this.sgOther.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Block Invalid Translations")).description("Cancels invalid translation strings.")).defaultValue((Object)true)).build());
        this.translations = this.sgOther.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("translations")).description("Translation strings to block")).defaultValue(new String[]{"%1$s"}).visible(() -> this.translationCrash.get())).build());
        this.entityCounts = new HashMap();
    }

    public boolean shouldRender(class_1297 entity) {
        if (entity == this.mc.field_1724) {
            return true;
        }
        if (entity == null || entity.method_31481()) {
            return false;
        }
        return !((Set)this.entities.get()).contains(entity.method_5864());
    }

    @EventHandler(priority=201)
    private void onReceivePacket(PacketEvent.Receive event) {
        class_2596 class_25962;
        if (event.packet instanceof class_2675 && ((Boolean)this.DeleteParticles.get()).booleanValue() && ((class_2675)event.packet).method_11545() >= (Integer)this.Threshold.get()) {
            event.cancel();
        }
        if (event.packet instanceof class_2663 && ((class_2663)event.packet).method_11469((class_1937)this.mc.field_1687) instanceof class_1671 && ((Boolean)this.CancelFireworks.get()).booleanValue()) {
            event.cancel();
        }
        if (!((class_25962 = event.packet) instanceof class_2604)) {
            return;
        }
        class_2604 packet = (class_2604)class_25962;
        if (((Set)this.entities.get()).contains(packet.method_11169())) {
            event.cancel();
        }
        if (this.entityCounts.getOrDefault(packet.method_11169(), 0) + 1 > (Integer)this.EntityThreshold.get() && ((Boolean)this.EntityLimit.get()).booleanValue()) {
            event.cancel();
        }
    }

    @EventHandler
    private void onAddParticle(ParticleEvent event) {
        if (((List)this.particles.get()).contains(event.particle.method_10295())) {
            event.cancel();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!((Boolean)this.EntityLimit.get()).booleanValue()) {
            return;
        }
        class_1297[] entities = (class_1297[])StreamSupport.stream(this.mc.field_1687.method_18112().spliterator(), false).toArray(class_1297[]::new);
        if (entities.length < (Integer)this.EntityThreshold.get()) {
            this.entityCounts = new HashMap();
            return;
        }
        ArrayList<class_1299> remove = new ArrayList<class_1299>();
        HashMap thisCounts = new HashMap();
        for (class_1297 entity : entities) {
            if (entity == this.mc.field_1724) continue;
            class_1299 type = entity.method_5864();
            if (((Set)this.excludeFromThreshold.get()).contains(type)) continue;
            if (remove.contains(type)) {
                entity.method_31745(class_1297.class_5529.field_26999);
                continue;
            }
            thisCounts.put(type, thisCounts.getOrDefault(type, 0) + 1);
            if (thisCounts.getOrDefault(type, 0) <= (Integer)this.EntityThreshold.get()) continue;
            entity.method_31745(class_1297.class_5529.field_26999);
            remove.add(type);
        }
        this.entityCounts = thisCounts;
    }

    public void onActivate() {
        this.mc.field_1687.method_18112().forEach(entity -> {
            if (!this.shouldRender((class_1297)entity)) {
                entity.method_31745(class_1297.class_5529.field_26999);
            }
        });
    }
}

