/*
 * Decompiled with CFR 0.152.
 */
package spigey.asteroide.modules;

import java.util.Set;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.settings.PacketListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.network.PacketUtils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import spigey.asteroide.AsteroideAddon;

public class PacketLoggerModule
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Set<Class<? extends class_2596<?>>>> s2cPackets;
    private final Setting<Set<Class<? extends class_2596<?>>>> c2sPackets;

    public PacketLoggerModule() {
        super(AsteroideAddon.CATEGORY, "Packet-Logger", "Logs sent/received packets");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.s2cPackets = this.sgGeneral.add((Setting)((PacketListSetting.Builder)((PacketListSetting.Builder)new PacketListSetting.Builder().name("S2C-packets")).description("Server-to-client packets to log.")).filter(aClass -> PacketUtils.getS2CPackets().contains(aClass)).build());
        this.c2sPackets = this.sgGeneral.add((Setting)((PacketListSetting.Builder)((PacketListSetting.Builder)new PacketListSetting.Builder().name("C2S-packets")).description("Client-to-server packets to log.")).filter(aClass -> PacketUtils.getC2SPackets().contains(aClass)).build());
    }

    @EventHandler(priority=201)
    private void onReceivePacket(PacketEvent.Receive event) {
        if (((Set)this.s2cPackets.get()).contains(event.packet.getClass())) {
            ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("\u00a77" + event.packet.getClass().getSimpleName() + " was received!")));
        }
    }

    @EventHandler(priority=201)
    private void onSendPacket(PacketEvent.Send event) {
        if (((Set)this.c2sPackets.get()).contains(event.packet.getClass())) {
            ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("\u00a77" + event.packet.getClass().getSimpleName() + " was sent!")));
        }
    }
}

