/*
 * Decompiled with CFR 0.152.
 */
package spigey.asteroide.modules;

import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import spigey.asteroide.AsteroideAddon;
import spigey.asteroide.utils.ws;

public class RTCSettingsModule
extends Module {
    private final SettingGroup sgGeneral;
    public final Setting<colors> color;
    public final Setting<format> formath;
    public final Setting<Boolean> hideMessages;
    public final Setting<Boolean> disableIcon;
    public final Setting<Boolean> censor;
    public final Setting<Boolean> broadcastOnline;

    public RTCSettingsModule() {
        super(AsteroideAddon.CATEGORY, "RTC-Settings", "Settings for the .rtc command. Enable to apply settings.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.color = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("chat-color")).description("Chat Color.")).defaultValue((Object)colors.aqua)).build());
        this.formath = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("chat-format")).description("Chat Format.")).defaultValue((Object)format.none)).build());
        this.hideMessages = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Hide RTC Messages")).description("Hides all messages received from the RTC.")).defaultValue((Object)false)).onChanged(value -> {
            AsteroideAddon.showRtc = value == false || !this.isActive();
        })).build());
        this.disableIcon = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Highlight Asteroide Users in the tab list")).description("Highlights Asteroide users in the player list with a custom icon.")).defaultValue((Object)true)).build());
        this.censor = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Censor Slurs")).description("Censors slurs in the RTC")).defaultValue((Object)false)).build());
        this.broadcastOnline = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Get notified when someone comes online")).description("Self explanatory")).onChanged(value -> ws.call("online", this.isActive() && value != false))).defaultValue((Object)false)).build());
    }

    public void onActivate() {
        ws.call("online", this.isActive() && (Boolean)this.broadcastOnline.get() != false);
    }

    public void onDeactivate() {
        ws.call("online", false);
    }

    public static enum colors {
        dark_red,
        red,
        gold,
        yellow,
        dark_green,
        green,
        aqua,
        dark_aqua,
        dark_blue,
        blue,
        light_purple,
        dark_purple,
        white,
        gray,
        dark_gray,
        black;

    }

    public static enum format {
        none,
        bold,
        italic,
        underline,
        strike,
        obfuscated;

    }
}

