/*
 * Decompiled with CFR 0.152.
 */
package spigey.asteroide.modules;

import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_742;
import spigey.asteroide.AsteroideAddon;

public class TrackerModule
extends Module {
    private final double[] last = new double[3];
    private long lastTickTime = 0L;
    private double partialTicks;
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final Setting<Double> interpolation = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("interpolation")).description("Smoothing factor to prevent motion sickness")).defaultValue(0.2).min(0.0).max(100.0).sliderMax(3.0).build());
    private final Setting<Boolean> render = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Renders a yellow box on the tracked player when enabled.")).defaultValue((Object)true)).build());

    public TrackerModule() {
        super(AsteroideAddon.CATEGORY, "Tracker", "Tracks a player by always looking at it. Use with .track <player>");
    }

    public void onActivate() {
        this.lastTickTime = System.currentTimeMillis();
        if (AsteroideAddon.trackedPlayer != null && this.mc.method_1562() != null && this.mc.method_1562().method_2880().stream().noneMatch(player -> player.method_2966().getName().equals(AsteroideAddon.trackedPlayer))) {
            ChatUtils.sendMsg((class_2561)class_2561.method_30163((String)("\u00a77Tracker enabled, use " + (String)Config.get().prefix.get() + "track <player> to start tracking someone. \u00a7cThe tracked Player must be loaded!")));
        }
    }

    @EventHandler
    public void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        long currentTickTime = System.currentTimeMillis();
        this.partialTicks = (double)(currentTickTime - this.lastTickTime) / 50.0;
        this.lastTickTime = currentTickTime;
    }

    @EventHandler
    public void onRender(Render3DEvent event) {
        if (AsteroideAddon.trackedPlayer == null || this.mc.field_1724 == null) {
            return;
        }
        class_742 entity = null;
        for (class_742 player : this.mc.field_1687.method_18456()) {
            if (!player.method_7334().getName().equals(AsteroideAddon.trackedPlayer)) continue;
            entity = player;
            break;
        }
        if (entity == null) {
            this.mc.field_1705.method_1758(class_2561.method_30163((String)"\u00a7cPlayer not found, pointing to last known location"), false);
            this.mc.field_1724.method_5702(class_2183.class_2184.field_9851, new class_243(AsteroideAddon.lastPos[0], AsteroideAddon.lastPos[1], AsteroideAddon.lastPos[2]));
            return;
        }
        AsteroideAddon.lastPos = new double[]{entity.method_23317(), entity.method_23318(), entity.method_23321()};
        this.mc.field_1705.method_1758(class_2561.method_30163((String)String.format("\u00a77Tracking %s at \u00a7cX: %.0f\u00a77, \u00a7aY: %.0f\u00a77, \u00a79Z: %.0f", AsteroideAddon.trackedPlayer, entity.method_23317(), entity.method_23318(), entity.method_23321())), false);
        double[] geminiwtf = new double[]{entity.method_23317(), entity.method_23318(), entity.method_23321()};
        for (int i = 0; i < 3; ++i) {
            this.last[i] = class_3532.method_16436((double)(this.partialTicks * (Double)this.interpolation.get()), (double)this.last[i], (double)(i == 1 ? entity.method_23320() : geminiwtf[i]));
        }
        if (((Boolean)this.render.get()).booleanValue()) {
            this.draw(event, (class_1297)entity);
        }
        this.mc.field_1724.method_5702(class_2183.class_2184.field_9851, new class_243(this.last[0], this.last[1], this.last[2]));
    }

    private void draw(Render3DEvent event, class_1297 entity) {
        double x = class_3532.method_16436((double)event.tickDelta, (double)entity.field_6038, (double)entity.method_23317()) - entity.method_23317();
        double y = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5971, (double)entity.method_23318()) - entity.method_23318();
        double z = class_3532.method_16436((double)event.tickDelta, (double)entity.field_5989, (double)entity.method_23321()) - entity.method_23321();
        class_238 box = entity.method_5829();
        event.renderer.box(x + box.field_1323, y + box.field_1322, z + box.field_1321, x + box.field_1320, y + box.field_1325, z + box.field_1324, new Color(255, 255, 0, 128), new Color(255, 255, 0, 255), ShapeMode.Both, 0);
    }
}

