/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import dev.stardust.util.commands.ApiHandler;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class FirstSeen2b2t
extends Command {
    private final String API_ENDPOINT = "/seen?playerName=";

    public FirstSeen2b2t() {
        super("firstseen2b2t", "Check the first-seen status of a 2b2t player.", new String[]{"fs"});
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(FirstSeen2b2t.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            MeteorExecutor.execute(() -> {
                class_746 player = class_310.method_1551().field_1724;
                String playerString = (String)ctx.getArgument("player", String.class);
                String requestString = "https://api.2b2t.vc/seen?playerName=" + playerString.trim();
                String response = new ApiHandler().fetchResponse(requestString);
                if (response == null) {
                    return;
                }
                if (response.equals("204 Undocumented") || response.contains("\"firstSeen\":null,")) {
                    if (player == null) {
                        return;
                    }
                    player.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u00a7o\u2728\u00a7r\u00a78> \u00a74\u00a7oThat player has not been seen\u00a77...")), false);
                } else {
                    JsonElement seenJson = JsonParser.parseString((String)response);
                    if (seenJson.getAsJsonObject().has("firstSeen")) {
                        String firstSeen = seenJson.getAsJsonObject().get("firstSeen").getAsString();
                        Instant instant = Instant.parse(firstSeen);
                        ZonedDateTime zonedTime = instant.atZone(ZoneId.systemDefault());
                        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("MMMM dd yyyy, HH:mm", Locale.US);
                        String cc = StardustUtil.rCC();
                        String formattedTimestamp = String.join((CharSequence)(" \u00a7r\u00a77at " + cc + "\u00a7o"), zonedTime.format(fmt).split(", "));
                        if (player != null) {
                            player.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u00a7o\u2728\u00a7r\u00a78> " + cc + "\u00a7o" + playerString + "\u00a7r\u00a77 was first seen on " + cc + "\u00a7o" + formattedTimestamp + "\u00a77.")), false);
                        }
                    } else {
                        ApiHandler.sendErrorResponse();
                        LogUtil.warn("Received unexpected output from api.2b2t.vc: \"" + String.valueOf(seenJson) + "\"", this.getName());
                    }
                }
            });
            return 1;
        }));
    }
}

