/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.stardust.hud.ConwayHud;
import dev.stardust.util.MsgUtil;
import dev.stardust.util.StardustUtil;
import java.text.DecimalFormat;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2172;

public class Life
extends Command {
    private int timer = 0;
    private int monRate = 20;
    private boolean monitoring = false;

    public Life() {
        super("life", "Companion command for the Conway's Game of Life HUD Module.", new String[0]);
        MeteorClient.EVENT_BUS.subscribe((Object)this);
    }

    @EventHandler
    private void onGameJoin(GameJoinedEvent event) {
        this.timer = 0;
        this.monitoring = false;
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        this.timer = 0;
        this.monitoring = false;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!Utils.canUpdate() || !this.monitoring) {
            return;
        }
        ++this.timer;
        if (this.timer >= this.monRate) {
            this.timer = 0;
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)element);
                    if (!hud.firstTick) {
                        MsgUtil.updateMsg(this.getSimulationStats(hud), "monitorConway".hashCode());
                    }
                }
            });
        }
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(Life.literal((String)"new").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.firstTick = true;
                    MsgUtil.sendModuleMsg("Simulation reset\u00a7a..!", "Conway");
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"pause").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.isPaused = !hud.isPaused;
                    MsgUtil.sendModuleMsg("Simulation " + (hud.isPaused ? "\u00a7cpaused\u00a77." : "\u00a7aresumed\u00a77."), "Conway");
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"resume").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.isPaused = !hud.isPaused;
                    MsgUtil.sendModuleMsg("Simulation " + (hud.isPaused ? "\u00a7cpaused\u00a77." : "\u00a7aresumed\u00a77."), "Conway");
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"hide").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.isVisible = !hud.isVisible;
                    MsgUtil.sendModuleMsg("Simulation " + (hud.isVisible ? "\u00a7ashown\u00a77." : "\u00a7chidden\u00a77."), "Conway");
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"show").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.isVisible = !hud.isVisible;
                    MsgUtil.sendModuleMsg("Simulation " + (hud.isVisible ? "\u00a7ashown\u00a77." : "\u00a7chidden\u00a77."), "Conway");
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"visibility").then(Life.literal((String)"always").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.visibility.set((Object)ConwayHud.Visibility.Always);
                    MsgUtil.sendModuleMsg("Successfully updated visibility.", "Conway");
                }
            });
            return 1;
        })));
        builder.then(Life.literal((String)"visibility").then(Life.literal((String)"windows").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.visibility.set((Object)ConwayHud.Visibility.Windows);
                    MsgUtil.sendModuleMsg("Successfully updated visibility.", "Conway");
                }
            });
            return 1;
        })));
        builder.then(Life.literal((String)"visibility").then(Life.literal((String)"widgets").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    hud.visibility.set((Object)ConwayHud.Visibility.Widgets);
                    MsgUtil.sendModuleMsg("Successfully updated visibility.", "Conway");
                }
            });
            return 1;
        })));
        builder.then(Life.literal((String)"step").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    if (!hud.isPaused) {
                        MsgUtil.sendModuleMsg("Simulation must be paused to step manually\u00a7c..!", "Conway");
                    } else {
                        hud.stepSimulation();
                    }
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"step").then(Life.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int step = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    if (!hud.isPaused) {
                        MsgUtil.sendModuleMsg("Simulation must be paused to step manually\u00a7c..!", "Conway");
                    } else {
                        for (int n = 0; n < step; ++n) {
                            hud.stepSimulation();
                        }
                    }
                }
            });
            return 1;
        })));
        builder.then(Life.literal((String)"stats").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    ConwayHud hud = (ConwayHud)((Object)((Object)element));
                    MsgUtil.sendModuleMsg("\n" + this.getSimulationStats(hud), "Conway");
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"monitor").executes(ctx -> {
            Hud.get().forEach(element -> {
                if (element instanceof ConwayHud) {
                    this.monitoring = !this.monitoring;
                }
            });
            return 1;
        }));
        builder.then(Life.literal((String)"monitor").then(Life.argument((String)"tickRate", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            this.monRate = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"tickRate");
            return 1;
        })));
    }

    private String getSimulationStats(ConwayHud hud) {
        ConwayHud.Ruleset rules = hud.gameRules.rules();
        Object name = rules.equals((Object)ConwayHud.Ruleset.Custom) ? "Custom(" + ((String)hud.customRules.get()).toUpperCase() + ")" : rules.method_15434();
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a77Ruleset\u00a7f: \u00a77");
        boolean inBracket = false;
        for (char c : ((String)name).toCharArray()) {
            if (c == '(') {
                inBracket = true;
                sb.append("\u00a78\u00a7o").append(c);
                continue;
            }
            if (c == ')') {
                inBracket = false;
                sb.append("\u00a78\u00a7o").append(c).append("\u00a77\u00a7o");
                continue;
            }
            if (inBracket && Character.isDigit(c) || c == '+') {
                sb.append(StardustUtil.rCC()).append("\u00a7o").append(c);
                continue;
            }
            if (inBracket && c == 'B' || c == 'S' || c == 'C' || c == 'R') {
                sb.append("\u00a7f\u00a7o").append(c);
                continue;
            }
            if (inBracket && c == '/') {
                sb.append("\u00a78\u00a7o").append(c);
                continue;
            }
            sb.append(c);
        }
        DecimalFormat df = new DecimalFormat("#.##");
        sb.append("\n\u00a77Cell size\u00a7f: ").append("\u00a7e\u00a7o").append(hud.getCellSize());
        sb.append("\n\u00a77Grid size\u00a7f: ").append("\u00a7e\u00a7o").append(hud.getGridSize());
        sb.append("\n\u00a77Generation\u00a7f: ").append("\u00a75\u00a7o").append(hud.getGeneration());
        sb.append("\n\u00a77Oldest cell\u00a7f: ").append("\u00a73\u00a7o").append(hud.getMaxAge());
        int[] cellCount = hud.getCellCount();
        int totalCells = hud.getGridSize() * hud.getGridSize();
        double percentCellsAlive = (double)cellCount[1] / (double)totalCells * 100.0;
        sb.append("\n\u00a77Survival rate\u00a7f: ").append("\u00a7a\u00a7o").append(df.format(percentCellsAlive)).append("\u00a78\u00a7o%");
        sb.append("\n\u00a77Simulation runtime\u00a7f: ").append("\u00a76\u00a7o").append(hud.getRuntime() / 1000L).append(" seconds");
        sb.append("\n\u00a77Cell count \u00a78\u00a7o[\u00a7a\u00a7oalive\u00a78\u00a7o/\u00a7c\u00a7odead\u00a78\u00a7o]\u00a7f: \u00a78\u00a7o[").append("\u00a7a\u00a7o").append(cellCount[1]).append("\u00a78\u00a7o/").append("\u00a7c\u00a7o").append(cellCount[0]).append("\u00a78\u00a7o]");
        return sb.toString();
    }
}

