/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.utils.files.StreamUtils;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3417;

public class Panorama
extends Command {
    private int timer = 10;
    private int screenshot = 0;
    private float preYaw = 69.0f;
    private float prevYaw = 69.0f;
    private float prePitch = 69.0f;
    private float prevPitch = 69.0f;
    private int preWidth = 42069;
    private int preHeight = 42069;
    private boolean isWarming = false;
    private boolean takingPanorama = false;
    private boolean readyToAssemble = false;
    @Nullable
    private Path currentPanoramaDir = null;
    @Nullable
    private class_310 instance = null;

    public Panorama() {
        super("panorama", "Takes a panorama and saves it to a custom resource pack for the main menu screen.", new String[]{"take"});
        MeteorClient.EVENT_BUS.subscribe((Object)this);
    }

    private void takeWarmedScreenshot() {
        if (this.currentPanoramaDir == null || this.instance == null) {
            return;
        }
        class_318.method_22690((File)this.currentPanoramaDir.toFile(), (String)("panorama_" + this.screenshot + ".png"), (class_276)this.instance.method_1522(), msg -> {});
        ++this.screenshot;
        this.isWarming = false;
    }

    private void startPanoramaProcess(String name) {
        Path panoramaDir = FabricLoader.getInstance().getGameDir().resolve("meteor-client/panoramas/" + name);
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        try {
            panoramaDir.toFile().mkdirs();
        }
        catch (Exception err) {
            LogUtil.error(err.toString(), this.getName());
        }
        this.instance = mc;
        this.screenshot = 0;
        this.preYaw = mc.field_1724.method_36454();
        this.prevYaw = mc.field_1724.field_5982;
        this.prePitch = mc.field_1724.method_36455();
        this.prevPitch = mc.field_1724.field_6004;
        this.currentPanoramaDir = panoramaDir;
        this.preWidth = mc.method_22683().method_4489();
        this.preHeight = mc.method_22683().method_4506();
        this.instance.method_22683().method_35642(4096);
        this.instance.method_22683().method_35643(4096);
        this.instance.method_1522().method_1234(4096, 4096);
        this.takingPanorama = true;
    }

    private void assembleResourcePack() {
        if (this.instance == null || this.currentPanoramaDir == null) {
            return;
        }
        Path resourcePacks = FabricLoader.getInstance().getGameDir().resolve("resourcepacks");
        Path screenshotsFolder = FabricLoader.getInstance().getGameDir().resolve("meteor-client/panoramas/" + String.valueOf(this.currentPanoramaDir.getFileName()) + "/screenshots");
        final Path customBaseFolder = resourcePacks.resolve(this.currentPanoramaDir.getFileName());
        final Path customPackFolder = customBaseFolder.resolve("assets/minecraft/textures/gui/title/background/");
        customPackFolder.toFile().mkdirs();
        String mcMeta = "{\n    \"pack\": {\"pack_format\": 34,\"description\": \"\\u00A73" + String.valueOf(this.currentPanoramaDir.getFileName()) + "_panorama\\n\\u00A72\\u00A7oGenerated by Stardust\\u00A7d\\u00A7o\\u2728\"}\n}";
        try {
            final int luckyNumber = ThreadLocalRandom.current().nextInt(6);
            Files.walkFileTree(screenshotsFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    StreamUtils.copy((File)file.toFile(), (File)customPackFolder.resolve(file.getFileName()).toFile());
                    if (file.getFileName().toString().contains(String.valueOf(luckyNumber))) {
                        StreamUtils.copy((File)file.toFile(), (File)customBaseFolder.resolve("pack.png").toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            File packMeta = customBaseFolder.resolve("pack.mcmeta").toFile();
            if (!packMeta.createNewFile()) {
                this.error("[Stardust] Failed to assemble custom resource pack! Does a pack of that name already exist?", new Object[0]);
                LogUtil.error("Failed to assemble custom resource pack (failed to create new file).", this.getName());
                return;
            }
            Files.write(packMeta.toPath(), mcMeta.getBytes(), new OpenOption[0]);
            BufferedImage transparentOverlay = new BufferedImage(16, 128, 2);
            File overlayImage = customPackFolder.resolve("panorama_overlay.png").toFile();
            ImageIO.write((RenderedImage)transparentOverlay, "PNG", overlayImage);
        }
        catch (Exception err) {
            this.error(err.toString(), new Object[0]);
            LogUtil.error(err.toString(), this.getName());
        }
        this.readyToAssemble = false;
        if (this.instance.field_1724 != null) {
            this.instance.field_1724.method_5783(class_3417.field_26980, 1.0f, 1.0f);
            this.instance.field_1724.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u2728\u00a78> \u00a73\u00a7oYour resource pack is ready to be enabled\u00a7f\u00a7o!")), false);
        }
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(Panorama.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = (String)ctx.getArgument("name", String.class);
            this.startPanoramaProcess(name);
            return 1;
        }));
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.instance == null || this.instance.field_1724 == null || this.currentPanoramaDir == null) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = 10;
        if (this.readyToAssemble) {
            this.assembleResourcePack();
        }
        if (!this.takingPanorama) {
            return;
        }
        switch (this.screenshot) {
            case 0: {
                if (!this.isWarming) {
                    this.instance.field_1773.method_35770(true);
                    this.instance.field_1773.method_35769(false);
                    this.instance.field_1769.method_3279();
                    if (!this.instance.field_1690.field_1842) {
                        this.instance.field_1690.field_1842 = true;
                    }
                    this.instance.field_1724.method_36456(this.preYaw);
                    this.instance.field_1724.method_36457(0.0f);
                    this.isWarming = true;
                    break;
                }
                this.takeWarmedScreenshot();
                break;
            }
            case 1: {
                if (!this.isWarming) {
                    this.instance.field_1724.method_36456((this.preYaw + 90.0f) % 360.0f);
                    this.instance.field_1724.method_36457(0.0f);
                    this.isWarming = true;
                    break;
                }
                this.takeWarmedScreenshot();
                break;
            }
            case 2: {
                if (!this.isWarming) {
                    this.instance.field_1724.method_36456((this.preYaw + 180.0f) % 360.0f);
                    this.instance.field_1724.method_36457(0.0f);
                    this.isWarming = true;
                    break;
                }
                this.takeWarmedScreenshot();
                break;
            }
            case 3: {
                if (!this.isWarming) {
                    this.instance.field_1724.method_36456((this.preYaw - 90.0f) % 360.0f);
                    this.instance.field_1724.method_36457(0.0f);
                    this.isWarming = true;
                    break;
                }
                this.takeWarmedScreenshot();
                break;
            }
            case 4: {
                if (!this.isWarming) {
                    this.instance.field_1724.method_36456(this.preYaw);
                    this.instance.field_1724.method_36457(-90.0f);
                    this.isWarming = true;
                    break;
                }
                this.takeWarmedScreenshot();
                break;
            }
            default: {
                if (!this.isWarming) {
                    this.instance.field_1724.method_36456(this.preYaw);
                    this.instance.field_1724.method_36457(90.0f);
                    this.isWarming = true;
                    break;
                }
                this.takeWarmedScreenshot();
                this.takingPanorama = false;
                this.instance.field_1724.method_36456(this.preYaw);
                this.instance.field_1724.method_36457(this.prePitch);
                this.instance.field_1724.field_5982 = this.prevYaw;
                this.instance.field_1724.field_6004 = this.prevPitch;
                this.instance.field_1773.method_35770(false);
                this.instance.field_1773.method_35769(true);
                this.instance.method_22683().method_35642(this.preWidth);
                this.instance.method_22683().method_35643(this.preHeight);
                if (this.instance.field_1690.field_1842) {
                    this.instance.field_1690.field_1842 = false;
                }
                this.instance.method_1522().method_1234(this.preWidth, this.preHeight);
                this.instance.field_1769.method_3279();
                this.timer = 100;
                this.readyToAssemble = true;
                this.instance.field_1724.method_7353(class_2561.method_30163((String)"\u00a78<\u00a72\u00a7o\u2728\u00a78> \u00a78\u00a7oFinalizing resource pack\u00a72\u00a7o, \u00a78\u00a7oplease wait\u00a72\u00a7o..."), false);
            }
        }
    }
}

