/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import dev.stardust.util.commands.ApiHandler;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class Playtime2b2t
extends Command {
    private final String API_ENDPOINT = "/playtime?playerName=";

    public Playtime2b2t() {
        super("playtime2b2t", "Check the playtime of a 2b2t player.", new String[]{"pt"});
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(Playtime2b2t.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            MeteorExecutor.execute(() -> {
                class_746 player = class_310.method_1551().field_1724;
                String playerString = (String)ctx.getArgument("player", String.class);
                String requestString = "https://api.2b2t.vc/playtime?playerName=" + playerString.trim();
                String response = new ApiHandler().fetchResponse(requestString);
                if (response == null) {
                    return;
                }
                if (response.equals("204 Undocumented")) {
                    if (player == null) {
                        return;
                    }
                    player.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u00a7o\u2728\u00a7r\u00a78> \u00a74\u00a7oPlayer not found\u00a77.")), false);
                } else {
                    JsonElement ptJson = JsonParser.parseString((String)response);
                    if (ptJson.getAsJsonObject().has("playtimeSeconds")) {
                        long playtimeSeconds = ptJson.getAsJsonObject().get("playtimeSeconds").getAsLong();
                        long days = TimeUnit.SECONDS.toDays(playtimeSeconds);
                        long hours = TimeUnit.SECONDS.toHours(playtimeSeconds -= TimeUnit.DAYS.toSeconds(days));
                        long minutes = TimeUnit.SECONDS.toMinutes(playtimeSeconds -= TimeUnit.HOURS.toSeconds(hours));
                        long seconds = TimeUnit.SECONDS.toSeconds(playtimeSeconds -= TimeUnit.MINUTES.toSeconds(minutes));
                        String cc = StardustUtil.rCC();
                        StringBuilder sb = new StringBuilder().append("\u00a78<").append(StardustUtil.rCC()).append("\u00a7o\u2728\u00a7r\u00a78> ").append(cc).append("\u00a7o").append(playerString).append("\u00a77: ").append(cc);
                        if (days != 0L) {
                            sb.append(days).append(" \u00a77Days, ").append(cc);
                        }
                        if (hours != 0L) {
                            sb.append(hours).append(" \u00a77Hours, ").append(cc);
                        }
                        if (minutes != 0L) {
                            sb.append(minutes).append(" \u00a77Minutes, ").append(cc);
                        }
                        if (seconds != 0L) {
                            sb.append(seconds).append(" \u00a77Seconds\u00a77.");
                        }
                        if (player != null) {
                            player.method_7353(class_2561.method_30163((String)sb.toString()), false);
                        }
                    } else {
                        ApiHandler.sendErrorResponse();
                        LogUtil.warn("Received unexpected output from api.2b2t.vc : \"" + String.valueOf(ptJson) + "\"", this.getName());
                    }
                }
            });
            return 1;
        }));
    }
}

