/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.commands;

import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.stardust.util.LogUtil;
import dev.stardust.util.StardustUtil;
import dev.stardust.util.commands.ApiHandler;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_746;

public class Stats2b2t
extends Command {
    private final String API_ENDPOINT = "/stats/player?playerName=";

    public Stats2b2t() {
        super("stats2b2t", "Fetch stats for a 2b2t player from api.2b2t.vc.", new String[]{"stats"});
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(Stats2b2t.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            MeteorExecutor.execute(() -> {
                class_746 player = Stats2b2t.mc.field_1724;
                if (player == null) {
                    return;
                }
                String playerString = (String)ctx.getArgument("player", String.class);
                String requestString = "https://api.2b2t.vc/stats/player?playerName=" + playerString.trim();
                String response = new ApiHandler().fetchResponse(requestString);
                if (response == null) {
                    return;
                }
                if (response.equals("204 Undocumented")) {
                    player.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u00a7o\u2728\u00a7r\u00a78> \u00a74\u00a7oPlayer not found\u00a77...")), false);
                } else {
                    try {
                        Object formattedPlaytimeInMonth;
                        Object formattedPlaytime;
                        Gson gson = new Gson();
                        String cc = StardustUtil.rCC();
                        PlayerStats stats = (PlayerStats)gson.fromJson(response, PlayerStats.class);
                        Instant firstInstant = Instant.parse(stats.firstSeen);
                        Instant lastInstant = Instant.parse(stats.lastSeen);
                        ZonedDateTime firstZonedTime = firstInstant.atZone(ZoneId.systemDefault());
                        ZonedDateTime lastZonedTime = lastInstant.atZone(ZoneId.systemDefault());
                        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("MM/dd/yyyy", Locale.US);
                        String formattedFirstSeen = firstZonedTime.format(fmt);
                        String formattedLastSeen = lastZonedTime.format(fmt);
                        long playtimeSeconds = stats.playtimeSeconds;
                        long playtimeSecondsInMonth = stats.playtimeSecondsMonth;
                        if (playtimeSeconds <= 0L) {
                            formattedPlaytime = "none";
                        } else {
                            long days = TimeUnit.SECONDS.toDays(playtimeSeconds);
                            long hours = TimeUnit.SECONDS.toHours(playtimeSeconds);
                            long minutes = TimeUnit.SECONDS.toMinutes(playtimeSeconds);
                            formattedPlaytime = days >= 60L ? days / 30L + " months" : (days >= 30L ? "1 month" : (days >= 14L ? days / 7L + " weeks" : (days >= 7L ? "1 week" : (days >= 2L ? days + " days" : (days > 0L ? "1 day" : (hours >= 2L ? hours + " hours" : (hours > 0L ? "1 hour" : (minutes >= 2L ? minutes + " minutes" : (minutes > 0L ? "1 minute" : (playtimeSeconds > 1L ? playtimeSeconds + " seconds" : "1 second"))))))))));
                        }
                        if (playtimeSecondsInMonth <= 0L) {
                            formattedPlaytimeInMonth = "none";
                        } else {
                            long daysInMonth = TimeUnit.SECONDS.toDays(playtimeSecondsInMonth);
                            long hoursInMonth = TimeUnit.SECONDS.toHours(playtimeSecondsInMonth);
                            long minutesInMonth = TimeUnit.SECONDS.toMinutes(playtimeSecondsInMonth);
                            formattedPlaytimeInMonth = daysInMonth >= 28L ? "1 month" : (daysInMonth >= 14L ? daysInMonth / 7L + " weeks" : (daysInMonth >= 7L ? "1 week" : (daysInMonth >= 2L ? daysInMonth + " days" : (daysInMonth > 0L ? "1 day" : (hoursInMonth >= 2L ? hoursInMonth + " hours" : (hoursInMonth > 0L ? "1 hour" : (minutesInMonth >= 2L ? minutesInMonth + " minutes" : (minutesInMonth > 0L ? "1 minute" : (playtimeSecondsInMonth > 1L ? playtimeSecondsInMonth + " seconds" : "1 second")))))))));
                        }
                        String kdRatioString = String.valueOf((float)stats.killCount / (float)stats.deathCount);
                        player.method_7353(class_2561.method_30163((String)("\u00a78<" + StardustUtil.rCC() + "\u00a7o\u2728\u00a7r\u00a78> \u00a77\u00a7oStats for " + cc + "\u00a7o" + playerString + "\u00a77\u00a7o:\n    \u00a77Joins: " + cc + "\u00a7o" + stats.joinCount + "\n    \u00a77Leaves: " + cc + "\u00a7o" + stats.leaveCount + "\n    \u00a77K/D Ratio: " + cc + "\u00a7o" + kdRatioString + "\n    \u00a77Chats: " + cc + "\u00a7o" + stats.chatsCount + "\n    \u00a77Prio: " + cc + "\u00a7o" + stats.prio + "\n    \u00a77First Seen: " + cc + "\u00a7o" + formattedFirstSeen + "\n    \u00a77Last Seen: " + cc + "\u00a7o" + formattedLastSeen + "\n    \u00a77Playtime: " + cc + "\u00a7o" + (String)formattedPlaytime + "\n    \u00a77Playtime in last month: " + cc + "\u00a7o" + (String)formattedPlaytimeInMonth)), false);
                    }
                    catch (Exception err) {
                        this.error("\u00a77Failed to deserialize response from the server\u00a74..!", new Object[0]);
                        LogUtil.error("Failed to deserialize Json: " + String.valueOf(err), this.getName());
                    }
                }
            });
            return 1;
        }));
    }

    private record PlayerStats(int joinCount, int leaveCount, int deathCount, int killCount, String firstSeen, String lastSeen, long playtimeSeconds, long playtimeSecondsMonth, int chatsCount, boolean prio) {
    }
}

