/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites;

import dev.stardust.gui.widgets.meteorites.FieldSize;
import dev.stardust.gui.widgets.meteorites.HighScore;
import dev.stardust.gui.widgets.meteorites.SaveData;
import dev.stardust.gui.widgets.meteorites.entity.Bullet;
import dev.stardust.gui.widgets.meteorites.entity.Meteorite;
import dev.stardust.gui.widgets.meteorites.entity.Powerups;
import dev.stardust.gui.widgets.meteorites.entity.Ship;
import dev.stardust.gui.widgets.meteorites.input.InputTracker;
import dev.stardust.gui.widgets.meteorites.render.GravityWellRenderer;
import dev.stardust.gui.widgets.meteorites.render.HudRenderer;
import dev.stardust.gui.widgets.meteorites.render.StarfieldRenderer;
import dev.stardust.modules.Meteorites;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class WMeteorites
extends WWidget {
    private static final double UPDATE_RATE = 60.0;
    private static final int BREAKING_SAVE_VERSION = 1;
    private static final int BREAKING_SCORE_VERSION = 1;
    private static final long THRUST_SOUND_INTERVAL = 12000L;
    private static final double NS_PER_SEC = 1.0E9;
    private static final double DELTA_TIME = 0.016666666666666666;
    private static final double NS_PER_UPDATE = 1.6666666666666666E7;
    public final Ship player;
    public boolean CHEAT_MODE;
    public final Meteorites module;
    public final FieldSize fieldSize;
    @Nullable
    public HighScore highScore;
    @Nullable
    public String currentGameTip;
    public final StarfieldRenderer starfield;
    public int wave;
    private long pausedAt;
    private long lastSaved;
    public boolean isPaused;
    public boolean gameOver;
    public boolean gameBegan;
    public double accumulator;
    public double gameTimeSecs;
    public boolean mouseInBounds;
    public double aimMouseLocalX;
    public double aimMouseLocalY;
    public boolean hasNewHighScore;
    private final long starfieldSeed;
    public int meteoriteCount;
    private final int MIN_METEORITES;
    private final int MAX_METEORITES;
    public final Meteorite[] meteorites;
    private long timer = System.nanoTime();
    public final Random rng = ThreadLocalRandom.current();
    private final InputTracker inputTracker = new InputTracker();
    private final List<Meteorite>[] renderBuckets = new ObjectArrayList[5];
    public int bulletCount;
    public final int MAX_BULLETS = 64;
    public Bullet[] bullets = new Bullet[256];
    private long lastThrustSoundMs = 0L;
    @Nullable
    private class_1113 thrustInstance = null;
    public static final ReferenceList<class_3414> BREAK_SOUNDS = ReferenceList.of((Object[])new class_3414[]{class_3417.field_26948, class_3417.field_14687, class_3417.field_43160, class_3417.field_21891, class_3417.field_26974, class_3417.field_54999, class_3417.field_28973});
    @Nullable
    public SettingColor prevShipColor = null;
    @Nullable
    public SettingColor prevFlameColor = null;
    @Nullable
    public SettingColor prevBulletColor = null;

    public WMeteorites(Meteorites module) {
        SaveData data;
        int n;
        for (n = 0; n <= 4; ++n) {
            this.renderBuckets[n] = new ObjectArrayList();
        }
        this.module = module;
        if (module.highScore != null && module.highScore.version() == 1) {
            this.highScore = module.highScore;
        }
        if (((Boolean)module.saveGames.get()).booleanValue() && module.saveData != null && (data = module.saveData).fieldSize().equals(module.canvasSize.get()) && data.version() == 1 && data.cheating() == ((Boolean)module.debug.get()).booleanValue()) {
            this.CHEAT_MODE = data.cheating();
            this.wave = data.waves();
            this.player = data.player();
            this.bullets = data.bullets();
            this.starfieldSeed = data.seed();
            this.fieldSize = data.fieldSize();
            this.meteorites = data.meteorites();
            this.accumulator = data.accumulator();
            this.bulletCount = data.bulletCount();
            this.meteoriteCount = data.meteoriteCount();
            this.MIN_METEORITES = this.fieldSize.getMinAsteroids();
            this.MAX_METEORITES = this.fieldSize.getMaxAsteroids();
            long millisSincePaused = System.currentTimeMillis() - data.pausedAt();
            this.starfield = new StarfieldRenderer(this.player, this.fieldSize.getWidth(), this.fieldSize.getHeight(), this.starfieldSeed);
            this.isPaused = true;
            this.gameBegan = true;
            this.pausedAt = System.currentTimeMillis();
            this.player.lastHyperJump += millisSincePaused;
            if (((Boolean)module.gameTips.get()).booleanValue()) {
                this.cycleNewGameTip();
            }
            if (this.player.getPowerup().equals((Object)Powerups.STARDUST)) {
                this.initStardustColor();
            } else if (this.player.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
                this.initMidasColor();
            }
            return;
        }
        this.fieldSize = (FieldSize)((Object)module.canvasSize.get());
        this.player = new Ship((double)this.fieldSize.getWidth() / 2.0, (double)this.fieldSize.getHeight() / 2.0, this.fieldSize.getShipThrustAmount());
        this.MIN_METEORITES = ((FieldSize)((Object)module.canvasSize.get())).getMinAsteroids();
        this.MAX_METEORITES = ((FieldSize)((Object)module.canvasSize.get())).getMaxAsteroids();
        this.meteorites = new Meteorite[this.MAX_METEORITES];
        for (n = 0; n < 256; ++n) {
            this.bullets[n] = new Bullet();
        }
        for (n = 0; n < this.MAX_METEORITES; ++n) {
            this.meteorites[n] = new Meteorite();
        }
        this.starfieldSeed = System.currentTimeMillis() / 1000L;
        this.starfield = new StarfieldRenderer(this.player, this.fieldSize.getWidth(), this.fieldSize.getHeight(), this.starfieldSeed);
        this.CHEAT_MODE = (Boolean)module.debug.get();
        this.initNewWave();
        this.isPaused = true;
        this.pausedAt = System.currentTimeMillis();
        if (((Boolean)module.gameTips.get()).booleanValue()) {
            this.cycleNewGameTip();
        }
    }

    public boolean shouldRestoreColorSettings() {
        return this.player.getPowerup().equals((Object)Powerups.STARDUST) && this.prevShipColor != null && this.prevFlameColor != null && this.prevBulletColor != null || this.player.getPowerup().equals((Object)Powerups.MIDAS_TOUCH) && this.prevBulletColor != null;
    }

    public boolean shouldSaveGame() {
        return (Boolean)this.module.saveGames.get() != false && this.player.lives > 0 && this.gameBegan;
    }

    public SaveData saveGame() {
        if (!this.isPaused) {
            this.pausedAt = System.currentTimeMillis();
        }
        return new SaveData(1, this.starfieldSeed, this.fieldSize, this.player, this.meteorites, this.bullets, this.CHEAT_MODE, this.wave, this.meteoriteCount, this.bulletCount, this.accumulator, this.pausedAt);
    }

    protected void onCalculateSize() {
        this.width = this.fieldSize.getWidth();
        this.height = this.fieldSize.getHeight();
    }

    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        int n;
        int bx = (int)this.x;
        int by = (int)this.y;
        this.aimMouseLocalX = mouseX - (double)bx;
        this.aimMouseLocalY = mouseY - (double)by;
        this.mouseInBounds = mouseX >= (double)bx && mouseX <= (double)bx + this.width && mouseY >= (double)by && mouseY <= (double)by + this.height;
        this.pollInput();
        if (!this.isPaused) {
            long now = System.nanoTime();
            double elapsedNanos = now - this.timer;
            this.timer = now;
            this.accumulator += elapsedNanos;
            while (this.accumulator >= 1.6666666666666666E7) {
                this.updatePhysics();
                this.accumulator -= 1.6666666666666666E7;
                this.gameTimeSecs += 0.016666666666666666;
            }
        } else {
            this.timer = System.nanoTime();
        }
        if (this.shouldSaveGame() && System.currentTimeMillis() - this.lastSaved >= 60000L) {
            this.module.saveGame(this.saveGame());
            this.lastSaved = System.currentTimeMillis();
        }
        renderer.quad((double)(bx - 2), (double)(by - 2), (double)((int)this.width + 4), (double)((int)this.height + 4), new Color(18, 18, 20));
        renderer.quad((double)bx, (double)by, (double)((int)this.width), (double)((int)this.height), new Color(8, 8, 12));
        renderer.scissorStart((double)bx, (double)by, (double)((int)this.width), (double)((int)this.height));
        if (((Boolean)this.module.renderStarfield.get()).booleanValue()) {
            double starfieldDeltaTime = this.gameTimeSecs + this.accumulator / 1.0E9;
            this.starfield.render(renderer, bx, by, this.player.x, this.player.y, this.width, this.height, starfieldDeltaTime);
        }
        if (this.player.getPowerup().equals((Object)Powerups.GRAVITY_WELL) && this.player.lives > 0 && !this.isPaused && this.mouseInBounds) {
            double baseCy;
            double baseCx;
            if (this.player.gravityWellDeployed) {
                baseCx = (double)bx + this.player.gravityWellX;
                baseCy = (double)by + this.player.gravityWellY;
            } else {
                baseCx = (double)bx + this.aimMouseLocalX;
                baseCy = (double)by + this.aimMouseLocalY;
            }
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    double drawCx = baseCx + (double)ox * this.width;
                    double drawCy = baseCy + (double)oy * this.height;
                    double maxDrawR = 82.8;
                    if (drawCx + maxDrawR < (double)bx || drawCx - maxDrawR > (double)bx + this.width || drawCy + maxDrawR < (double)by || drawCy - maxDrawR > (double)by + this.height) continue;
                    GravityWellRenderer.renderBackground(renderer, this.player.gravityWellDeployed, drawCx, drawCy, (Color)this.module.gravityColor.get());
                }
            }
        }
        for (n = 0; n <= 4; ++n) {
            this.renderBuckets[n].clear();
        }
        for (n = 0; n < this.meteoriteCount; ++n) {
            int s;
            Meteorite m = this.meteorites[n];
            int n2 = s = m.isBoss ? 4 : m.size;
            if (s < 1) {
                s = 1;
            }
            if (s > 4) {
                s = 4;
            }
            this.renderBuckets[s].add(m);
        }
        for (int size = 1; size <= 4; ++size) {
            for (Meteorite m : this.renderBuckets[size]) {
                m.render(renderer, bx, by, this.width, this.height);
            }
        }
        for (n = 0; n < this.bulletCount; ++n) {
            Bullet bullet = this.bullets[n];
            bullet.render(renderer, bx, by, (SettingColor)this.module.bulletColor.get());
        }
        boolean drawShip = true;
        if (this.player.iFrames > 0.0 || this.player.phaseActive) {
            boolean bl = drawShip = (System.currentTimeMillis() / 120L & 1L) == 0L;
        }
        if (drawShip) {
            this.player.render(renderer, bx, by, (SettingColor)this.module.shipColor.get(), (SettingColor)this.module.flameColor.get());
        }
        if (this.player.getPowerup().equals((Object)Powerups.GRAVITY_WELL) && this.player.lives > 0 && !this.isPaused && this.mouseInBounds) {
            double baseCy;
            double baseCx;
            if (this.player.gravityWellDeployed) {
                baseCx = (double)bx + this.player.gravityWellX;
                baseCy = (double)by + this.player.gravityWellY;
            } else {
                baseCx = (double)bx + this.aimMouseLocalX;
                baseCy = (double)by + this.aimMouseLocalY;
            }
            double maxDrawR = 82.8;
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    double drawCx = baseCx + (double)ox * this.width;
                    double drawCy = baseCy + (double)oy * this.height;
                    if (drawCx + maxDrawR < (double)bx || drawCx - maxDrawR > (double)bx + this.width || drawCy + maxDrawR < (double)by || drawCy - maxDrawR > (double)by + this.height) continue;
                    GravityWellRenderer.renderReticle(renderer, this.player.gravityWellDeployed, drawCx, drawCy);
                }
            }
        }
        renderer.scissorEnd();
        HudRenderer.renderHud(renderer, this.theme, bx, by, this.width, this.height, this);
    }

    private void updatePhysics() {
        if (this.player.lives <= 0) {
            this.module.clearSave();
            if (this.thrustInstance != null) {
                MeteorClient.mc.method_1483().method_4870(this.thrustInstance);
                this.thrustInstance = null;
            }
            return;
        }
        this.player.updatePhysics(0.016666666666666666, this.width, this.height, this.aimMouseLocalX, this.aimMouseLocalY, this);
        int n = 0;
        while (n < this.bulletCount) {
            Bullet bullet = this.bullets[n];
            if (!bullet.updatePhysics(0.016666666666666666, this.width, this.height, this.player, this.meteorites, this.meteoriteCount, this)) {
                this.bullets[n].set(this.bullets[this.bulletCount - 1]);
                --this.bulletCount;
                continue;
            }
            ++n;
        }
        double[] shipX = new double[3];
        double[] shipY = new double[3];
        shipX[0] = this.player.x + Math.cos(this.player.angle) * 10.0;
        shipY[0] = this.player.y + Math.sin(this.player.angle) * 10.0;
        shipX[1] = this.player.x + Math.cos(this.player.angle + 2.356194490192345) * 8.0;
        shipY[1] = this.player.y + Math.sin(this.player.angle + 2.356194490192345) * 8.0;
        shipX[2] = this.player.x + Math.cos(this.player.angle - 2.356194490192345) * 8.0;
        shipY[2] = this.player.y + Math.sin(this.player.angle - 2.356194490192345) * 8.0;
        for (int n2 = 0; n2 < this.meteoriteCount; ++n2) {
            Meteorite meteorite = this.meteorites[n2];
            meteorite.updatePhysics(0.016666666666666666, this.width, this.height, shipX, shipY, this.meteoriteCount, this.player, this.meteorites, this);
        }
        if (this.meteoriteCount == 0) {
            this.initNewWave();
        }
    }

    private void pollInput() {
        boolean rightClick;
        boolean left = InputTracker.isKeyDown(65) || InputTracker.isKeyDown(263);
        boolean right = InputTracker.isKeyDown(68) || InputTracker.isKeyDown(262);
        boolean up = InputTracker.isKeyDown(87) || InputTracker.isKeyDown(265);
        boolean down = InputTracker.isKeyDown(83) || InputTracker.isKeyDown(264);
        boolean space = InputTracker.isKeyDown(32) || InputTracker.isMouseDown(0);
        boolean rKey = InputTracker.isKeyDown(82);
        boolean mKey = InputTracker.isKeyDown(77);
        boolean cKey = InputTracker.isKeyDown(67);
        boolean iKey = InputTracker.isKeyDown(73);
        boolean pKey = InputTracker.isKeyDown(80);
        boolean nKey = InputTracker.isKeyDown(78);
        boolean middleClick = InputTracker.isMouseDown(2);
        boolean bl = rightClick = InputTracker.isMouseDown(1) || InputTracker.isKeyDown(72);
        if (rKey && this.inputTracker.isNotHeld(82) && this.player.lives <= 0 || nKey && this.inputTracker.isNotHeld(78) && this.isPaused) {
            this.resetGame();
            return;
        }
        if (mKey && this.inputTracker.isNotHeld(77)) {
            this.module.sounds.set((Object)((Boolean)this.module.sounds.get() == false ? 1 : 0));
            if (!((Boolean)this.module.sounds.get()).booleanValue()) {
                this.killThrustInstance();
            }
        }
        if (this.player.lives > 0) {
            if (cKey && this.inputTracker.isNotHeld(67) && this.CHEAT_MODE) {
                this.player.cyclePowerup(this);
            }
            if (iKey && this.inputTracker.isNotHeld(73) && this.CHEAT_MODE) {
                boolean bl2 = this.player.invulnerable = !this.player.invulnerable;
                if (!this.player.invulnerable) {
                    this.player.iFrames = 1.2;
                }
            }
            if (middleClick && this.inputTracker.isNotHeld(2)) {
                this.module.mouseAim.set((Object)((Boolean)this.module.mouseAim.get() == false ? 1 : 0));
            }
            if (pKey && this.inputTracker.isNotHeld(80) && !this.isPaused || rKey && this.inputTracker.isNotHeld(82) && this.isPaused) {
                boolean bl3 = this.isPaused = !this.isPaused;
                if (this.isPaused) {
                    this.pauseGame();
                } else {
                    this.gameBegan = true;
                    this.currentGameTip = null;
                    long millisSincePaused = System.currentTimeMillis() - this.pausedAt;
                    this.player.lastHyperJump += millisSincePaused;
                }
            }
            if (!this.isPaused) {
                this.player.rotLeft = left;
                this.player.rotRight = right;
                this.player.thrusting = up;
                if (space && this.player.shootCooldownTimer <= 0.0) {
                    this.player.tryToShoot(this);
                }
                if (rightClick && this.inputTracker.isNotHeld(1)) {
                    if (this.player.getPowerup().equals((Object)Powerups.PHASE_SHIFT)) {
                        if (this.player.phaseActive && this.player.phaseTimer <= this.player.phaseDuration) {
                            this.player.phaseActive = false;
                            this.player.phaseCooldownTimer = this.player.phaseCooldown - (this.player.phaseDuration - this.player.phaseTimer);
                            this.player.iFrames = 0.42;
                            this.playSound(class_3417.field_46945, 0.69f);
                        } else if (!this.player.phaseActive && this.player.phaseCooldownTimer <= 0.0) {
                            this.player.phaseTimer = 0.0;
                            this.player.phaseActive = true;
                            this.playSound(class_3417.field_46945, 0.42f);
                        } else {
                            this.playSound(class_3417.field_15008, this.rng.nextFloat(0.969f, 1.1337f));
                        }
                    } else if (this.player.getPowerup().equals((Object)Powerups.GRAVITY_WELL)) {
                        if (this.mouseInBounds) {
                            if (!this.player.gravityWellDeployed) {
                                if (this.player.gravityWellCdTimer <= 0.0) {
                                    this.player.gravityWellDeployed = true;
                                    this.player.gravityWellX = this.aimMouseLocalX;
                                    this.player.gravityWellY = this.aimMouseLocalY;
                                    this.player.gravityWellTimer = this.player.gravityWellTimer > 0.0 ? this.player.gravityWellTimer : this.player.gravityWellDuration;
                                    this.playSound(class_3417.field_19197, this.rng.nextFloat(0.969f, 1.1337f));
                                } else {
                                    this.playSound(class_3417.field_15008, this.rng.nextFloat(0.969f, 1.1337f));
                                }
                            } else {
                                double dx = this.player.gravityWellX - this.aimMouseLocalX;
                                double dy = this.player.gravityWellY - this.aimMouseLocalY;
                                double distFromCenter = dx * dx + dy * dy;
                                if (distFromCenter < 4761.0) {
                                    this.player.gravityWellCdTimer = 0.0;
                                    this.player.gravityWellDeployed = false;
                                    this.playSound(class_3417.field_38371, this.rng.nextFloat(0.969f, 1.1337f));
                                }
                            }
                        }
                    } else if (this.player.getPowerup().equals((Object)Powerups.CALIBRATED_FSD) || this.player.isShotgun && !this.player.isSniper && this.player.getPowerup().equals((Object)Powerups.STARDUST)) {
                        boolean poweredUp = this.player.getPowerup().equals((Object)Powerups.STARDUST);
                        if (poweredUp && System.currentTimeMillis() - this.player.lastHyperJump >= 1000L || this.player.iFrames <= 0.0 && (double)(System.currentTimeMillis() - this.player.lastHyperJump) >= 3000.0) {
                            this.player.lastHyperJump = System.currentTimeMillis();
                            this.player.doHyperspaceJump(poweredUp, true, this.width, this.height, this);
                        } else {
                            this.playSound(class_3417.field_15008, this.rng.nextFloat(0.969f, 1.1337f));
                        }
                    } else {
                        boolean poweredUp;
                        boolean bl4 = poweredUp = this.player.getPowerup().equals((Object)Powerups.SUPERCHARGED_FSD) || this.player.getPowerup().equals((Object)Powerups.STARDUST) && !this.player.isShotgun && !this.player.isSniper;
                        if (poweredUp || this.player.iFrames <= 0.0 && this.player.score >= 1000 && (double)(System.currentTimeMillis() - this.player.lastHyperJump) >= 3599.9999999999995) {
                            this.player.lastHyperJump = System.currentTimeMillis();
                            this.player.doHyperspaceJump(poweredUp, false, this.width, this.height, this);
                            if (!poweredUp) {
                                this.player.score -= 1000;
                                this.playSound(class_3417.field_19152, this.rng.nextFloat(0.969f, 1.1337f));
                            }
                        } else {
                            this.playSound(class_3417.field_15008, this.rng.nextFloat(0.969f, 1.1337f));
                        }
                    }
                }
            }
        }
        this.inputTracker.updateState(87, up, this);
        this.inputTracker.updateState(73, iKey, this);
        this.inputTracker.updateState(67, cKey, this);
        this.inputTracker.updateState(77, mKey, this);
        this.inputTracker.updateState(78, nKey, this);
        this.inputTracker.updateState(80, pKey, this);
        this.inputTracker.updateState(82, rKey, this);
        this.inputTracker.updateState(83, down, this);
        this.inputTracker.updateState(65, left, this);
        this.inputTracker.updateState(68, right, this);
        this.inputTracker.updateState(32, space, this);
        this.inputTracker.updateState(1, rightClick, this);
        this.inputTracker.updateState(2, middleClick, this);
    }

    public void resetGame() {
        if (this.player.getPowerup().equals((Object)Powerups.STARDUST)) {
            this.deInitStardustColor();
        } else if (this.player.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
            this.deInitMidasColor();
        }
        for (Meteorite m : this.meteorites) {
            m.isBoss = false;
        }
        this.wave = 0;
        this.bulletCount = 0;
        this.isPaused = false;
        this.gameOver = false;
        this.meteoriteCount = 0;
        this.hasNewHighScore = false;
        this.player.score = 0;
        this.player.lives = 3;
        this.player.x = this.width / 2.0;
        this.player.y = this.height / 2.0;
        this.player.vy = 0.0;
        this.player.vx = 0.0;
        this.player.pointsWithCurrentPower = 0;
        if (((Boolean)this.module.renderStarfield.get()).booleanValue()) {
            this.starfield.resetInstant(this.player.x, this.player.y);
        }
        this.module.clearSave();
        this.player.resetPowerup();
        this.player.powerMap.clear();
        this.initNewWave();
    }

    private void initNewWave() {
        boolean bossMeteoriteWave;
        ++this.wave;
        boolean bl = bossMeteoriteWave = this.wave % 10 == 0;
        if (this.wave % 6 == 0 && this.player.lives < 5) {
            ++this.player.lives;
        }
        if (bossMeteoriteWave) {
            this.player.x = this.width / 2.0;
            this.player.y = this.height / 2.0;
            this.player.vy = 0.0;
            this.player.vx = 0.0;
            if (((Boolean)this.module.renderStarfield.get()).booleanValue()) {
                double dt = this.gameTimeSecs + this.accumulator / 1.0E9;
                this.starfield.resetSmooth(this.player.x, this.player.y, 0.969, dt);
            }
            this.spawnMeteorite(true);
        } else {
            int JITTER_RANGE = 2;
            int EARLY_WAVE_LAST = 4;
            double GROWTH_RATE = 1.42;
            double SURGE_CHANCE = 0.06;
            double BREATHER_CHANCE = 0.08;
            int BREATHER_AMOUNT = Math.max(1, (int)Math.round(2.0 + Math.sqrt(this.wave) * 0.5));
            int SURGE_AMOUNT = Math.max(2, (int)Math.round(2.0 + Math.sqrt(this.wave) * 0.9));
            int EARLY_WAVE_SOFT_CAP = Math.max(this.MIN_METEORITES, Math.min(this.MAX_METEORITES, 6));
            int base = this.MIN_METEORITES + (int)Math.floor(1.42 * Math.sqrt(Math.max(1, this.wave)));
            if (this.wave <= 4) {
                base = Math.min(base, EARLY_WAVE_SOFT_CAP);
            }
            double r1 = this.rng.nextDouble();
            double r2 = this.rng.nextDouble();
            int jitter = (int)Math.round((r1 - r2) * 2.0);
            int toSpawn = base + jitter;
            double specialRoll = this.rng.nextDouble();
            if (specialRoll < 0.08) {
                toSpawn = Math.max(this.MIN_METEORITES, toSpawn - BREATHER_AMOUNT);
            } else if (specialRoll < 0.14) {
                toSpawn = Math.min(this.MAX_METEORITES, toSpawn + SURGE_AMOUNT);
            }
            toSpawn = Math.max(this.MIN_METEORITES, Math.min(this.MAX_METEORITES, toSpawn));
            for (int n = 0; n < toSpawn; ++n) {
                this.spawnMeteorite(false);
            }
        }
        if (this.player.hasEntropy() || this.CHEAT_MODE && ((Boolean)this.module.randomizePowerups.get()).booleanValue() || !this.CHEAT_MODE && this.wave % 3 == 0 && (this.player.getPowerup().equals((Object)Powerups.NONE) || this.player.getPowerup().equals((Object)Powerups.STARDUST))) {
            this.player.gainNewPowerup(this.player.hasEntropy() ? this.player.getPowerup() : null, this);
            this.playSound(class_3417.field_14709, this.rng.nextFloat(0.77f, 1.1337f));
        } else {
            this.playSound(class_3417.field_14627, this.rng.nextFloat(0.77f, 1.1337f));
        }
    }

    private void spawnMeteorite(boolean boss) {
        if (this.meteoriteCount >= this.MAX_METEORITES) {
            return;
        }
        for (int attempt = 0; attempt < 8; ++attempt) {
            double safeDistance;
            double y;
            double x;
            switch (this.rng.nextInt(4)) {
                case 0: {
                    x = -20.0;
                    y = this.rng.nextDouble() * this.height;
                    break;
                }
                case 1: {
                    x = this.width + 20.0;
                    y = this.rng.nextDouble() * this.height;
                    break;
                }
                case 2: {
                    y = -20.0;
                    x = this.rng.nextDouble() * this.width;
                    break;
                }
                default: {
                    y = this.height + 20.0;
                    x = this.rng.nextDouble() * this.width;
                }
            }
            double dxp = x - this.player.x;
            double dyp = y - this.player.y;
            double d = safeDistance = boss ? 280.0 : 140.0;
            if (!(dxp * dxp + dyp * dyp >= safeDistance * safeDistance)) continue;
            double angle = Math.atan2(this.player.y - y, this.player.x - x);
            double maxSpread = Math.toRadians(50.0);
            double ang = angle + (this.rng.nextDouble() * 2.0 - 1.0) * maxSpread;
            double baseSpeed = 28.0 + this.rng.nextDouble() * 60.0 + (double)(this.wave * 2);
            if (this.rng.nextDouble() < 0.06) {
                baseSpeed *= 1.6;
            }
            double perp = ang + 1.5707963267948966;
            double perpStrength = 20.0 + this.rng.nextDouble() * 60.0;
            double perpFactor = (this.rng.nextDouble() * 2.0 - 1.0) * perpStrength;
            double vx = Math.cos(ang) * baseSpeed + Math.cos(perp) * perpFactor;
            double vy = Math.sin(ang) * baseSpeed + Math.sin(perp) * perpFactor;
            if (boss) {
                Meteorite b = this.meteorites[this.meteoriteCount++];
                b.becomeBoss(x, y, vx, vy, this.width, this.height, this.wave);
            } else {
                double radius = 36.0 + this.rng.nextDouble() * 12.0;
                Meteorite m = this.meteorites[this.meteoriteCount++];
                m.set(x, y, vx, vy, radius, false);
            }
            return;
        }
        double fx = this.player.x < this.width / 2.0 ? this.width + 40.0 : -40.0;
        double fy = this.player.y < this.height / 2.0 ? this.height + 40.0 : -40.0;
        double angle = Math.atan2(this.player.y - fy, this.player.x - fx);
        double vx = Math.cos(angle) * (30.0 + this.rng.nextDouble() * 40.0);
        double vy = Math.sin(angle) * (30.0 + this.rng.nextDouble() * 40.0);
        if (boss) {
            Meteorite b = this.meteorites[this.meteoriteCount++];
            b.becomeBoss(fx, fy, vx, vy, this.width, this.height, this.wave);
        } else {
            double radius = 36.0 + this.rng.nextDouble() * 12.0;
            Meteorite m = this.meteorites[this.meteoriteCount++];
            m.set(fx, fy, vx, vy, radius, false);
        }
    }

    private void spawnMeteoriteAt(double x, double y, double vx, double vy, double radius) {
        if (this.meteoriteCount >= this.MAX_METEORITES) {
            return;
        }
        Meteorite m = this.meteorites[this.meteoriteCount++];
        m.set(x, y, vx, vy, radius, false);
    }

    public void spawnChildMeteorite(Meteorite source, double angle, double baseSpeedMin, double baseSpeedMax, double spawnOffsetMin, double spawnOffsetMax, double fragRadius) {
        if (this.meteoriteCount >= this.MAX_METEORITES) {
            return;
        }
        double fx = Math.cos(angle);
        double fy = Math.sin(angle);
        double offset = spawnOffsetMin + this.rng.nextDouble() * (spawnOffsetMax - spawnOffsetMin);
        double spawnDist = Math.max(1.0, source.radius * Math.max(0.6, offset));
        double sx = source.x + fx * spawnDist;
        double sy = source.y + fy * spawnDist;
        double speed = baseSpeedMin + this.rng.nextDouble() * (baseSpeedMax - baseSpeedMin);
        double vx = fx * speed;
        double vy = fy * speed;
        double inherit = 0.05 + this.rng.nextDouble() * 0.37;
        vx += source.vx * inherit;
        vy += source.vy * inherit;
        double perpAngle = angle + 1.5707963267948966;
        double perpStrength = 6.0 + this.rng.nextDouble() * 48.0;
        double perp = (this.rng.nextDouble() * 2.0 - 1.0) * perpStrength;
        vx += Math.cos(perpAngle) * perp;
        vy += Math.sin(perpAngle) * perp;
        double maxSpeed = 512.0;
        double ss = Math.hypot(vx, vy);
        if (ss > maxSpeed) {
            double s = maxSpeed / ss;
            vx *= s;
            vy *= s;
        }
        this.spawnMeteoriteAt(sx, sy, vx, vy, fragRadius);
    }

    public void splitMeteorite(int index) {
        if (index < 0 || index >= this.meteoriteCount) {
            return;
        }
        Meteorite m = this.meteorites[index];
        int size = m.size;
        double cx = m.x;
        double cy = m.y;
        if (m.isBoss) {
            m.isBoss = false;
            this.meteorites[index].set(this.meteorites[this.meteoriteCount - 1]);
            --this.meteoriteCount;
            return;
        }
        if (size > 1) {
            int parts = 2 + this.rng.nextInt(2);
            for (int n = 0; n < parts && this.meteoriteCount < this.MAX_METEORITES; ++n) {
                Meteorite m2 = this.meteorites[this.meteoriteCount++];
                double aAng = this.rng.nextDouble() * Math.PI * 2.0;
                double speed = 20.0 + this.rng.nextDouble() * 90.0;
                double nvx = Math.cos(aAng) * speed + (this.rng.nextDouble() - 0.5) * 30.0;
                double nvy = Math.sin(aAng) * speed + (this.rng.nextDouble() - 0.5) * 30.0;
                double newRadius = size == 3 ? 18.0 + this.rng.nextDouble() * 6.0 : 8.0 + this.rng.nextDouble() * 3.0;
                m2.set(cx + Math.cos(aAng) * 6.0, cy + Math.sin(aAng) * 6.0, nvx, nvy, newRadius, false);
            }
        }
        this.meteorites[index].set(this.meteorites[this.meteoriteCount - 1]);
        --this.meteoriteCount;
        int luckyIndex = this.rng.nextInt(BREAK_SOUNDS.size());
        this.playSound((class_3414)BREAK_SOUNDS.get(luckyIndex), this.rng.nextFloat(0.77f, 1.1337f), ((Double)this.module.soundVolume.get()).floatValue() * 0.5f);
    }

    public void clearMeteoritesAround(double cx, double cy) {
        for (int n = 0; n < this.meteoriteCount; ++n) {
            Meteorite meteorite = this.meteorites[n];
            double dx = meteorite.x - cx;
            double dy = meteorite.y - cy;
            double d2 = dx * dx + dy * dy;
            double min = 80.0 + meteorite.radius;
            if (!(d2 <= min * min)) continue;
            double d = Math.sqrt(Math.max(1.0E-6, d2));
            double nx = dx / d;
            double ny = dy / d;
            meteorite.x = cx + nx * (min + 4.0);
            meteorite.y = cy + ny * (min + 4.0);
            meteorite.vx += nx * 40.0;
            meteorite.vx += ny * 40.0;
            meteorite.wrap(this.width, this.height);
        }
    }

    public void deInitMidasColor() {
        if (this.prevBulletColor != null) {
            this.module.bulletColor.set((Object)this.prevBulletColor);
        }
        this.prevBulletColor = null;
    }

    public void initMidasColor() {
        this.prevBulletColor = (SettingColor)this.module.bulletColor.get();
        if (this.prevBulletColor != null) {
            this.module.bulletColor.set((Object)new SettingColor(213, 213, 13));
        }
    }

    public void deInitStardustColor() {
        if (this.prevShipColor != null) {
            this.module.shipColor.set((Object)this.prevShipColor);
        }
        if (this.prevFlameColor != null) {
            this.module.flameColor.set((Object)this.prevFlameColor);
        }
        if (this.prevBulletColor != null) {
            this.module.bulletColor.set((Object)this.prevBulletColor);
        }
        this.prevShipColor = null;
        this.prevFlameColor = null;
        this.prevBulletColor = null;
    }

    public void initStardustColor() {
        this.prevShipColor = (SettingColor)this.module.shipColor.get();
        this.prevFlameColor = (SettingColor)this.module.flameColor.get();
        this.prevBulletColor = (SettingColor)this.module.bulletColor.get();
        if (this.prevShipColor != null) {
            this.module.shipColor.set((Object)new SettingColor(this.prevShipColor.r, this.prevShipColor.g, this.prevShipColor.b, this.prevShipColor.a, true));
        }
        if (this.prevFlameColor != null) {
            this.module.flameColor.set((Object)new SettingColor(this.prevFlameColor.r, this.prevFlameColor.g, this.prevFlameColor.b, this.prevFlameColor.a, true));
        }
        if (this.prevBulletColor != null) {
            this.module.bulletColor.set((Object)new SettingColor(this.prevBulletColor.r, this.prevBulletColor.g, this.prevBulletColor.b, this.prevBulletColor.a, true));
        }
    }

    public void updateHighScore() {
        if (!this.CHEAT_MODE && (this.highScore == null || this.highScore.isSurpassed(this.fieldSize, this.player.score))) {
            this.hasNewHighScore = true;
            int most = 0;
            Powerups bestPower = Powerups.NONE;
            for (Map.Entry<Powerups, Integer> powers : this.player.powerMap.entrySet()) {
                if (powers.getValue() <= most) continue;
                most = powers.getValue();
                bestPower = powers.getKey();
            }
            if (this.highScore == null) {
                HashMap<FieldSize, int[]> scores = new HashMap<FieldSize, int[]>();
                scores.put(this.fieldSize, new int[]{this.player.score, this.wave, bestPower.ordinal()});
                this.highScore = new HighScore(1, scores);
            } else {
                this.highScore.update(this.fieldSize, this.player.score, this.wave, bestPower.ordinal());
            }
            this.module.saveHighScore(this.highScore);
        }
    }

    public void cycleNewGameTip() {
        this.currentGameTip = "Tip: " + Meteorites.GAMEPLAY_TIPS[this.rng.nextInt(Meteorites.GAMEPLAY_TIPS.length)];
    }

    public void playSound(class_3414 sound, float pitch) {
        if (!((Boolean)this.module.sounds.get()).booleanValue()) {
            return;
        }
        try {
            if (MeteorClient.mc == null) {
                return;
            }
            if (MeteorClient.mc.method_1483() == null) {
                return;
            }
            MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)((Double)this.module.soundVolume.get()).floatValue()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void playSound(class_3414 sound, float pitch, float volume) {
        if (!((Boolean)this.module.sounds.get()).booleanValue()) {
            return;
        }
        try {
            if (MeteorClient.mc == null) {
                return;
            }
            if (MeteorClient.mc.method_1483() == null) {
                return;
            }
            MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)volume));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void playThrustInstance() {
        if (((Boolean)this.module.sounds.get()).booleanValue()) {
            long now = System.currentTimeMillis();
            if (this.thrustInstance == null || now - this.lastThrustSoundMs >= 12000L) {
                this.lastThrustSoundMs = now;
                try {
                    if (MeteorClient.mc == null) {
                        return;
                    }
                    if (MeteorClient.mc.method_1483() == null) {
                        return;
                    }
                    this.thrustInstance = class_1109.method_4757((class_3414)class_3417.field_14572, (float)0.777f, (float)(((Double)this.module.soundVolume.get()).floatValue() * 0.69f));
                    MeteorClient.mc.method_1483().method_4873(this.thrustInstance);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void killThrustInstance() {
        if (this.thrustInstance != null) {
            MeteorClient.mc.method_1483().method_4870(this.thrustInstance);
            this.thrustInstance = null;
        }
    }

    public void pauseGame() {
        this.isPaused = true;
        this.killThrustInstance();
        this.pausedAt = System.currentTimeMillis();
        if (((Boolean)this.module.gameTips.get()).booleanValue()) {
            this.cycleNewGameTip();
        }
    }
}

