/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.entity;

import dev.stardust.gui.widgets.meteorites.WMeteorites;
import dev.stardust.gui.widgets.meteorites.entity.BulletTypes;
import dev.stardust.gui.widgets.meteorites.entity.Entity;
import dev.stardust.gui.widgets.meteorites.entity.Meteorite;
import dev.stardust.gui.widgets.meteorites.entity.Powerups;
import dev.stardust.gui.widgets.meteorites.entity.Ship;
import dev.stardust.gui.widgets.meteorites.entity.collision.CollisionUtil;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;

public class Bullet
extends Entity {
    public static final double BULLET_SPEED = 280.0;
    public static final double HOMING_RANGE = 69.0;
    public static final double BULLET_LIFETIME = 1.2;
    public static final double HOMING_STRENGTH = 0.0969;
    public double angle;
    public double life = 0.0;
    public BulletTypes type;

    public void set(BulletTypes type, double x, double y, double vx, double vy, double life, double angle) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.life = life;
        this.angle = angle;
    }

    public void set(Bullet other) {
        this.type = other.type;
        this.x = other.x;
        this.y = other.y;
        this.vx = other.vx;
        this.vy = other.vy;
        this.life = other.life;
        this.angle = other.angle;
    }

    public void render(GuiRenderer renderer, int bx, int by, SettingColor bulletColor) {
        double angle;
        double thickness = 2.0;
        double baseLength = 2.0;
        if (this.type == BulletTypes.SNIPER) {
            double speed = Math.hypot(this.vx, this.vy);
            double speedFactor = Math.min(3.0, speed / 50.0);
            baseLength = 4.0 * speedFactor;
        }
        if (Double.isNaN(angle = Math.atan2(this.vy, this.vx)) || Math.abs(this.vx) < 1.0E-6 && Math.abs(this.vy) < 1.0E-6) {
            angle = this.angle;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double hx = cos * baseLength;
        double hy = sin * baseLength;
        double px = -sin * thickness;
        double py = cos * thickness;
        double fx = this.x + hx;
        double fy = this.y + hy;
        double bx2 = this.x - hx;
        double by2 = this.y - hy;
        double flx = fx + px;
        double fly = fy + py;
        double frx = fx - px;
        double fry = fy - py;
        double brx = bx2 - px;
        double bry = by2 - py;
        double blx = bx2 + px;
        double bly = by2 + py;
        float screenBx = bx;
        float screenBy = by;
        renderer.triangle((double)((float)(flx + (double)screenBx)), (double)((float)(fly + (double)screenBy)), (double)((float)(frx + (double)screenBx)), (double)((float)(fry + (double)screenBy)), (double)((float)(brx + (double)screenBx)), (double)((float)(bry + (double)screenBy)), (Color)bulletColor);
        renderer.triangle((double)((float)(flx + (double)screenBx)), (double)((float)(fly + (double)screenBy)), (double)((float)(brx + (double)screenBx)), (double)((float)(bry + (double)screenBy)), (double)((float)(blx + (double)screenBx)), (double)((float)(bly + (double)screenBy)), (Color)bulletColor);
    }

    public boolean updatePhysics(double dt, double width, double height, Ship player, Meteorite[] meteorites, int meteoriteCount, WMeteorites widget) {
        this.life -= dt;
        if (this.life <= 0.0) {
            return false;
        }
        if (player.getPowerup().equals((Object)Powerups.HOMING_SHOTS) || player.getPowerup().equals((Object)Powerups.STARDUST) && player.isSniper) {
            double ty;
            double tx;
            double len;
            Meteorite target = null;
            double bestDist2 = 4761.0;
            for (int mi = 0; mi < meteoriteCount; ++mi) {
                Meteorite meteorite = meteorites[mi];
                double dx = meteorite.x - this.x;
                double dy = meteorite.y - this.y;
                double distFromCenter = Math.sqrt(dx * dx + dy * dy);
                double distFromEdge = Math.max(0.0, distFromCenter - meteorite.radius);
                if (!(distFromEdge * distFromEdge < bestDist2)) continue;
                bestDist2 = distFromEdge * distFromEdge;
                target = meteorite;
            }
            if (target != null && (len = Math.hypot(tx = target.x - this.x, ty = target.y - this.y)) > 1.0E-6) {
                boolean sniper = player.getPowerup().equals((Object)Powerups.SNIPER) || player.getPowerup().equals((Object)Powerups.STARDUST) && player.isSniper;
                double multiplier = width >= 1280.0 ? 6.666 : 4.2;
                double speed = sniper ? 280.0 * multiplier : 280.0;
                double desiredVx = (tx /= len) * speed;
                double desiredVy = (ty /= len) * speed;
                double steer = sniper ? 0.40698 : 0.0969;
                this.vx += (desiredVx - this.vx) * steer;
                this.vy += (desiredVy - this.vy) * steer;
                double nv = Math.hypot(this.vx, this.vy);
                if (nv > 1.0E-6) {
                    this.vx = this.vx / nv * speed;
                    this.vy = this.vy / nv * speed;
                }
            }
        }
        this.x += this.vx * dt;
        this.y += this.vy * dt;
        this.wrap(width, height);
        double speed = Math.hypot(this.vx, this.vy);
        double angle = Math.atan2(this.vy, this.vx);
        if (Double.isNaN(angle) || Math.abs(this.vx) < 1.0E-6 && Math.abs(this.vy) < 1.0E-6) {
            angle = this.angle;
        }
        double halfLength = 2.0;
        if (this.type == BulletTypes.SNIPER) {
            double speedFactor = Math.min(3.0, speed / 50.0);
            halfLength = 4.0 * speedFactor;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double hx = cos * halfLength;
        double hy = sin * halfLength;
        double segMx = this.x + hx;
        double segMy = this.y + hy;
        double segBx = this.x - hx;
        double segBy = this.y - hy;
        double bulletThickness = 2.0;
        boolean removed = false;
        for (int midx = 0; midx < meteoriteCount; ++midx) {
            boolean bulletRemoves;
            double collisionRadius;
            int oy;
            double drawMy;
            Meteorite meteorite = meteorites[midx];
            double mx = meteorite.x;
            double my = meteorite.y;
            int ox = (int)Math.round((this.x - mx) / width);
            double drawMx = mx + (double)ox * width;
            double d2 = CollisionUtil.distToSegmentSquared(drawMx, drawMy = my + (double)(oy = (int)Math.round((this.y - my) / height)) * height, segMx, segMy, segBx, segBy);
            if (!(d2 <= (collisionRadius = meteorite.radius + bulletThickness) * collisionRadius)) continue;
            if (player.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
                player.score += 50;
            }
            if (meteorite.isBoss) {
                int dmg = this.type.equals((Object)BulletTypes.SNIPER) ? widget.rng.nextInt(10, 40) : widget.rng.nextInt(1, 4);
                boolean dead = meteorite.damageByBullet(dmg, widget);
                if (dead) {
                    boolean dbl = player.getPowerup().equals((Object)Powerups.DOUBLE_POINTS);
                    int reward = (dbl ? 200 : 100) * meteorite.size + meteorite.maxHp;
                    if (player.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
                        reward *= 4;
                    }
                    player.score += reward;
                    player.pointsWithCurrentPower += 100 * meteorite.size + meteorite.maxHp;
                    widget.splitMeteorite(midx);
                } else {
                    meteorite.hitFlashTimer = 0.12;
                    double strength = Math.min(1.0, (double)dmg * (dmg > 10 ? 0.02 : 0.04));
                    meteorite.hitPulseStrength = Math.max(meteorite.hitPulseStrength, strength);
                    meteorite.hitPulseTimer = 0.16 * (0.8 + 0.8 * strength);
                }
                removed = widget.rng.nextInt(69) <= 42 || !player.getPowerup().equals((Object)Powerups.PIERCING_SHOTS) && this.type != BulletTypes.SNIPER;
                break;
            }
            boolean dbl = player.getPowerup().equals((Object)Powerups.DOUBLE_POINTS);
            int reward = (dbl ? 20 : 10) * meteorite.size;
            if (player.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
                reward *= 4;
            }
            player.score += reward;
            player.pointsWithCurrentPower += 10 * meteorite.size;
            widget.splitMeteorite(midx);
            boolean bl = bulletRemoves = widget.rng.nextInt(4) > 2 || !player.getPowerup().equals((Object)Powerups.PIERCING_SHOTS) && !player.getPowerup().equals((Object)Powerups.STARDUST);
            if (this.type == BulletTypes.SNIPER) {
                bulletRemoves = false;
            }
            if (!bulletRemoves) break;
            removed = true;
            break;
        }
        return !removed;
    }
}

