/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.entity;

import dev.stardust.gui.widgets.meteorites.WMeteorites;
import dev.stardust.gui.widgets.meteorites.entity.Entity;
import dev.stardust.gui.widgets.meteorites.entity.Powerups;
import dev.stardust.gui.widgets.meteorites.entity.Ship;
import dev.stardust.gui.widgets.meteorites.entity.collision.CollisionUtil;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;

public class Meteorite
extends Entity {
    public static final int SIZE_BOSS = 4;
    public static final int SIZE_SMALL = 1;
    public static final int SIZE_LARGE = 3;
    public static final int SIZE_MEDIUM = 2;
    public static final int TOTAL_SIZES = 4;
    public static final double MIN_SMALL_RADIUS = 8.0;
    public static final double MIN_LARGE_RADIUS = 36.0;
    public static final double MIN_MEDIUM_RADIUS = 18.0;
    public static final double SMALL_RADIUS_MULTIPLIER = 3.0;
    public static final double MEDIUM_RADIUS_MULTIPLIER = 6.0;
    public static final double LARGE_RADIUS_MULTIPLIER = 12.0;
    public static final double RESTITUTION = 0.18;
    public static final double MIN_DAMAGE_IMPACT = 18.0;
    public static final double LETHAL_IMPACT_SPEED = 128.0;
    public static final double HULL_BASE_MULTIPLIER = 0.06;
    public static final double METEORITE_MASS_FACTOR = 0.04;
    public static final double PLAYER_KNOCKBACK_MULTIPLIER = 1.6;
    public static final double METEORITE_KNOCKBACK_MULTIPLIER = 0.42;
    public static final double MASS_EXPONENT = 1.666;
    public static final double SMALL_DAMAGE_BONUS = 4.2;
    public static final double LARGE_DAMAGE_PENALTY = 0.72;
    public static final double SMALL_RADIUS_THRESHOLD = 12.0;
    public static final double MAX_SINGLE_HIT_FRACTION = 0.969;
    public static final int BOSS_CHIP_STAGES = 4;
    public static final int BOSS_BASE_HP_PER_100PX = 17;
    public static final int BOSS_MIN_CHIP_FRAGMENTS = 2;
    public static final int BOSS_MAX_CHIP_FRAGMENTS = 6;
    public static final double HIT_FLASH_DURATION = 0.12;
    public static final double HIT_PULSE_DURATION = 0.16;
    public static final int BOSS_MIN_FINAL_FRAGMENTS = 5;
    public static final int BOSS_MAX_FINAL_FRAGMENTS = 10;
    public static final double BOSS_MIN_RADIUS_FACTOR = 0.2;
    public static final double BOSS_MAX_RADIUS_FACTOR = 0.42;
    public int hp;
    public int size;
    public int maxHp;
    private int stage;
    public double radius;
    public boolean isBoss;
    public double maxJitter;
    public double hitPulseTimer;
    public double hitFlashTimer;
    public double hitPulseStrength;
    public int vertCount;
    public double[] polyX;
    public double[] polyY;
    public double rot = 0.0;
    public double rotSpeed = 0.0;

    public void set(double x, double y, double vx, double vy, double radius, boolean boss) {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.isBoss = boss;
        this.radius = radius;
        this.rot = Math.random() * Math.PI * 2.0;
        this.rotSpeed = (Math.random() - 0.5) * 1.5;
        this.rotSpeed += Math.signum(this.vx) * (0.05 + Math.random() * 0.18);
        this.size = this.radius >= 36.0 && !this.isBoss ? 3 : (this.radius >= 18.0 ? 2 : (!this.isBoss ? 1 : 4));
        this.vertCount = 8 + (int)(Math.random() * 7.0);
        this.polyX = new double[this.vertCount];
        this.polyY = new double[this.vertCount];
        double max = 0.0;
        for (int n = 0; n < this.vertCount; ++n) {
            double a = (double)n / (double)this.vertCount * Math.PI * 2.0;
            double jitter = 0.777 + Math.random() * 0.46;
            double r = radius * jitter;
            this.polyX[n] = Math.cos(a) * r;
            this.polyY[n] = Math.sin(a) * r;
            if (!(jitter > max)) continue;
            max = jitter;
        }
        this.maxJitter = max;
    }

    public void set(Meteorite other) {
        this.hp = other.hp;
        this.maxHp = other.maxHp;
        this.stage = other.stage;
        this.isBoss = other.isBoss;
        this.x = other.x;
        this.y = other.y;
        this.vx = other.vx;
        this.vy = other.vy;
        this.radius = other.radius;
        this.rot = other.rot;
        this.rotSpeed = other.rotSpeed;
        this.size = this.radius >= 36.0 && !this.isBoss ? 3 : (this.radius >= 18.0 ? 2 : (!this.isBoss ? 1 : 4));
        if (other.vertCount > 0 && other.polyX != null) {
            this.vertCount = other.vertCount;
            this.polyX = new double[this.vertCount];
            this.polyY = new double[this.vertCount];
            System.arraycopy(other.polyX, 0, this.polyX, 0, this.vertCount);
            System.arraycopy(other.polyY, 0, this.polyY, 0, this.vertCount);
        } else {
            this.vertCount = 0;
            this.polyY = null;
            this.polyX = null;
        }
    }

    public void becomeBoss(double x, double y, double vx, double vy, double width, double height, int wave) {
        this.isBoss = true;
        double minDim = Math.min(width, height);
        double bossRadius = Math.max(minDim * 0.2, Math.min(minDim * 0.42, minDim * 0.2 * ((double)Math.max(wave, 10) / 10.0)));
        this.set(x, y, vx, vy, bossRadius, true);
        this.maxHp = Math.max(40, (int)Math.round(this.radius / 100.0 * 17.0 * 10.0));
        this.stage = 0;
        this.hp = this.maxHp;
        this.rotSpeed = (Math.random() - 0.5) * 0.2 + Math.signum(vx) * 0.07;
        this.vx = vx * 0.37;
        this.vy = vy * 0.37;
    }

    public void render(GuiRenderer renderer, int bx, int by, double width, double height) {
        double rExt = this.aabbRadius();
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oy = -1; oy <= 1; ++oy) {
                double drawX = this.x + (double)ox * width;
                double drawY = this.y + (double)oy * height;
                if (drawX + rExt < 0.0 || drawX - rExt > width || drawY + rExt < 0.0 || drawY - rExt > height) continue;
                double screenX = (double)bx + drawX;
                double screenY = (double)by + drawY;
                double innerScale = 0.96;
                double strokeScale = 1.06;
                Color innerColor = new Color(8, 8, 12);
                Color strokeColor = new Color(255, 255, 255);
                Color highlightColor = new Color(40, 40, 48);
                if (this.isBoss && (this.hitFlashTimer > 0.0 || this.hitPulseTimer > 0.0)) {
                    double flashProgress = this.hitFlashTimer / 0.12;
                    flashProgress = class_3532.method_15363((float)((float)flashProgress), (float)0.0f, (float)1.0f);
                    double fade = Math.pow(flashProgress, 0.6);
                    double pulseProgress = this.hitPulseTimer / 0.16;
                    pulseProgress = class_3532.method_15363((float)((float)pulseProgress), (float)0.0f, (float)1.0f);
                    double p = 1.0 - pulseProgress;
                    double pulseEase = Math.sin(p * Math.PI);
                    double maxScaleBump = 0.037 * this.hitPulseStrength;
                    double scaleBump = maxScaleBump * pulseEase;
                    strokeScale *= 1.0 + scaleBump;
                    innerScale *= 1.0 - 0.02 * pulseEase;
                    int baseStrokeR = 255;
                    int baseStrokeG = 255;
                    int baseStrokeB = 255;
                    strokeColor = new Color(baseStrokeR, baseStrokeG, baseStrokeB, 255);
                    double tintAmount = 1.0 * fade * this.hitPulseStrength * 4.2;
                    int innerR = (int)Math.round(Meteorite.lerp(innerColor.r, highlightColor.r, tintAmount));
                    int innerG = (int)Math.round(Meteorite.lerp(innerColor.g, highlightColor.g, tintAmount));
                    int innerB = (int)Math.round(Meteorite.lerp(innerColor.b, highlightColor.b, tintAmount));
                    int innerA = innerColor.a;
                    innerColor = new Color(innerR, innerG, innerB, innerA);
                }
                double cos = Math.cos(this.rot);
                double sin = Math.sin(this.rot);
                if (this.vertCount < 3) continue;
                double v0x = screenX + (this.polyX[0] * strokeScale * cos - this.polyY[0] * strokeScale * sin);
                double v0y = screenY + (this.polyX[0] * strokeScale * sin + this.polyY[0] * strokeScale * cos);
                for (int v = 1; v < this.vertCount - 1; ++v) {
                    double v1x = screenX + (this.polyX[v] * strokeScale * cos - this.polyY[v] * strokeScale * sin);
                    double v1y = screenY + (this.polyX[v] * strokeScale * sin + this.polyY[v] * strokeScale * cos);
                    double v2x = screenX + (this.polyX[v + 1] * strokeScale * cos - this.polyY[v + 1] * strokeScale * sin);
                    double v2y = screenY + (this.polyX[v + 1] * strokeScale * sin + this.polyY[v + 1] * strokeScale * cos);
                    renderer.triangle(v0x, v0y, v1x, v1y, v2x, v2y, strokeColor);
                }
                double iv0x = screenX + (this.polyX[0] * innerScale * cos - this.polyY[0] * innerScale * sin);
                double iv0y = screenY + (this.polyX[0] * innerScale * sin + this.polyY[0] * innerScale * cos);
                for (int v = 1; v < this.vertCount - 1; ++v) {
                    double iv1x = screenX + (this.polyX[v] * innerScale * cos - this.polyY[v] * innerScale * sin);
                    double iv1y = screenY + (this.polyX[v] * innerScale * sin + this.polyY[v] * innerScale * cos);
                    double iv2x = screenX + (this.polyX[v + 1] * innerScale * cos - this.polyY[v + 1] * innerScale * sin);
                    double iv2y = screenY + (this.polyX[v + 1] * innerScale * sin + this.polyY[v + 1] * innerScale * cos);
                    renderer.triangle(iv0x, iv0y, iv1x, iv1y, iv2x, iv2y, innerColor);
                }
            }
        }
    }

    public void updatePhysics(double dt, double width, double height, double[] shipX, double[] shipY, int count, Ship player, Meteorite[] meteorites, WMeteorites widget) {
        if (this.hitFlashTimer > 0.0) {
            this.hitFlashTimer -= dt;
            if (this.hitFlashTimer < 0.0) {
                this.hitFlashTimer = 0.0;
            }
        }
        if (this.hitPulseTimer > 0.0) {
            this.hitPulseTimer -= dt;
            if (this.hitPulseTimer <= 0.0) {
                this.hitPulseTimer = 0.0;
                this.hitPulseStrength = 0.0;
            }
        }
        this.x += this.vx * dt;
        this.y += this.vy * dt;
        this.wrap(width, height);
        this.updateRotation(dt);
        if (player.getPowerup().equals((Object)Powerups.GRAVITY_WELL) && player.gravityWellDeployed) {
            double gx = player.gravityWellX;
            double gy = player.gravityWellY;
            double falloff = 69.0;
            double falloff2 = falloff * falloff;
            double maxTurnPerTick = Math.PI * 2 * dt;
            for (int n = 0; n < count; ++n) {
                double desiredY;
                double rx;
                double dist;
                double ry;
                double tx;
                double desiredX;
                double dLen;
                double dy;
                Meteorite meteorite2 = meteorites[n];
                double dx = Meteorite.wrappedDelta(gx - meteorite2.x, width);
                double dist2 = dx * dx + (dy = Meteorite.wrappedDelta(gy - meteorite2.y, height)) * dy;
                if (dist2 < 1.0E-8 || dist2 > falloff2 || (dLen = Math.hypot(desiredX = (tx = -(ry = dy / (dist = Math.sqrt(dist2)))) + (rx = dx / dist) * 0.069, desiredY = rx + ry * 0.069)) < 1.0E-8) continue;
                desiredX /= dLen;
                desiredY /= dLen;
                double proximityFactor = 1.0 - dist / falloff;
                if (proximityFactor < 0.0) {
                    proximityFactor = 0.0;
                }
                double massScale = 1.0 / (1.0 + (double)meteorite2.size * 0.75);
                double effectScale = 42.69 * proximityFactor * massScale;
                double vx = meteorite2.vx;
                double vy = meteorite2.vy;
                double speed = Math.hypot(vx, vy);
                if (speed < 1.0E-6) {
                    double kickSpeed = 42.0;
                    meteorite2.vx = desiredX * kickSpeed * effectScale;
                    meteorite2.vy = desiredY * kickSpeed * effectScale;
                    continue;
                }
                double curDirX = vx / speed;
                double curDirY = vy / speed;
                double dot = curDirX * desiredX + curDirY * desiredY;
                dot = Math.max(-1.0, Math.min(1.0, dot));
                double cross = curDirX * desiredY - curDirY * desiredX;
                double angleToDesired = Math.atan2(cross, dot);
                double maxDelta = maxTurnPerTick * Math.max(0.2, effectScale);
                double deltaAngle = Math.max(-maxDelta, Math.min(maxDelta, angleToDesired));
                double cosA = Math.cos(deltaAngle);
                double sinA = Math.sin(deltaAngle);
                double newDirX = curDirX * cosA - curDirY * sinA;
                double newDirY = curDirX * sinA + curDirY * cosA;
                meteorite2.vx = newDirX * speed;
                meteorite2.vy = newDirY * speed;
                double newSpeed = Math.hypot(meteorite2.vx, meteorite2.vy);
                if (!(newSpeed > 128.0)) continue;
                double s = 128.0 / newSpeed;
                meteorite2.vx *= s;
                meteorite2.vy *= s;
            }
        }
        if (player.getPowerup().equals((Object)Powerups.PHASE_SHIFT) && player.phaseActive) {
            return;
        }
        boolean collidedAny = false;
        CollisionUtil.CollisionResult best = null;
        double shipBoundRadius = 10.0;
        double earlyR = this.aabbRadius() + shipBoundRadius;
        block1: for (int ox = -1; ox <= 1 && !collidedAny; ++ox) {
            for (int oy = -1; oy <= 1; ++oy) {
                double drawX = this.x + (double)ox * width;
                double dxC = drawX - player.x;
                double drawY = this.y + (double)oy * height;
                double dyC = drawY - player.y;
                if (dxC * dxC + dyC * dyC > earlyR * earlyR) continue;
                int vc = this.vertCount;
                double[] mWorldX = new double[vc];
                double[] mWorldY = new double[vc];
                double cos = Math.cos(this.rot);
                double sin = Math.sin(this.rot);
                for (int v = 0; v < vc; ++v) {
                    double rx = this.polyX[v];
                    double ry = this.polyY[v];
                    mWorldX[v] = drawX + (rx * cos - ry * sin);
                    mWorldY[v] = drawY + (rx * sin + ry * cos);
                }
                CollisionUtil.CollisionResult result = CollisionUtil.satPolygonCollision(shipX, shipY, mWorldX, mWorldY, vc);
                if (!result.collided) continue;
                collidedAny = true;
                best = result;
                continue block1;
            }
        }
        if (!collidedAny) {
            return;
        }
        if (player.iFrames > 0.0 || player.getPowerup().equals((Object)Powerups.HIGH_TECH_HULL) || player.getPowerup().equals((Object)Powerups.REINFORCED_HULL)) {
            double nx = best.nx;
            double ny = best.ny;
            double impactSpeed = Math.abs((this.vx - player.vx) * nx + (this.vy - player.vy) * ny);
            double meteoriteMass = Math.pow(this.radius, 1.666) * 0.04 + 1.0E-6;
            double invMassP = 4.0;
            double invMassM = 1.0 / meteoriteMass;
            if (impactSpeed >= 128.0 && player.iFrames <= 0.0) {
                player.onHit(width, height, widget);
                return;
            }
            if (impactSpeed < 18.0) {
                this.x += nx * 2.0;
                this.y += ny * 2.0;
                this.vx += nx * 6.0;
                this.vy += ny * 6.0;
                if (player.iFrames <= 0.0) {
                    widget.playSound(class_3417.field_14778, ThreadLocalRandom.current().nextFloat(0.666f, 1.1337f));
                }
                player.iFrames = 0.42;
                return;
            }
            double baseDamage = 0.06 * impactSpeed * (meteoriteMass * 0.5);
            double sizeBias = 1.0;
            if (this.radius < 12.0) {
                sizeBias = impactSpeed >= 64.0 ? 4.2 : 2.1;
            } else if (this.radius >= 36.0) {
                sizeBias = 0.72;
            }
            double damage = baseDamage * sizeBias;
            damage = Math.max(1.0, damage);
            double maxPerHit = 96.89999999999999;
            if (damage > maxPerHit) {
                damage = maxPerHit;
            }
            if (player.iFrames <= 0.0) {
                player.damageHull(damage);
                widget.playSound(class_3417.field_15115, 0.9f);
            } else {
                widget.playSound(class_3417.field_14794, 0.7f, ((Double)widget.module.soundVolume.get()).floatValue() * 0.66f);
            }
            double j = -1.18 * ((this.vx - player.vx) * nx + (this.vy - player.vy) * ny);
            double denom = invMassP + invMassM;
            if (denom <= 0.0) {
                denom = 1.0E-6;
            }
            if ((j /= denom) < 0.0) {
                j = -j;
            }
            player.vx -= nx * j * invMassP * 1.6;
            player.vy -= ny * j * invMassP * 1.6;
            this.vx += nx * j * invMassM * 0.42;
            this.vy += ny * j * invMassM * 0.42;
            double pushOut = best.penetration + 1.4;
            if (pushOut > 0.0) {
                this.x += nx * pushOut * 0.7;
                this.y += ny * pushOut * 0.7;
                player.x -= nx * pushOut * 0.3;
                player.y -= ny * pushOut * 0.3;
            }
            player.iFrames = 0.42;
            if (player.hull <= 0.0) {
                player.onHit(width, height, widget);
            } else {
                return;
            }
        }
        player.onHit(width, height, widget);
    }

    public boolean damageByBullet(int damageAmount, WMeteorites widget) {
        double fraction;
        int newStage;
        if (!this.isBoss) {
            return false;
        }
        this.hp -= damageAmount;
        widget.playSound(widget.rng.nextBoolean() ? class_3417.field_21891 : class_3417.field_28973, widget.rng.nextFloat(1.137f, 2.1f), ((Double)widget.module.soundVolume.get()).floatValue() * 0.42f);
        if (widget.rng.nextDouble() <= 0.1337) {
            widget.playSound(class_3417.field_14833, widget.rng.nextFloat(3.333f, 4.42f), ((Double)widget.module.soundVolume.get()).floatValue() * 0.1337f);
        }
        if ((newStage = (int)Math.floor((1.0 - (fraction = (double)this.hp / (double)this.maxHp)) * 4.0)) > this.stage) {
            for (int s = this.stage + 1; s <= newStage; ++s) {
                int fragments = widget.rng.nextInt(2, 7);
                fragments = (int)Math.round((double)fragments * (1.0 + (double)s * ((double)widget.wave / 10.0)));
                this.chipOff(fragments, widget);
            }
            this.stage = newStage;
            widget.playSound((class_3414)class_3417.field_15152.comp_349(), widget.rng.nextFloat(0.8f, 1.1f), ((Double)widget.module.soundVolume.get()).floatValue() * 0.42f);
        }
        if (this.hp <= 0) {
            this.explode(widget);
            return true;
        }
        return false;
    }

    private void chipOff(int nFragments, WMeteorites widget) {
        if (nFragments <= 0) {
            return;
        }
        widget.playSound((class_3414)WMeteorites.BREAK_SOUNDS.get(widget.rng.nextInt(WMeteorites.BREAK_SOUNDS.size())), ThreadLocalRandom.current().nextFloat(0.42f, 0.69f));
        for (int n = 0; n < nFragments; ++n) {
            double angle = widget.rng.nextDouble(0.0, Math.PI * 2);
            double r = widget.rng.nextDouble();
            double fragRadius = r < 0.25 ? 36.0 + widget.rng.nextDouble() * 12.0 : (r < 0.45 ? 18.0 + widget.rng.nextDouble() * 6.0 : 8.0 + widget.rng.nextDouble() * 3.0);
            double spawnOffsetMin = 0.666;
            double spawnOffsetMax = 0.777;
            double speedMin = 47.0 + (double)widget.wave;
            double speedMax = 100.0 * Math.min(1.0, this.radius / 120.0) + (double)widget.wave;
            widget.spawnChildMeteorite(this, angle, speedMin, speedMax, spawnOffsetMin, spawnOffsetMax, fragRadius);
        }
    }

    private void explode(WMeteorites widget) {
        widget.playSound((class_3414)class_3417.field_15152.comp_349(), widget.rng.nextFloat(0.8f, 1.15f));
        int finalCount = widget.rng.nextInt(5, 11) * (widget.wave / 10);
        for (int n = 0; n < finalCount; ++n) {
            double angle = widget.rng.nextDouble(0.0, Math.PI * 2);
            double r = widget.rng.nextDouble();
            double fragRadius = r < 0.42 ? 36.0 + widget.rng.nextDouble() * 12.0 : (r < 0.69 ? 18.0 + widget.rng.nextDouble() * 6.0 : 8.0 + widget.rng.nextDouble() * 3.0);
            double spawnOffsetMin = 0.069;
            double spawnOffsetMax = 0.777;
            double speedMin = 69.0 + (double)widget.wave;
            double speedMax = 242.0 * Math.min(1.0, this.radius / 120.0) + (double)widget.wave;
            widget.spawnChildMeteorite(this, angle, speedMin, speedMax, spawnOffsetMin, spawnOffsetMax, fragRadius);
        }
        this.isBoss = false;
    }

    public void updateRotation(double dt) {
        this.rot += this.rotSpeed * dt;
    }

    public double aabbRadius() {
        return Math.max(this.radius * this.maxJitter, 4.0);
    }

    public static double wrappedDelta(double targetMinusSource, double span) {
        double d;
        double half = span * 0.5;
        for (d = targetMinusSource; d > half; d -= span) {
        }
        while (d <= -half) {
            d += span;
        }
        return d;
    }

    public static double lerp(double a, double b, double t) {
        return a + (b - a) * (double)class_3532.method_15363((float)((float)t), (float)0.0f, (float)1.0f);
    }
}

