/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.entity;

import dev.stardust.gui.widgets.meteorites.WMeteorites;
import dev.stardust.gui.widgets.meteorites.entity.Bullet;
import dev.stardust.gui.widgets.meteorites.entity.BulletTypes;
import dev.stardust.gui.widgets.meteorites.entity.Entity;
import dev.stardust.gui.widgets.meteorites.entity.Meteorite;
import dev.stardust.gui.widgets.meteorites.entity.Powerups;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class Ship
extends Entity {
    public static final double SHIP_MASS = 0.25;
    public static final double SHIP_FRICTION = 0.98;
    public static final double SHOOT_COOLDOWN = 0.18;
    public static final double MAX_HULL_HEALTH = 100.0;
    public static final double SHIP_ROT_SPEED = Math.toRadians(250.0);
    public static final int HYPERSPACE_ATTEMPTS = 25;
    public static final double RESPAWN_SAFE_DIST = 80.0;
    public static final int SAFE_RESPAWN_ATTEMPTS = 50;
    public static final int HYPERSPACE_SCORE_COST = 1000;
    public static final double HYPERSPACE_SAFE_DIST = 90.0;
    public static final double WAVE_SPAWN_SAFE_DIST = 140.0;
    public static final double CALIBRATED_WARP_COOLDOWN = 3.0;
    public static final double IFRAMES_ON_RESPAWN = 1.8;
    public static final double IFRAMES_ON_HYPERJUMP = 1.2;
    public static final double IFRAMES_ON_EXIT_PHASE = 0.42;
    public static final double IFRAMES_ON_ASTEROID_COLLISION = 0.42;
    public static final double GW_FALLOFF = 69.0;
    public static final double GW_STRENGTH = 42.69;
    public static final double GW_RADIAL_BIAS = 0.069;
    public static final double GW_MAX_TURN_RADS = Math.PI * 2;
    public static final double GW_METEORITE_SIZE_MASS_FACTOR = 0.75;
    public static final double GW_MAX_METEORITE_SPEED = 128.0;
    public static final double SHOTGUN_SPREAD_DEGREES = 30.0;
    public static final double SHOTGUN_SPEED_MULTIPLIER = 2.0;
    public static final double SHOTGUN_LIFETIME_MULTIPLIER = 0.3333333333333333;
    public static final double SHOTGUN_JITTER_RAD = Math.toRadians(6.0);
    public static final double SHOTGUN_SPREAD_RAD = Math.toRadians(30.0);
    public static final int MIDAS_TOUCH_BULLET_COST = 50;
    public static final int MIDAS_TOUCH_REWARD_MULTIPLIER = 4;
    Powerups powerUp;
    public long lastHyperJump;
    private boolean jumpCooling;
    public long lastMidasRejectSound;
    public double shootCooldownTimer;
    public int pointsWithCurrentPower;
    public double angle = -1.5707963267948966;
    public double hull = 100.0;
    public final Map<Powerups, Integer> powerMap = new HashMap<Powerups, Integer>();
    public boolean rotLeft;
    public boolean rotRight;
    public boolean thrusting;
    public boolean entropy;
    public boolean invulnerable;
    public boolean isShotgun;
    public boolean isSniper;
    public double phaseTimer;
    public boolean phaseActive;
    public double phaseCooldownTimer;
    public final double phaseDuration = 2.0;
    public final double phaseCooldown = 2.42;
    public double gravityWellX;
    public double gravityWellY;
    public double gravityWellTimer;
    public double gravityWellCdTimer;
    public boolean gravityWellDeployed;
    public final double gravityWellCooldown = 5.0;
    public final double gravityWellDuration = 10.0;
    public int lives = 3;
    public int score = 0;
    public double iFrames;
    public final double thrustStrength;

    public Ship(double x, double y, double thrust) {
        this.x = x;
        this.y = y;
        this.powerUp = Powerups.NONE;
        this.thrustStrength = thrust;
    }

    public Powerups getPowerup() {
        return this.powerUp;
    }

    public void setPowerup(Powerups powerUp) {
        this.powerUp = powerUp;
    }

    public void resetHull() {
        this.hull = 100.0;
    }

    public boolean isHullFull() {
        return this.hull >= 99.45;
    }

    public void damageHull(double dmg) {
        this.hull -= dmg;
        if (this.hull < 0.0) {
            this.hull = 0.0;
        }
    }

    public void healHull(double health) {
        this.hull += health;
        if (this.hull > 100.0) {
            this.hull = 100.0;
        }
    }

    public boolean hasEntropy() {
        return this.entropy;
    }

    public void setEntropy(boolean entropy) {
        this.entropy = entropy;
    }

    public void resetPhase() {
        this.phaseTimer = 0.0;
        this.phaseActive = false;
        this.phaseCooldownTimer = 0.0;
    }

    public void creditPowerup() {
        this.powerMap.computeIfPresent(this.hasEntropy() ? Powerups.ENTROPY : this.getPowerup(), (k, pointsEarned) -> pointsEarned + this.pointsWithCurrentPower);
        this.powerMap.computeIfAbsent(this.hasEntropy() ? Powerups.ENTROPY : this.getPowerup(), pwr -> this.pointsWithCurrentPower);
        this.pointsWithCurrentPower = 0;
    }

    public void resetPowerup() {
        this.resetGun();
        this.resetHull();
        this.resetPhase();
        this.setEntropy(false);
        this.resetGravityWell();
        this.setPowerup(Powerups.NONE);
    }

    public void resetGun() {
        this.isSniper = false;
        this.isShotgun = false;
    }

    public void resetGravityWell() {
        this.gravityWellX = 0.0;
        this.gravityWellY = 0.0;
        this.gravityWellTimer = 0.0;
        this.gravityWellCdTimer = 0.0;
        this.gravityWellDeployed = false;
    }

    public void render(GuiRenderer renderer, int bx, int by, SettingColor shipColor, SettingColor flameColor) {
        double sx = this.x + (double)bx;
        double sy = this.y + (double)by;
        double angle = this.angle;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double s1x = sx + cos * 10.0;
        double s1y = sy + sin * 10.0;
        double s2x = sx + Math.cos(angle + 2.356194490192345) * 8.0;
        double s2y = sy + Math.sin(angle + 2.356194490192345) * 8.0;
        double s3x = sx + Math.cos(angle - 2.356194490192345) * 8.0;
        double s3y = sy + Math.sin(angle - 2.356194490192345) * 8.0;
        if (this.thrusting) {
            boolean strong = this.getPowerup().equals((Object)Powerups.THRUSTER_UPGRADES) || this.getPowerup().equals((Object)Powerups.STARDUST);
            double thrustStrength = strong ? 12.0 : 10.0;
            double fx = sx - cos * thrustStrength;
            double fy = sy - sin * thrustStrength;
            renderer.triangle(fx, fy, s2x, s2y, s3x, s3y, (Color)flameColor);
        }
        renderer.triangle(s1x, s1y, s2x, s2y, s3x, s3y, (Color)shipColor);
    }

    public void updatePhysics(double dt, double width, double height, double aimMouseLocalX, double aimMouseLocalY, WMeteorites widget) {
        double rotSpeed;
        boolean strong = this.getPowerup().equals((Object)Powerups.THRUSTER_UPGRADES) || this.getPowerup().equals((Object)Powerups.STARDUST);
        double d = rotSpeed = strong ? Math.toRadians(269.0) : SHIP_ROT_SPEED;
        if (this.rotLeft) {
            this.angle -= rotSpeed * dt;
        }
        if (this.rotRight) {
            this.angle += rotSpeed * dt;
        }
        if (((Boolean)widget.module.mouseAim.get()).booleanValue() && !this.rotLeft && !this.rotRight && (widget.mouseInBounds || ((Boolean)widget.module.mouseAimOutside.get()).booleanValue())) {
            double target = Math.atan2(aimMouseLocalY - this.y, aimMouseLocalX - this.x);
            if (this.getPowerup().equals((Object)Powerups.PRECISION_AIM) || this.getPowerup().equals((Object)Powerups.STARDUST) || this.getPowerup().equals((Object)Powerups.SNIPER)) {
                this.angle = target;
            } else {
                double delta = this.shortestAngleDiff(target, this.angle);
                double maxTurn = SHIP_ROT_SPEED * dt;
                this.angle = Math.abs(delta) <= maxTurn ? target : (this.angle += Math.signum(delta) * maxTurn);
            }
        }
        if (this.invulnerable) {
            this.iFrames = Double.MAX_VALUE;
        }
        if (this.iFrames > 0.0) {
            this.iFrames -= dt;
            if (this.iFrames < 0.0) {
                this.iFrames = 0.0;
            }
        }
        if (this.shootCooldownTimer > 0.0) {
            this.shootCooldownTimer -= dt;
        }
        if (this.getPowerup().equals((Object)Powerups.HIGH_TECH_HULL)) {
            this.healHull(dt);
        }
        if (this.getPowerup().equals((Object)Powerups.GRAVITY_WELL)) {
            if (this.gravityWellDeployed) {
                this.gravityWellTimer -= dt;
                if (this.gravityWellTimer <= 0.0) {
                    this.gravityWellDeployed = false;
                    this.gravityWellCdTimer = this.gravityWellCooldown;
                    widget.playSound(class_3417.field_15065, widget.rng.nextFloat(0.77f, 1.1337f));
                }
            } else if (this.gravityWellTimer <= 0.0 && this.gravityWellCdTimer > 0.0) {
                this.gravityWellCdTimer -= dt;
                if (this.gravityWellCdTimer <= 0.0) {
                    this.gravityWellCdTimer = 0.0;
                    widget.playSound(class_3417.field_48791, widget.rng.nextFloat(0.77f, 1.1337f));
                }
            }
        }
        if (this.getPowerup().equals((Object)Powerups.PHASE_SHIFT)) {
            if (this.phaseActive) {
                this.phaseTimer += dt;
                if (this.phaseTimer >= this.phaseDuration) {
                    this.phaseTimer = 0.0;
                    this.phaseActive = false;
                    this.iFrames = 0.42;
                    this.phaseCooldownTimer = this.phaseCooldown;
                    widget.playSound(class_3417.field_46945, 0.69f);
                }
            } else if (this.phaseCooldownTimer >= 0.0) {
                this.phaseCooldownTimer -= dt;
                if (this.phaseCooldownTimer <= 0.0) {
                    widget.playSound(class_3417.field_48791, widget.rng.nextFloat(0.77f, 1.1337f));
                }
            }
        }
        if (this.jumpCooling) {
            if (this.getPowerup().equals((Object)Powerups.CALIBRATED_FSD)) {
                if ((double)(System.currentTimeMillis() - this.lastHyperJump) >= 3000.0) {
                    this.jumpCooling = false;
                }
            } else if (this.isShotgun && this.getPowerup().equals((Object)Powerups.STARDUST)) {
                if (System.currentTimeMillis() - this.lastHyperJump >= 1000L) {
                    this.jumpCooling = false;
                }
            } else if (!this.getPowerup().equals((Object)Powerups.SUPERCHARGED_FSD) && this.score >= 1000 && (double)(System.currentTimeMillis() - this.lastHyperJump) >= 3599.9999999999995) {
                this.jumpCooling = false;
            }
            if (!this.jumpCooling) {
                widget.playSound(class_3417.field_48791, widget.rng.nextFloat(0.77f, 1.1337f));
            }
        }
        if (this.thrusting) {
            double thrustStrength = strong ? this.thrustStrength * 2.0 : this.thrustStrength;
            this.vx += Math.cos(this.angle) * thrustStrength * dt;
            this.vy += Math.sin(this.angle) * thrustStrength * dt;
            widget.playThrustInstance();
        } else {
            widget.killThrustInstance();
        }
        this.vx *= Math.pow(0.98, dt * 60.0);
        this.vy *= Math.pow(0.98, dt * 60.0);
        this.x += this.vx * dt;
        this.y += this.vy * dt;
        this.wrap(width, height);
    }

    public void onHit(double width, double height, WMeteorites widget) {
        --this.lives;
        if (this.lives > 0) {
            if (!widget.CHEAT_MODE) {
                this.setEntropy(false);
                if (this.getPowerup().equals((Object)Powerups.STARDUST)) {
                    widget.deInitStardustColor();
                } else if (this.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
                    widget.deInitMidasColor();
                }
                this.creditPowerup();
                this.resetPowerup();
            } else {
                this.resetHull();
                this.resetPhase();
                this.resetGravityWell();
            }
            double[] safe = this.findSafePosition(width, height, 80.0, 30.0, 50, widget);
            if (safe != null) {
                this.x = safe[0];
                this.y = safe[1];
            } else {
                this.x = width / 2.0;
                this.y = height / 2.0;
                widget.clearMeteoritesAround(this.x, this.y);
            }
            this.vx = 0.0;
            this.vy = 0.0;
            if (((Boolean)widget.module.renderStarfield.get()).booleanValue()) {
                double dt = widget.gameTimeSecs + widget.accumulator / 1.0E9;
                widget.starfield.resetSmooth(this.x, this.y, 0.69, dt);
            }
            this.iFrames = 1.8;
            if (!(this.getPowerup().equals((Object)Powerups.CALIBRATED_FSD) || this.getPowerup().equals((Object)Powerups.STARDUST) && this.isSniper)) {
                this.lastHyperJump = System.currentTimeMillis();
            }
            widget.playSound(class_3417.field_15115, widget.rng.nextFloat(0.77f, 1.1337f));
        } else {
            this.vy = 0.0;
            this.vx = 0.0;
            widget.gameOver = true;
            widget.playSound(class_3417.field_14904, widget.rng.nextFloat(0.77f, 1.1337f));
            widget.playSound((class_3414)class_3417.field_15152.comp_349(), widget.rng.nextFloat(0.77f, 1.1337f));
            this.creditPowerup();
            widget.updateHighScore();
        }
    }

    public void tryToShoot(WMeteorites widget) {
        double recoilPerSpeed;
        int capacityLimit;
        boolean hell;
        if (this.getPowerup().equals((Object)Powerups.MIDAS_TOUCH) && this.score < 50) {
            long now = System.currentTimeMillis();
            if (now - this.lastMidasRejectSound >= 1337L) {
                this.lastMidasRejectSound = now;
                widget.playSound(class_3417.field_15008, widget.rng.nextFloat(0.969f, 1.1337f));
            }
            return;
        }
        boolean sniper = this.getPowerup().equals((Object)Powerups.SNIPER) || this.getPowerup().equals((Object)Powerups.STARDUST) && this.isSniper;
        boolean shotgun = this.getPowerup().equals((Object)Powerups.SHOTGUN) || this.getPowerup().equals((Object)Powerups.STARDUST) && this.isShotgun;
        boolean bl = hell = this.getPowerup().equals((Object)Powerups.BULLET_HELL) || this.getPowerup().equals((Object)Powerups.STARDUST) && !shotgun && !sniper;
        int n = hell ? widget.MAX_BULLETS * 4 : (capacityLimit = shotgun ? widget.MAX_BULLETS * 2 : widget.MAX_BULLETS);
        if (widget.bulletCount >= capacityLimit) {
            return;
        }
        int availableSlots = capacityLimit - widget.bulletCount;
        int pelletCount = 1;
        if (shotgun) {
            pelletCount = widget.rng.nextInt(4, 13);
        }
        if (pelletCount > availableSlots) {
            pelletCount = availableSlots;
        }
        if (pelletCount <= 0) {
            return;
        }
        if (!shotgun) {
            boolean rapid;
            double bulletLifetime;
            Bullet b = widget.bullets[widget.bulletCount++];
            double multiplier = widget.width >= 1280.0 ? 6.666 : 4.2;
            double speed = sniper ? 280.0 * multiplier : 280.0;
            double d = bulletLifetime = hell ? 4.8 : 1.2;
            if (hell) {
                speed *= 1.5;
            }
            if (this.getPowerup().equals((Object)Powerups.HOMING_SHOTS)) {
                bulletLifetime *= 2.0;
            } else if (this.getPowerup().equals((Object)Powerups.STARDUST) && this.isSniper) {
                bulletLifetime *= 1.337;
            }
            b.set(sniper ? BulletTypes.SNIPER : BulletTypes.NORMAL, this.x + Math.cos(this.angle) * 12.0, this.y + Math.sin(this.angle) * 12.0, Math.cos(this.angle) * speed + this.vx, Math.sin(this.angle) * speed + this.vy, bulletLifetime, this.angle);
            boolean bl2 = rapid = this.getPowerup().equals((Object)Powerups.RAPID_FIRE) || this.getPowerup().equals((Object)Powerups.STARDUST) && !this.isSniper;
            this.shootCooldownTimer = rapid ? 0.09 : (sniper ? 0.756 : 0.18);
            widget.playSound(class_3417.field_15187, widget.rng.nextFloat(3.3333f, 4.2f), ((Double)widget.module.soundVolume.get()).floatValue() * (sniper ? 0.69f : 0.333f));
            if (this.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
                this.score -= 50;
            }
            return;
        }
        double baseAngle = this.angle;
        double d = recoilPerSpeed = this.getPowerup().equals((Object)Powerups.STARDUST) ? 0.00666 : 0.00969;
        if (pelletCount == 1) {
            Bullet b = widget.bullets[widget.bulletCount++];
            double speed = 560.0 * (0.9 + widget.rng.nextDouble() * 0.2);
            b.set(BulletTypes.NORMAL, this.x + Math.cos(baseAngle) * 12.0, this.y + Math.sin(baseAngle) * 12.0, Math.cos(baseAngle) * speed + this.vx, Math.sin(baseAngle) * speed + this.vy, 0.39999999999999997, this.angle);
        } else {
            double spacing = SHOTGUN_SPREAD_RAD / (double)Math.max(1, pelletCount - 1);
            double half = SHOTGUN_SPREAD_RAD * 0.5;
            double sumBulletSpeed = 0.0;
            for (int n2 = 0; n2 < pelletCount; ++n2) {
                double angle = baseAngle - half + (double)n2 * spacing + (widget.rng.nextDouble() * 2.0 - 1.0) * SHOTGUN_JITTER_RAD;
                double speed = 280.0 * (2.0 * (0.85 + widget.rng.nextDouble() * 0.3));
                sumBulletSpeed += speed;
                Bullet b = widget.bullets[widget.bulletCount++];
                b.set(BulletTypes.NORMAL, this.x + Math.cos(angle) * 12.0, this.y + Math.sin(angle) * 12.0, Math.cos(angle) * speed + this.vx, Math.sin(angle) * speed + this.vy, 0.39999999999999997, this.angle);
            }
            double avgSpeed = sumBulletSpeed / (double)pelletCount;
            double recoil = avgSpeed * (double)pelletCount * recoilPerSpeed;
            this.vx -= Math.cos(baseAngle) * recoil;
            this.vy -= Math.sin(baseAngle) * recoil;
        }
        boolean rapid = this.getPowerup().equals((Object)Powerups.RAPID_FIRE) || this.getPowerup().equals((Object)Powerups.STARDUST);
        this.shootCooldownTimer = rapid ? 0.09 : 0.945;
        float pitch = widget.rng.nextFloat(1.666f, 2.1337f);
        float pitch2 = widget.rng.nextFloat(1.666f, 2.1337f);
        widget.playSound(class_3417.field_15187, pitch, ((Double)widget.module.soundVolume.get()).floatValue() * 0.42f);
        widget.playSound(class_3417.field_15187, pitch2, ((Double)widget.module.soundVolume.get()).floatValue() * 0.69f);
    }

    public void doHyperspaceJump(boolean poweredUp, boolean calibrated, double width, double height, WMeteorites widget) {
        if (calibrated) {
            this.x = widget.aimMouseLocalX;
            this.y = widget.aimMouseLocalY;
        } else {
            double[] safe = this.findSafePosition(width, height, 90.0, 25.0, 25, widget);
            if (safe != null) {
                this.x = safe[0];
                this.y = safe[1];
            } else {
                this.x = width / 2.0;
                this.y = height / 2.0;
            }
        }
        this.jumpCooling = true;
        if (((Boolean)widget.module.renderStarfield.get()).booleanValue()) {
            double dt = widget.gameTimeSecs + widget.accumulator / 1.0E9;
            widget.starfield.resetSmooth(this.x, this.y, 0.45, dt);
        }
        this.vx = (widget.rng.nextDouble() - 0.5) * 60.0;
        this.vy = (widget.rng.nextDouble() - 0.5) * 60.0;
        widget.playSound(class_3417.field_46945, widget.rng.nextFloat(0.8f, 1.1337f));
        if (!poweredUp) {
            this.iFrames = 1.2;
        }
    }

    public double[] findSafePosition(double width, double height, double minDistFromPlayer, double minDistFromMeteorites, int attempts, WMeteorites widget) {
        for (int n = 0; n < attempts; ++n) {
            double sy;
            double dyp;
            double sx = 20.0 + widget.rng.nextDouble() * (width - 40.0);
            double dxp = sx - this.x;
            if (dxp * dxp + (dyp = (sy = 20.0 + widget.rng.nextDouble() * (height - 40.0)) - this.y) * dyp < minDistFromPlayer * minDistFromPlayer) continue;
            boolean ok = true;
            for (int i = 0; i < widget.meteoriteCount; ++i) {
                Meteorite meteorite = widget.meteorites[i];
                double dx = sx - meteorite.x;
                double dy = sy - meteorite.y;
                double minAllowed = minDistFromMeteorites + meteorite.radius;
                if (!(dx * dx + dy * dy < minAllowed * minAllowed)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return new double[]{sx, sy};
        }
        return null;
    }

    public void cyclePowerup(WMeteorites widget) {
        Powerups nextPower;
        this.resetGun();
        this.resetHull();
        this.resetPhase();
        this.creditPowerup();
        this.resetGravityWell();
        Powerups[] vals = Powerups.values();
        int len = vals.length;
        int current = this.hasEntropy() ? Powerups.ENTROPY.ordinal() : this.getPowerup().ordinal();
        int start = (current + 1) % len;
        if (this.hasEntropy()) {
            this.setEntropy(false);
        } else if (this.getPowerup().equals((Object)Powerups.STARDUST)) {
            widget.deInitStardustColor();
        } else if (this.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
            widget.deInitMidasColor();
        }
        int foundIdx = -1;
        for (int n = 0; n < len; ++n) {
            int idx = (start + n) % len;
            Powerups[] p = vals[idx];
            if (!((Boolean)widget.module.mouseAim.get()).booleanValue() && (p == Powerups.PRECISION_AIM || p == Powerups.CALIBRATED_FSD)) continue;
            foundIdx = idx;
            break;
        }
        if ((nextPower = vals[foundIdx]) == Powerups.ENTROPY) {
            ArrayList<Powerups> valid = new ArrayList<Powerups>();
            for (Powerups p : vals) {
                if (p == Powerups.NONE || p == Powerups.ENTROPY || p == Powerups.STARDUST || !((Boolean)widget.module.mouseAim.get()).booleanValue() && (p == Powerups.PRECISION_AIM || p == Powerups.CALIBRATED_FSD)) continue;
                valid.add(p);
            }
            Powerups chosen = (Powerups)((Object)valid.get(widget.rng.nextInt(valid.size())));
            this.setEntropy(true);
            this.setPowerup(chosen);
            return;
        }
        if (nextPower == Powerups.MIDAS_TOUCH) {
            widget.initMidasColor();
        }
        if (nextPower == Powerups.STARDUST) {
            widget.initStardustColor();
            if (widget.rng.nextBoolean()) {
                this.isSniper = widget.rng.nextInt(69) > 42;
            } else {
                this.isShotgun = widget.rng.nextInt(69) > 42;
            }
        }
        this.setPowerup(nextPower);
    }

    public void gainNewPowerup(@Nullable Powerups excludeLast, WMeteorites widget) {
        this.resetGun();
        this.resetHull();
        this.resetPhase();
        this.resetGravityWell();
        if (!this.hasEntropy()) {
            this.creditPowerup();
        }
        if (this.getPowerup().equals((Object)Powerups.STARDUST)) {
            widget.deInitStardustColor();
        } else if (this.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
            widget.deInitMidasColor();
        }
        if (!this.hasEntropy()) {
            boolean hyperLucky;
            boolean bl = widget.wave % 10 == 9 ? widget.rng.nextInt(widget.CHEAT_MODE ? 7 : 69) <= widget.wave % 3 : (hyperLucky = widget.rng.nextInt(widget.CHEAT_MODE ? 10 : 100) <= widget.wave % 3);
            if (hyperLucky && (excludeLast != Powerups.STARDUST || !this.getPowerup().equals((Object)Powerups.STARDUST))) {
                widget.initStardustColor();
                this.setPowerup(Powerups.STARDUST);
                if (widget.rng.nextBoolean()) {
                    this.isSniper = widget.rng.nextInt(69) > 42;
                } else {
                    this.isShotgun = widget.rng.nextInt(69) > 42;
                }
                return;
            }
        }
        ArrayList<Powerups> valid = new ArrayList<Powerups>();
        for (Powerups power : Powerups.values()) {
            if (power.equals((Object)excludeLast) || power.equals((Object)Powerups.NONE) || power.equals((Object)Powerups.STARDUST) || this.hasEntropy() && power.equals((Object)Powerups.ENTROPY) || power.equals((Object)Powerups.PRECISION_AIM) && !((Boolean)widget.module.mouseAim.get()).booleanValue() || power.equals((Object)Powerups.CALIBRATED_FSD) && !((Boolean)widget.module.mouseAim.get()).booleanValue()) continue;
            valid.add(power);
        }
        int luckyIndex = widget.rng.nextInt(valid.size());
        Powerups powerup = (Powerups)((Object)valid.get(luckyIndex));
        if (powerup.equals((Object)Powerups.ENTROPY)) {
            valid.remove((Object)Powerups.ENTROPY);
            int newLuck = widget.rng.nextInt(valid.size());
            this.setEntropy(true);
            this.setPowerup((Powerups)((Object)valid.get(newLuck)));
        } else {
            this.setPowerup(powerup);
        }
        if (this.getPowerup().equals((Object)Powerups.MIDAS_TOUCH)) {
            widget.initMidasColor();
        }
    }

    private double shortestAngleDiff(double target, double src) {
        double a = (target - src) % (Math.PI * 2);
        if (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        if (a > Math.PI) {
            a -= Math.PI * 2;
        }
        return a;
    }
}

