/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.entity.collision;

public class CollisionUtil {
    public static CollisionResult satPolygonCollision(double[] ax, double[] ay, double[] bx, double[] by, int bc) {
        double overlap;
        double[] ov;
        CollisionResult res = new CollisionResult();
        double bestAx = 0.0;
        double bestAy = 0.0;
        res.collided = true;
        double minOverlap = Double.POSITIVE_INFINITY;
        double[] proj = new double[2];
        double[] proj2 = new double[2];
        double[] normalTmp = new double[2];
        int i = 0;
        int j = 2;
        while (i < 3) {
            CollisionUtil.edgeNormal(j, i, ax, ay, normalTmp);
            CollisionUtil.projectPolygon(ax, ay, 3, normalTmp[0], normalTmp[1], proj);
            CollisionUtil.projectPolygon(bx, by, bc, normalTmp[0], normalTmp[1], proj2);
            ov = new double[1];
            if (!CollisionUtil.intervalOverlap(proj[0], proj[1], proj2[0], proj2[1], ov)) {
                res.collided = false;
                return res;
            }
            overlap = ov[0];
            if (overlap < minOverlap) {
                minOverlap = overlap;
                bestAx = normalTmp[0];
                bestAy = normalTmp[1];
            }
            j = i++;
        }
        i = 0;
        j = bc - 1;
        while (i < bc) {
            CollisionUtil.edgeNormal(j, i, bx, by, normalTmp);
            CollisionUtil.projectPolygon(ax, ay, 3, normalTmp[0], normalTmp[1], proj);
            CollisionUtil.projectPolygon(bx, by, bc, normalTmp[0], normalTmp[1], proj2);
            ov = new double[1];
            if (!CollisionUtil.intervalOverlap(proj[0], proj[1], proj2[0], proj2[1], ov)) {
                res.collided = false;
                return res;
            }
            overlap = ov[0];
            if (overlap < minOverlap) {
                minOverlap = overlap;
                bestAx = normalTmp[0];
                bestAy = normalTmp[1];
            }
            j = i++;
        }
        res.penetration = minOverlap;
        double acx = 0.0;
        double acy = 0.0;
        for (int i2 = 0; i2 < 3; ++i2) {
            acx += ax[i2];
            acy += ay[i2];
        }
        acx /= 3.0;
        acy /= 3.0;
        double bcx = 0.0;
        double bcy = 0.0;
        for (int i3 = 0; i3 < bc; ++i3) {
            bcx += bx[i3];
            bcy += by[i3];
        }
        double dirX = (bcx /= (double)bc) - acx;
        double dirY = (bcy /= (double)bc) - acy;
        if (CollisionUtil.dot(dirX, dirY, bestAx, bestAy) < 0.0) {
            bestAx = -bestAx;
            bestAy = -bestAy;
        }
        res.nx = bestAx;
        res.ny = bestAy;
        return res;
    }

    public static void projectPolygon(double[] vertsX, double[] vertsY, int vertCount, double mx, double my, double[] out) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vertCount; ++i) {
            double p = CollisionUtil.dot(vertsX[i], vertsY[i], mx, my);
            if (p < min) {
                min = p;
            }
            if (!(p > max)) continue;
            max = p;
        }
        out[0] = min;
        out[1] = max;
    }

    public static boolean intervalOverlap(double minA, double maxA, double minB, double maxB, double[] out) {
        double overlap;
        out[0] = overlap = Math.min(maxA, maxB) - Math.max(minA, minB);
        return overlap > 0.0;
    }

    public static void edgeNormal(int i1, int i2, double[] vertsX, double[] vertsY, double[] out) {
        double ey = vertsY[i2] - vertsY[i1];
        double nx = -ey;
        double ex = vertsX[i2] - vertsX[i1];
        double len = Math.hypot(nx, ex);
        if (len == 0.0) {
            out[0] = 1.0;
            out[1] = 0.0;
            return;
        }
        out[0] = nx / len;
        out[1] = ex / len;
    }

    public static double dot(double ax, double ay, double bx, double by) {
        return ax * bx + ay * by;
    }

    public static double distToSegmentSquared(double px, double py, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (dx == 0.0 && dy == 0.0) {
            double ddx = px - x1;
            double ddy = py - y1;
            return ddx * ddx + ddy * ddy;
        }
        double t = ((px - x1) * dx + (py - y1) * dy) / (dx * dx + dy * dy);
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        double projX = x1 + t * dx;
        double projY = y1 + t * dy;
        double ddx = px - projX;
        double ddy = py - projY;
        return ddx * ddx + ddy * ddy;
    }

    public static class CollisionResult {
        public boolean collided;
        public double nx;
        public double ny;
        public double penetration;
    }
}

