/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.render;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_3532;

public class GravityWellRenderer {
    public static void renderBackground(GuiRenderer renderer, boolean deployed, double cx, double cy, Color gravityColor) {
        double t = (double)System.nanoTime() * 1.0E-9;
        float pulse = (float)(0.9 + 0.15 * Math.sin(t * Math.PI * 1.5));
        pulse = class_3532.method_15363((float)pulse, (float)0.13f, (float)1.0f);
        int segments = 28;
        double gR1 = Math.max(6.0, 20.7);
        Color c1 = new Color(gravityColor.r, gravityColor.g, gravityColor.b, (int)((float)(deployed ? 18 : 9) * pulse));
        GravityWellRenderer.drawFilledCircleFan(renderer, cx, cy, gR1 * 1.6, segments, c1);
        double gR2 = Math.max(4.0, 13.8);
        Color c2 = new Color(gravityColor.r, gravityColor.g, gravityColor.b, (int)((float)(deployed ? 36 : 18) * pulse));
        GravityWellRenderer.drawFilledCircleFan(renderer, cx, cy, gR2 * 1.25, segments, c2);
        double gR3 = Math.max(2.0, 5.5200000000000005);
        Color c3 = new Color(gravityColor.r, gravityColor.g, gravityColor.b, (int)((float)(deployed ? 60 : 30) * pulse));
        GravityWellRenderer.drawFilledCircleFan(renderer, cx, cy, gR3, segments, c3);
        int ringSegments = 36;
        double ringThickness = Math.max(2.0, 2.07);
        double outerR = 69.0 + ringThickness * 0.5;
        double innerR = 69.0 - ringThickness * 0.5;
        Color ringCol = new Color(gravityColor.r, gravityColor.g, gravityColor.b, (int)((float)(deployed ? 80 : 40) * pulse));
        double step = Math.PI * 2 / (double)ringSegments;
        for (int n = 0; n < ringSegments; ++n) {
            double a0 = (double)n * step;
            double a1 = (double)(n + 1) * step;
            double ox0 = Math.cos(a0);
            double oy0 = Math.sin(a0);
            double ox1 = Math.cos(a1);
            double oy1 = Math.sin(a1);
            double outerX0 = cx + ox0 * outerR;
            double outerY0 = cy + oy0 * outerR;
            double outerX1 = cx + ox1 * outerR;
            double outerY1 = cy + oy1 * outerR;
            double innerX0 = cx + ox0 * innerR;
            double innerY0 = cy + oy0 * innerR;
            double innerX1 = cx + ox1 * innerR;
            double innerY1 = cy + oy1 * innerR;
            renderer.triangle(outerX0, outerY0, innerX0, innerY0, outerX1, outerY1, ringCol);
            renderer.triangle(innerX0, innerY0, outerX1, outerY1, innerX1, innerY1, ringCol);
        }
    }

    public static void renderReticle(GuiRenderer renderer, boolean deployed, double cx, double cy) {
        Color crossColor = new Color(230, 230, 255, deployed ? 137 : 69);
        double crossHalf = Math.max(6.0, 2.07);
        renderer.quad(cx - crossHalf, cy - 1.0, crossHalf * 2.0, 2.0, crossColor);
        renderer.quad(cx - 1.0, cy - crossHalf, 2.0, crossHalf * 2.0, crossColor);
        renderer.quad(cx - 1.5, cy - 1.5, 3.0, 3.0, new Color(255, 255, 255, deployed ? 220 : 110));
    }

    private static void drawFilledCircleFan(GuiRenderer renderer, double cx, double cy, double radius, int segments, Color color) {
        int n;
        if (segments < 6) {
            segments = 6;
        }
        double[] vx = new double[segments];
        double[] vy = new double[segments];
        double step = Math.PI * 2 / (double)segments;
        for (n = 0; n < segments; ++n) {
            double a = (double)n * step;
            vx[n] = cx + Math.cos(a) * radius;
            vy[n] = cy + Math.sin(a) * radius;
        }
        for (n = 0; n < segments; ++n) {
            int j = (n + 1) % segments;
            renderer.triangle(cx, cy, vx[n], vy[n], vx[j], vy[j], color);
        }
    }
}

