/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.render;

import dev.stardust.gui.widgets.meteorites.WMeteorites;
import dev.stardust.gui.widgets.meteorites.entity.Powerups;
import dev.stardust.gui.widgets.meteorites.entity.Ship;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.renderer.text.TextRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import org.jetbrains.annotations.NotNull;

public class HudRenderer {
    private static final int PAD_Y = 8;
    private static final int PAD_X = 12;
    private static final double TITLE_SCALE = 1.25;
    private static final double NORMAL_SCALE = 1.0;
    private static final int GAP_INLINE_TO_SUB = 6;
    private static final int GAP_TITLE_TO_INLINE = 6;
    private static final DecimalFormat displayFormat = new DecimalFormat("#.##");

    public static void renderHud(GuiRenderer renderer, GuiTheme theme, int bx, int by, double width, double height, WMeteorites widget) {
        Color textColor = new Color(8, 8, 12);
        Color shadowColor = new Color(255, 255, 1255);
        if (widget.CHEAT_MODE) {
            String cheatText = "CHEAT";
            Color cheatShadow = new Color(69, 0, 0);
            double cheatWidth = theme.textRenderer().getWidth(cheatText);
            renderer.text("CHEAT", (double)(bx + (int)width) - cheatWidth - 6.0 - 1.0, (double)(by + 6), cheatShadow, false);
            renderer.text("CHEAT", (double)(bx + (int)width) - cheatWidth - 6.0 + 1.0, (double)(by + 6), cheatShadow, false);
            renderer.text("CHEAT", (double)(bx + (int)width) - cheatWidth - 6.0, (double)(by + 5), cheatShadow, false);
            renderer.text("CHEAT", (double)(bx + (int)width) - cheatWidth - 6.0, (double)(by + 7), cheatShadow, false);
            renderer.text("CHEAT", (double)(bx + (int)width) - cheatWidth - 6.0, (double)(by + 6), new Color(255, 0, 0), false);
        }
        int[] yOffsets = new int[]{6, 22, 38, 54};
        List<String> hudText = HudRenderer.getHudStrings(widget);
        hudText.sort(Comparator.comparingDouble(str -> theme.textRenderer().getWidth((String)str)).reversed());
        for (int n = 0; n < 4; ++n) {
            int yOffset = yOffsets[n];
            String text = hudText.get(n);
            renderer.text(text, (double)(bx + 5), (double)(by + yOffset), shadowColor, false);
            renderer.text(text, (double)(bx + 7), (double)(by + yOffset), shadowColor, false);
            renderer.text(text, (double)(bx + 6), (double)(by + yOffset - 1), shadowColor, false);
            renderer.text(text, (double)(bx + 6), (double)(by + yOffset + 1), shadowColor, false);
            renderer.text(text, (double)(bx + 6), (double)(by + yOffset), textColor, false);
        }
        if (widget.player.lives <= 0) {
            HudRenderer.renderGameOverPopup(renderer, bx, by, width, height, widget);
        } else if (widget.isPaused) {
            HudRenderer.renderPausePopup(renderer, bx, by, width, height, widget);
        }
    }

    private static void renderPausePopup(GuiRenderer renderer, int bx, int by, double width, double height, WMeteorites widget) {
        String tip = widget.currentGameTip;
        String title = widget.gameBegan ? "PAUSED" : "METEORITES";
        String subtitle = widget.gameBegan ? "Press R to resume | Press N to restart" : "Press R to start";
        ArrayList<String> subs = new ArrayList<String>();
        if (!widget.gameBegan) {
            subs.add("by <0xTas>");
        }
        subs.add(subtitle);
        if (tip != null && !tip.isEmpty()) {
            subs.add(tip);
        }
        ArrayList<Color> subCols = new ArrayList<Color>();
        if (!widget.gameBegan) {
            subCols.add(new Color(80, 255, 80));
        }
        subCols.add(new Color(200, 200, 200));
        HudRenderer.drawPopup(renderer, bx, by, width, height, title, widget.gameBegan ? new Color(255, 80, 80) : new Color(80, 255, 80), null, null, subs, subCols);
    }

    private static void renderGameOverPopup(GuiRenderer renderer, int bx, int by, double width, double height, WMeteorites widget) {
        String inlineLeft;
        String inlineRight;
        String separator = " | ";
        if (widget.highScore != null && !widget.CHEAT_MODE) {
            int pts = widget.highScore.getScore(widget.fieldSize);
            int maxWave = widget.highScore.getWave(widget.fieldSize);
            String bestPower = Powerups.values()[widget.highScore.getBestPowerOrdinal(widget.fieldSize)].method_15434();
            inlineRight = "Favorite power: " + bestPower;
            inlineLeft = widget.hasNewHighScore ? String.format("Wave %d: %,d pts", maxWave, pts) : String.format("Highscore: wave %d - %,d pts", maxWave, pts);
        } else {
            int most = 0;
            Powerups bestPower = Powerups.NONE;
            for (Map.Entry<Powerups, Integer> powers : widget.player.powerMap.entrySet()) {
                if (powers.getValue() <= most) continue;
                most = powers.getValue();
                bestPower = powers.getKey();
            }
            int pts = widget.player.score;
            inlineLeft = String.format("Wave: %d, Score: %,d", widget.wave, pts);
            inlineRight = "Favorite power: " + bestPower.method_15434();
        }
        String[] inlineTriple = new String[]{inlineLeft, separator, inlineRight};
        Color[] inlineColors = new Color[]{widget.hasNewHighScore ? new Color(13, 225, 13) : new Color(169, 169, 0), new Color(200, 200, 200), new Color(180, 220, 255)};
        ArrayList<String> subs = new ArrayList<String>();
        subs.add("Press R to restart");
        ArrayList<Color> subCols = new ArrayList<Color>();
        subCols.add(new Color(200, 200, 200));
        Color titleColor = widget.hasNewHighScore ? new Color(80, 255, 80) : new Color(255, 80, 80);
        HudRenderer.drawPopup(renderer, bx, by, width, height, widget.hasNewHighScore ? "NEW HIGH SCORE" : "GAME OVER", titleColor, inlineTriple, inlineColors, subs, subCols);
    }

    private static void drawPopup(GuiRenderer renderer, int bx, int by, double width, double height, String title, Color titleColor, String[] inlineTriple, Color[] inlineColors, List<String> subtitles, List<Color> subColors) {
        TextRenderer tr = renderer.theme.textRenderer();
        int titleW = HudRenderer.scaledTextWidth(renderer, tr, title, 1.25);
        int titleH = HudRenderer.scaledTextHeight(renderer, tr, 1.25);
        int maxSubW = 0;
        int subH = HudRenderer.scaledTextHeight(renderer, tr, 1.0);
        if (subtitles != null) {
            for (String s : subtitles) {
                if (s == null) continue;
                maxSubW = Math.max(maxSubW, HudRenderer.scaledTextWidth(renderer, tr, s, 1.0));
            }
        }
        int inlineH = 0;
        int inlineCombinedW = 0;
        if (inlineTriple != null) {
            int leftW = HudRenderer.scaledTextWidth(renderer, tr, inlineTriple[0], 1.0);
            int sepW = HudRenderer.scaledTextWidth(renderer, tr, inlineTriple[1], 1.0);
            int rightW = HudRenderer.scaledTextWidth(renderer, tr, inlineTriple[2], 1.0);
            inlineCombinedW = leftW + sepW + rightW;
            inlineH = subH;
        }
        int subtitleAmount = subtitles == null ? 0 : subtitles.size();
        int maxInnerWidth = Math.max(titleW, Math.max(maxSubW, inlineCombinedW));
        int quadW = maxInnerWidth + 24;
        int quadH = titleH + 16 + subH * subtitleAmount;
        if (inlineCombinedW > 0) {
            quadH += inlineH + 6 + 6;
        }
        int centerX = bx + (int)(width / 2.0);
        int centerY = by + (int)(height / 2.0) - 8;
        int quadX = centerX - quadW / 2;
        int quadY = centerY - titleH / 2 - 8;
        renderer.quad((double)quadX, (double)quadY, (double)quadW, (double)quadH, new Color(0, 0, 0, 180));
        int titleY = quadY + 4;
        int titleX = centerX - titleW / 2;
        Color strokeColor = new Color(0, 0, 0);
        HudRenderer.drawText(renderer, title, titleX + 1, titleY, strokeColor, true);
        HudRenderer.drawText(renderer, title, titleX - 1, titleY, strokeColor, true);
        HudRenderer.drawText(renderer, title, titleX, titleY + 1, strokeColor, true);
        HudRenderer.drawText(renderer, title, titleX, titleY - 1, strokeColor, true);
        HudRenderer.drawText(renderer, title, titleX, titleY, titleColor != null ? titleColor : new Color(255, 80, 80), true);
        int currentY = titleY + titleH;
        if (inlineCombinedW > 0) {
            int inlineXStart = centerX - inlineCombinedW / 2;
            Color leftCol = inlineColors != null && inlineColors.length > 0 ? inlineColors[0] : new Color(200, 200, 200);
            HudRenderer.drawText(renderer, inlineTriple[0], inlineXStart, currentY += 6, leftCol, false);
            int leftW = HudRenderer.scaledTextWidth(renderer, tr, inlineTriple[0], 1.0);
            int sepX = inlineXStart + leftW;
            Color sepCol = inlineColors != null && inlineColors.length > 1 ? inlineColors[1] : new Color(200, 200, 200);
            HudRenderer.drawText(renderer, inlineTriple[1], sepX, currentY, sepCol, false);
            int sepW = HudRenderer.scaledTextWidth(renderer, tr, inlineTriple[1], 1.0);
            int rightX = sepX + sepW;
            Color rightCol = inlineColors != null && inlineColors.length > 2 ? inlineColors[2] : new Color(200, 200, 200);
            HudRenderer.drawText(renderer, inlineTriple[2], rightX, currentY, rightCol, false);
            currentY += inlineH + 6;
        }
        if (subtitles != null) {
            for (int n = 0; n < subtitles.size(); ++n) {
                String s = subtitles.get(n);
                if (s == null) continue;
                Color c = subColors != null && n < subColors.size() ? subColors.get(n) : new Color(200, 200, 200);
                int sw = HudRenderer.scaledTextWidth(renderer, tr, s, 1.0);
                int sx = centerX - sw / 2;
                HudRenderer.drawText(renderer, s, sx, currentY, c, false);
                currentY += subH;
            }
        }
    }

    private static int scaledTextWidth(GuiRenderer renderer, TextRenderer tr, String s, double scale) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        return (int)Math.round(tr.getWidth(s) * renderer.theme.scale(scale));
    }

    private static int scaledTextHeight(GuiRenderer renderer, TextRenderer tr, double scale) {
        return (int)Math.round(tr.getHeight() * renderer.theme.scale(scale));
    }

    private static void drawText(GuiRenderer renderer, String text, int x, int y, Color color, boolean title) {
        renderer.text(text, (double)x, (double)y, color, title);
    }

    @NotNull
    private static List<String> getHudStrings(WMeteorites widget) {
        Ship player = widget.player;
        ArrayList<String> hudText = new ArrayList<String>();
        String waveText = "Wave: " + widget.wave;
        String livesText = "Lives: " + player.lives;
        String scoreText = "Points: " + String.format("%,d", player.score);
        Object powerText = "Powerup: ";
        powerText = player.hasEntropy() ? (String)powerText + "Entropy(" + player.getPowerup().method_15434() + ")" : (String)powerText + player.getPowerup().method_15434();
        switch (player.getPowerup()) {
            case MIDAS_TOUCH: {
                powerText = (String)powerText + " [$$$]";
                break;
            }
            case CALIBRATED_FSD: {
                long now = System.currentTimeMillis();
                if ((double)(now - player.lastHyperJump) >= 3000.0) {
                    powerText = (String)powerText + " [READY]";
                    break;
                }
                double cd = 3000.0 - (double)(now - player.lastHyperJump);
                powerText = (String)powerText + " [COOLING: " + displayFormat.format(Math.max(0.0, cd / 1000.0)) + "]";
                break;
            }
            case GRAVITY_WELL: {
                if (player.gravityWellDeployed) {
                    powerText = (String)powerText + " [DEPLOYED: " + displayFormat.format(Math.max(player.gravityWellTimer, 0.0)) + "]";
                    break;
                }
                if (player.gravityWellCdTimer <= 0.0) {
                    powerText = (String)powerText + " [READY]";
                    break;
                }
                powerText = (String)powerText + " [COOLING: " + displayFormat.format(Math.max(player.gravityWellCdTimer, 0.0)) + "]";
                break;
            }
            case PHASE_SHIFT: {
                if (player.phaseActive) {
                    powerText = (String)powerText + " [ACTIVE: " + displayFormat.format(Math.max(player.phaseDuration - player.phaseTimer, 0.0)) + "]";
                    break;
                }
                if (player.phaseCooldownTimer <= 0.0) {
                    powerText = (String)powerText + " [READY]";
                    break;
                }
                powerText = (String)powerText + " [COOLING]";
                break;
            }
            case STARDUST: {
                powerText = (String)powerText + " [" + (player.isShotgun ? "SHOTGUN" : (player.isSniper ? "SNIPER" : "HELL")) + "]";
                break;
            }
            case HIGH_TECH_HULL: 
            case REINFORCED_HULL: {
                powerText = (String)powerText + " [" + String.valueOf(player.isHullFull() ? "FULL" : Integer.valueOf((int)Math.ceil(player.hull))) + "]";
            }
        }
        hudText.add(waveText);
        hudText.add(scoreText);
        hudText.add((String)powerText);
        hudText.add(livesText);
        return hudText;
    }
}

