/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.meteorites.render;

import dev.stardust.gui.widgets.meteorites.entity.Ship;
import java.util.Random;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_3532;

public class StarfieldRenderer {
    private static final int STAR_SEGMENTS = 8;
    private static final int MIN_DUST_COUNT = 13;
    private static final int MAX_DUST_COUNT = 37;
    private static final int MIN_STARS_LAYER1 = 80;
    private static final int MAX_STARS_LAYER1 = 120;
    private static final int MIN_STARS_LAYER0 = 120;
    private static final int MAX_STARS_LAYER0 = 250;
    private static final double DUST_PARALLAX = 0.42;
    private static final double LAYER1_PARALLAX = 0.17;
    private static final double LAYER0_PARALLAX = 0.069;
    private final Dust[] dustLayer;
    private final Star[] starsLayer0;
    private final Star[] starsLayer1;
    private double worldX;
    private double worldY;
    private double prevPlayerX;
    private double prevPlayerY;
    private double resetDurationSec;
    private double resetStartTimeSec;
    private boolean resetting = false;
    private double resetToX;
    private double resetToY;
    private double resetFromX;
    private double resetFromY;
    private final int dustAmount;
    private final int stars0Amount;
    private final int stars1Amount;

    public StarfieldRenderer(Ship player, double width, double height, long seed) {
        Star s;
        int n;
        this.worldX = player.x;
        this.worldY = player.y;
        this.prevPlayerX = this.worldX;
        this.prevPlayerY = this.worldY;
        Random rng = new Random(seed);
        this.dustAmount = rng.nextInt(13, 37);
        this.stars0Amount = rng.nextInt(120, 250);
        this.stars1Amount = rng.nextInt(80, 120);
        this.dustLayer = new Dust[this.dustAmount];
        this.starsLayer0 = new Star[this.stars0Amount];
        this.starsLayer1 = new Star[this.stars1Amount];
        for (n = 0; n < this.stars0Amount; ++n) {
            s = new Star();
            s.x = rng.nextDouble() * width;
            s.y = rng.nextDouble() * height;
            s.size = 1.0 + rng.nextDouble() * 1.6;
            s.alpha = 0.06 + rng.nextDouble() * 0.18;
            s.phase = rng.nextDouble() * Math.PI * 2.0;
            s.hue = rng.nextFloat() * 0.05f + 0.05f;
            this.starsLayer0[n] = s;
        }
        for (n = 0; n < this.stars1Amount; ++n) {
            s = new Star();
            s.x = rng.nextDouble() * width;
            s.y = rng.nextDouble() * height;
            s.size = 1.5 + rng.nextDouble() * 2.6;
            s.alpha = 0.12 + rng.nextDouble() * 0.36;
            s.phase = rng.nextDouble() * Math.PI * 2.0;
            s.hue = rng.nextFloat() * 0.08f + 0.02f;
            this.starsLayer1[n] = s;
        }
        for (n = 0; n < this.dustAmount; ++n) {
            Dust d = new Dust();
            d.x = rng.nextDouble() * width;
            d.y = rng.nextDouble() * height;
            d.size = 4.0 + rng.nextDouble() * 8.0;
            d.alpha = 0.06 + rng.nextDouble() * 0.14;
            d.vx = (rng.nextDouble() - 0.5) * 7.0;
            d.vy = (rng.nextDouble() - 0.5) * 7.0;
            d.phase = rng.nextDouble() * Math.PI * 2.0;
            this.dustLayer[n] = d;
        }
    }

    public void resetInstant(double worldXTarget, double worldYTarget) {
        this.worldX = worldXTarget;
        this.worldY = worldYTarget;
        this.resetting = false;
    }

    public void resetSmooth(double worldXTarget, double worldYTarget, double durationSec, double timeSec) {
        double curX = this.worldX;
        double curY = this.worldY;
        if (this.resetting) {
            double t = (timeSec - this.resetStartTimeSec) / Math.max(1.0E-9, this.resetDurationSec);
            t = class_3532.method_15363((float)((float)t), (float)0.0f, (float)1.0f);
            double ease = StarfieldRenderer.easeInOutCubic(t);
            curX = StarfieldRenderer.lerp(this.resetFromX, this.resetToX, ease);
            curY = StarfieldRenderer.lerp(this.resetFromY, this.resetToY, ease);
        }
        this.resetFromX = curX;
        this.resetFromY = curY;
        this.resetToX = worldXTarget;
        this.resetToY = worldYTarget;
        this.resetStartTimeSec = timeSec;
        this.resetDurationSec = Math.max(1.0E-6, durationSec);
        this.resetting = true;
    }

    public void render(GuiRenderer renderer, int bx, int by, double px, double py, double width, double height, double time) {
        int w = (int)width;
        int h = (int)height;
        double rawDx = px - this.prevPlayerX;
        double rawDy = py - this.prevPlayerY;
        double dx = StarfieldRenderer.wrappedDelta(rawDx, width);
        double dy = StarfieldRenderer.wrappedDelta(rawDy, height);
        this.worldX += dx;
        this.worldY += dy;
        this.prevPlayerX = px;
        this.prevPlayerY = py;
        if (this.resetting) {
            double t = (time - this.resetStartTimeSec) / this.resetDurationSec;
            t = class_3532.method_15363((float)((float)t), (float)0.0f, (float)1.0f);
            double ease = StarfieldRenderer.easeInOutCubic(t);
            this.worldX = StarfieldRenderer.lerp(this.resetFromX, this.resetToX, ease);
            this.worldY = StarfieldRenderer.lerp(this.resetFromY, this.resetToY, ease);
            if (t >= 0.999999999) {
                this.resetting = false;
            }
        }
        this.renderStarsLayer(renderer, this.starsLayer0, this.stars0Amount, bx, by, w, h, 0.069, this.worldX, this.worldY, time, false);
        this.renderStarsLayer(renderer, this.starsLayer1, this.stars1Amount, bx, by, w, h, 0.17, this.worldX, this.worldY, time, true);
        this.renderDustLayer(renderer, this.dustLayer, bx, by, w, h, this.worldX, this.worldY, time);
    }

    private void renderStarsLayer(GuiRenderer renderer, Star[] stars, int count, int bx, int by, int width, int height, double parallax, double worldX, double worldY, double timeSec, boolean twinkle) {
        double ox = -worldX * parallax;
        double oy = -worldY * parallax;
        ox = StarfieldRenderer.mod(ox, width);
        oy = StarfieldRenderer.mod(oy, height);
        for (int n = 0; n < count; ++n) {
            double wy;
            double wx;
            Star s = stars[n];
            double a = s.alpha;
            if (twinkle) {
                double tw = 0.6 + 0.4 * Math.sin(timeSec * 3.0 + s.phase);
                a *= 0.7 + 0.6 * tw;
            }
            if ((wx = (s.x + ox) % (double)width) < 0.0) {
                wx += (double)width;
            }
            if ((wy = (s.y + oy) % (double)height) < 0.0) {
                wy += (double)height;
            }
            Color color = new Color(255, 255, 255, Math.round(255.0f * class_3532.method_15363((float)((float)a), (float)0.0f, (float)1.0f)));
            double sr = s.size;
            this.drawCircleWrapped(renderer, bx, by, width, height, wx, wy, sr, color);
        }
    }

    private void renderDustLayer(GuiRenderer renderer, Dust[] dust, int bx, int by, int width, int height, double worldX, double worldY, double timeSec) {
        double ox = -worldX * 0.42;
        double oy = -worldY * 0.42;
        ox = StarfieldRenderer.mod(ox, width);
        oy = StarfieldRenderer.mod(oy, height);
        for (int n = 0; n < this.dustAmount; ++n) {
            double wy;
            Dust d = dust[n];
            double dx = d.x + d.vx * (timeSec * 0.42);
            double dy = d.y + d.vy * (timeSec * 0.42);
            double wx = (dx + ox) % (double)width;
            if (wx < 0.0) {
                wx += (double)width;
            }
            if ((wy = (dy + oy) % (double)height) < 0.0) {
                wy += (double)height;
            }
            double pulse = 0.85 + 0.15 * Math.sin(timeSec * 1.1 + d.phase);
            Color col = new Color(220, 220, 240, Math.round(255.0f * class_3532.method_15363((float)((float)(d.alpha * pulse)), (float)0.0f, (float)0.42f)));
            this.drawCircleWrapped(renderer, bx, by, width, height, wx, wy, d.size * pulse, col);
        }
    }

    private void drawCircleWrapped(GuiRenderer renderer, int bx, int by, int width, int height, double centerX, double centerY, double w, Color color) {
        this.drawFilledCircleWrapped(renderer, bx, by, width, height, centerX, centerY, Math.max(0.5, w * 0.5), color);
        int ringAlpha = Math.max(8, (int)((double)color.a * 0.3));
        double ringRadius = Math.max(1.0, w * 0.5 * 1.8);
        Color ringColor = new Color(color.r, color.g, color.b, ringAlpha);
        this.drawRingWrapped(renderer, bx, by, width, height, centerX, centerY, ringRadius, ringColor);
    }

    private void drawFilledCircleWrapped(GuiRenderer renderer, int bx, int by, int width, int height, double centerX, double centerY, double radius, Color color) {
        for (int offX = -1; offX <= 1; ++offX) {
            for (int offY = -1; offY <= 1; ++offY) {
                double sx = centerX + (double)(offX * width);
                double sy = centerY + (double)(offY * height);
                if (sx + radius < 0.0 || sx - radius > (double)width || sy + radius < 0.0 || sy - radius > (double)height) continue;
                double cx = (double)bx + sx;
                double cy = (double)by + sy;
                double angleStep = 0.7853981633974483;
                double prevX = cx + Math.cos(0.0) * radius;
                double prevY = cy + Math.sin(0.0) * radius;
                for (int n = 1; n <= 8; ++n) {
                    double ang = (double)n * angleStep;
                    double vx = cx + Math.cos(ang) * radius;
                    double vy = cy + Math.sin(ang) * radius;
                    renderer.triangle(cx, cy, prevX, prevY, vx, vy, color);
                    prevX = vx;
                    prevY = vy;
                }
            }
        }
    }

    private void drawRingWrapped(GuiRenderer renderer, int bx, int by, int width, int height, double centerX, double centerY, double outerRadius, Color ringColor) {
        double thickness = Math.max(0.5, outerRadius * 0.45);
        double innerRadius = Math.max(0.5, outerRadius - thickness);
        for (int offX = -1; offX <= 1; ++offX) {
            for (int offY = -1; offY <= 1; ++offY) {
                double sx = centerX + (double)(offX * width);
                double sy = centerY + (double)(offY * height);
                if (sx + outerRadius < 0.0 || sx - outerRadius > (double)width || sy + outerRadius < 0.0 || sy - outerRadius > (double)height) continue;
                double cx = (double)bx + sx;
                double cy = (double)by + sy;
                double angleStep = 0.7853981633974483;
                double oPrevX = cx + Math.cos(0.0) * outerRadius;
                double oPrevY = cy + Math.sin(0.0) * outerRadius;
                double iPrevX = cx + Math.cos(0.0) * innerRadius;
                double iPrevY = cy + Math.sin(0.0) * innerRadius;
                for (int n = 1; n <= 8; ++n) {
                    double ang = (double)n * angleStep;
                    double oX = cx + Math.cos(ang) * outerRadius;
                    double oY = cy + Math.sin(ang) * outerRadius;
                    double iX = cx + Math.cos(ang) * innerRadius;
                    double iY = cy + Math.sin(ang) * innerRadius;
                    renderer.triangle(oPrevX, oPrevY, iPrevX, iPrevY, oX, oY, ringColor);
                    renderer.triangle(oX, oY, iPrevX, iPrevY, iX, iY, ringColor);
                    oPrevX = oX;
                    oPrevY = oY;
                    iPrevX = iX;
                    iPrevY = iY;
                }
            }
        }
    }

    private static double wrappedDelta(double targetMinusSource, double span) {
        double d;
        double half = span * 0.5;
        for (d = targetMinusSource; d > half; d -= span) {
        }
        while (d <= -half) {
            d += span;
        }
        return d;
    }

    private static double mod(double v, double m) {
        double r = v % m;
        if (r < 0.0) {
            r += m;
        }
        return r;
    }

    private static double easeInOutCubic(double t) {
        return t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0;
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static class Dust {
        double x;
        double y;
        double size;
        double alpha;
        double vx;
        double vy;
        double phase;

        private Dust() {
        }
    }

    private static class Star {
        double x;
        double y;
        double size;
        double alpha;
        double phase;
        float hue;

        private Star() {
        }
    }
}

