/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.minesweeper;

import dev.stardust.modules.Minesweeper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class WMinesweeper
extends WWidget {
    private static final int TEXT_Y_OFFSET = 1;
    private static final int BREAKING_VERSION = 1;
    private int rows;
    private int cols;
    private int mines;
    private final int cellSize;
    private final Minesweeper module;
    private final Difficulty difficulty;
    private final ColorScheme colorScheme;
    private final Random random = new Random();
    private long gameEnd = 0L;
    private long gameStart = 0L;
    private long accumulated = 0L;
    private boolean resetHover = false;
    private final int statusHeight = 32;
    private boolean dragging;
    private int clickedMouseX;
    private int clickedMouseY;
    private final List<int[]> hoveredCells = new ArrayList<int[]>();
    private final List<int[]> highlightedCells = new ArrayList<int[]>();
    private int[][] grid;
    private byte[][] state;
    private boolean firstClick = true;
    private boolean gameOver = false;
    private boolean gameWon = false;

    public boolean shouldSaveGame() {
        return !this.gameOver && !this.firstClick;
    }

    public SaveState saveGame() {
        return new SaveState(1, this.difficulty, this.rows, this.cols, this.mines, this.grid, this.state, this.accumulated + (System.currentTimeMillis() - this.gameStart));
    }

    public WMinesweeper(Minesweeper module, GuiTheme theme) {
        this.module = module;
        this.cellSize = (Integer)module.cellSize.get();
        this.difficulty = (Difficulty)((Object)module.difficulty.get());
        this.colorScheme = new ColorScheme(module, theme);
        if (((Boolean)module.shouldSave.get()).booleanValue() && module.saveData != null) {
            SaveState save = module.saveData;
            if (this.difficulty != save.difficulty() || save.version != 1) {
                this.initEmpty();
            } else if (this.difficulty.equals((Object)Difficulty.Custom)) {
                if (((Integer)module.rows.get()).intValue() != save.rows() || ((Integer)module.columns.get()).intValue() != save.columns() || ((Integer)module.mines.get()).intValue() != save.mines()) {
                    this.initEmpty();
                } else {
                    this.loadSave(save);
                }
            } else {
                this.loadSave(save);
            }
        } else {
            this.initEmpty();
        }
    }

    private void loadSave(SaveState save) {
        this.rows = save.rows();
        this.cols = save.columns();
        this.mines = Math.min(save.mines(), this.rows * this.cols - 1);
        this.accumulated += save.accumulatedMillis();
        this.gameStart = System.currentTimeMillis();
        this.grid = save.grid();
        this.state = save.state();
        this.firstClick = false;
        this.gameOver = false;
        this.gameWon = false;
    }

    private void initEmpty() {
        if (this.difficulty.equals((Object)Difficulty.Custom)) {
            this.rows = (Integer)this.module.rows.get();
            this.cols = (Integer)this.module.columns.get();
            this.mines = Math.min((Integer)this.module.mines.get(), this.rows * this.cols - 1);
        } else {
            this.rows = this.difficulty.getRows();
            this.cols = this.difficulty.getColumns();
            this.mines = Math.min(this.difficulty.getMines(), this.rows * this.cols - 1);
        }
        this.gameStart = 0L;
        this.accumulated = 0L;
        this.grid = new int[this.rows][this.cols];
        this.state = new byte[this.rows][this.cols];
        this.firstClick = true;
        this.gameOver = false;
        this.gameWon = false;
    }

    private void placeMines(int exX, int exY) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.grid[r][c] = 0;
                this.state[r][c] = 0;
            }
        }
        int placed = 0;
        while (placed < this.mines) {
            int c;
            int r = this.random.nextInt(this.rows);
            if (this.grid[r][c = this.random.nextInt(this.cols)] == -1 || Math.abs(r - exX) <= 1 && Math.abs(c - exY) <= 1) continue;
            ++placed;
            this.grid[r][c] = -1;
            for (int dr = -1; dr <= 1; ++dr) {
                for (int dc = -1; dc <= 1; ++dc) {
                    int nc;
                    int nr;
                    if (dr == 0 && dc == 0 || !this.inBounds(nr = r + dr, nc = c + dc) || this.grid[nr][nc] == -1) continue;
                    int[] nArray = this.grid[nr];
                    int n = nc;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
    }

    private boolean inBounds(int r, int c) {
        return r >= 0 && c >= 0 && r < this.rows && c < this.cols;
    }

    public void revealCell(int r, int c) {
        if (!this.inBounds(r, c) || this.state[r][c] == 2 || this.gameOver) {
            return;
        }
        if (this.firstClick) {
            this.placeMines(r, c);
            this.firstClick = false;
        }
        if (this.state[r][c] == 1) {
            int nc;
            int nr;
            int dc;
            int dr;
            int flags = 0;
            int amt = this.grid[r][c];
            for (dr = -1; dr <= 1; ++dr) {
                for (dc = -1; dc <= 1; ++dc) {
                    if (dr == 0 && dc == 0 || !this.inBounds(nr = r + dr, nc = c + dc) || this.state[nr][nc] != 2) continue;
                    ++flags;
                }
            }
            if (flags > 0 && flags == amt) {
                for (dr = -1; dr <= 1; ++dr) {
                    for (dc = -1; dc <= 1; ++dc) {
                        if (dr == 0 && dc == 0 || !this.inBounds(nr = r + dr, nc = c + dc) || this.state[nr][nc] != 0) continue;
                        this.revealCell(nr, nc);
                    }
                }
            }
            return;
        }
        if (this.grid[r][c] == -1) {
            if (!this.gameOver) {
                this.module.clearSave();
                if (((Boolean)this.module.gameSounds.get()).booleanValue()) {
                    MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15008, (float)ThreadLocalRandom.current().nextFloat(0.77f, 1.1337f), (float)((Double)this.module.soundVolume.get()).floatValue()));
                    MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15152.comp_349()), (float)ThreadLocalRandom.current().nextFloat(0.77f, 1.1337f), (float)((Double)this.module.soundVolume.get()).floatValue()));
                }
            }
            this.revealAllMines();
            this.gameOver = true;
            this.gameWon = false;
            this.gameEnd = System.currentTimeMillis();
            return;
        }
        this.floodReveal(r, c);
        if (this.checkWin()) {
            if (!this.gameOver) {
                this.module.clearSave();
                if (((Boolean)this.module.gameSounds.get()).booleanValue()) {
                    MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14815, (float)ThreadLocalRandom.current().nextFloat(0.77f, 1.1337f), (float)((Double)this.module.soundVolume.get()).floatValue()));
                    MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14709, (float)ThreadLocalRandom.current().nextFloat(0.77f, 1.1337f), (float)((Double)this.module.soundVolume.get()).floatValue()));
                }
            }
            this.gameOver = true;
            this.gameWon = true;
            this.gameEnd = System.currentTimeMillis();
        } else if (((Boolean)this.module.gameSounds.get()).booleanValue()) {
            MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_26941, (float)ThreadLocalRandom.current().nextFloat(0.666f, 1.42f), (float)((Double)this.module.soundVolume.get()).floatValue()));
        }
    }

    private void revealAllMines() {
        for (int rr = 0; rr < this.rows; ++rr) {
            for (int cc = 0; cc < this.cols; ++cc) {
                if (this.grid[rr][cc] != -1) continue;
                this.state[rr][cc] = 1;
            }
        }
    }

    private void floodReveal(int sr, int sc) {
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{sr, sc});
        while (!stack.isEmpty()) {
            int c;
            int[] p = (int[])stack.pop();
            int r = p[0];
            if (!this.inBounds(r, c = p[1]) || this.state[r][c] == 1 || this.state[r][c] == 2) continue;
            this.state[r][c] = 1;
            if (this.grid[r][c] != 0) continue;
            for (int dr = -1; dr <= 1; ++dr) {
                for (int dc = -1; dc <= 1; ++dc) {
                    int nc;
                    int nr;
                    if (dr == 0 && dc == 0 || !this.inBounds(nr = r + dr, nc = c + dc) || this.state[nr][nc] != 0) continue;
                    stack.push(new int[]{nr, nc});
                }
            }
        }
    }

    public void toggleFlag(int r, int c) {
        if (!this.inBounds(r, c) || this.state[r][c] == 1 || this.gameOver) {
            return;
        }
        if (this.state[r][c] == 2) {
            this.state[r][c] = 0;
            if (((Boolean)this.module.gameSounds.get()).booleanValue()) {
                MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14770, (float)ThreadLocalRandom.current().nextFloat(0.666f, 1.333f), (float)((Double)this.module.soundVolume.get()).floatValue()));
            }
        } else {
            this.state[r][c] = 2;
            if (((Boolean)this.module.gameSounds.get()).booleanValue()) {
                MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14667, (float)ThreadLocalRandom.current().nextFloat(0.666f, 1.333f), (float)((Double)this.module.soundVolume.get()).floatValue()));
            }
        }
    }

    public void reset() {
        this.initEmpty();
        this.module.clearSave();
    }

    private boolean checkWin() {
        int revealed = 0;
        int total = this.rows * this.cols;
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.state[r][c] != 1) continue;
                ++revealed;
            }
        }
        return revealed == total - this.mines;
    }

    protected void onCalculateSize() {
        this.width = this.cols * this.cellSize;
        this.height = 32 + this.rows * this.cellSize;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button, boolean used) {
        double localX = mouseX - this.x;
        double localY = mouseY - this.y;
        if (localY >= 0.0 && localY < 32.0) {
            int resetW = 64;
            int resetX = (int)this.width - resetW - 6;
            int resetY = 3;
            int resetH = 26;
            if (localX >= (double)resetX && localX <= (double)(resetX + resetW) && localY >= (double)resetY && localY <= (double)(resetY + resetH)) {
                this.reset();
                return true;
            }
            return false;
        }
        if (this.gameOver) {
            return false;
        }
        int boardLocalX = (int)localX;
        int boardLocalY = (int)(localY - 32.0);
        int c = boardLocalX / this.cellSize;
        int r = boardLocalY / this.cellSize;
        if (r < 0 || c < 0 || r >= this.rows || c >= this.cols) {
            return false;
        }
        this.dragging = true;
        this.clickedMouseX = boardLocalX;
        this.clickedMouseY = boardLocalY;
        this.highlightedCells.add(new int[]{r, c});
        return true;
    }

    public void onMouseMoved(double mouseX, double mouseY, double lastMouseX, double lastMouseY) {
        super.onMouseMoved(mouseX, mouseY, lastMouseX, lastMouseY);
        double localX = mouseX - this.x;
        double localY = mouseY - this.y;
        int statusW = (int)this.width;
        int resetW = 64;
        int resetX = statusW - resetW - 6;
        int resetY = 3;
        int resetH = 26;
        boolean bl = this.resetHover = localX >= (double)resetX && localX <= (double)(resetX + resetW) && localY >= (double)resetY && localY <= (double)(resetY + resetH);
        if (!this.dragging) {
            this.hoveredCells.clear();
            int boardLocalX = (int)localX;
            int boardLocalY = (int)(localY - 32.0);
            int c = boardLocalX / this.cellSize;
            int r = boardLocalY / this.cellSize;
            if (r < 0 || c < 0 || r >= this.rows || c >= this.cols) {
                return;
            }
            if (this.state[r][c] == 0) {
                this.hoveredCells.add(new int[]{r, c});
            } else if (this.state[r][c] == 1) {
                int nc;
                int nr;
                int dc;
                int dr;
                int flags = 0;
                int amt = this.grid[r][c];
                for (dr = -1; dr <= 1; ++dr) {
                    for (dc = -1; dc <= 1; ++dc) {
                        if (dr == 0 && dc == 0 || !this.inBounds(nr = r + dr, nc = c + dc) || this.state[nr][nc] != 2) continue;
                        ++flags;
                    }
                }
                if (flags > 0 && flags == amt) {
                    for (dr = -1; dr <= 1; ++dr) {
                        for (dc = -1; dc <= 1; ++dc) {
                            if (dr == 0 && dc == 0 || !this.inBounds(nr = r + dr, nc = c + dc) || this.state[nr][nc] != 0) continue;
                            this.hoveredCells.add(new int[]{nr, nc});
                        }
                    }
                }
            }
        }
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        this.highlightedCells.clear();
        double localX = mouseX - this.x;
        double localY = mouseY - this.y;
        int boardLocalX = (int)localX;
        int boardLocalY = (int)(localY - 32.0);
        int bc = boardLocalX / this.cellSize;
        int br = boardLocalY / this.cellSize;
        int c = this.clickedMouseX / this.cellSize;
        int r = this.clickedMouseY / this.cellSize;
        if (c != bc || r != br) {
            return false;
        }
        if (r < 0 || c < 0 || r >= this.rows || c >= this.cols) {
            return false;
        }
        if (button == 0) {
            if (this.firstClick && this.gameStart == 0L) {
                this.gameStart = System.currentTimeMillis();
            }
            this.revealCell(r, c);
            return true;
        }
        if (button == 1) {
            this.toggleFlag(r, c);
            return true;
        }
        return false;
    }

    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        int bx = (int)this.x;
        int by = (int)this.y;
        renderer.quad((double)(bx - 2), (double)(by - 2), (double)((int)this.width + 4), (double)((int)this.height + 4), this.colorScheme.backgroundColor);
        int statusW = (int)this.width;
        int statusH = 32;
        renderer.quad((double)bx, (double)by, (double)statusW, (double)statusH, this.colorScheme.statusBarColor);
        long elapsedSec = 0L;
        if (!this.firstClick && this.gameStart > 0L && !this.gameOver) {
            elapsedSec = (System.currentTimeMillis() - (this.gameStart - this.accumulated)) / 1000L;
        } else if (this.gameOver) {
            elapsedSec = (this.gameEnd - (this.gameStart - this.accumulated)) / 1000L;
        }
        int timerTextWidth = 40;
        String timerText = String.format("%02d:%02d", elapsedSec / 60L, elapsedSec % 60L);
        double timerX = (double)bx + (double)statusW / 2.0 - (double)timerTextWidth / 2.0;
        renderer.text(timerText, timerX - 1.0, (double)(by + 4), this.colorScheme.textShadowColor, false);
        renderer.text(timerText, timerX + 1.0, (double)(by + 4), this.colorScheme.textShadowColor, false);
        renderer.text(timerText, timerX, (double)(by + 5), this.colorScheme.textShadowColor, false);
        renderer.text(timerText, timerX, (double)(by + 4), this.colorScheme.runtimeColor, false);
        int resetW = 64;
        int resetH = statusH - 6;
        int resetX = bx + statusW - resetW - 6;
        int resetY = by + 3;
        Color resetBg = this.resetHover ? this.colorScheme.resetHoveredColor : this.colorScheme.resetButtonColor;
        renderer.quad((double)resetX, (double)resetY, (double)resetW, (double)resetH, resetBg);
        renderer.text("Reset", (double)(resetX + 9), (double)(resetY + 3), this.colorScheme.textShadowColor, false);
        renderer.text("Reset", (double)(resetX + 11), (double)(resetY + 3), this.colorScheme.textShadowColor, false);
        renderer.text("Reset", (double)(resetX + 10), (double)(resetY + 4), this.colorScheme.textShadowColor, false);
        renderer.text("Reset", (double)(resetX + 10), (double)(resetY + 3), this.colorScheme.resetTextColor, false);
        int boardY = by + statusH;
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                int sx = bx + c * this.cellSize;
                int sy = boardY + r * this.cellSize;
                int inner = 1;
                int w = this.cellSize - inner * 2;
                int h = this.cellSize - inner * 2;
                byte s = this.state[r][c];
                if (s == 0) {
                    Color hiddenCellColor = this.colorScheme.hiddenCellColor;
                    if (this.dragging && this.isHighlightedCell(r, c)) {
                        int cr = Math.min(255, hiddenCellColor.r + 50);
                        cg = Math.min(255, hiddenCellColor.g + 50);
                        cb = Math.min(255, hiddenCellColor.b + 50);
                        hiddenCellColor = new Color(cr, cg, cb, this.colorScheme.hiddenCellColor.a);
                    } else if (!this.dragging && this.isHoveredCell(r, c)) {
                        int cr = Math.min(255, hiddenCellColor.r + 25);
                        cg = Math.min(255, hiddenCellColor.g + 25);
                        cb = Math.min(255, hiddenCellColor.b + 25);
                        hiddenCellColor = new Color(cr, cg, cb, this.colorScheme.hiddenCellColor.a);
                    }
                    renderer.quad((double)(sx + inner), (double)(sy + inner), (double)w, (double)h, hiddenCellColor);
                } else if (s == 2) {
                    renderer.quad((double)(sx + inner), (double)(sy + inner), (double)w, (double)h, this.colorScheme.flaggedCellColor);
                    renderer.text("?", (double)(sx + inner + 2), (double)(sy + inner + 1), this.colorScheme.textShadowColor, false);
                    renderer.text("?", (double)(sx + inner + 4), (double)(sy + inner + 1), this.colorScheme.textShadowColor, false);
                    renderer.text("?", (double)(sx + inner + 3), (double)(sy + inner + 1 + 1), this.colorScheme.textShadowColor, false);
                    renderer.text("?", (double)(sx + inner + 3), (double)(sy + inner + 1), this.colorScheme.flaggedCellTextColor, false);
                } else if (this.grid[r][c] == -1) {
                    renderer.quad((double)(sx + inner), (double)(sy + inner), (double)w, (double)h, this.colorScheme.mineCellColor);
                    renderer.text("X", (double)(sx + inner + 2), (double)(sy + inner + 1), this.colorScheme.textShadowColor, false);
                    renderer.text("X", (double)(sx + inner + 4), (double)(sy + inner + 1), this.colorScheme.textShadowColor, false);
                    renderer.text("X", (double)(sx + inner + 3), (double)(sy + inner + 1 + 1), this.colorScheme.textShadowColor, false);
                    renderer.text("X", (double)(sx + inner + 3), (double)(sy + inner + 1), this.colorScheme.mineTextColor, false);
                } else if (this.grid[r][c] == 0) {
                    renderer.quad((double)(sx + inner), (double)(sy + inner), (double)w, (double)h, this.colorScheme.revealedCellColor);
                } else {
                    renderer.quad((double)(sx + inner), (double)(sy + inner), (double)w, (double)h, this.colorScheme.revealedCellColor);
                    Color color = this.numberColor(this.grid[r][c]);
                    String txt = Integer.toString(this.grid[r][c]);
                    renderer.text(txt, (double)(sx + inner + 2), (double)(sy + inner + 1), this.colorScheme.textShadowColor, false);
                    renderer.text(txt, (double)(sx + inner + 4), (double)(sy + inner + 1), this.colorScheme.textShadowColor, false);
                    renderer.text(txt, (double)(sx + inner + 3), (double)(sy + inner + 1 + 1), this.colorScheme.textShadowColor, false);
                    renderer.text(txt, (double)(sx + inner + 3), (double)(sy + inner + 1), color, false);
                }
                renderer.quad((double)sx, (double)sy, (double)this.cellSize, 1.0, this.colorScheme.cellBorderColor);
                renderer.quad((double)sx, (double)sy, 1.0, (double)this.cellSize, this.colorScheme.cellBorderColor);
                renderer.quad((double)sx, (double)(sy + this.cellSize), (double)this.cellSize, 1.0, this.colorScheme.cellBorderColor);
                renderer.quad((double)(sx + this.cellSize - 1), (double)sy, 1.0, (double)this.cellSize, this.colorScheme.cellBorderColor);
            }
        }
        if (this.gameOver) {
            String gameOverText = this.gameWon ? "YOU WIN! 8)" : "GAME OVER X)";
            renderer.text(gameOverText, (double)(bx + 5), (double)(by + 4), this.colorScheme.textShadowColor, false);
            renderer.text(gameOverText, (double)(bx + 7), (double)(by + 4), this.colorScheme.textShadowColor, false);
            renderer.text(gameOverText, (double)(bx + 6), (double)(by + 5), this.colorScheme.textShadowColor, false);
            renderer.text(gameOverText, (double)(bx + 6), (double)(by + 4), this.gameWon ? this.colorScheme.wonTextColor : this.colorScheme.lostTextColor, false);
        } else {
            int flags = this.countFlags();
            int minesLeft = Math.max(0, this.mines - flags);
            String minesText = "Mines: " + minesLeft;
            renderer.text(minesText, (double)(bx + 5), (double)(by + 4), this.colorScheme.textShadowColor, false);
            renderer.text(minesText, (double)(bx + 7), (double)(by + 4), this.colorScheme.textShadowColor, false);
            renderer.text(minesText, (double)(bx + 6), (double)(by + 5), this.colorScheme.textShadowColor, false);
            renderer.text(minesText, (double)(bx + 6), (double)(by + 4), this.colorScheme.mineCountColor, false);
        }
    }

    private Color numberColor(int n) {
        return switch (n) {
            case 1 -> new Color(0, 0, 255);
            case 2 -> new Color(0, 128, 0);
            case 3 -> new Color(255, 0, 0);
            case 4 -> new Color(0, 0, 128);
            case 5 -> new Color(128, 0, 0);
            case 6 -> new Color(0, 128, 128);
            case 7 -> new Color(0, 0, 0);
            case 8 -> new Color(128, 128, 128);
            default -> new Color(0, 0, 0);
        };
    }

    private int countFlags() {
        int flags = 0;
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.state[r][c] != 2) continue;
                ++flags;
            }
        }
        return flags;
    }

    private boolean isHoveredCell(int r, int c) {
        for (int[] cell : this.hoveredCells) {
            if (r != cell[0] || c != cell[1]) continue;
            return true;
        }
        return false;
    }

    private boolean isHighlightedCell(int r, int c) {
        for (int[] cell : this.highlightedCells) {
            if (r != cell[0] || c != cell[1]) continue;
            return true;
        }
        return false;
    }

    public record SaveState(int version, Difficulty difficulty, int rows, int columns, int mines, int[][] grid, byte[][] state, long accumulatedMillis) {
    }

    public static enum Difficulty {
        Easy(new int[]{12, 12, 10}),
        Normal(new int[]{16, 16, 40}),
        Hard(new int[]{30, 16, 99}),
        Insane(new int[]{30, 24, 137}),
        Custom(new int[]{37, 37, 169});

        public final int[] values;

        private Difficulty(int[] values) {
            this.values = values;
        }

        public int getMines() {
            return this.values[2];
        }

        public int getRows() {
            return this.values[1];
        }

        public int getColumns() {
            return this.values[0];
        }
    }

    public static class ColorScheme {
        public Color wonTextColor;
        public Color lostTextColor;
        public Color cellBorderColor;
        public Color mineTextColor;
        public Color mineCellColor;
        public Color runtimeColor;
        public Color resetTextColor;
        public Color statusBarColor;
        public Color backgroundColor;
        public Color mineCountColor;
        public Color hiddenCellColor;
        public Color flaggedCellColor;
        public Color flaggedCellTextColor;
        public Color resetButtonColor;
        public Color resetHoveredColor;
        public Color revealedCellColor;
        public Color textShadowColor;

        public ColorScheme(Minesweeper module, GuiTheme theme) {
            ColorSchemes scheme = (ColorSchemes)((Object)module.colorScheme.get());
            boolean assignDefaults = false;
            switch (scheme.ordinal()) {
                case 1: {
                    if (theme instanceof MeteorGuiTheme) {
                        MeteorGuiTheme guiTheme = (MeteorGuiTheme)theme;
                        this.wonTextColor = (Color)guiTheme.plusColor.get();
                        this.lostTextColor = (Color)guiTheme.minusColor.get();
                        this.cellBorderColor = guiTheme.outlineColor.get();
                        this.mineTextColor = (Color)guiTheme.minusColor.get();
                        this.mineCellColor = guiTheme.backgroundColor.get();
                        this.runtimeColor = (Color)guiTheme.titleTextColor.get();
                        this.resetTextColor = (Color)guiTheme.textSecondaryColor.get();
                        this.statusBarColor = (Color)guiTheme.accentColor.get();
                        this.backgroundColor = guiTheme.backgroundColor.get();
                        this.mineCountColor = (Color)guiTheme.titleTextColor.get();
                        this.hiddenCellColor = (Color)guiTheme.moduleBackground.get();
                        this.flaggedCellColor = (Color)guiTheme.accentColor.get();
                        this.flaggedCellTextColor = (Color)guiTheme.textColor.get();
                        this.resetButtonColor = guiTheme.backgroundColor.get();
                        this.resetHoveredColor = guiTheme.backgroundColor.get(false, true, false);
                        this.revealedCellColor = guiTheme.backgroundColor.get();
                        this.textShadowColor = guiTheme.backgroundColor.get(false, true, false);
                        break;
                    }
                    assignDefaults = true;
                    break;
                }
                case 2: {
                    this.wonTextColor = (Color)module.wonColor.get();
                    this.lostTextColor = (Color)module.lostColor.get();
                    this.cellBorderColor = (Color)module.cellBorderColor.get();
                    this.mineTextColor = (Color)module.mineTextColor.get();
                    this.mineCellColor = (Color)module.mineCellColor.get();
                    this.runtimeColor = (Color)module.timerColor.get();
                    this.resetTextColor = (Color)module.resetTextColor.get();
                    this.statusBarColor = (Color)module.statusBarColor.get();
                    this.backgroundColor = (Color)module.backgroundColor.get();
                    this.mineCountColor = (Color)module.mineCountColor.get();
                    this.hiddenCellColor = (Color)module.hiddenCellColor.get();
                    this.flaggedCellColor = (Color)module.flaggedCellColor.get();
                    this.flaggedCellTextColor = (Color)module.flaggedCellTextColor.get();
                    this.resetButtonColor = (Color)module.resetButtonColor.get();
                    this.resetHoveredColor = (Color)module.resetHoveredColor.get();
                    this.revealedCellColor = (Color)module.revealedCellColor.get();
                    this.textShadowColor = (Color)module.textShadowColor.get();
                    break;
                }
                default: {
                    assignDefaults = true;
                }
            }
            if (assignDefaults) {
                this.wonTextColor = new Color(0, 255, 0);
                this.lostTextColor = new Color(255, 0, 0);
                this.cellBorderColor = new Color(0, 0, 0);
                this.mineTextColor = new Color(255, 0, 0);
                this.textShadowColor = new Color(0, 0, 0);
                this.mineCellColor = new Color(13, 13, 13);
                this.runtimeColor = new Color(255, 255, 0);
                this.resetTextColor = new Color(20, 20, 20);
                this.statusBarColor = new Color(42, 42, 42);
                this.backgroundColor = new Color(51, 51, 51);
                this.mineCountColor = new Color(255, 255, 255);
                this.hiddenCellColor = new Color(176, 176, 176);
                this.flaggedCellColor = new Color(255, 204, 102);
                this.flaggedCellTextColor = new Color(169, 0, 0);
                this.resetButtonColor = new Color(200, 200, 200);
                this.resetHoveredColor = new Color(230, 230, 230);
                this.revealedCellColor = new Color(248, 248, 248);
            }
        }
    }

    public static enum ColorSchemes {
        Classic,
        Themed,
        Custom;

    }
}

