/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.solitaire;

import dev.stardust.gui.widgets.solitaire.input.InputTracker;
import dev.stardust.gui.widgets.solitaire.model.Card;
import dev.stardust.gui.widgets.solitaire.model.ColorScheme;
import dev.stardust.gui.widgets.solitaire.model.ColorSchemes;
import dev.stardust.gui.widgets.solitaire.model.DrawMode;
import dev.stardust.gui.widgets.solitaire.model.Rank;
import dev.stardust.gui.widgets.solitaire.model.SaveState;
import dev.stardust.gui.widgets.solitaire.model.Suit;
import dev.stardust.gui.widgets.solitaire.render.CardRenderer;
import dev.stardust.gui.widgets.solitaire.render.PolygonRenderer;
import dev.stardust.gui.widgets.solitaire.render.StatusBarRenderer;
import dev.stardust.modules.Solitaire;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

public class WSolitaire
extends WWidget {
    public static final int TOP_PAD_PX = 6;
    public static final int LEFT_PAD_PX = 12;
    public static final int CARD_WIDTH = 169;
    public static final int CARD_HEIGHT = 272;
    public static final int PILE_SPACING = 12;
    public static final int TABLEAU_COUNT = 7;
    public static final int WINDOW_WIDTH = 1280;
    public static final int WINDOW_HEIGHT = 1280;
    public static final int FOUNDATION_COUNT = 4;
    public static final int TAB_OVERLAP_FACEUP = 56;
    public static final int TAB_OVERLAP_FACEDOWN = 24;
    public static final int WASTE_DRAW_3_OVERLAP = 56;
    private static final long AUTO_MOVE_INTERVAL = 169L;
    public static final int STATUS_BAR_HEIGHT = 32;
    public static final int UNDO_BUTTON_WIDTH = 64;
    public static final int RESET_BUTTON_WIDTH = 64;
    public static final int UNDO_BUTTON_HEIGHT = 26;
    public static final int RESET_BUTTON_HEIGHT = 26;
    private List<Card> stock = new ArrayList<Card>();
    private List<Card> waste = new ArrayList<Card>();
    private List<List<Card>> tableau = new ArrayList<List<Card>>();
    private List<List<Card>> foundations = new ArrayList<List<Card>>();
    private double dragX;
    private double dragY;
    public boolean dragging = false;
    private int dragOriginIndex = -1;
    @Nullable
    private Move lastMove = null;
    private List<Card> dragOriginPile = null;
    private List<Card> draggedCards = new ArrayList<Card>();
    public long gameEnd;
    public long gameStart;
    public long accumulated;
    private double lastMouseX;
    private double lastMouseY;
    public boolean gameWon;
    public boolean gameOver;
    public boolean undoButtonVisible;
    public boolean undoButtonHovered;
    public boolean resetButtonHovered;
    private boolean autoMoving = false;
    private long nextAutoMoveTime = 0L;
    private final Deque<AutoMove> autoMoveQueue = new ArrayDeque<AutoMove>();
    public final Solitaire module;
    public final DrawMode drawMode;
    public final ColorScheme colors;
    private final InputTracker inputTracker;
    private final Random rng = ThreadLocalRandom.current();

    public WSolitaire(Solitaire module, GuiTheme theme) {
        int n;
        this.module = module;
        this.inputTracker = new InputTracker();
        this.colors = new ColorScheme((ColorSchemes)((Object)module.colorScheme.get()), theme);
        if (((Boolean)module.shouldSave.get()).booleanValue() && module.saveData != null && module.drawMode.get() == module.saveData.mode()) {
            this.stock = module.saveData.stock();
            this.waste = module.saveData.waste();
            this.drawMode = module.saveData.mode();
            this.tableau = module.saveData.tableau();
            this.gameStart = System.currentTimeMillis();
            this.foundations = module.saveData.foundations();
            this.accumulated += module.saveData.accumulatedMillis();
            return;
        }
        this.drawMode = (DrawMode)((Object)module.drawMode.get());
        for (n = 0; n < 7; ++n) {
            this.tableau.add(new ArrayList());
        }
        for (n = 0; n < 4; ++n) {
            this.foundations.add(new ArrayList());
        }
        this.initEmpty();
    }

    protected void onCalculateSize() {
        this.width = 1280.0;
        this.height = 1280.0;
    }

    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        int n;
        Card top;
        List<Card> origin;
        AutoMove move;
        long now;
        if (this.autoMoving && !this.autoMoveQueue.isEmpty() && (now = System.currentTimeMillis()) >= this.nextAutoMoveTime && (move = this.autoMoveQueue.pollFirst()) != null && !(origin = this.tableau.get(move.fromPileIdx)).isEmpty() && origin.getLast() == move.card) {
            if (this.tryAutoMoveToFoundations(move.card, origin)) {
                origin.removeLast();
                this.playSound(class_3417.field_19197, this.rng.nextFloat(0.77f, 1.42f), ((Double)this.module.soundVolume.get()).floatValue());
                this.nextAutoMoveTime = System.currentTimeMillis() + 169L;
            } else {
                this.autoMoveQueue.clear();
            }
        }
        if (this.autoMoving && this.autoMoveQueue.isEmpty()) {
            this.autoMoving = false;
        }
        this.pollInput();
        int bx = (int)this.x;
        int by = (int)this.y;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.undoButtonVisible = this.lastMove != null;
        renderer.quad((double)(bx - 2), (double)(by - 2), this.width, this.height, this.colors.backgroundColor);
        StatusBarRenderer.render(renderer, bx, by, this.width, this);
        int stockY = (by += 32) + 6;
        int stockX = bx + 12;
        int wasteY = stockY;
        int wasteX = stockX + 169 + 12;
        int foundationsStartX = bx + 12 + 543;
        if (this.stock.isEmpty()) {
            CardRenderer.drawCardBorder(renderer, stockX, stockY, 169.0, 272.0, 16.0, 1.0, this.colors.cardBorder);
            PolygonRenderer.drawRoundedRect(renderer, stockX, stockY, 169.0, 272.0, 16.0, this.colors.emptyPileColor);
        } else {
            top = this.stock.getLast();
            top.faceUp = false;
            CardRenderer.drawCard(renderer, stockX, stockY, 169, 272, false, top, this.colors);
        }
        if (this.drawMode.equals((Object)DrawMode.Draw_Three)) {
            int cx;
            int n2;
            int visibleStart = this.waste.size() > 3 ? this.waste.size() - 3 : 0;
            int offset = 0;
            for (n2 = visibleStart; n2 < Math.max(this.waste.size(), 3); ++n2) {
                cx = wasteX + 56 * offset;
                CardRenderer.drawCardBorder(renderer, cx, wasteY, 169.0, 272.0, 16.0, 1.0, this.colors.cardBorder);
                PolygonRenderer.drawRoundedRect(renderer, cx, wasteY, 169.0, 272.0, 16.0, this.colors.emptyPileColor);
                ++offset;
            }
            offset = 0;
            if (!this.waste.isEmpty()) {
                for (n2 = visibleStart; n2 < this.waste.size(); ++n2) {
                    cx = wasteX + 56 * offset;
                    Card c = this.waste.get(n2);
                    if (n2 == this.waste.size() - 1) {
                        if (!this.dragging || !this.draggedCards.contains(c)) {
                            CardRenderer.drawCard(renderer, cx, wasteY, 169, 272, false, c, this.colors);
                        }
                    } else {
                        boolean cullSuit = n2 < this.waste.size() - 2 || n2 == this.waste.size() - 2 && (!this.dragging || !this.draggedCards.contains(this.waste.getLast()));
                        CardRenderer.drawCard(renderer, cx, wasteY, 169, 272, cullSuit, c, this.colors);
                    }
                    ++offset;
                }
            }
        } else {
            CardRenderer.drawCardBorder(renderer, wasteX, wasteY, 169.0, 272.0, 16.0, 1.0, this.colors.cardBorder);
            PolygonRenderer.drawRoundedRect(renderer, wasteX, wasteY, 169.0, 272.0, 16.0, this.colors.emptyPileColor);
            if (!this.waste.isEmpty()) {
                top = this.waste.getLast();
                if (!this.dragging || !this.draggedCards.contains(top)) {
                    CardRenderer.drawCard(renderer, wasteX, wasteY, 169, 272, false, top, this.colors);
                }
            }
        }
        renderer.scissorStart((double)bx, (double)by, this.width, this.height);
        for (int n3 = 0; n3 < 4; ++n3) {
            int fy = 6 + by;
            int fx = foundationsStartX + n3 * 181;
            CardRenderer.drawCardBorder(renderer, fx, fy, 169.0, 272.0, 16.0, 1.0, this.colors.cardBorder);
            PolygonRenderer.drawRoundedRect(renderer, fx, fy, 169.0, 272.0, 16.0, this.colors.emptyPileColor);
            List<Card> f = this.foundations.get(n3);
            if (f.isEmpty()) continue;
            Card fc = f.getLast();
            if (this.dragging && this.draggedCards.contains(fc)) continue;
            CardRenderer.drawCard(renderer, fx, fy, 169, 272, false, fc, this.colors);
        }
        int tableauStartY = by + 6 + 272 + 12;
        for (int pi = 0; pi < 7; ++pi) {
            int py = tableauStartY;
            int px = bx + 12 + pi * 181;
            CardRenderer.drawCardBorder(renderer, px, py, 169.0, 272.0, 16.0, 1.0, this.colors.cardBorder);
            PolygonRenderer.drawRoundedRect(renderer, px, py, 169.0, 272.0, 16.0, this.colors.emptyPileColor);
            List<Card> pile = this.tableau.get(pi);
            if (pile.isEmpty()) continue;
            n = 0;
            int curY = py;
            for (Card c : pile) {
                if (!this.dragging || !this.draggedCards.contains(c)) {
                    boolean cullSuit = n != pile.size() - 1 && (!this.dragging || !this.draggedCards.contains(pile.get(Math.min(pile.size() - 1, n + 1))));
                    CardRenderer.drawCard(renderer, px, curY, 169, 272, cullSuit, c, this.colors);
                    curY += c.faceUp ? 56 : 24;
                }
                ++n;
            }
        }
        renderer.scissorEnd();
        if (this.dragging && !this.draggedCards.isEmpty()) {
            double baseX = this.dragX;
            double baseY = this.dragY;
            for (n = 0; n < this.draggedCards.size(); ++n) {
                int dx = (int)baseX;
                int dy = (int)(baseY + (double)(n * 56));
                CardRenderer.drawCard(renderer, dx + bx, dy + by, 169, 272, n < this.draggedCards.size() - 1, this.draggedCards.get(n), this.colors);
            }
        }
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button, boolean used) {
        double localX = mouseX - this.x;
        double localY = mouseY - this.y;
        if (localY >= 0.0 && localY < 32.0) {
            int buttonY = 3;
            int resetButtonX = (int)this.width - 64 - 6;
            int undoButtonX = (int)this.width - 64 - 12 - 64;
            if (localX >= (double)resetButtonX && localX <= (double)(resetButtonX + 64) && localY >= (double)buttonY && localY <= (double)(buttonY + 26)) {
                this.initEmpty();
                return true;
            }
            if (this.lastMove != null && localX >= (double)undoButtonX && localX <= (double)(undoButtonX + 64) && localY >= (double)buttonY && localY <= (double)(buttonY + 26)) {
                this.undoLastMove();
                return true;
            }
        }
        if (this.gameOver && this.gameWon) {
            return true;
        }
        int stockX = 12;
        int stockY = 38;
        if (localX >= (double)stockX && localX <= (double)(stockX + 169) && localY >= (double)stockY && localY <= (double)(stockY + 272)) {
            if (button == 0) {
                ArrayList<Card> moved;
                if (!this.stock.isEmpty()) {
                    moved = new ArrayList<Card>();
                    int count = this.drawMode.count();
                    for (int n = 0; n < count && !this.stock.isEmpty(); ++n) {
                        Card c = this.stock.removeLast();
                        c.faceUp = true;
                        this.waste.add(c);
                        moved.add(c);
                    }
                } else {
                    boolean moved2 = false;
                    while (!this.waste.isEmpty()) {
                        Card c = this.waste.removeLast();
                        c.faceUp = false;
                        this.stock.add(c);
                        moved2 = true;
                    }
                    if (moved2) {
                        this.lastMove = null;
                    }
                    if (!this.hasAnyLegalMoves()) {
                        this.gameOver = true;
                        this.gameWon = false;
                        this.module.clearSave();
                        this.gameEnd = System.currentTimeMillis();
                        this.playSound(class_3417.field_15008, this.rng.nextFloat(0.69f, 1.337f));
                    }
                    return true;
                }
                this.lastMove = new Move(moved, this.stock, this.waste);
                return true;
            }
            if (button == 1) {
                Card top;
                if (!this.waste.isEmpty() && this.tryAutoMoveToFoundations(top = this.waste.getLast(), this.waste)) {
                    this.waste.removeLast();
                    this.playSound(class_3417.field_19197, this.rng.nextFloat(0.77f, 1.42f), ((Double)this.module.soundVolume.get()).floatValue());
                }
                return true;
            }
        }
        int wasteY = 38;
        int wasteX = 193;
        int wasteOffset = 56 * (this.drawMode.count() < 3 ? 0 : 3);
        if (localX >= (double)wasteX && localX <= (double)(wasteX + 169 + wasteOffset) && localY >= (double)wasteY && localY <= (double)(wasteY + 272)) {
            Card top;
            if (!this.waste.isEmpty() && button == 0) {
                this.startDragFromPile(this.waste, this.waste.size() - 1, localX, localY);
                return true;
            }
            if (!this.waste.isEmpty() && button == 1 && this.tryAutoMoveToFoundations(top = this.waste.getLast(), this.waste)) {
                this.waste.removeLast();
                this.playSound(class_3417.field_19197, this.rng.nextFloat(0.77f, 1.42f), ((Double)this.module.soundVolume.get()).floatValue());
                return true;
            }
            return false;
        }
        int foundationsStartX = 555;
        for (int n = 0; n < 4; ++n) {
            int fy = 38;
            int fx = foundationsStartX + n * 181;
            List<Card> f = this.foundations.get(n);
            if (!(localX >= (double)fx) || !(localX <= (double)(fx + 169)) || !(localY >= (double)fy) || !(localY <= (double)(fy + 272))) continue;
            if (!f.isEmpty() && button == 0) {
                this.startDragFromPile(f, f.size() - 1, localX, localY);
                return true;
            }
            return false;
        }
        int tableauStartY = 322;
        for (int n = 0; n < 7; ++n) {
            Card top;
            int py = tableauStartY;
            int px = 12 + n * 181;
            List<Card> pile = this.tableau.get(n);
            int idx = this.indexAtTableauPosition(pile, (int)localX, (int)localY, px, py);
            if (idx < 0) continue;
            Card c = pile.get(idx);
            if (!c.faceUp) {
                if (idx == pile.size() - 1 && button == 0) {
                    c.faceUp = true;
                    this.lastMove = null;
                    return true;
                }
                return false;
            }
            if (button == 0) {
                this.startDragFromPile(pile, idx, localX, localY);
                return true;
            }
            if (button != 1 || !this.tryAutoMoveToFoundations(top = pile.getLast(), pile)) continue;
            pile.removeLast();
            this.playSound(class_3417.field_19197, this.rng.nextFloat(0.77f, 1.42f), ((Double)this.module.soundVolume.get()).floatValue());
            this.tryAutoMoveAllRemainingToFoundations();
            return true;
        }
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        if (!this.dragging) {
            return false;
        }
        double localX = mouseX - this.x;
        double localY = mouseY - this.y;
        int foundationsStartX = 555;
        for (int n = 0; n < 4; ++n) {
            int fy = 38;
            int fx = foundationsStartX + n * 181;
            if (!(localX >= (double)fx) || !(localX <= (double)(fx + 169)) || !(localY >= (double)fy) || !(localY <= (double)(fy + 272)) || !this.canDropOnFoundation(this.draggedCards, this.foundations.get(n))) continue;
            this.playSound(class_3417.field_19197, this.rng.nextFloat(0.77f, 1.42f), ((Double)this.module.soundVolume.get()).floatValue());
            this.performDrop(this.dragOriginPile, this.foundations.get(n), this.dragOriginIndex);
            this.endDrag();
            return true;
        }
        int tableauStartY = 322;
        for (int pi = 0; pi < 7; ++pi) {
            List<Card> dest;
            int px;
            int py = tableauStartY;
            int pileX1 = px = 12 + pi * 181;
            int pileY1 = py;
            int pileY2 = (int)this.height;
            int pileX2 = px + 169;
            if (!(localX >= (double)pileX1) || !(localX <= (double)pileX2) || !(localY >= (double)pileY1) || !(localY <= (double)pileY2) || !this.canDropOnTableau(this.draggedCards, dest = this.tableau.get(pi))) continue;
            this.performDrop(this.dragOriginPile, dest, this.dragOriginIndex);
            this.endDrag();
            return true;
        }
        this.cancelDragReturn();
        return true;
    }

    public void onMouseMoved(double mouseX, double mouseY, double lastMouseX, double lastMouseY) {
        super.onMouseMoved(mouseX, mouseY, lastMouseX, lastMouseY);
        double localX = mouseX - this.x;
        double localY = mouseY - this.y;
        if (this.dragging) {
            this.dragX = localX;
            this.dragY = localY;
        }
        int buttonY = 3;
        int resetButtonX = (int)this.width - 64 - 6;
        this.resetButtonHovered = localX >= (double)resetButtonX && localX <= (double)(resetButtonX + 64) && localY >= (double)buttonY && localY <= (double)(buttonY + 26);
        int undoButtonX = (int)this.width - 64 - 12 - 64;
        this.undoButtonHovered = localX >= (double)undoButtonX && localX <= (double)(undoButtonX + 64) && localY >= (double)buttonY && localY <= (double)(buttonY + 26);
    }

    private void pollInput() {
        boolean wKey = InputTracker.isKeyDown(87);
        boolean eKey = InputTracker.isKeyDown(69);
        boolean rKey = InputTracker.isKeyDown(82);
        boolean qKey = InputTracker.isKeyDown(81);
        boolean space = InputTracker.isKeyDown(32);
        if (!this.dragging) {
            if (qKey && this.inputTracker.isNotHeld(81) || wKey && this.inputTracker.isNotHeld(87) || space && this.inputTracker.isNotHeld(32)) {
                this.onMouseClicked(this.lastMouseX, this.lastMouseY, 0, false);
            }
            if (eKey && this.inputTracker.isNotHeld(69) || rKey && this.inputTracker.isNotHeld(82)) {
                this.onMouseClicked(this.lastMouseX, this.lastMouseY, 1, false);
            }
        } else {
            if (qKey && this.inputTracker.isNotHeld(81) || wKey && this.inputTracker.isNotHeld(87) || space && this.inputTracker.isNotHeld(32)) {
                this.onMouseReleased(this.lastMouseX, this.lastMouseY, 0);
            }
            if (eKey && this.inputTracker.isNotHeld(69) || rKey && this.inputTracker.isNotHeld(82)) {
                this.onMouseReleased(this.lastMouseX, this.lastMouseY, 1);
            }
        }
        this.inputTracker.updateState(87, wKey);
        this.inputTracker.updateState(69, eKey);
        this.inputTracker.updateState(82, rKey);
        this.inputTracker.updateState(81, qKey);
        this.inputTracker.updateState(32, space);
    }

    /*
     * WARNING - void declaration
     */
    private void initEmpty() {
        void var2_7;
        this.endDrag();
        this.stock.clear();
        this.waste.clear();
        this.lastMove = null;
        for (List<Card> list : this.tableau) {
            list.clear();
        }
        for (List<Card> list : this.foundations) {
            list.clear();
        }
        ArrayList<Card> deck = new ArrayList<Card>(52);
        for (Suit s : Suit.values()) {
            for (Rank r : Rank.values()) {
                deck.add(new Card(r, s));
            }
        }
        Collections.shuffle(deck, this.rng);
        boolean bl = false;
        while (var2_7 < 7) {
            List<Card> pile = this.tableau.get((int)var2_7);
            for (int i = 0; i <= var2_7; ++i) {
                Card c = (Card)deck.removeLast();
                c.faceUp = i == var2_7;
                pile.add(c);
            }
            ++var2_7;
        }
        while (!deck.isEmpty()) {
            Card card = (Card)deck.removeLast();
            card.faceUp = false;
            this.stock.add(card);
        }
        this.gameWon = false;
        this.gameOver = false;
        this.dragging = false;
        this.accumulated = 0L;
        this.autoMoving = false;
        this.dragOriginIndex = -1;
        this.draggedCards.clear();
        this.autoMoveQueue.clear();
        this.dragOriginPile = null;
        this.undoButtonHovered = false;
        this.resetButtonHovered = false;
        this.gameStart = System.currentTimeMillis();
        this.playSound(class_3417.field_14627, this.rng.nextFloat(0.69f, 1.337f));
    }

    private void undoLastMove() {
        if (this.lastMove == null) {
            return;
        }
        List<Card> origin = this.lastMove.origin();
        List<Card> dest = this.lastMove.destination();
        ArrayList<Card> moved = new ArrayList<Card>(this.lastMove.moved());
        if (!moved.isEmpty()) {
            this.playSound(class_3417.field_46945, this.rng.nextFloat(0.42f, 0.69f));
        }
        block0: for (Card c : moved) {
            for (int n = dest.size() - 1; n >= 0; --n) {
                if (dest.get(n) != c) continue;
                dest.remove(n);
                continue block0;
            }
        }
        origin.addAll(moved);
        this.lastMove = null;
    }

    private void startDragFromPile(List<Card> pile, int index, double localMouseX, double localMouseY) {
        this.draggedCards = new ArrayList<Card>();
        for (int n = index; n < pile.size(); ++n) {
            this.draggedCards.add(pile.get(n));
        }
        this.dragging = true;
        this.dragOriginPile = pile;
        this.dragOriginIndex = index;
        this.dragX = localMouseX - 84.5;
        this.dragY = localMouseY - 136.0;
        this.playSound(class_3417.field_14770, this.rng.nextFloat(0.69f, 1.337f), ((Double)this.module.soundVolume.get()).floatValue() * 0.77f);
    }

    private void endDrag() {
        this.dragging = false;
        this.draggedCards.clear();
        this.dragOriginIndex = -1;
        this.dragOriginPile = null;
    }

    private void performDrop(List<Card> origin, List<Card> dest, int startIndex) {
        ArrayList<Card> moved = new ArrayList<Card>();
        for (int n = startIndex; n < origin.size(); ++n) {
            moved.add(origin.get(n));
        }
        for (Card c : moved) {
            origin.remove(c);
        }
        dest.addAll(moved);
        this.lastMove = new Move(moved, origin, dest);
        this.playSound(class_3417.field_14667, this.rng.nextFloat(0.69f, 1.337f), ((Double)this.module.soundVolume.get()).floatValue() * 0.77f);
        if (this.checkWin()) {
            this.gameWon = true;
            this.gameOver = true;
            this.lastMove = null;
            this.module.clearSave();
            this.gameEnd = System.currentTimeMillis();
            this.playSound(class_3417.field_19152, this.rng.nextFloat(0.69f, 1.337f));
            this.playSound(class_3417.field_14981, this.rng.nextFloat(0.777f, 1.1337f), ((Double)this.module.soundVolume.get()).floatValue() * 0.42f);
        }
    }

    private boolean checkWin() {
        for (List<Card> f : this.foundations) {
            if (f.size() == 13) continue;
            return false;
        }
        return true;
    }

    private boolean hasAnyLegalMoves() {
        if (!this.waste.isEmpty()) {
            Card wTop = this.waste.getLast();
            if (this.canDropOnAnyFoundation(wTop)) {
                return true;
            }
            for (List<Card> list : this.tableau) {
                if (!this.canDropOnTableau(Collections.singletonList(wTop), list)) continue;
                return true;
            }
        }
        if (!this.stock.isEmpty()) {
            for (int n = this.stock.size() - this.drawMode.count(); n >= 0; n -= this.drawMode.count()) {
                Card c = this.stock.get(n);
                if (this.canDropOnAnyFoundation(c)) {
                    return true;
                }
                for (List<Card> list : this.tableau) {
                    if (!this.canDropOnTableau(Collections.singletonList(c), list)) continue;
                    return true;
                }
            }
        }
        for (List<Card> pile : this.tableau) {
            if (pile.isEmpty()) continue;
            Card card = pile.getLast();
            if (!card.faceUp || !this.canDropOnAnyFoundation(card)) continue;
            return true;
        }
        for (List<Card> src : this.tableau) {
            boolean bl = false;
            for (int i = 0; i < src.size(); ++i) {
                Card c = src.get(i);
                if (!c.faceUp || !bl) continue;
                List<Card> faceUpStack = src.subList(i, src.size());
                for (List<Card> dest : this.tableau) {
                    if (dest == src || !this.canDropOnTableau(new ArrayList<Card>(faceUpStack), dest)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canDropOnAnyFoundation(Card c) {
        for (List<Card> f : this.foundations) {
            if (!this.canDropOnFoundation(Collections.singletonList(c), f)) continue;
            return true;
        }
        return false;
    }

    private boolean canDropOnFoundation(List<Card> moving, List<Card> dest) {
        if (moving.isEmpty()) {
            return false;
        }
        if (moving.size() > 1) {
            return false;
        }
        Card c = moving.getFirst();
        if (dest.isEmpty()) {
            return c.rank == Rank.ACE;
        }
        Card top = dest.getLast();
        return top.suit == c.suit && top.rank.ordinal() + 1 == c.rank.ordinal();
    }

    private boolean canDropOnTableau(List<Card> moving, List<Card> dest) {
        if (moving.isEmpty()) {
            return false;
        }
        Card first = moving.getFirst();
        if (dest.isEmpty()) {
            return first.rank == Rank.KING;
        }
        Card top = dest.getLast();
        if (!top.faceUp) {
            return false;
        }
        boolean colorsOpposite = top.suit.isRed() != first.suit.isRed();
        boolean rankCorrect = top.rank.ordinal() == first.rank.ordinal() + 1;
        return colorsOpposite && rankCorrect;
    }

    private void tryAutoMoveAllRemainingToFoundations() {
        if (!this.stock.isEmpty() || !this.waste.isEmpty()) {
            return;
        }
        for (List<Card> list : this.tableau) {
            for (Card c : list) {
                if (c.faceUp) continue;
                return;
            }
        }
        ArrayList<List<Card>> simFoundations = new ArrayList<List<Card>>();
        for (List<Card> list : this.foundations) {
            simFoundations.add(new ArrayList<Card>(list));
        }
        int n = this.tableau.size();
        int[] nArray = new int[n];
        for (int n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.tableau.get(n2).size();
        }
        ArrayDeque<AutoMove> planned = new ArrayDeque<AutoMove>();
        boolean progress = true;
        while (progress) {
            progress = false;
            for (int n3 = 0; n3 < n; ++n3) {
                int idx;
                Card top;
                if (nArray[n3] == 0 || !this.canDropOnAnySimulatedFoundation(top = this.tableau.get(n3).get(nArray[n3] - 1), simFoundations) || (idx = this.findSimulatedFoundationIndexFor(top, simFoundations)) < 0) continue;
                planned.addLast(new AutoMove(n3, top));
                ((List)simFoundations.get(idx)).add(top);
                int n4 = n3;
                nArray[n4] = nArray[n4] - 1;
                progress = true;
            }
        }
        if (planned.isEmpty()) {
            return;
        }
        this.autoMoving = true;
        this.autoMoveQueue.addAll(planned);
        this.nextAutoMoveTime = System.currentTimeMillis() + 169L;
    }

    private boolean canDropOnAnySimulatedFoundation(Card c, List<List<Card>> simFoundations) {
        for (List<Card> f : simFoundations) {
            if (!this.canDropOnFoundation(Collections.singletonList(c), f)) continue;
            return true;
        }
        return false;
    }

    private int findSimulatedFoundationIndexFor(Card c, List<List<Card>> simFoundations) {
        for (int n = 0; n < simFoundations.size(); ++n) {
            List<Card> f = simFoundations.get(n);
            if (!this.canDropOnFoundation(Collections.singletonList(c), f)) continue;
            return n;
        }
        return -1;
    }

    private boolean tryAutoMoveToFoundations(Card c, List<Card> origin) {
        for (List<Card> f : this.foundations) {
            if (!this.canDropOnFoundation(Collections.singletonList(c), f)) continue;
            f.add(c);
            this.lastMove = new Move(Collections.singletonList(c), origin, f);
            if (this.checkWin()) {
                this.gameWon = true;
                this.gameOver = true;
                this.lastMove = null;
                this.module.clearSave();
                this.gameEnd = System.currentTimeMillis();
                this.playSound(class_3417.field_19152, this.rng.nextFloat(0.69f, 1.337f));
                this.playSound(class_3417.field_14981, this.rng.nextFloat(0.777f, 1.1337f), ((Double)this.module.soundVolume.get()).floatValue() * 0.42f);
            }
            return true;
        }
        return false;
    }

    private int indexAtTableauPosition(List<Card> pile, int localX, int localY, int px, int pyStart) {
        int n;
        if (pile.isEmpty()) {
            if (localX >= px && localX <= px + 169 && localY >= pyStart && localY <= pyStart + 272) {
                return -1;
            }
            return -2;
        }
        int size = pile.size();
        int[] yPos = new int[size];
        int curY = pyStart;
        for (n = 0; n < size; ++n) {
            yPos[n] = curY;
            Card c = pile.get(n);
            curY += c.faceUp ? 56 : 24;
        }
        for (n = size - 1; n >= 0; --n) {
            int top = yPos[n];
            int bottom = top + 272;
            if (localX < px || localX > px + 169 || localY < top || localY > bottom) continue;
            return n;
        }
        int lastTop = yPos[size - 1];
        if (localX >= px && localX <= px + 169 && localY >= lastTop && localY <= lastTop + 272) {
            return size - 1;
        }
        return -2;
    }

    public void cancelDragReturn() {
        this.playSound(class_3417.field_14667, this.rng.nextFloat(0.69f, 1.337f), ((Double)this.module.soundVolume.get()).floatValue() * 0.69f);
        this.endDrag();
    }

    public boolean shouldSaveGame() {
        return (Boolean)this.module.shouldSave.get() != false && !this.gameOver;
    }

    public SaveState saveGame() {
        return new SaveState(this.drawMode, this.stock, this.waste, this.foundations, this.tableau, this.accumulated + (System.currentTimeMillis() - this.gameStart));
    }

    public void playSound(class_3414 sound, float pitch) {
        if (!((Boolean)this.module.sounds.get()).booleanValue()) {
            return;
        }
        try {
            if (MeteorClient.mc == null) {
                return;
            }
            if (MeteorClient.mc.method_1483() == null) {
                return;
            }
            MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)((Double)this.module.soundVolume.get()).floatValue()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void playSound(class_3414 sound, float pitch, float volume) {
        if (!((Boolean)this.module.sounds.get()).booleanValue()) {
            return;
        }
        try {
            if (MeteorClient.mc == null) {
                return;
            }
            if (MeteorClient.mc.method_1483() == null) {
                return;
            }
            MeteorClient.mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)volume));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private record Move(List<Card> moved, List<Card> origin, List<Card> destination) {
    }

    private record AutoMove(int fromPileIdx, Card card) {
    }
}

