/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.solitaire.render;

import dev.stardust.gui.widgets.solitaire.model.Card;
import dev.stardust.gui.widgets.solitaire.model.ColorScheme;
import dev.stardust.gui.widgets.solitaire.model.Rank;
import dev.stardust.gui.widgets.solitaire.model.Suit;
import dev.stardust.gui.widgets.solitaire.render.PolygonRenderer;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class CardRenderer {
    private static final int TOP_TEXT_Y_OFFSET = 5;
    private static final int TOP_TEXT_X_OFFSET = 12;
    private static final int BOTTOM_TEXT_X_OFFSET = 24;
    private static final int BOTTOM_TEXT_Y_OFFSET = 44;
    private static final double CARD_BORDER_WIDTH = 1.0;
    public static final double CARD_CORNER_RESOLUTION = 16.0;

    public static void drawCard(GuiRenderer renderer, int x, int y, int width, int height, boolean cullSuit, Card c, ColorScheme colors) {
        if (!c.faceUp) {
            CardRenderer.drawCardFaceDown(renderer, x, y, width, height, colors);
            return;
        }
        CardRenderer.drawCardBorder(renderer, x, y, width, height, 16.0, 1.0, colors.cardBorder);
        PolygonRenderer.drawRoundedRect(renderer, x, y, width, height, 16.0, colors.cardFaceColor);
        String rankText = c.rank.method_15434();
        Color suitColor = c.suit.isRed() ? colors.suitRed : colors.suitBlack;
        renderer.text(rankText, (double)(x + 12 - 1), (double)(y + 5 - 1), colors.textShadow, false);
        renderer.text(rankText, (double)(x + 12 + 1), (double)(y + 5 - 1), colors.textShadow, false);
        renderer.text(rankText, (double)(x + 12), (double)(y + 5), colors.rankColor, false);
        int smallSuitCenterX = x + 18;
        int smallSuitCenterY = y + 32;
        double smallSuitSize = Math.max(12.0, (double)width * 0.14);
        CardRenderer.drawSuit(renderer, smallSuitCenterX, smallSuitCenterY, smallSuitSize, c.suit, suitColor, colors.textShadow);
        if (!cullSuit) {
            renderer.text(rankText, (double)(x + width - 24 - 1), (double)(y + height - 44 - 1), colors.textShadow, false);
            renderer.text(rankText, (double)(x + width - 24 + 1), (double)(y + height - 44 - 1), colors.textShadow, false);
            renderer.text(rankText, (double)(x + width - 24), (double)(y + height - 44), colors.rankColor, false);
            int brCenterX = x + width - 20;
            int brCenterY = y + height - 18;
            double brSize = Math.max(12.0, (double)width * 0.14);
            CardRenderer.drawSuit(renderer, brCenterX, brCenterY, brSize, c.suit, suitColor, colors.textShadow);
        }
        for (Vec pos : CardRenderer.pipPositionsForRank(c.rank)) {
            int innerPadX = 12;
            int innerPadY = 24;
            int px = x + (int)(pos.x * (double)(width - innerPadX * 2)) + innerPadX;
            int py = y + (int)(pos.y * (double)(height - innerPadY * 2)) + innerPadY;
            double pipSize = Math.max(14.0, (double)width * 0.16);
            CardRenderer.drawSuit(renderer, px, py, pipSize, c.suit, suitColor, colors.textShadow);
        }
    }

    private static void drawCardFaceDown(GuiRenderer renderer, int x, int y, int width, int height, ColorScheme colors) {
        CardRenderer.drawCardBorder(renderer, x, y, width, height, 16.0, 1.0, colors.cardBorder);
        PolygonRenderer.drawRoundedRect(renderer, x, y, width, height, 16.0, colors.cardBackColor);
        int cx = x + width / 2;
        int cy = y + height / 2;
        int minDimensions = Math.min(width, height);
        double vignetteInset = Math.max(6.0, (double)minDimensions * 0.06);
        PolygonRenderer.drawRoundedRect(renderer, (double)x + vignetteInset, (double)y + vignetteInset, (double)width - vignetteInset * 2.0, (double)height - vignetteInset * 2.0, 16.0, colors.cardBorder);
        int petals = 6;
        int petalOuterR = Math.max(6, (int)Math.round((double)minDimensions * 0.14));
        int petalRingR = Math.max(14, (int)Math.round((double)minDimensions * 0.24));
        for (int n = 0; n < petals; ++n) {
            double a = Math.PI * 2 * (double)n / (double)petals;
            double px = (long)cx + Math.round(Math.cos(a) * (double)petalRingR);
            double py = (long)cy + Math.round(Math.sin(a) * (double)petalRingR * 0.8);
            PolygonRenderer.drawFilledCircleSpan(renderer, px, py, (double)petalOuterR * 0.9, colors.cardBackColor);
        }
        PolygonRenderer.drawRoundedRect(renderer, (double)cx - (double)minDimensions * 0.28, (double)cy - (double)minDimensions * 0.06, (double)minDimensions * 0.56, Math.max(8.0, (double)minDimensions * 0.12), 6.0, colors.cardBorder);
        PolygonRenderer.drawRoundedRectRotated(renderer, cx, cy, (double)minDimensions * 0.56, Math.max(8.0, (double)minDimensions * 0.12), Math.toRadians(45.0), colors.cardBorder);
        double outer = Math.max(18.0, (double)minDimensions * 0.2);
        double inner = Math.max(8.0, outer * 0.45);
        double[][] star = CardRenderer.starPolygon(cx, cy, outer, inner, 8);
        PolygonRenderer.drawFilledPolygon(renderer, star[0], star[1], colors.cardFaceColor);
        double[][] innerStar = CardRenderer.starPolygon(cx, cy, outer * 0.69, inner * 0.49, 8);
        PolygonRenderer.drawFilledPolygon(renderer, innerStar[0], innerStar[1], colors.cardBorder);
    }

    public static void drawCardBorder(GuiRenderer renderer, double rx, double ry, double rw, double rh, double cornerResolution, double borderWidth, Color color) {
        if (cornerResolution == 0.0) {
            CardRenderer.drawCardBorder(renderer, rx, ry, rw, rh, color);
            return;
        }
        PolygonRenderer.drawRoundedRect(renderer, rx - borderWidth, ry, rw, rh, 16.0, color);
        PolygonRenderer.drawRoundedRect(renderer, rx + borderWidth, ry, rw, rh, 16.0, color);
        PolygonRenderer.drawRoundedRect(renderer, rx, ry - borderWidth, rw, rh, 16.0, color);
        PolygonRenderer.drawRoundedRect(renderer, rx, ry + borderWidth, rw, rh, 16.0, color);
    }

    private static void drawCardBorder(GuiRenderer renderer, double x, double y, double width, double height, Color color) {
        renderer.quad(x, y, width, 1.0, color);
        renderer.quad(x, y, 1.0, height, color);
        renderer.quad(x + width - 1.0, y, 1.0, height, color);
        renderer.quad(x, y + height - 1.0, width, 1.0, color);
    }

    private static void drawSuit(GuiRenderer renderer, int cx, int cy, double sizePx, Suit suit, Color color, Color shadowColor) {
        CardRenderer.drawSuitPolygons(renderer, cx + 1, cy + 1, sizePx, suit, shadowColor);
        CardRenderer.drawSuitPolygons(renderer, cx, cy, sizePx, suit, color);
    }

    private static void drawSuitPolygons(GuiRenderer renderer, int cx, int cy, double sizePx, Suit suit, Color color) {
        int segments = Math.max(64, (int)Math.round(sizePx / 4.0));
        switch (suit) {
            case HEARTS: {
                double[][] p = CardRenderer.heartPolygon(cx, cy, sizePx, segments);
                PolygonRenderer.drawFilledPolygon(renderer, p[0], p[1], color);
                break;
            }
            case DIAMONDS: {
                double[][] p = CardRenderer.diamondPolygon(cx, cy, sizePx);
                PolygonRenderer.drawFilledPolygon(renderer, p[0], p[1], color);
                break;
            }
            case CLUBS: {
                for (double[][] poly : CardRenderer.clubPolygons(cx, cy, sizePx, segments)) {
                    PolygonRenderer.drawFilledPolygon(renderer, poly[0], poly[1], color);
                }
                double stemW = Math.max(1.0, sizePx * 0.18);
                double stemH = Math.max(1.0, sizePx * 0.29);
                renderer.quad((double)cx - stemW / 2.0, (double)cy + sizePx * 0.28, stemW, stemH, color);
                break;
            }
            case SPADES: {
                for (double[][] poly : CardRenderer.spadePolygons(cx, cy, sizePx, segments)) {
                    PolygonRenderer.drawFilledPolygon(renderer, poly[0], poly[1], color);
                }
                double stemW = Math.max(1.0, sizePx * 0.16);
                double stemH = Math.max(1.0, sizePx * 0.35);
                renderer.quad((double)cx - stemW / 2.0, (double)cy + sizePx * 0.32, stemW, stemH, color);
            }
        }
    }

    private static double[][] circlePolygon(double cx, double cy, double r, int segments) {
        double[] xs = new double[segments];
        double[] ys = new double[segments];
        for (int n = 0; n < segments; ++n) {
            double a = Math.PI * 2 * (double)n / (double)segments;
            xs[n] = cx + Math.cos(a) * r;
            ys[n] = cy + Math.sin(a) * r;
        }
        return new double[][]{xs, ys};
    }

    private static double[][] heartPolygon(int cx, int cy, double size, int segments) {
        double[] xs = new double[segments];
        double[] ys = new double[segments];
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int n = 0; n < segments; ++n) {
            double t = Math.PI * 2 * (double)n / (double)segments;
            double x = 16.0 * Math.pow(Math.sin(t), 3.0);
            double y = 13.0 * Math.cos(t) - 5.0 * Math.cos(2.0 * t) - 2.0 * Math.cos(3.0 * t) - Math.cos(4.0 * t);
            xs[n] = x;
            ys[n] = y;
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        double w = maxX - minX;
        double h = maxY - minY;
        double scale = size / Math.max(w, h);
        double[] ix = new double[segments];
        double[] iy = new double[segments];
        for (int n = 0; n < segments; ++n) {
            ix[n] = (double)cx + (xs[n] - (minX + w / 2.0)) * scale;
            iy[n] = (double)cy - (ys[n] - (minY + h / 2.0)) * scale;
        }
        return new double[][]{ix, iy};
    }

    private static double[][] diamondPolygon(int cx, int cy, double size) {
        double halfW = size * 0.45;
        double halfH = size * 0.5;
        double[] xs = new double[]{cx, (double)cx + halfW, cx, (double)cx - halfW};
        double[] ys = new double[]{(double)cy - halfH, cy, (double)cy + halfH, cy};
        return new double[][]{xs, ys};
    }

    private static List<double[][]> clubPolygons(int cx, int cy, double size, int segments) {
        double r = size * 0.242;
        double offsetX = size * 0.36;
        double offsetY = size * 0.08;
        ArrayList<double[][]> out = new ArrayList<double[][]>();
        out.add(CardRenderer.circlePolygon((double)cx - offsetX, (double)cy - offsetY, r, segments));
        out.add(CardRenderer.circlePolygon((double)cx + offsetX, (double)cy - offsetY, r, segments));
        out.add(CardRenderer.circlePolygon(cx, (double)cy + size * 0.18, r, segments));
        out.add(CardRenderer.circlePolygon(cx, cy, r * 0.77, segments));
        return out;
    }

    private static List<double[][]> spadePolygons(int cx, int cy, double size, int segments) {
        double halfW = size * 0.55;
        double topY = (double)cy - size * 0.45;
        double bottomY = (double)cy + size * 0.15;
        double[] ys = new double[]{topY, bottomY, bottomY};
        double[] xs = new double[]{cx, (double)cx + halfW, (double)cx - halfW};
        ArrayList<double[][]> out = new ArrayList<double[][]>();
        out.add(new double[][]{xs, ys});
        double lobeR = size * 0.277;
        double lobeCenterY = cy + 4;
        double lobeOffsetX = size * 0.268;
        out.add(CardRenderer.circlePolygon((double)cx - lobeOffsetX, lobeCenterY, lobeR, segments));
        out.add(CardRenderer.circlePolygon((double)cx + lobeOffsetX, lobeCenterY, lobeR, segments));
        out.add(CardRenderer.circlePolygon(cx, (double)cy + size * 0.1, lobeR * 0.969, segments));
        return out;
    }

    private static double[][] starPolygon(double cx, double cy, double outerR, double innerR, int spikes) {
        if (spikes < 2) {
            spikes = 2;
        }
        int vertices = spikes * 2;
        double[] xs = new double[vertices];
        double[] ys = new double[vertices];
        double twoPi = Math.PI * 2;
        for (int k = 0; k < spikes; ++k) {
            double baseAngle = -1.5707963267948966 + twoPi * (double)k / (double)spikes;
            int outerIndex = k * 2;
            int innerIndex = k * 2 + 1;
            xs[outerIndex] = cx + Math.cos(baseAngle) * outerR;
            ys[outerIndex] = cy + Math.sin(baseAngle) * outerR;
            double innerAngle = baseAngle + Math.PI / (double)spikes;
            xs[innerIndex] = cx + Math.cos(innerAngle) * innerR;
            ys[innerIndex] = cy + Math.sin(innerAngle) * innerR;
        }
        return new double[][]{xs, ys};
    }

    private static List<Vec> pipPositionsForRank(Rank r) {
        return switch (r) {
            default -> throw new MatchException(null, null);
            case Rank.ACE -> List.of(new Vec(0.5, 0.35));
            case Rank.TWO -> List.of(new Vec(0.5, 0.22), new Vec(0.5, 0.78));
            case Rank.THREE -> List.of(new Vec(0.5, 0.16), new Vec(0.5, 0.5), new Vec(0.5, 0.84));
            case Rank.FOUR -> List.of(new Vec(0.28, 0.22), new Vec(0.72, 0.22), new Vec(0.28, 0.78), new Vec(0.72, 0.78));
            case Rank.FIVE -> List.of(new Vec(0.28, 0.22), new Vec(0.72, 0.22), new Vec(0.5, 0.5), new Vec(0.28, 0.78), new Vec(0.72, 0.78));
            case Rank.SIX -> List.of(new Vec(0.28, 0.16), new Vec(0.72, 0.16), new Vec(0.28, 0.5), new Vec(0.72, 0.5), new Vec(0.28, 0.84), new Vec(0.72, 0.84));
            case Rank.SEVEN -> {
                ArrayList<Vec> v = new ArrayList<Vec>(CardRenderer.pipPositionsForRank(Rank.SIX));
                v.addFirst(new Vec(0.5, 0.08));
                yield v;
            }
            case Rank.EIGHT -> {
                ArrayList<Vec> v = new ArrayList<Vec>(CardRenderer.pipPositionsForRank(Rank.SEVEN));
                v.add(new Vec(0.5, 0.92));
                yield v;
            }
            case Rank.NINE -> {
                ArrayList<Vec> v = new ArrayList<Vec>(CardRenderer.pipPositionsForRank(Rank.EIGHT));
                v.add(new Vec(0.5, 0.5));
                yield v;
            }
            case Rank.TEN -> List.of(new Vec(0.28, 0.12), new Vec(0.72, 0.12), new Vec(0.28, 0.28), new Vec(0.72, 0.28), new Vec(0.28, 0.5), new Vec(0.72, 0.5), new Vec(0.28, 0.72), new Vec(0.72, 0.72), new Vec(0.28, 0.88), new Vec(0.72, 0.88));
            case Rank.JACK, Rank.QUEEN, Rank.KING -> List.of(new Vec(0.5, 0.55));
        };
    }

    private record Vec(double x, double y) {
    }
}

