/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.solitaire.render;

import java.util.ArrayList;
import java.util.Collections;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class PolygonRenderer {
    private static final int TOP_LEFT = 2;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 3;
    private static final int BOTTOM_RIGHT = 0;

    public static void drawFilledPolygon(GuiRenderer renderer, double[] xs, double[] ys, Color color) {
        double y0;
        int l = xs.length;
        if (l < 3) {
            return;
        }
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int n = 0; n < l; ++n) {
            minY = Math.min(minY, ys[n]);
            maxY = Math.max(maxY, ys[n]);
        }
        double y1 = Math.ceil(maxY);
        for (double y = y0 = Math.floor(minY); y <= y1; y += 1.0) {
            ArrayList<Double> inter = new ArrayList<Double>();
            for (int n = 0; n < l; ++n) {
                int j = (n + 1) % l;
                double x1 = xs[n];
                double y1d = ys[n];
                double x2 = xs[j];
                double y2d = ys[j];
                if (Math.abs(y1d - y2d) < 1.0E-12) continue;
                double yMinE = Math.min(y1d, y2d);
                double yMaxE = Math.max(y1d, y2d);
                if (!(y >= Math.ceil(yMinE)) || !(y < Math.ceil(yMaxE))) continue;
                double t = (y - y1d) / (y2d - y1d);
                double xi = x1 + t * (x2 - x1);
                inter.add(xi);
            }
            if (inter.isEmpty()) continue;
            Collections.sort(inter);
            int k = 0;
            while (k + 1 < inter.size()) {
                PolygonRenderer.emitSpan(renderer, (Double)inter.get(k), (Double)inter.get(k + 1), y, color);
                k += 2;
            }
        }
    }

    public static void drawFilledCircleSpan(GuiRenderer renderer, double cx, double cy, double r, Color color) {
        double y0;
        double rr = r * r;
        double y1 = Math.ceil(cy + r);
        for (double y = y0 = Math.floor(cy - r); y <= y1; y += 1.0) {
            double dy = y - cy;
            double val = rr - dy * dy;
            if (val <= 0.0) continue;
            double dx = Math.sqrt(val);
            double left = cx - dx;
            double right = cx + dx;
            PolygonRenderer.emitSpan(renderer, left, right, y, color);
        }
    }

    private static void emitSpan(GuiRenderer renderer, double xLeft, double xRight, double y, Color color) {
        int leftPx = (int)Math.ceil(xLeft - 0.5);
        int rightPx = (int)Math.floor(xRight + 0.5);
        if (rightPx < leftPx) {
            return;
        }
        double w = rightPx - leftPx + 1;
        renderer.quad((double)leftPx, y, w, 1.0, color);
    }

    public static void drawRoundedRect(GuiRenderer renderer, double rx, double ry, double rw, double rh, double cornerRadius, Color color) {
        double radius = Math.min(rw, rh) / cornerRadius;
        renderer.quad(rx + radius, ry, rw - radius * 2.0, rh, color);
        renderer.quad(rx, ry + radius, radius, rh - radius * 2.0, color);
        renderer.quad(rx + rw - radius, ry + radius, radius, rh - radius * 2.0, color);
        PolygonRenderer.drawQuarterCircle(renderer, rx + radius, ry + radius, radius, 2, color);
        PolygonRenderer.drawQuarterCircle(renderer, rx + rw - radius - 1.0, ry + radius, radius, 1, color);
        PolygonRenderer.drawQuarterCircle(renderer, rx + radius, ry + rh - radius - 1.0, radius, 3, color);
        PolygonRenderer.drawQuarterCircle(renderer, rx + rw - radius - 1.0, ry + rh - radius - 1.0, radius, 0, color);
    }

    public static void drawRoundedRectRotated(GuiRenderer renderer, double cx, double cy, double rw, double rh, double angleRad, Color color) {
        int samples = Math.max(24, (int)Math.round(Math.max(rw, rh) / 4.0));
        double step = 1.0 / (double)samples;
        for (int n = 0; n <= samples; ++n) {
            double t = -0.5 + (double)n * step;
            double localX = t * rw;
            double localY = 0.0;
            double rx = localX * Math.cos(angleRad) - localY * Math.sin(angleRad);
            double ry = localX * Math.sin(angleRad) + localY * Math.cos(angleRad);
            double px = cx + rx;
            double py = cy + ry;
            double sq = Math.max(2.0, Math.min(rw, rh) * 0.06);
            renderer.quad(px - sq / 2.0, py - sq / 2.0, sq, sq, color);
        }
    }

    private static void drawQuarterCircle(GuiRenderer renderer, double cx, double cy, double r, int quadrant, Color color) {
        double rr = r * r;
        for (double dy = -r; dy <= r; dy += 1.0) {
            double ex;
            double sx;
            double y = cy + dy;
            double dxD = Math.sqrt(Math.max(0.0, rr - dy * dy));
            double x1 = cx - dxD;
            double x2 = cx + dxD;
            if (quadrant == 0) {
                if (y < cy || !((sx = Math.max(x1, cx)) <= x2)) continue;
                renderer.quad(sx, y, x2 - sx + 1.0, 1.0, color);
                continue;
            }
            if (quadrant == 1) {
                if (y > cy || !((sx = Math.max(x1, cx)) <= x2)) continue;
                renderer.quad(sx, y, x2 - sx + 1.0, 1.0, color);
                continue;
            }
            if (quadrant == 2) {
                if (y > cy || !(x1 <= (ex = Math.min(x2, cx)))) continue;
                renderer.quad(x1, y, ex - x1 + 1.0, 1.0, color);
                continue;
            }
            if (y < cy || !(x1 <= (ex = Math.min(x2, cx)))) continue;
            renderer.quad(x1, y, ex - x1 + 1.0, 1.0, color);
        }
    }
}

