/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.gui.widgets.solitaire.render;

import dev.stardust.gui.widgets.solitaire.WSolitaire;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.renderer.text.TextRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class StatusBarRenderer {
    public static void render(GuiRenderer renderer, int bx, int by, double width, WSolitaire widget) {
        renderer.quad((double)bx, (double)by, width, 32.0, widget.colors.statusBarColor);
        long elapsedSec = 0L;
        if (widget.gameStart > 0L && !widget.gameOver) {
            elapsedSec = (System.currentTimeMillis() - (widget.gameStart - widget.accumulated)) / 1000L;
        } else if (widget.gameOver) {
            elapsedSec = (widget.gameEnd - (widget.gameStart - widget.accumulated)) / 1000L;
        }
        double textHeight = TextRenderer.get().getHeight();
        String timerText = String.format("%02d:%02d", elapsedSec / 60L, elapsedSec % 60L);
        double scaledHeight = textHeight * 1.25;
        double timerTextWidth = TextRenderer.get().getWidth(timerText) * 1.25;
        double timerX = (double)bx + width / 2.0 - timerTextWidth / 2.0;
        renderer.text(timerText, timerX - 1.0, (double)(by + 32) - scaledHeight - 2.0, widget.colors.textShadow, true);
        renderer.text(timerText, timerX + 1.0, (double)(by + 32) - scaledHeight - 2.0, widget.colors.textShadow, true);
        renderer.text(timerText, timerX, (double)(by + 32) - scaledHeight - 1.0, widget.colors.textShadow, true);
        renderer.text(timerText, timerX, (double)(by + 32) - scaledHeight - 2.0, widget.colors.timerColor, true);
        int resetButtonY = by + 3;
        int resetButtonX = (int)((double)bx + width - 64.0 - 6.0);
        renderer.quad((double)resetButtonX, (double)resetButtonY, 64.0, 26.0, widget.resetButtonHovered ? widget.colors.buttonHoveredColor : widget.colors.buttonColor);
        String reset = "Reset";
        double resetTextWidth = TextRenderer.get().getWidth(reset);
        double resetTextX = (double)resetButtonX + 32.0 - resetTextWidth / 2.0;
        renderer.text(reset, resetTextX - 1.0, (double)(resetButtonY + 26) - textHeight - 3.0, widget.colors.textShadow, false);
        renderer.text(reset, resetTextX + 1.0, (double)(resetButtonY + 26) - textHeight - 3.0, widget.colors.textShadow, false);
        renderer.text(reset, resetTextX, (double)(resetButtonY + 26) - textHeight - 2.0, widget.colors.textShadow, false);
        renderer.text(reset, resetTextX, (double)(resetButtonY + 26) - textHeight - 3.0, widget.colors.statusTextColor, false);
        if (widget.undoButtonVisible) {
            int undoButtonY = by + 3;
            int undoButtonX = (int)((double)bx + width - 64.0 - 12.0 - 64.0);
            renderer.quad((double)undoButtonX, (double)undoButtonY, 64.0, 26.0, widget.undoButtonHovered ? widget.colors.buttonHoveredColor : widget.colors.buttonColor);
            String undo = "Undo";
            double undoTextWidth = TextRenderer.get().getWidth(undo);
            double undoTextX = (double)undoButtonX + 32.0 - undoTextWidth / 2.0;
            renderer.text(undo, undoTextX - 1.0, (double)(undoButtonY + 26) - textHeight - 3.0, widget.colors.textShadow, false);
            renderer.text(undo, undoTextX + 1.0, (double)(undoButtonY + 26) - textHeight - 3.0, widget.colors.textShadow, false);
            renderer.text(undo, undoTextX, (double)(undoButtonY + 26) - textHeight - 2.0, widget.colors.textShadow, false);
            renderer.text(undo, undoTextX, (double)(undoButtonY + 26) - textHeight - 3.0, widget.colors.statusTextColor, false);
        }
        if (widget.gameOver) {
            String gameOverText = widget.gameWon ? "You win..!" : "You lost..?";
            renderer.text(gameOverText, (double)(bx + 12 - 1), (double)by + 16.0 - scaledHeight / 2.0 - 1.0, widget.colors.textShadow, true);
            renderer.text(gameOverText, (double)(bx + 12 + 1), (double)by + 16.0 - scaledHeight / 2.0 - 1.0, widget.colors.textShadow, true);
            renderer.text(gameOverText, (double)(bx + 12), (double)by + 16.0 - scaledHeight / 2.0, widget.colors.textShadow, true);
            renderer.text(gameOverText, (double)(bx + 12), (double)by + 16.0 - scaledHeight / 2.0 - 1.0, widget.gameWon ? new Color(13, 255, 13) : new Color(255, 13, 13), true);
        }
    }
}

