/*
 * Decompiled with CFR 0.152.
 */
package dev.stardust.hud;

import dev.stardust.Stardust;
import dev.stardust.mixin.meteor.accessor.SettingAccessor;
import dev.stardust.util.MsgUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.RainbowColors;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public class ConwayHud
extends HudElement {
    public static final HudElementInfo<ConwayHud> INFO = new HudElementInfo(Stardust.HUD_GROUP, "game-of-life", "Conway's Game of Life in your HUD.", ConwayHud::new);
    private final SettingGroup sgRules;
    private final SettingGroup sgGeneral;
    private final Setting<Ruleset> rules;
    public final Setting<String> customRules;
    private final Setting<Integer> cyclicStates;
    private final Setting<Integer> cyclicRate;
    private final Setting<Integer> cyclicDuration;
    private final Setting<Double> mutateAliveRate;
    private final Setting<Double> mutateDeadRate;
    private final Setting<Double> seedDensity;
    public final Setting<Integer> cellSize;
    public final Setting<Integer> gridSize;
    public final Setting<Integer> maxAge;
    public final Setting<Integer> maxGeneration;
    private final Setting<Integer> updateInterval;
    public final Setting<Visibility> visibility;
    private final Setting<ColorScheme> colorScheme;
    public final Setting<SettingColor> aliveColor;
    public final Setting<SettingColor> deadColor;
    public final Setting<Integer> minAlpha;
    public final Setting<Integer> maxAlpha;
    private static final Integer DEAD = 0;
    private static final Integer ALIVE = 1;
    private int timer;
    private int offset;
    private int resetTimer;
    private int generation;
    private int biggestAge;
    private long timestamp;
    private int CELL_SIZE;
    private int GRID_SIZE;
    private int[][] grid;
    private int[][] buffer;
    public boolean isPaused;
    public boolean isVisible;
    public boolean firstTick;
    public Rules gameRules;
    private static final int[][] NEIGHBOR_OFFSETS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};

    public ConwayHud() {
        super(INFO);
        this.sgRules = this.settings.createGroup("Rules");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.rules = this.sgRules.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("simulation-rules")).defaultValue((Object)Ruleset.Standard)).description(Ruleset.Standard.method_15434())).onChanged(it -> {
            switch (it.ordinal()) {
                case 1: {
                    this.seedDensity.set((Object)0.69);
                    break;
                }
                case 6: {
                    this.seedDensity.set((Object)0.469);
                    break;
                }
                case 7: {
                    this.seedDensity.set((Object)0.42);
                    break;
                }
                case 8: {
                    this.seedDensity.set((Object)1.0);
                    break;
                }
                default: {
                    this.seedDensity.set((Object)0.33);
                }
            }
            if (it == Ruleset.Stardust) {
                this.updateInterval.set((Object)2);
            } else {
                this.updateInterval.set((Object)1);
            }
            this.firstTick = true;
            this.alterOwnDescription((Ruleset)((Object)it));
        })).build());
        this.customRules = this.sgRules.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("custom-rules")).description("In the format \"B3/S23\" where B means birth, S means survive, and digits must be 1-8. Optional \"R\" flag to inject randomness.")).defaultValue((Object)Ruleset.Custom.rules)).visible(() -> ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Custom) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Random))).onChanged(it -> {
            this.firstTick = true;
        })).build());
        this.cyclicStates = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cyclic-max-states")).description("The max amount of states to use for cyclic automata. Half of these will be rendered as transparent.")).range(2, 32).noSlider().defaultValue((Object)8)).visible(() -> ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Cyclic) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Random))).build());
        this.cyclicRate = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cyclic-threshold")).description("The threshold value to use for the cyclic automata ruleset. Higher values cause less change.")).range(1, 8).noSlider().defaultValue((Object)1)).visible(() -> ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Cyclic) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Random))).build());
        this.cyclicDuration = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cyclic-duration")).description("The duration in seconds to allow any one cyclic simulation to live for.")).min(1).noSlider().defaultValue((Object)30)).visible(() -> ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Cyclic) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Random))).build());
        this.mutateAliveRate = this.sgRules.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("mutation-rate-alive")).description("How often to inject random life mutations when the randomize (R) rule is added to the Ruleset.")).range(0.0, 1.0).sliderRange(0.0, 0.001).defaultValue(6.9E-5).visible(() -> ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Mutation) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Stardust) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Random) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Custom) && ((String)this.customRules.get()).toUpperCase().contains("R"))).build());
        this.mutateDeadRate = this.sgRules.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("mutation-rate-dead")).description("How often to inject random death mutations when the randomize (R) rule is added to the Ruleset.")).range(0.0, 1.0).sliderRange(0.0, 0.001).defaultValue(4.2E-5).visible(() -> ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Mutation) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Stardust) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Random) || ((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Custom) && ((String)this.customRules.get()).toUpperCase().contains("R"))).build());
        this.seedDensity = this.sgRules.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("seed-density")).description("The density of live cells when first seeding the simulation.")).range(0.0, 1.0).noSlider().defaultValue(0.3333333333333333).build());
        this.cellSize = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cell-size")).min(1).noSlider().defaultValue((Object)5)).onChanged(it -> {
            this.firstTick = true;
        })).build());
        this.gridSize = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("grid-size")).min(10).noSlider().defaultValue((Object)420)).onChanged(it -> {
            this.firstTick = true;
        })).build());
        this.maxAge = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("maximum-age")).description("The maximum cell age to allow before resetting the game. Set to 0 to disable.")).min(0).noSlider().defaultValue((Object)1337)).build());
        this.maxGeneration = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("maximum-generation")).description("The maximum generation to allow before resetting the game. Set to 0 to disable.")).min(0).noSlider().defaultValue((Object)Short.MAX_VALUE)).build());
        this.updateInterval = this.sgRules.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("update-interval")).description("How often in ticks to update the simulation.")).min(1).sliderMax(20).defaultValue((Object)1)).build());
        this.visibility = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("visibility")).defaultValue((Object)Visibility.Windows)).build());
        this.colorScheme = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("color-scheme")).defaultValue((Object)ColorScheme.Stabilizing)).visible(() -> !((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Cyclic))).build());
        this.aliveColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("alive-color")).description("The color to use for alive cells.")).defaultValue(new SettingColor(101, 17, 255, 142, true)).visible(() -> !((ColorScheme)((Object)((Object)this.colorScheme.get()))).equals((Object)ColorScheme.Trippy) && !((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Cyclic))).build());
        this.deadColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("dead-color")).description("The color to use for dead cells.")).defaultValue(new SettingColor(0, 0, 0, 0)).visible(() -> !((ColorScheme)((Object)((Object)this.colorScheme.get()))).equals((Object)ColorScheme.Trippy) && !((Ruleset)((Object)((Object)this.rules.get()))).equals((Object)Ruleset.Cyclic))).build());
        this.minAlpha = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("minimum-opacity")).min(0).sliderMax(255).defaultValue((Object)69)).visible(() -> !((ColorScheme)((Object)((Object)this.colorScheme.get()))).equals((Object)ColorScheme.Bichromatic))).build());
        this.maxAlpha = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("maximum-opacity")).min(0).sliderMax(255).defaultValue((Object)213)).visible(() -> !((ColorScheme)((Object)((Object)this.colorScheme.get()))).equals((Object)ColorScheme.Bichromatic))).build());
        this.timer = 0;
        this.offset = 0;
        this.resetTimer = 0;
        this.generation = 0;
        this.biggestAge = 0;
        this.timestamp = 0L;
        this.CELL_SIZE = (Integer)this.cellSize.get();
        this.GRID_SIZE = (Integer)this.gridSize.get();
        this.grid = new int[this.GRID_SIZE][this.GRID_SIZE];
        this.buffer = new int[this.GRID_SIZE][this.GRID_SIZE];
        this.isPaused = false;
        this.isVisible = true;
        this.firstTick = true;
        this.gameRules = Rules.STANDARD;
        if (((SettingColor)this.deadColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.deadColor.get()));
        }
        if (((SettingColor)this.aliveColor.get()).rainbow) {
            RainbowColors.add((SettingColor)((SettingColor)this.aliveColor.get()));
        }
    }

    public int getMaxAge() {
        return this.biggestAge;
    }

    public int getCellSize() {
        return this.CELL_SIZE;
    }

    public int getGridSize() {
        return this.GRID_SIZE;
    }

    public long getRuntime() {
        return System.currentTimeMillis() - this.timestamp;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int[] getCellCount() {
        int dead = 0;
        int alive = 0;
        for (int x = 0; x < this.GRID_SIZE; ++x) {
            for (int y = 0; y < this.GRID_SIZE; ++y) {
                if (this.grid[x][y] == DEAD) {
                    ++dead;
                    continue;
                }
                ++alive;
            }
        }
        return new int[]{dead, alive};
    }

    public void stepSimulation() {
        if (this.isPaused) {
            this.tickSimulation();
        }
    }

    public WWidget getWidget(GuiTheme theme) {
        WHorizontalList list = theme.horizontalList();
        WButton reset = (WButton)list.add((WWidget)theme.button("New Game")).widget();
        WButton manualStep = (WButton)list.add((WWidget)theme.button("Step")).widget();
        WButton pauseResume = (WButton)list.add((WWidget)theme.button(this.isPaused ? "Resume" : "Pause")).widget();
        WButton visibilityBtn = (WButton)list.add((WWidget)theme.button(this.isVisible ? "Hide" : "Show")).widget();
        reset.action = () -> {
            this.firstTick = true;
        };
        manualStep.action = this::stepSimulation;
        pauseResume.action = () -> {
            this.isPaused = !this.isPaused;
        };
        visibilityBtn.action = () -> {
            this.isVisible = !this.isVisible;
        };
        return list;
    }

    public void tick(HudRenderer hud) {
        if (this.shouldHide() || this.isPaused) {
            return;
        }
        if (this.firstTick) {
            if (((Ruleset)((Object)this.rules.get())).equals((Object)Ruleset.Random)) {
                int luckyIndex = ThreadLocalRandom.current().nextInt(Ruleset.values().length);
                Ruleset rule = Ruleset.values()[luckyIndex];
                if (rule.equals((Object)Ruleset.Random)) {
                    rule = Ruleset.Standard;
                }
                switch (rule.ordinal()) {
                    case 1: {
                        this.seedDensity.set((Object)0.69);
                        break;
                    }
                    case 6: {
                        this.seedDensity.set((Object)0.469);
                        break;
                    }
                    case 7: {
                        this.seedDensity.set((Object)0.42);
                        break;
                    }
                    case 8: {
                        this.seedDensity.set((Object)1.0);
                        break;
                    }
                    default: {
                        this.seedDensity.set((Object)0.33);
                    }
                }
                if (rule.equals((Object)Ruleset.Stardust)) {
                    this.updateInterval.set((Object)2);
                } else {
                    this.updateInterval.set((Object)1);
                }
                this.gameRules = rule.equals((Object)Ruleset.Custom) ? this.parseRules(rule, (String)this.customRules.get()) : this.parseRules(rule, rule.rules);
            } else {
                this.gameRules = ((Ruleset)((Object)this.rules.get())).equals((Object)Ruleset.Custom) ? this.parseRules((Ruleset)((Object)this.rules.get()), (String)this.customRules.get()) : this.parseRules((Ruleset)((Object)this.rules.get()), ((Ruleset)((Object)this.rules.get())).rules);
            }
            this.timer = 0;
            this.resetTimer = 0;
            this.generation = 0;
            this.biggestAge = 0;
            this.calculateSize();
            this.seedSimulation();
            this.firstTick = false;
            this.timestamp = System.currentTimeMillis();
            this.offset = ThreadLocalRandom.current().nextInt(256);
        }
        if (this.resetTimer > 0) {
            --this.resetTimer;
            if (this.resetTimer <= 1) {
                this.resetTimer = 0;
                this.firstTick = true;
            }
        }
        ++this.timer;
        if (this.timer >= (Integer)this.updateInterval.get()) {
            this.timer = 0;
            this.tickSimulation();
        }
    }

    public void render(HudRenderer hud) {
        if (this.shouldHide() || this.firstTick) {
            return;
        }
        if (this.gameRules.cyclic || !((ColorScheme)((Object)this.colorScheme.get())).equals((Object)ColorScheme.Bichromatic)) {
            for (int x = 0; x < this.GRID_SIZE; ++x) {
                for (int y = 0; y < this.GRID_SIZE; ++y) {
                    meteordevelopment.meteorclient.utils.render.color.Color color = this.gameRules.cyclic ? (this.grid[x][y] <= (Integer)this.cyclicStates.get() / 2 ? (meteordevelopment.meteorclient.utils.render.color.Color)this.deadColor.get() : this.getColorByValue(x, y)) : (this.grid[x][y] <= 0 ? (meteordevelopment.meteorclient.utils.render.color.Color)this.deadColor.get() : (((ColorScheme)((Object)this.colorScheme.get())).equals((Object)ColorScheme.Trippy) ? this.getColorByValue(x, y) : (((ColorScheme)((Object)this.colorScheme.get())).equals((Object)ColorScheme.Stabilizing) ? (this.grid[x][y] < (Integer)this.minAlpha.get() ? this.getColorByValue(x, y) : new meteordevelopment.meteorclient.utils.render.color.Color(((SettingColor)this.aliveColor.get()).r, ((SettingColor)this.aliveColor.get()).g, ((SettingColor)this.aliveColor.get()).b, class_3532.method_15340((int)this.grid[x][y], (int)((Integer)this.minAlpha.get()), (int)((Integer)this.maxAlpha.get())))) : new meteordevelopment.meteorclient.utils.render.color.Color(((SettingColor)this.aliveColor.get()).r, ((SettingColor)this.aliveColor.get()).g, ((SettingColor)this.aliveColor.get()).b, class_3532.method_15340((int)this.grid[x][y], (int)((Integer)this.minAlpha.get()), (int)((Integer)this.maxAlpha.get()))))));
                    hud.quad((double)(this.x + x * this.CELL_SIZE), (double)(this.y + y * this.CELL_SIZE), (double)this.CELL_SIZE, (double)this.CELL_SIZE, color);
                }
            }
        } else {
            for (int x = 0; x < this.GRID_SIZE; ++x) {
                for (int y = 0; y < this.GRID_SIZE; ++y) {
                    meteordevelopment.meteorclient.utils.render.color.Color color = this.grid[x][y] >= 1 ? (meteordevelopment.meteorclient.utils.render.color.Color)this.aliveColor.get() : (meteordevelopment.meteorclient.utils.render.color.Color)this.deadColor.get();
                    hud.quad((double)(this.x + x * this.CELL_SIZE), (double)(this.y + y * this.CELL_SIZE), (double)this.CELL_SIZE, (double)this.CELL_SIZE, color);
                }
            }
        }
    }

    private boolean shouldHide() {
        if (!this.isVisible) {
            return true;
        }
        switch (((Visibility)((Object)this.visibility.get())).ordinal()) {
            case 1: {
                if (MeteorClient.mc.field_1755 instanceof WidgetScreen) break;
                return true;
            }
            case 2: {
                if (MeteorClient.mc.field_1755 != null) break;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldMutate(int aliveNeighbors, boolean alive) {
        if (aliveNeighbors <= 0 && !((Ruleset)((Object)this.rules.get())).equals((Object)Ruleset.Stardust)) {
            if (!((Ruleset)((Object)this.rules.get())).equals((Object)Ruleset.Custom)) return false;
            if (!((String)this.customRules.get()).toUpperCase().contains("R+")) return false;
        }
        double d = ThreadLocalRandom.current().nextDouble();
        Double d2 = alive ? (Double)this.mutateDeadRate.get() : (Double)this.mutateAliveRate.get();
        if (!(d <= d2)) return false;
        return true;
    }

    private void calculateSize() {
        this.CELL_SIZE = (Integer)this.cellSize.get();
        this.GRID_SIZE = (Integer)this.gridSize.get();
        this.grid = new int[this.GRID_SIZE][this.GRID_SIZE];
        this.buffer = new int[this.GRID_SIZE][this.GRID_SIZE];
        this.setSize(this.GRID_SIZE * this.CELL_SIZE, this.GRID_SIZE * this.CELL_SIZE);
    }

    private void tickSimulation() {
        boolean[][] mutated = new boolean[this.GRID_SIZE][this.GRID_SIZE];
        ++this.generation;
        for (int x = 0; x < this.GRID_SIZE; ++x) {
            for (int y = 0; y < this.GRID_SIZE; ++y) {
                if (this.gameRules.cyclic) {
                    int current = this.grid[x][y];
                    int newState = (current + 1) % (Integer)this.cyclicStates.get();
                    int neighbors = this.countNeighborsWithState(x, y, newState);
                    this.buffer[x][y] = neighbors >= (Integer)this.cyclicRate.get() ? newState : current;
                    if (this.resetTimer > 0 || System.currentTimeMillis() - this.timestamp < (long)((Integer)this.cyclicDuration.get() * 1000)) continue;
                    this.resetTimer = 100;
                    continue;
                }
                if (mutated[x][y]) continue;
                boolean randomize = this.gameRules.randomize;
                Set<Integer> birth = this.gameRules.birthSet;
                Set<Integer> survival = this.gameRules.survivalSet;
                int aliveNeighbors = this.countAliveNeighbors(x, y);
                if ((Integer)this.maxGeneration.get() > 0 && this.generation >= (Integer)this.maxGeneration.get() && this.resetTimer <= 0) {
                    this.resetTimer = 100;
                }
                if (this.grid[x][y] != DEAD) {
                    if (this.grid[x][y] > this.biggestAge) {
                        this.biggestAge = this.grid[x][y];
                    }
                    if ((Integer)this.maxAge.get() > 0 && this.biggestAge >= (Integer)this.maxAge.get() && this.resetTimer <= 0) {
                        this.resetTimer = 100;
                    }
                    if (randomize && this.shouldMutate(aliveNeighbors, true)) {
                        this.mutateNeighbors(x, y, DEAD, ThreadLocalRandom.current().nextInt(9), this.buffer, mutated);
                        continue;
                    }
                    if (survival.contains(aliveNeighbors)) {
                        this.buffer[x][y] = this.grid[x][y] + ALIVE;
                        continue;
                    }
                    this.buffer[x][y] = DEAD;
                    continue;
                }
                if (randomize && this.shouldMutate(aliveNeighbors, false)) {
                    this.mutateNeighbors(x, y, ALIVE, ThreadLocalRandom.current().nextInt(9), this.buffer, mutated);
                    continue;
                }
                this.buffer[x][y] = birth.contains(aliveNeighbors) ? ALIVE.intValue() : DEAD.intValue();
            }
        }
        int[][] temp = this.grid;
        this.grid = this.buffer;
        this.buffer = temp;
    }

    private void seedSimulation() {
        if (this.gameRules.cyclic) {
            for (int x = 0; x < this.GRID_SIZE; ++x) {
                for (int y = 0; y < this.GRID_SIZE; ++y) {
                    this.grid[x][y] = ThreadLocalRandom.current().nextDouble() < (Double)this.seedDensity.get() ? ThreadLocalRandom.current().nextInt((Integer)this.cyclicStates.get()) : DEAD.intValue();
                }
            }
        } else {
            for (int x = 0; x < this.GRID_SIZE; ++x) {
                for (int y = 0; y < this.GRID_SIZE; ++y) {
                    this.grid[x][y] = Math.random() < (Double)this.seedDensity.get() ? ALIVE : DEAD;
                }
            }
        }
    }

    private int countAliveNeighbors(int x, int y) {
        int count = 0;
        for (int[] offset : NEIGHBOR_OFFSETS) {
            int nx = (x + offset[0] + this.GRID_SIZE) % this.GRID_SIZE;
            int ny = (y + offset[1] + this.GRID_SIZE) % this.GRID_SIZE;
            if (this.grid[nx][ny] == DEAD) continue;
            ++count;
        }
        return count;
    }

    private int countNeighborsWithState(int x, int y, int state) {
        int count = 0;
        for (int[] offset : NEIGHBOR_OFFSETS) {
            int nx = (x + offset[0] + this.GRID_SIZE) % this.GRID_SIZE;
            int ny = (y + offset[1] + this.GRID_SIZE) % this.GRID_SIZE;
            if (this.grid[nx][ny] != state) continue;
            ++count;
        }
        return count;
    }

    private void mutateNeighbors(int x, int y, int mutation, int amount, int[][] buffer, boolean[][] mutated) {
        int mutations = 0;
        for (int[] offset : NEIGHBOR_OFFSETS) {
            int nx = (x + offset[0] + this.GRID_SIZE) % this.GRID_SIZE;
            int ny = (y + offset[1] + this.GRID_SIZE) % this.GRID_SIZE;
            if (mutated[nx][ny]) continue;
            mutated[nx][ny] = true;
            buffer[nx][ny] = mutation;
            if (++mutations >= amount) break;
        }
    }

    private meteordevelopment.meteorclient.utils.render.color.Color getColorByValue(int x, int y) {
        float hue = (float)(this.grid[x][y] + this.offset) * 0.618034f % 1.0f;
        float saturation = 0.8f;
        float brightness = 0.9f;
        Color temp = Color.getHSBColor(hue, saturation, brightness);
        return new meteordevelopment.meteorclient.utils.render.color.Color((float)temp.getRed() / 255.0f, (float)temp.getGreen() / 255.0f, (float)temp.getBlue() / 255.0f, (float)class_3532.method_15340((int)this.grid[x][y], (int)((Integer)this.minAlpha.get()), (int)((Integer)this.maxAlpha.get())));
    }

    private Rules parseRules(Ruleset set, String rules) {
        if (rules.toUpperCase().startsWith("C")) {
            return new Rules(set, new HashSet<Integer>(), new HashSet<Integer>(), false, true);
        }
        if (rules.isBlank() || !rules.contains("/")) {
            MsgUtil.updateModuleMsg("Invalid rule syntax\u00a7c..! \u00a77Cannot parse: \"\u00a7c" + rules + "\u00a77\"\u00a7c..!", "Conway", "invalidRuleset".hashCode());
            return Rules.STANDARD;
        }
        String[] parts = rules.toUpperCase().split("/");
        boolean isCyclic = false;
        boolean hasRandom = false;
        HashSet<Integer> birthSet = new HashSet<Integer>();
        HashSet<Integer> survivalSet = new HashSet<Integer>();
        for (String part : parts) {
            int value;
            if (part.startsWith("B")) {
                for (char c : part.toCharArray()) {
                    if (!Character.isDigit(c) || (value = Integer.parseInt(String.valueOf(c))) >= 9) continue;
                    birthSet.add(value);
                }
                continue;
            }
            if (part.startsWith("S")) {
                for (char c : part.toCharArray()) {
                    if (!Character.isDigit(c) || (value = Integer.parseInt(String.valueOf(c))) >= 9) continue;
                    survivalSet.add(value);
                }
                continue;
            }
            if (part.startsWith("R")) {
                hasRandom = true;
                continue;
            }
            if (!part.startsWith("C")) continue;
            isCyclic = true;
        }
        if (birthSet.contains(0)) {
            birthSet.clear();
        }
        if (survivalSet.contains(0)) {
            survivalSet.clear();
        }
        if (isCyclic) {
            return new Rules(set, birthSet, survivalSet, hasRandom, true);
        }
        if (birthSet.isEmpty() && survivalSet.isEmpty()) {
            MsgUtil.updateModuleMsg("Invalid Ruleset\u00a7c..! \u00a77The birth & survival sets are both empty\u00a7c..!", "Conway", "badConwayRules".hashCode());
            return Rules.STANDARD;
        }
        if (birthSet.isEmpty()) {
            MsgUtil.updateModuleMsg("Empty birth set\u00a7c..! \u00a77The simulation may not work, or may be short-lived\u00a7c..!", "Conway", "badConwayRules".hashCode());
            return new Rules(set, birthSet, survivalSet, hasRandom, false);
        }
        if (survivalSet.isEmpty()) {
            MsgUtil.updateModuleMsg("Empty survival set\u00a7c..! \u00a77The simulation may not work, or may be short-lived\u00a7c..!", "Conway", "badConwayRules".hashCode());
            return new Rules(set, birthSet, survivalSet, hasRandom, false);
        }
        return new Rules(set, birthSet, survivalSet, hasRandom, false);
    }

    private void alterOwnDescription(Ruleset set) {
        ((SettingAccessor)this.rules).setDescription(set.method_15434());
    }

    public static enum Ruleset implements class_3542
    {
        Random(""),
        Cyclic("C"),
        Standard("B3/S23"),
        HighLife("B36/S23"),
        Custom("B3/S137/R"),
        Mutation("B3/S23/R"),
        Amoeba("B35678/S5678"),
        Sunspots("B3678/S34678"),
        Stardust("B3678/S14568/R+");

        public final String rules;

        private Ruleset(String rules) {
            this.rules = rules;
        }

        public String method_15434() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 4 -> "Custom";
                case 1 -> "Cyclic";
                case 0 -> "Random";
                case 2 -> "Standard(B3/S23)";
                case 3 -> "HighLife(B36/S23)";
                case 6 -> "Amoeba(B35678/S5678)";
                case 5 -> "Mutation(B3/S23/R)";
                case 8 -> "Stardust(B3678/S14568/R+)";
                case 7 -> "Sunspots(B3678/S34678)";
            };
        }
    }

    public static enum Visibility {
        Always,
        Widgets,
        Windows;

    }

    public static enum ColorScheme {
        Dynamic,
        Bichromatic,
        Trippy,
        Stabilizing;

    }

    public record Rules(Ruleset rules, Set<Integer> birthSet, Set<Integer> survivalSet, boolean randomize, boolean cyclic) {
        public static Rules STANDARD = new Rules(Ruleset.Standard, Set.of(Integer.valueOf(3)), Set.of(Integer.valueOf(2), Integer.valueOf(3)), false, false);
    }
}

